/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   DecodeCMsgPcb_bis.c
*
*   Code for doing information exchange
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// DecodeCMsgPcb_bis.c
//
// History
//
// 31/7/2010 Nihar: Modification done to reduce US PCB requested by CO by 3 dB in case of CNXT CO & ADSL2+ mode.
//           The fix enabled/Disabled through bit #8(0x100) of cmv INFO 103 0. By Default Disabled
//       Grep for PERF_US_BisPlus_CNXT_Reduce_US_PCB_By_3_dB
//
// 09/08/2010 Nihar: At present in the CPE FW, if the CO request the US blackout tones above bin #31,
//             it will not blackout the requested bins . It is because CPE FW copy only 4 bytes
//             (that means only 32 bits)  from the array guca_RCMsgPCBTab(packed C-MSG-PCB message received
//             from ATU-C) to gp_BlackoutBits_US( US BlackoutBits array in CPE). This is perfectly fine in
//             case of annex A , but  not for Annex B and Annex M where the US is up Tone #63.Modified the
//             code to handle the US blackout bins based annex A,B,I,J,M
//             Grep for IOP_AB_DS_BisPlus_ALL_USblackoutbits
//
// 19/08/2010 AdeelJ/Palaksh/Bhadra: Fix for ADSL2+ low US rates against Intracom CNXT DSLAM.
//               In case fix conditions are true, the PCBus requested by the CO
//               will be halved. It was seen that the CO was not requesting any
//               PCBus from an AR7 based modem, although the AR7 transmitted the same power
//               as Danube during G.hs. The power Cutback is reduced to increase US performance.
//               Grep for SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement
//
// 06/05/2012 Vinjam: Added code changes to extract the Transmitter referred downstream
//            virtual noise break points.
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 06/05/2012 Vinjam: Code changes to handle the virtual noise break points in LDM(DELT) mode
//            Also relocated the code which extrats the C-BLOCK out tones. This is common for
//            LDM & Normal modes. Also code added to extract the diag information along with
//            Virtual noise break points in LDM mode.
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
// ******************************************************************
#include <string.h>
#include "common.h"
#include "typedef_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "bitload_const.h"
#include "cmv.h"
#include "trail.h"


//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : UnpackVNPSD
 *
 *  Description:  Unpack the virtual noise PSD
 *
 *  Prototype:
 *          void UnpackVNPSD(int16 s_NumOfPoints,
 *                   uint8 *puca_OctetBuffer,
 *                   PSDDescriptorTable_t *pt_PSDDesc)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void UnpackVNPSD(int16 s_NumOfPoints,
            uint8  *puca_OctetBuffer,
            DsVnPSDDescriptorTable_t *pt_PSDDesc)
{

   int16 i, i3, j, s_PSDLevel;
   uint8 uc_Byte_LSB, uc_Byte_MSB;


    for(i=0; i<s_NumOfPoints; i++)
   {
      i3 = i*3;
      //Parse next 3 bytes to exract the Down stream virtual noise break points
        //Extract DS VN PSD
      uc_Byte_LSB = puca_OctetBuffer[i3]; //Bits 7:0, representing DS VN PSD.
        pt_PSDDesc->ut_PSDRecord[i].s_PSDLevelOfTone = uc_Byte_LSB;
      //Extract DS VN Tone Index
      uc_Byte_LSB = puca_OctetBuffer[i3+1]; //Bits 15:8, representing Tone Index.
      uc_Byte_MSB = puca_OctetBuffer[i3+2]; //Bits 23:16.
      uc_Byte_MSB = (uc_Byte_MSB & 0x1);  //Only Bit-16 contains the MSB of the Tone index.
        pt_PSDDesc->ut_PSDRecord[i].us_IndexOfTone = (uc_Byte_MSB << 8) + uc_Byte_LSB;
      //Bits 23:16, contains all zeros, reserved, not used as per Virtual Noise
      //feature in G.992.3 Ammendment-5.
   }

   for (j = 0; j < s_NumOfPoints; j++ )
   {

      // Convert PSD level from ADSL2 message format to PSD descriptor format:
      s_PSDLevel  = pt_PSDDesc->ut_PSDRecord[j].s_PSDLevelOfTone;

      //Added offset "80" to bring the VN between "-40dBm/Hz" to "-140dBm/Hz" in 0.5dB granulaity
      //So, "-40dBm/Hz" is stored as "80" (with 0.5dB granuality) &
      //"-140dBm/Hz" is stored as "280" (with 0.5dB granuality).
      s_PSDLevel = s_PSDLevel + 80;

      // VN level should be between -40dBm/Hz and -140dBm/Hz
      // API defined VN PSD level as offset from 0dBm/Hz with step size of 0.5dB
      if (s_PSDLevel < 80)
         s_PSDLevel = 80;
      else if (s_PSDLevel > 280)
         s_PSDLevel = 280;

      pt_PSDDesc->ut_PSDRecord[j].s_PSDLevelOfTone = s_PSDLevel;
   }

}
//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)


/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void DecodCMsgPcb_BIS(void);
*
*   Abstract:
*       Decode C_MSG_PCB message received from ATU-C
*
*   Input Parameters:
*     none
*
*  Return:
*     none
*
*  Global Variables:
*     guca_RCMsgPCBTab  -- (I) packed C_MSG_FMT received from ATU-C
*     gt_RCMsgPcb_bis      -- (O) structure containing decoded C_MSG_FMT messages
*
*-----------------------------------------------------------------------------
^^^*/

void DecodCMsgPcb_BIS(void)
{
    int32 i;
    uint8  uc_NumBlackoutbytes;
   uint16 us_NumOfDsVnBreakPoints, us_idx; //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise



    gt_RCMsgPcb_bis.us_C_MIN_PCB_DS = (guca_RCMsgPCBTab[0] & 0x3F);
    gt_RCMsgPcb_bis.us_C_MIN_PCB_US = ((guca_RCMsgPCBTab[0] >> 6) & 0x03) |
    ((guca_RCMsgPCBTab[1] & 0x0F) << 2);

#ifdef ISDN   // Only for Annex-B
    // PERF_US_BisPlus_CNXT_Reduce_US_PCB_By_3_dB (START)
    if((gt_INFX_CMV.us_OperatorSpBits & CMV_ENABLE_IOP_CNXT_REDUCE_US_PCB_BY_3dB) &&
            (gs_CurrentCoChipset == GSI_CO_CHIPSET) && (gl_SelectedMode & (MODE_G992_5)))
    {
        if(gt_RCMsgPcb_bis.us_C_MIN_PCB_US >= 3)
        {
            gt_RCMsgPcb_bis.us_C_MIN_PCB_US = gt_RCMsgPcb_bis.us_C_MIN_PCB_US - 3;
        }
        else
        {
            gt_RCMsgPcb_bis.us_C_MIN_PCB_US = 0;
        }
    }
    // PERF_US_BisPlus_CNXT_Reduce_US_PCB_By_3_dB (END)
   //SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (START)
#else   // ifdef ISDN
   if(gft_USPerf_Intracom_Gspn)
      gt_RCMsgPcb_bis.us_C_MIN_PCB_US = gt_RCMsgPcb_bis.us_C_MIN_PCB_US>>1;
   //SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (END)
#endif   // ifdef ISDN

    gt_RCMsgPcb_bis.us_HOOK_STATUS = ((guca_RCMsgPCBTab[1] >> 4) & 0x03);

    memcpy(gp_MEDLEYset_US, gp_SUPPORTEDset_US, sizeof(gp_SUPPORTEDset_US));

//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (Start)

   //SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START_END)
   //Extracting the C-BLOCK out bits from C-MSG-PCB
   //common for Loop Diagnostics Mode & Normal mode
   //Brought out side the if loop during virtual noise feature testing in LDM mode
    /* If US blackout bits are enabled, guca_RCMsgPCBTab[2] to guca_RCMsgPCBTab[5 or 9] */
    /* contain the information ; otherwise we will save CRC contained there at the end of
     guca_RCMsgPCBTab */

 //SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
    //SMS00859763 IOP_AB_DS_BisPlus_ALL_USblackoutbits (START)
    //32(blackout)= 32/8 = 4 bytes (ANNEX_A | ANNEX_L | ANNEX_I)
    //64(blackout)= 64/8 = 8 bytes (ANNEX_B | ANNEX_J | ANNEX_M)
    uc_NumBlackoutbytes = ((gs_TxNumTones+7)>>3);
    memset(gp_BlackoutBits_US, 0, uc_NumBlackoutbytes);
    //SMS00859763 IOP_AB_DS_BisPlus_ALL_USblackoutbits (END)
    if (gt_RCMsgFmt_bis.us_FMT_C_MSG_PCB)
    {
         // Copy blackout bits to BlackoutBits array.
         //SMS00859763 IOP_AB_DS_BisPlus_ALL_USblackoutbits (START_END)
         memcpy(gp_BlackoutBits_US, &guca_RCMsgPCBTab[2], uc_NumBlackoutbytes);
                  //Valid for Annex-A. //Not clear for Annex-M & Annex-J, as code copies
                     //only 4 octets for extracting blackout bits, which can give info
                     //about 32 tones only - Vinjam
                     //logic required: Replace "4" with "((gs_TxNumTones+7)>>3)" - Vinjam;

         // The Medley set is the Supported set minus any blacked out tones.
         for (i = 0; i < (int32) gs_TxNumTones; i++)
         {
            if (IS_TONEFLAGSET(gp_BlackoutBits_US, i))
               CLEARTONEFLAG(gp_MEDLEYset_US, i);
         }

    }
   //ADSLRTFW-1397 BugFix_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (Start)
   //Comment : Below code is corrupting the virtual noise break points present in guca_RCMsgPCBTab[].
    //else
    //{
    //     // No blackout bits.  Copy CRC.
    //     guca_RCMsgPCBTab[8] = guca_RCMsgPCBTab[2];
    //     guca_RCMsgPCBTab[9] = guca_RCMsgPCBTab[3];
    //}
   //ADSLRTFW-1397 BugFix_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (End)

 //SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

   //SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START_END)
   us_NumOfDsVnBreakPoints = gt_DS_RefVirtNoiseLevel_ADSL2.us_NumberOfTones;
   if ((STATArray[STAT_MacroState] == STAT_LoopDiagMode) && (us_NumOfDsVnBreakPoints == 0))
   {
#ifndef ISDN
      guc_CO_PassFail = guca_RCMsgPCBTab[6];
      guc_CO_Last_TX_State = guca_RCMsgPCBTab[7];
#else
      guc_CO_PassFail = guca_RCMsgPCBTab[10];
      guc_CO_Last_TX_State = guca_RCMsgPCBTab[11];
#endif
   }
   else
   {
   //SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
   //us_NumOfDsVnBreakPoints = gt_DS_RefVirtNoiseLevel_ADSL2.us_NumberOfTones;
   us_idx = 2;
      if (gt_RCMsgFmt_bis.us_FMT_C_MSG_PCB)
      us_idx = ((gs_TxNumTones+7)>>3)+2;   //Valid for Annex-A, Annex-B, Annex-J/M.
      //Extract downstream virtual noise break points
      /* Populate the DS VN PSD Descriptor table */
      if ((us_NumOfDsVnBreakPoints > 0) && (us_NumOfDsVnBreakPoints <= MAX_NUM_VN_DS_PSD_POINTS))
   {
         UnpackVNPSD((int16) us_NumOfDsVnBreakPoints,
            &(guca_RCMsgPCBTab[us_idx]),
            &gt_DS_RefVirtNoiseLevel_ADSL2);            // Ds
   }
   //SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

   //SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
      //Extract Diag information, if "LoopDiagMode is set & Virtual Noise feature is enabled
      if(STATArray[STAT_MacroState] == STAT_LoopDiagMode)
      {
          us_idx += (3*us_NumOfDsVnBreakPoints);
          guc_CO_PassFail = guca_RCMsgPCBTab[us_idx];
          guc_CO_Last_TX_State = guca_RCMsgPCBTab[us_idx+1];
      }
   //SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

   }

#if 0
   //ADSLRTFW-1397 BugFix_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (Start)
   //Vinjam: Legacy code (< 2005). Still Not understood the purpose of it ????
   //Retained at the end of this function. Don't move this.
   //This code is not used. So this code is commented out using compiler option.
   if((gt_RCMsgFmt_bis.us_FMT_C_MSG_PCB == 0) && (us_NumOfDsVnBreakPoints == 0))
   {
    //     // No blackout bits.  Copy CRC.
         guca_RCMsgPCBTab[8] = guca_RCMsgPCBTab[2];
         guca_RCMsgPCBTab[9] = guca_RCMsgPCBTab[3];
   }
   //ADSLRTFW-1397 BugFix_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (End)
#endif

//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (End)

}
