/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   DecodeCParams.c
*
*   Code for doing information exchange
*
*-------------------------------------------------------------------------
*/


// ******************************************************************************************************************
// DecodeCParams.c
//
// History
//
// 18/06/2012 Vinjam: Re-named "Params_t" structure's element "ft_TrellisSupported" to "us_VN_TCM_Supported".
//           This is done to convey the "Virtual Noise Selected" status as per VR9 Message Specifications doc (1.6.1).
//           Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 07/08/2012 Vinjam: Added a CMV "TEST 40 0 0x1" to force upstream fine gains to unity (0x2000) to measure CPE Tx PSD.
//           Grep for XDSLRTFW-501 Test_US_BisPlus_ALL_ForceUpStreamFineGainsToUnityForPSDmeasurement
//
// 29/8/2012 Vinjam: Changed CMV (from "TEST 40 0 0x1" to "TEST 28 0 0x2") to force upstream fine gains to unity
//            CMV is changed to keep it same across ARx & VRx platforms.
//            Grep for XDSLRTFW-501 Test_US_BisPlus_ALL_ForceUpStreamFineGainsToUnityForPSDmeasurement
//
//  07/02/18: Stefan: XDSLRTFW-2417: INFINEON not used anymore in VR9 ADSL code
//            Re-enable required code under #ifdef INFINEON
//            - KPN specific ADSL Annex-B (oISDN) Tx-spectrum
//            - Nlp = 1
//            grep for: XDSLRTFW-2417 #define INFINEON not used anymore in VR9 ADSL code
// ******************************************************************************************************************

#include "common.h"
#include "typedef_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "rinfo_bis.h"
#include "tx_ops2.h"
#include "pn_tab.h"
#include "dsp_op.h"
#include "dsp_op2.h"
#include "cmv.h"
#include "states.h"
#include "CalcRate_BIS.h"
#ifdef DEBUG_STREAMING
#include "DebugBuffer.h"
#endif

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : DecodeCParams
 *
 *  Description: Decodes C_PARAMS and fills necessary data structures
 *
 *
 *  Prototype:
 *       void DecodeCParams(void);
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *  Global Variables Used:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void DecodeCParams(void)
{
   int16 s_word;
   int16 us_LP_of_BC[4];
   uint8 s_Lp_lsb;
   uint8 s_Log2Dp;
   int i, j, idx;

   idx =0;

#ifdef DEBUG_STREAMING
   DSH_SendStream(DSH_C_PARAMS,sizeof(guca_R_C_PARAMS_bis),&guca_R_C_PARAMS_bis[0]);
#endif

    // PMD Parameters:
   gt_FarEndParam.us_LoopAttenuation = (uint16)(guca_R_C_PARAMS_bis[idx++]);
   gt_FarEndParam.us_LoopAttenuation |= (uint16)(guca_R_C_PARAMS_bis[idx++] << 8);

   gt_FarEndParam.us_SignalAttenuation = (uint16)(guca_R_C_PARAMS_bis[idx++]);
   gt_FarEndParam.us_SignalAttenuation |= (uint16)(guca_R_C_PARAMS_bis[idx++] << 8);

   gt_FarEndParam.s_SnrMargin = (int16)(guca_R_C_PARAMS_bis[idx++]);
   gt_FarEndParam.s_SnrMargin |= (int16)(guca_R_C_PARAMS_bis[idx++] << 8);

   gt_FarEndParam.ul_AttainableDataRate = (uint32)guca_R_C_PARAMS_bis[idx++];
   gt_FarEndParam.ul_AttainableDataRate |= ((uint32)guca_R_C_PARAMS_bis[idx++]) << 8;
   gt_FarEndParam.ul_AttainableDataRate |= ((uint32)guca_R_C_PARAMS_bis[idx++]) << 16;
   gt_FarEndParam.ul_AttainableDataRate |= ((uint32)guca_R_C_PARAMS_bis[idx++]) << 24;

   gt_FarEndParam.s_ActualAggregateXmtPwr = (int16)(guca_R_C_PARAMS_bis[idx++]);
   gt_FarEndParam.s_ActualAggregateXmtPwr |= (int16)(guca_R_C_PARAMS_bis[idx++] << 8); // CHECK

   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
   gt_FarEndParam.us_VN_TCM_Supported = (FlagT)(guca_R_C_PARAMS_bis[idx++]);     // US/DS TCM Support
   // set flag to use TCM in the upstream
   gft_TcmFlag_bis_US = gt_FarEndParam.us_VN_TCM_Supported;
   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

   if (gft_TcmFlag_bis_US)
    {
      STATArray[STAT_Misc] |= STAT_TCM_US;
    }

   idx++; // skip reserved octet (PMD #13 )

   // fill gsa_TxToneOrder[], gsa_TxBat[]

   guca_TxBat[0] = 0;
   gsa_TxFineGains[0] = 0;

   for(i=1; i<gs_TxNumTones; i++)
   {
      s_word = (int16)(guca_R_C_PARAMS_bis[idx++]);
      s_word |= (int16)(guca_R_C_PARAMS_bis[idx++]) << 8;
      guca_TxBat[i] = s_word & 0xF;

      //XDSLRTFW-501 Test_US_BisPlus_ALL_ForceUpStreamFineGainsToUnityForPSDmeasurement (Start)
      if (TESTArray[TEST_Control3] & TEST_ForceUpStreamFineGainsToUnity)
         gsa_TxFineGains[i] = 0x2000;
      else
         gsa_TxFineGains[i] = s_word & 0xFFF0;
      //XDSLRTFW-501 Test_US_BisPlus_ALL_ForceUpStreamFineGainsToUnityForPSDmeasurement (End)

   }

   gt_tx_config.psa_BAT = guca_TxBat;
    gt_tx_config.psa_FineGains = gsa_TxFineGains;

   idx++; // skip reserved octet

   if (( gl_SelectedMode & (MODE_G992_5)  ))
      idx++; // skip reserved octet

   gsa_TxToneOrder[0] = 0;
   for(i=1; i<gs_TxNumTones; i++)
   {
      gsa_TxToneOrder[i] = (int16)(guca_R_C_PARAMS_bis[idx++]);
        if (( gl_SelectedMode & (MODE_G992_5)  )) // if plus mode
      {
         gsa_TxToneOrder[i] |= (int16)(guca_R_C_PARAMS_bis[idx++]) << 8;
      }
   }

   // PMS Parameters:
    gt_tx_config.s_MSGlp =  (guca_R_C_PARAMS_bis[idx]) & 0x03;
    gs_InitFailCauseFarEnd =  (guca_R_C_PARAMS_bis[idx++] & 0xF0)>>4;

   // Clear array gt_tx_config.sa_Bpn[][]
    for(i=0; i<NUM_DATA_PATHS; i++)
      for(j=0; j<NUM_DS_BEARER_CHANNELS;j++)
         gt_tx_config.sa_Bpn[i][j] =0;

   us_LP_of_BC[0] = (guca_R_C_PARAMS_bis[idx]>>4) & 0xF; // This is the latency path to which BC0 is assigned.
   us_LP_of_BC[1] = guca_R_C_PARAMS_bis[idx++] & 0xF;    // This is the latency path to which BC1 is assigned.
   us_LP_of_BC[2] = (guca_R_C_PARAMS_bis[idx]>>4) & 0xF; // This and the next line should result in 0xF.
   us_LP_of_BC[3] = guca_R_C_PARAMS_bis[idx++] & 0xF;    // We have these lines in case if we want to expand # of supported BC.

   gt_tx_config.s_MSGc = guca_R_C_PARAMS_bis[idx++];

   gt_tx_config.s_Nbc = 0;// Initialize
   gt_tx_config.s_Nlp = 0;// Initialize

   for (i=0 ; i<2 ; i++)
   {
      if(us_LP_of_BC[i] != 0xF)
      {
         gt_tx_config.sa_Bpn[us_LP_of_BC[i]][i] = (int16) (guca_R_C_PARAMS_bis[idx]);
         gt_tx_config.s_Nbc++;
      }
      idx++;
   }

   for(j=0; j<NUM_US_BEARER_CHANNELS_SUPPORTED;j++)
      guca_txBCnToLPp[j] = (uint8)(us_LP_of_BC[j] & 0xF);

   // The max num of supported bearer channels is two.
   idx = idx +2;

   for (i=0 ; i<2 ; i++)
   {

      // Assign M, T, R, D and L parameters to gt_tx_config Latency path 0
      gt_tx_config.s_Mp[i] = (int16) (guca_R_C_PARAMS_bis[idx++]);
      gt_tx_config.s_Tp[i] = (int16) (guca_R_C_PARAMS_bis[idx++]);
      gt_tx_config.s_Rp[i] = (int16) ((guca_R_C_PARAMS_bis[idx]>>3)&0x1E);

      s_Log2Dp = guca_R_C_PARAMS_bis[idx++]&0x7;
      gt_tx_config.s_Dp[i] = 1;
      while (s_Log2Dp > 0)
      {
         gt_tx_config.s_Dp[i] <<= 1;
         s_Log2Dp--;
      }

      s_Lp_lsb = guca_R_C_PARAMS_bis[idx++];
      gt_tx_config.s_Lp[i] = (int16) ((guca_R_C_PARAMS_bis[idx++]<<8) | (s_Lp_lsb));
      if (gt_tx_config.s_Lp[i] > 0)
         gt_tx_config.s_Nlp++;
   }

   // XDSLRTFW-2417 #define INFINEON not used anymore in VR9 ADSL code
   // At Infineon's request, force Nlp =1 , i.e. disable dual latency.
   // See additional changes in ConfigTaskLayerForLinkStart().
   gt_tx_config.s_Nlp = 1;

   idx = idx + 10; // ignore the parameters for Latency paths 2 and 3

   // Calculate data rates in bps for management variables.  We do Rx here as well for compactness.
   //Update the net data rate and ovhd msg rate
   CalcRate_BitsPerSecond(&gt_rx_config, gla_DSDataRate, gsa_DSOvhdRate);
   CalcRate_BitsPerSecond(&gt_tx_config, gla_USDataRate, gsa_USOvhdRate);
}

