/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   FormRMsg1_bis.c
*
*   Code for doing information exchange
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// FormRMsg1_bis.c
//
// History
//
//
//
//14/03/2012 Kannan: 08/04/2009 Bhadra: Added code for uinversal ReTx R-Msg1 related changes
//                     Grep for SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod to see changes.
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// ******************************************************************
#include "common.h"
#include "typedef_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "rinfo_bis.h"
#include "cmv.h"
#include "trail.h"

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void FormRMsg1_BIS(void)
*
*   Abstract:
*       Pack R_MSG1 to the format for transmission
*
*   Input Parameters: none
*
*  Output Parameter: none
*
*  Global Variables:
*     gt_RMsg1_BIS      -- (I) R_MSGS1 information
*     guca_RMsg1Tab_BIS    -- (O) packed R_MSGS1 data
*
*-----------------------------------------------------------------------------
^^^*/
void FormRMsg1_BIS(void)
{
   int16 i;
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   //SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod (Start End)
   int16 s_numRMsg1Bytes;

   /* ============================================================= */
   /* Set R_MSGS1 */
   /* ============================================================= */
   //SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod (Start)
   s_numRMsg1Bytes = R_MSG1_NUM_BYTES_BIS;

#ifdef UNV_RETX_MSGS
   if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
      s_numRMsg1Bytes = R_MSG1_RETX_NUM_BYTES_BIS;
   }
#endif

   for (i = 0; i < s_numRMsg1Bytes; i++)
      guca_RMsgs1Tab_bis[i] = 0;

   //SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod ( End)
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

   /* m0-m3, maximum numbers of bits per tone supported */
   /* m4-m7 is set to zero */
   guca_RMsgs1Tab_bis[0] = (gt_RMsgs1_bis.us_MaxBitsPerTone & 0xF);

   /* m8-m15, max extension of gi range supported */
   guca_RMsgs1Tab_bis[1] = (gt_RMsgs1_bis.us_EXTGIus & 0xFF);

   /* m16-m21, minimum length of the C_MEDLEY state */
   /* m22-m23 is set to zero. */
   guca_RMsgs1Tab_bis[2] = (gt_RMsgs1_bis.uc_CA_MEDLEYds & 0x3F);

   /* m24-m31, Reserved bits, for bis and plus */
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod (Start)
#ifdef UNV_RETX_MSGS

   /* m32-m39, ReTx inforamtion.ie., half roundtrip of the
   ATU-R. The bits ssss contain the part in DMT symbols coded
   as integer from 0 to 15 and the bits dd contain the part in DTU
   coded as integer from 0 to 3. */
   if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {

      guca_RMsgs1Tab_bis[4] = (gt_ReTxConfigInfo.us_s_CPE & 0xF) |
                           ((gt_ReTxConfigInfo.us_d_CPE & 0x3) << 4);
      //FEATURE_BisPlus_ALL_CPARAMS_INP_FLAG_Modifications (Start)
      gt_ReTxConfigInfo.us_CPARAMS_INP_FLAG = ((gt_ReTxConfigInfo.us_ReTxConfigOptionBits & CMV_CPARAMS_INP_FLAG) >> 11);
      guca_RMsgs1Tab_bis[4] |= ((gt_ReTxConfigInfo.us_CPARAMS_INP_FLAG & 0x1) << 6);
      //FEATURE_BisPlus_ALL_CPARAMS_INP_FLAG_Modifications (End)
    }

#endif





//SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod (End)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
}
