/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   FormRMsg2_bis.c
*
*   Code for doing information exchange
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "typedef_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "rinfo_bis.h"
#include "trail.h"
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void FormRMsg2_BIS(void)
*
*   Abstract:
*       Pack R_MSG2 to the format for transmission
*
*   Input Parameters: none
*
*  Output Parameter: none
*
*  Global Variables:
*     gt_RMsg2_BIS      -- (I) R_MSGS1 information
*     guca_RMsg2Tab_BIS    -- (O) packed R_MSGS2 data
*
*-----------------------------------------------------------------------------
^^^*/
void FormRMsg2_BIS(void)
{
   int16 i, idx, s_bitnum;
    uint16 us_byte;


   /* ============================================================= */
   /* Set R_MSGS2 */
   /* ============================================================= */

   for(i=0; i<R_MSG2_NUM_BYTES_PLUS; i++)
      guca_RMsgs2Tab_bis[i] = 0;

   for(i=0; i<NSC_C_PARAMS; i++)
   {
       us_byte = gusa_Tones_RMsg2[i];

      idx = (int16)(us_byte>>3);
      s_bitnum = (int16)(us_byte & 0x07);

      // idx has the byte position and s_bitnum has the bit position
      guca_RMsgs2Tab_bis[idx] |=(0x1 << s_bitnum);
   }



}
