/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   FormRMsgFmt_bis.c
*
*   Code for doing information exchange
*
*-------------------------------------------------------------------------
*/



// ****************************************************************************************************
// FormRMsgFmt_bis.c
// History :
//  27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx(R-MSG-FMT in particular) and Rx-
//                   training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
//****************************************************************************************************

#include "common.h"
#include "typedef_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "rinfo_bis.h"
#include "cmv.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "pll.h"
#include "DebugBuffer.h"

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void FormRMsgFmt_BIS(void)
*
*   Abstract:
*       Pack R_MSG_FMT to the format for transmission
*
*   Input Parameters: none
*
*  Output Parameter: none
*
*  Global Variables:
*     gt_RMsgFmt_bis    -- (I) R_MSG_FMT information
*     guca_RMsgFMTTab      -- (O) packed R_MSG_FMT data
*
*-----------------------------------------------------------------------------
^^^*/
void FormRMsgFmt_BIS(void)
{
   int32 i;

   if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
   {
      gt_RMsgFmt_bis.us_FMT_R_REVERB1 = guc_RT_FMT_R_REVERB1;
   gt_RMsgFmt_bis.us_FMT_C_REVERB4 = guc_RT_FMT_C_REVERB4;
   gt_RMsgFmt_bis.us_FMT_C_TREF1 = guc_RT_FMT_C_TREF1_DURATION;

   /* Set PCB flag in FMT message iff DS blackout bits will be included in */
   /* R-MSG-PCB message. */
   gt_RMsgFmt_bis.us_FMT_R_MSG_PCB = 0;
   for (i = 4; i < LEN_R_MSGPCB_WITHOUT_CRC; i++)
   {
      if (guca_RMsgPCBTab[i] != 0)
      {
      gt_RMsgFmt_bis.us_FMT_R_MSG_PCB = 1;
      }
   }

   guca_RMsgFMTTab[0] = (gt_RMsgFmt_bis.us_FMT_R_REVERB1) |
                     (gt_RMsgFmt_bis.us_FMT_C_REVERB4 << 2) |
                     (gt_RMsgFmt_bis.us_FMT_C_TREF1 << 3) |
                     (gt_RMsgFmt_bis.us_FMT_R_MSG_PCB << 7);

   gs_R_C_TREF1_RX_LEN_BIS = 512 * guc_RT_FMT_C_TREF1_DURATION;
   }
   else
   {
        guca_RMsgFMTTab[0] = 0;
        gs_R_C_TREF1_RX_LEN_BIS = (int16)R_C_TREF1_RX_LEN_BIS_DIAG;
   }


   if(OPTNArray[OPTN_StateMachineCtrl] & OPTN_PilotOnDecTraining_Bis)
   {
      gt_RMsgFmt_bis.us_FMT_C_TREF2 = 1; /* 1 = RT asks the CO to transmit C-TREF during R-ECT; 0 = C-QUIET */
      gft_PilotOnDecTraining = TRUE;
   }
   else
   {
      gt_RMsgFmt_bis.us_FMT_C_TREF2 = 0; /* 0 = RT asks the CO to transmit C-QUIET during R-ECT; 1 = C-TREF */
      gft_PilotOnDecTraining = FALSE;
   }

   if (gft_AuxPilot == AUX_PILOT_ACTIVE)
   {
      guc_RT_FMT_C_PILOT = 0; /* 0 = RT asks the CO to transmit a data on the pilot tone */
   }

   gt_RMsgFmt_bis.us_FMT_C_PILOT = guc_RT_FMT_C_PILOT;

   guca_RMsgFMTTab[1] = (gt_RMsgFmt_bis.us_FMT_C_TREF2) |
                  (gt_RMsgFmt_bis.us_FMT_C_PILOT << 1);


    if (( gl_SelectedMode & (MODE_G992_5)  ))
   {
   guca_RMsgFMTTab[1] |= (gt_RMsgFmt_bis.uc_MedleyPRBSus <<2);
   }

#ifdef DEBUG_TRACES // XDSLRTFW-597
      LogMessages(4,NOT_END_OF_MSG,(uint16)R_MSG_FMT_MSG, (uint16)LEN_R_MSGFMT_WITHOUT_CRC, (uint8 *)guca_RMsgFMTTab, DEBUG_BUFFER_DELIMITER_ADSL);
#endif
#ifdef DEBUG_STREAMING
    DSH_SendStream(DSH_R_MSG_FMT,(uint8)LEN_R_MSGFMT_WITHOUT_CRC,&guca_RMsgFMTTab[0]);
#endif
}

