/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   FormRMsgLD_bis.c
*
*   Code that populates Loop Diagnostics messages.
*
*-------------------------------------------------------------------------
*/
// **********************************************************************************************************************************
//  FormRMsgLD_bis.c
//
// History
//
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// 12/7/2012 Vinjam: Code changes to convey actual SNR with out virtual noise to far end in loop diagnostics mode
//                Grep for //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 27/06/2013 Prashant: Bug fix to correctly report SNRM in DELT mode. As we are not doing actual SNRM calculation in DELT mode,
//                      It is populated with default values (6db).
//            Grep for XDSLRTFW-892 BugFix_DS_DELT_ALL_SNRM
//
// **********************************************************************************************************************************


#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "gdata_bis_diag.h"
#include "const_bis.h"
#include "cmv.h"
#include "diagparam_bis.h"
#include "dsp_op.h"
#include "InterpolateLDInfo.h"
#include "tx_ops_bis.h"

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void BgFormRMsgLD_BIS(void)
*
*   Abstract:
*       Background function to segment the Loop Diagnostics information and
*       populate R-MSGx-LD messages to be transmitted during R_MSG_LD_TX_BIS
*       state.
*
*   Input Parameters: none
*
*  Output Parameter: none
*
*-----------------------------------------------------------------------------
^^^*/
void BgFormRMsgLD_BIS(void)
{
   int16 s_ByteCnt;
   static int16 s_ToneCnt;

   /* Prepare next message only if C-ACK was received. */
   if (gft_RCAckLDRcvFlag == RECEIVE_OK1)
   {
      /* Increment the message counter. */
      guc_msg_ld_idx_us++;

      /* Populate message sequence number and reserved field. */
      if (( gl_SelectedMode & (MODE_G992_5)  ))
      {
         gpuca_RMSGx_LD[0] = guc_msg_ld_idx_us;             // Sequence number in PLUS
      }
      else
      {
         gpuca_RMSGx_LD[0] = (guc_msg_ld_idx_us << 4) & 0xF0;
         gpuca_RMSGx_LD[0] |= guc_msg_ld_idx_us & 0x0F;        // Sequence number in BIS
      }
      gpuca_RMSGx_LD[1] = 0x00;                          // Reserved field

      /* Populate the rest of the message based on the message type. */
      switch (guc_RMsgLDType)
      {
      case R_MSG_LD_SCLR:
         /* Form some of the scalars for R-MSG1-LD */
         guca_RMSG1_LD[0] = gt_DS_LDParam.s_Hlin_scale & 0xFF;             // Hlin Scale (lsb)
         guca_RMSG1_LD[1] = (gt_DS_LDParam.s_Hlin_scale>>8) & 0xFF;           // Hlin Scale (msb)

         /* Loop attenuation. */
         guca_RMSG1_LD[2] = guc_LoopAtten_LSB;
         guca_RMSG1_LD[3] = guc_LoopAtten_MSB;

         /* Signal attenuation. */
         guca_RMSG1_LD[4] = guc_SigAtten_LSB;
         guca_RMSG1_LD[5] = guc_SigAtten_MSB;

         /* Attainable net data rate (ATTNDR) */
         guca_RMSG1_LD[8] = (uint8)gl_ATTNDRds_Initial & 0xFF;
         guca_RMSG1_LD[9] = (uint8)(gl_ATTNDRds_Initial>>8) & 0xFF;
         guca_RMSG1_LD[10] = (uint8)(gl_ATTNDRds_Initial>>16)& 0xFF;
         guca_RMSG1_LD[11] = (uint8)(gl_ATTNDRds_Initial>>24) & 0xFF;

         guca_RMSG1_LD[12] = guc_ACTATP_LSB;
         guca_RMSG1_LD[13] = guc_ACTATP_MSB;                   //include sign bit extention

         // XDSLRTFW-892 BugFix_DS_DELT_ALL_SNRM (Start)
         guca_RMSG1_LD[6] =  (LOOPDIAG_SNRM * 10) & 0xFF;
         guca_RMSG1_LD[7] =  ((LOOPDIAG_SNRM * 10)>>8) & 0xFF;
         // XDSLRTFW-892 BugFix_DS_DELT_ALL_SNRM (End)

         /* Populate the message array. */
         for (s_ByteCnt = 2; s_ByteCnt < 16; s_ByteCnt++)
         {
            gpuca_RMSGx_LD[s_ByteCnt] = guca_RMSG1_LD[s_ByteCnt-2];
         }

         s_ToneCnt = 0;
         guc_RMsgLDType = R_MSG_LD_HLIN;

         /* Populate array */
         gt_NearEndParam.s_SnrMargin = (int16)(guca_RMSG1_LD[7]<<8)+guca_RMSG1_LD[6];
         gt_NearEndParam.ul_AttainableDataRate = ((int32)guca_RMSG1_LD[11]<<24)+(guca_RMSG1_LD[10]<<16)+(guca_RMSG1_LD[9]<<8)+guca_RMSG1_LD[8];

         gs_SnrMargin_OneOverTen_dB_Resolution = gt_NearEndParam.s_SnrMargin;
         break;

      case R_MSG_LD_HLIN:
         for (s_ByteCnt = 2; s_ByteCnt < 258; s_ByteCnt = s_ByteCnt + 4)
         {
            /* Interpolate data if in PLUS mode. */
            InterpolateLDInfo(s_ToneCnt, (uint8*)(void *)gpsa_RxHlin, &gpuca_RMSGx_LD[s_ByteCnt], 4, OUT_OF_RANGE_HLIN);

            s_ToneCnt++;
         }
         if (s_ToneCnt == gs_RxNumTones)
         {
            s_ToneCnt = 0;
            guc_RMsgLDType = R_MSG_LD_HLOG;
         }
         break;

      case R_MSG_LD_HLOG:
         for (s_ByteCnt = 2; s_ByteCnt < 258; s_ByteCnt = s_ByteCnt + 2)
         {
            /* Interpolate data if in PLUS mode. */
            InterpolateLDInfo(s_ToneCnt, (uint8*)(void *)gsa_RxHlogDS, &gpuca_RMSGx_LD[s_ByteCnt], 2, OUT_OF_RANGE_HLOG);

            s_ToneCnt++;
         }
         if (s_ToneCnt == gs_RxNumTones)
         {
            s_ToneCnt = 0;
            guc_RMsgLDType = R_MSG_LD_QLN;
         }
         break;

      case R_MSG_LD_QLN:
         for (s_ByteCnt = 2; s_ByteCnt < 258; s_ByteCnt = s_ByteCnt + 1)
         {
         //XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): Interpolate for PLUS mode
         // if 512pt QLN is enabled
         if (STATArray[STAT_QLN_Performance] & STAT_512Bin_QLN_ON)
            gpuca_RMSGx_LD[s_ByteCnt] =guca_QLN[s_ToneCnt];
         else
            /* Interpolate data if in PLUS mode. */
            InterpolateLDInfo(s_ToneCnt, guca_QLN, &gpuca_RMSGx_LD[s_ByteCnt], 1, OUT_OF_RANGE_QUIETLINE_PSD);

            s_ToneCnt++;
         }
         if (s_ToneCnt == gs_RxNumTones)
         {
            s_ToneCnt = 0;
            guc_RMsgLDType = R_MSG_LD_SNR;
         }
         break;

      case R_MSG_LD_SNR:
         for (s_ByteCnt = 2; s_ByteCnt < 258; s_ByteCnt++)
         {
            if((s_ToneCnt < gs_RxFirstChannel) || (s_ToneCnt > gs_RxLastChannel))
            {
               gpuca_RMSGx_LD[s_ByteCnt] = OUT_OF_RANGE_SNR & 0xFF;
            }
            else
            {
               //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (Start)
               if(gus_NumbDsVnBrkPoints > 0)
                  //Convey actual SNR with out virtual noise to far end in loop diagnostics mode
                  gpuca_RMSGx_LD[s_ByteCnt] = ((uint8)round((32<<8) + gpsa_RxSnrBufWoVN[s_ToneCnt],7)) & 0xFF;
               else
                  gpuca_RMSGx_LD[s_ByteCnt] = ((uint8)round((32<<8) + gsa_MedleySnrBuf[s_ToneCnt],7)) & 0xFF;
               //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (End)
            }

            s_ToneCnt++;
         }
         if (s_ToneCnt == gs_RxNumTones)
         {
            s_ToneCnt = 0;
            guc_RMsgLDType = R_MSG_LD_DONE;
         }
         break;
      }

      gft_RCAckLDRcvFlag = NOT_RECEIVE;
   }

   guc_BkgdTaskState = BKGDTASK_DONE;
}
