/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   FormRMsgPcb_bis.c
*
*   Code for doing information exchange
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "typedef_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "rinfo_bis.h"
#include "cmv.h"
#include "trail.h"

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void FormRMsgPcb_BIS(void)
*
*   Abstract:
*       Pack R_MSG_PCB to the format for transmission
*
*   Input Parameters: none
*
*  Output Parameter: none
*
*  Global Variables:
*     gt_RMsgPcb_bis    -- (I) R_MSG_PCB information
*     guca_RMsgPCBTab      -- (O) packed R_MSG_PCB data
*
*-----------------------------------------------------------------------------
^^^*/
void FormRMsgPcb_BIS(void)
{
   guca_RMsgPCBTab[0] = (gt_RMsgPcb_bis.us_R_MIN_PCB_DS) |
                  ((gt_RMsgPcb_bis.us_R_MIN_PCB_US & 0x03) << 6);

   guca_RMsgPCBTab[1] = ((gt_RMsgPcb_bis.us_R_MIN_PCB_US >> 2) & 0x0F) |
                  (gt_RMsgPcb_bis.us_HOOK_STATUS << 4);


   if (( gl_SelectedMode & (MODE_G992_5)  ))
   {
      guca_RMsgPCBTab[2] = (uint8)(gt_RMsgPcb_bis.us_C_PILOT & 0xFF);
      guca_RMsgPCBTab[3] = (uint8)((gt_RMsgPcb_bis.us_C_PILOT >> 8 ) & 0x07);    /* bit 24 to 26 of C_PILOT and rest are Reserved bits, set to 0 */
   }
   else
   {
      guca_RMsgPCBTab[2] = (uint8)(gt_RMsgPcb_bis.us_C_PILOT);
      guca_RMsgPCBTab[3] = 0;    /* Reserved bits, set to 0 */
   }

   /* The blackout bits should be used to modify guca_RMsgPCBTab[4-35]. */
   if(STATArray[STAT_MacroState] == STAT_LoopDiagMode)
   {
      if (( gl_SelectedMode & (MODE_G992_5)  ))
      {
         guca_RMsgPCBTab[68] = guc_RT_PassFail;
         guca_RMsgPCBTab[69] = guc_RT_Last_TX_State;
      }
      else
      {
         guca_RMsgPCBTab[36] = guc_RT_PassFail;
         guca_RMsgPCBTab[37] = guc_RT_Last_TX_State;
      }
   }




}
