/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   DecodingCParams.c
*
*   Code for doing information exchange
*
*-------------------------------------------------------------------------
*/
#include "common.h"
#include "const.h"

int16 FormSNRM(int16 s_SNRMargin)
{
   int32 temp;

   // Original gs_RxAvMargin is of Q8.8 format, we need to transform it to a 10bit 2's
   // complement signed integer snrm, with the value of SNRM defined as SNRM = snrm/10dB.
   // This data format supports an SNRM granulairty of 0.1dB and an SNRM dynamic range of
   // -51.1dB to 51.1dB.
   temp = (int32)(s_SNRMargin)*10;
   temp = (temp+ (int16)(1<<7)) >> 8;

   // According to BIS spec, snrm = -512 is a special value, which indicates that the snrm
   // is out of range to be represented. During diagnostic mode, it may also indicate that
   // the snrm value was not measured.
   if (temp < -511)
         temp = -512; // 0x200 special value!

   // However if the margin is very good (>51.1) - we don't want to mess up simple snr monitoring code
   // by sending a negative number, even though it would be technically compliant.
   // So we send the largest positive number.
   if (temp > 511) temp = 511;

   return((int16)temp);
}
