/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   rinfo_bis.c
*
*   Code for doing information exchange
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// GenRReverb_XcvrTrain_b.c
//
// History
//
//
// 19/08/2010 AdeelJ/Palaksh/Bhadra: Fix for ADSL2+ low US rates against Intracom CNXT DSLAM.
//               In case fix is enabled, The special TSSi set with wide spectrum and more power
//               on complex conjugate tones will be enabled. Here an additional modification to
//               the changed TSSi set is done. The TSSi values for tones 32, and 33 are set to zero.
//               In experiments it was seen that setting these values to zero enhances the US rate.
//               Grep for SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement
//
// 09/02/2011 Sriram: Use the special TSSI set from SMS00910375 in the range of
//            2100m to 4200m to improve the US rates against CNXT DSLAMs with FW
//            version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 18/04/2011 Sriram: Use the special TSSI set to improve the US rates against CNXT DSLAMs with FW version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 15/04/2014 ChiWen/Hanyu: Fine tuned US performance against CNXT DSLAMs based on ADSLRTFW-1480 and ADSLRTFW-1591 with the following changes
//  (1) Added special flat US TSSI;
//  (2) Set tone 32 to zero(gusa_US_Tssi_Value[32] = 0);
//  (3) Enabled special flat US TSSI in C-REVERB1/R-REVERB1 (might have influence over the final PGA training);
//  (4) Enabled special flat US TSSI in C-REVERB2;
//  (5) Renamed gft_USPerf_Midloop_Gspn to gft_USPerf_Gspn for all CNXT CO's;
//  (6) Above changes are applied to all CNXT CO/DSLAMs regardless of CO FW versions and controlled by CMV bit4 (MASK 0x0010) of info 103 27
//      that is ENABLED (bit4=1) by default. This is especially recommended at CenturyLink/USA. So far no side effect has been observed.
//  Grep for XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement
//
// ******************************************************************


#include "common.h"
#include "typedef_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "bitload_const.h"
#include "rinfo_bis.h"
#include "tx_ops2.h"
#include "pn_tab.h"
#include "dsp_op.h"
#include "tx_ops_bis.h"
#include "cmv.h"
#include "applyblackoutbits.h"
#include "tssi_rx.h"

/*^^^
*-----------------------------------------------------------------------------
*
*  Name:
*     BgGenRReverb_XcvrTrain
*
*  Description:
*     Generate freq domain R-Reverb signal to be used for Transceiver Training.
*     Note that this signal cannot be used for Channel Analysis, Exchange and showtime
*     phases.
*     Computes DS linear inverse tssi from log_tssi values in the process.
*
*   Prototype:
*       void BgGenRReverb_XcvrTrain(void);
*
*   Input Parameters:
*     none
*
*  Return:
*     none
*
*  Global Variables:
*     gt_RCMsgPcb_bis      -- (O) structure containing decoded C_MSG_FMT messages
*
*-----------------------------------------------------------------------------
^^^*/
#define SQRT_TWO  (23170)     // Sqrt(2) in 2.14 format.
void BgGenRReverb_XcvrTrain(void)
{
   int i;
   int16 s_TxNumTones;
   int16 s_NoImages = 0;
   s_TxNumTones = gs_TxNumTones;
#if 0 //Todo: The below code is rightway of doing for zero filling n conjugate
   if(gs_TX_IMAGE_NYQ & 0x200)
   {
      s_TxNumTones = TX_NUM_TONES;
      s_NoImages = 1;
   }
   else
      s_TxNumTones = gs_TxNumTones;
   if(gs_TX_IMAGE_NYQ & 0x100)
   {
      gft_IFFT64_T1413_TxImages = 1;
   }
#endif
   // Compute Ceiled Log Tssi
   if ((( gl_SelectedMode & (MODE_G992_5)  )) &&
      !(OPTNArray[OPTN_StateMachineCtrl] & OPTN_TssiCeil_Disable))
   {
      uint16 *pusa_DsLogTssi = gusa_DS_Tssi_Value;
      int16 s_DsLogTssi, s_DsPcb;

      // DS power cutback (dB)
      s_DsPcb = (gt_RCMsgPcb_bis.us_C_MIN_PCB_DS > gt_RMsgPcb_bis.us_R_MIN_PCB_DS) ?
               gt_RCMsgPcb_bis.us_C_MIN_PCB_DS: gt_RMsgPcb_bis.us_R_MIN_PCB_DS;

      for(i=0; i < gs_RxNumTones; i++)
      {
         s_DsLogTssi = *pusa_DsLogTssi;
         if (IS_TONEFLAGSET(p_SUPPORTEDset_DS, i))
         {
            // Adjust tssi for DS PCB
            s_DsLogTssi -= (s_DsPcb<<9);
            if (s_DsLogTssi < 0)
               s_DsLogTssi = 0;
         }
         *pusa_DsLogTssi++ = s_DsLogTssi;
      }
   }

   // Define QAM encoded tones according to US PRBS, and zero the DC tone.
   SyncSymbol(gsa_RReverbTones, s_TxNumTones, gusa_PN_US_Tab, ENCGAIN2);

   /* Apply the blackout bits before the conjugate and symmetric operation. */
    ApplyBlackoutBits(gsa_RReverbTones);

   // Incase we are using oversampled IFFT
   if ((gs_TxNumTones<<1) == TX_NUM_TONES)
   {
      // Nyquist tone.
      gsa_RReverbTones[2*gs_TxNumTones] = (int16) round((int32)SQRT_TWO * ENCGAIN2,14);
      gsa_RReverbTones[2*gs_TxNumTones+1] = 0;
      if(s_NoImages == 0)
      {
         // Mirror and conjugate tones 1-31 into tones 32-63
         for (i=gs_TxNumTones+1 ; i<TX_NUM_TONES ; i++)
         {
            gsa_RReverbTones[2*i] = gsa_RReverbTones[2*(TX_NUM_TONES-i)];
            gsa_RReverbTones[2*i+1] = -gsa_RReverbTones[2*(TX_NUM_TONES-i)+1]; // Conjugate.
         }
      }
   }

   //SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (START)
   //ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove (START_END)
#ifndef ISDN
    //XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove (START_END)
    //XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (START_END)
   if(( gft_USPerf_Intracom_Gspn ) || (gft_USPerf_Gspn))
   {
       gusa_US_Tssi_Value[32] = 0;  // This is the Nyquist Frequency Tone position for 64pt ifft emulation.
   }
#endif
   //SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (END)
   // Scale by tssi values, which have format 6.10.
   for (i=0; i < TX_NUM_TONES; i++)
   {
      gsa_RReverbTones[2*i] = (int16) round((int32)gsa_RReverbTones[2*i] * gusa_US_Tssi_Value[i],10);
      gsa_RReverbTones[2*i+1] = (int16) round((int32)gsa_RReverbTones[2*i+1] * gusa_US_Tssi_Value[i],10);
   }

   guc_BkgdTaskState = BKGDTASK_DONE;
}
#undef SQRT_TWO
