/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RAckNAckLDTxF_bis.c
 *
 *   ATU-R Exchange Phase in diagnostics mode.
 *   Covering the TX states: R_ACK_NACK_LD_TX_BIS
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "tx_ops.h"
#include "states.h"
#include "tx_ops_bis.h"
#include "RQuiet3LDTxF_bis.h"
#include "const.h"
#include "TxTneSt.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RAckNAckLDTxF_BIS
 *
 *  Description: Transmits the R_Segue or R_Reverb signal to the ATU-C.
 *
 *  Prototype: void RAckNAckLDTxF_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount     - (I) # symbol periods in current TX state
 *      gs_TxNextState       - (O) TX state that will begin next symbol period
 *      gt_StateMachCntrl    -  (O) Maintains state machine control variables
 *
 *  Notes: implements states R_ACK_NACK_LD_TX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RAckNAckLDTxF_BIS(void)
{
   //const unit8 uc_Act_byte = 0x55;

   int16 s_temp;
   uint16 us_infobit;

    if (gl_TxSymbolCount == 0)
   {
      gs_TxSubState = 0;

      /* If RX receives C-MSGx-LD message correctly, TX should send out R-ACK. */
      /* Otherwise, R-NACK(Quiet) will be transmitted to CO */
      if(gft_RCExch1RcvFlag != RECEIVE_OK1)
      TxToneSetUp(0,0,0);
    }

   s_temp = (int16)(gl_TxSymbolCount % 8);

   if((s_temp == 0) && (gft_RCExch1RcvFlag == RECEIVE_OK1))
   {
      us_infobit = (C_ACK_MESSAGE_LD >> gs_TxSubState ) & 0x01;
      gs_TxSubState++;

   /* 0=R_REVERB; 1= R_SEGUE */
   TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, us_infobit);
   }


    if (gl_TxSymbolCount == (R_ACK_NACK_LD_TX_LEN_BIS -1))
   {
      gs_TxNextState = R_QUIET3_LD_TX_BIS;
   gpF_TxStateFunc = (PtrToFunc)RQuiet3LDTxF_BIS;
    }

}

