/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RCComb1RxF_BIS.c
 * DESCRIPTION:      Implements the RX state function for the C-COMB1 state
 *                   in G.dmt.bis.
 *
 **********************************************************************/

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "detect.h"
#include "states.h"
#include "RCQuietRxF_bis.h"
#include "pga_set.h"
#include "vecpwr.h"
#include "fifo.h"
#include "memcopy.h"
#include "memsetbf.h"
#include "BgDetectMultiTones_Comb.h"

/**********************************************************************
 * Function: RCComb1RxF_BIS
 *
 * Description: Implements the state R_C_COMB1_RX_BIS.
 **********************************************************************/

void RCComb1RxF_BIS(void)
{
   int16 ft_DetectCntThresholdMet;

   gs_TrainCnt++;

   if (gl_RxSymbolCount == 0){
      gs_RxDetectCnt = 0;
      // Initialize BgDetectMultiTones state.
      guc_BkgdTaskState = TRAINING_DONE;
      gft_BgDetectMultiTonesResult = 1;   // Means Quiet not detected.

#ifdef ADSL_62_XYMEM
      MemSetBuffer(gpsa_RxToneBuf_sav2, 0, 0, (int16)(sizeof(int16)*(gs_RxNumTones*2)));
#endif
   }

   /* Detect the beginning of C-QUIET2 */
   if(gs_TrainCnt > (PGA_ACCUM_SYMBOLS+1))
   {
      ft_DetectCntThresholdMet = 0;

      if (guc_BkgdTaskState == TRAINING_DONE){  // Check if BgDetectMultiTones has completed.

         if (!gft_BgDetectMultiTonesResult)
            gs_RxDetectCnt++;     /*  No C-COMB symbol present, increment Quiet detect count */
         else
            gs_RxDetectCnt = 0;

//       if (gs_RxDetectCnt >= R_C_COMB_QUIET_TRANSITIONS_CNT_BIS)
         if (gs_RxDetectCnt >= gs_ChanDiscDetCnt) //R_C_COMB_QUIET_TRANSITIONS_CNT_BIS)
            ft_DetectCntThresholdMet = 1;
         else {
            // Restart BgDetectMultiTones
            MemCopyWords(gpsa_RxToneBuf_sav2, 0, gsa_RxToneBuf, 0, (int16)(2*gs_RxNumTones));
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgDetectMultiTones_Comb);
            guc_BkgdTaskState = TRAINING_IN_PROGRESS;
         }
      }

      if(ft_DetectCntThresholdMet)
      {
         gs_RxNextState = R_C_QUIET2_RX_BIS;
         gpF_RxStateFunc = (PtrToFunc)RCQuiet2RxF_BIS;
         gft_BIS_TX_transition = TRUE;    // TX state may transition to R-COMB1
      }
   }

   if(gl_RxSymbolCount >= R_C_COMB1_RX_LEN_BIS - 1 + BIS_TIME_OUT_LENGTH)
   {
      gs_RxNextState = FAIL_RX;
      gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

      /* Set exception handler variables */
      gus_ExceptionState   = gs_RxState;
      gus_ExceptionCode = E_CODE_RCQuietRx_Bis_TIME_OUT;
   }
}
