/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RCComb2RxF_BIS.c
 * DESCRIPTION:      Implements the RX state function for the C-COMB2 state
 *                   in G.dmt.bis.
 *
 **********************************************************************/
//*******************************************************************
// RCComb2RxF_BIS.c
//
// History
//
// 14/05/2010 Nihar: QLN/HLOG calibration for Annex-B DMT, ADSL2/2+
//             Grep for Feature_DS_BisPlus_ALL_VR9QLNCalib
//
//*****************************************************************************
#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "pll.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "vecpwr.h"
#include "detect.h"
#include "accum32.h"
#include "fifo.h"
#include "bufmisc.h"
#include "memsetbf.h"
#include "noiseacc.h"
#include "pga_set.h"
#include "states.h"
#include "RCQuiet3RxF_bis.h"
#include "hndshk_Data.h"
#include "snr.h"
#include "BGChooseRevSegBin.h"
#include "memcopy.h"
#include "memsetbf.h"
#include "afe.h"
#include "DetectComb.h"
#include "tx_ops_bis.h"
#include "bitload_const.h"
#include "cmv.h"
#include "SetPgaForToneDetection.h"
#include "ComputeDsPCB.h"
#include "afe.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"


extern BkgdFunction BGComb2SnrCalc_bis;


#define R_C_COMB2_RX_BIS_RESET_PGA          0
#define R_C_COMB2_RX_BIS_RESET_PGA_WAIT     1
#define R_C_COMB2_RX_BIS_INITIALIZE2        2
#define R_C_COMB2_RX_BIS_COMPUTE_DS_POWER_CUTBACK  3
#define R_C_COMB2_RX_BIS_RESTORE_PGA        4
#define R_C_COMB2_RX_BIS_RESTORE_PGA_WAIT   5
#define R_C_COMB2_RX_BIS_INITIALIZE1      6
#define R_C_COMB2_RX_BIS_LOCK_PHASE       7
#define R_C_COMB2_RX_BIS_INITIALIZE3        8
#define R_C_COMB2_RX_BIS_AVERAGE_FRAME       9
#define R_C_COMB2_RX_BIS_SELECT_PILOT       10
#define R_C_COMB2_RX_BIS_PREDETECT1_ICOMB   11
#define R_C_COMB2_RX_BIS_DETECT1_ICOMB       12
#define R_C_COMB2_RX_BIS_PREDETECT2_ICOMB   13
#define R_C_COMB2_RX_BIS_DETECT2_ICOMB       14
#define R_C_COMB2_RX_BIS_SKIP_LINEPROBE      15
#define R_C_COMB2_RX_BIS_END           16


/**********************************************************************
 * Function: RCComb2RxF_BIS
 *
 * Description: Implements the states R_C_COMB2_RX_BIS, R_C_ICOMB1_RX_BIS
 *              and R_C_LINEPROBE_RX_BIS.
 **********************************************************************/
#ifdef INFINEON
extern void WriteAfe(int16 addr, int16 data);
#endif

void RCComb2RxF_BIS(void)
{
   int i;
   int16 s_detection_result;

   switch (gs_RxSubState) {

   case R_C_COMB2_RX_BIS_RESET_PGA:

         /* save the current pga value */
         gs_PGA_required_saved = gs_PGA_required;
         gs_PGA_required = gs_min_pga_setting; /* reset the PGA setting to its minimum value for power cutback computation */
         //gs_PGA_required = gs_min_pga_setting_RefPCB; /* reset the PGA setting to its minimum value for power cutback computation */

         guc_PgaTrainingState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgPGA);
         gs_RxSubState = R_C_COMB2_RX_BIS_RESET_PGA_WAIT;

      break;

   case R_C_COMB2_RX_BIS_RESET_PGA_WAIT:

      if (guc_PgaTrainingState == TRAINING_DONE) {
         gft_EnablePLL = FALSE;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_HskQlnHlogSetHybrid);

         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_COMB2_RX_BIS_INITIALIZE2;
      }
      break;

    case R_C_COMB2_RX_BIS_INITIALIZE2:

      gs_RxSubStateCnt++;

      if(gs_RxSubStateCnt == PGA_SETTLING_TIME)
      {
         /* clear average power accumulator; */
         gl_Pa = 0;
         /* Go to next substate */
            gs_RxSubState = R_C_COMB2_RX_BIS_COMPUTE_DS_POWER_CUTBACK;
            gs_RxSubStateCnt = 0;
         /* clear states */
         guc_AccumState = TRAINING_WAITING;
         guc_BkgdTaskState = TRAINING_WAITING;
         /* Clear gla_RxAccumBuf before use it */
         MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*2*gs_RxNumTones));
#ifdef ADSL_62_XYMEM
         MemSetBuffer(gsa_FDQ_coef_best, 0, 0, (int16)sizeof(int16)*(gs_RxNumTones*2));
#endif
        }
        break;

      /* ======================================================================== */
      /* Conpute the average received power and DS power cutback if necessary     */
      /* ======================================================================== */
   case R_C_COMB2_RX_BIS_COMPUTE_DS_POWER_CUTBACK:

         gs_RxSubStateCnt++;

         // accumulate representative frame of frequency domain samples
         if(gs_RxSubStateCnt <= R_C_COMB2_AC_LEN_BIS)
         {
            Accum16to32(gla_RxAccumBuf, 0, gsa_RxToneBuf, 0, gs_RxSamplesPerFrame);
         }
         // Wait for accumulation to be completed
         else if(gs_RxSubStateCnt == (R_C_COMB2_AC_LEN_BIS+1))
         {
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgRightShiftAndRound32to16);
            guc_AccumState = TRAINING_IN_PROGRESS;
         }
         // Wait for averaging to be completed
         else if (guc_AccumState == TRAINING_DONE)
         {
            guc_AccumState = TRAINING_WAITING;

            // Compute DS PCB here using representative freq domain frame in gsa_RxRepFrameAlignBuf.
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgComputeDsPCB);
            guc_BkgdTaskState = TRAINING_IN_PROGRESS;
         }
         // Wait for DS PCB bkgd task to complete.
         else if (guc_BkgdTaskState == TRAINING_DONE)
         {

            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_RestoreHyb_QlnHlog);

               #ifdef DANUBE_AFE
               // retore hyb hpf with setting from afeini
               WriteAfe(DANUBEA_HYB_SET_A, gs_HybA);
            WriteAfe(DANUBEA_HYB_SET_B, gs_HybB);
            /* Turn HPF on and equalizer off and set HPF corner frequency x. */
            gs_HPFEq_Reg_Setting = gs_HPF_init; //0x0001;
            WriteAfe(DANUBEA_HPF_EQ_SET,gs_HPFEq_Reg_Setting);
               #endif

            guc_BkgdTaskState = TRAINING_WAITING;

            /* If PGA set was disabled, power cutback is not calculated properly so set it to 0. */
            if (gft_SetPGADisable != FALSE)
            {
               gt_RMsgPcb_bis.us_R_MIN_PCB_DS = 0;
            }

            gft_CopyRxBuffer = TRUE;
            gs_RxSubState = R_C_COMB2_RX_BIS_RESTORE_PGA;
            gs_RxSubStateCnt = 0;
         }

         break;


   case R_C_COMB2_RX_BIS_RESTORE_PGA:

   /* get the saved pga value. */
        gs_PGA_required = gs_PGA_required_saved;


      guc_PgaTrainingState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgPGA);
      gs_RxSubState = R_C_COMB2_RX_BIS_RESTORE_PGA_WAIT;
      break;

   case R_C_COMB2_RX_BIS_RESTORE_PGA_WAIT:

      if (guc_PgaTrainingState == TRAINING_DONE) {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_COMB2_RX_BIS_INITIALIZE1;
      }
      break;



    /* ================================================================== */
   /* Initialize the phase lock loop (PLL) parameters and power variable */
   /* ================================================================== */
      case R_C_COMB2_RX_BIS_INITIALIZE1:

         gs_RxSubStateCnt++;

        if(gs_RxSubStateCnt == PGA_SETTLING_TIME)
      {
      /* Get the reference phase of pilot signal */
         ResetPllRefTone(gsa_RxPilotTone[0], gsa_RxPilotTone[1]);

      /* Turn on PLL */
         gft_EnablePLL = TRUE;

      /* Set PLL loop filter parameters to fast converge */
         ResetPLL((int16)gs_Kp_Fast, (int16)gs_Ki_Fast, (int16)PLL_HALF_PI_RADIANS);

      /* Here gs_PilotToneIdx is equal to gs_ChosenPilot_preSNR */
         ScalePLL(gs_PllScaling_bis_preSNR);

      /* go to next substate */
         gs_RxSubStateCnt = 0;
         gs_TrainCnt = 0;
         gs_RxSubState = R_C_COMB2_RX_BIS_LOCK_PHASE;
      }
         break;

   /* ====================================================================== */
   /*  Wait for phase lock, set steady-state PLL parameters                  */
   /* ====================================================================== */
   case R_C_COMB2_RX_BIS_LOCK_PHASE:

        gs_TrainCnt++;

      if(gs_TrainCnt >= PGA_SETTLING_TIME)
      {

      /* Update substate count */
         gs_RxSubStateCnt++;

      /* Reset PLL loop filter parameters to slow converge parameters */
         if(gs_RxSubStateCnt == PLL_FAST_ACQUISITION_LEN)
         {
            ResetPLL((int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);

         /* Here gs_PilotToneIdx is equal to gs_ChosenPilot_preSNR */
            ScalePLL(gs_PllScaling_bis_preSNR);
         }


      /* Achieve phase lock */
         if(gs_RxSubStateCnt == PLL_ACQUISITION_LEN0) {
            gl_Pa =0;
            gs_RxSubState = R_C_COMB2_RX_BIS_INITIALIZE3;
            gs_RxSubStateCnt = 0;
         }
      }
         break;

    case R_C_COMB2_RX_BIS_INITIALIZE3:

   // gs_RxSubStateCnt++;

   // if(gs_RxSubStateCnt == PGA_SETTLING_TIME)
   // {

         /* Clear gla_RxAccumBuf before use it */
         MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*2*gs_RxNumTones));

      //   gft_EnablePLL = TRUE;
            gs_RxSubState = R_C_COMB2_RX_BIS_AVERAGE_FRAME;
            gs_RxSubStateCnt = 0;

      //  }
        break;

      /* ======================================================================== */
      /* Get the representative frame by averaging over R_C_COMB2_AC_LEN_BIS frames   */
      /* ======================================================================== */
      case R_C_COMB2_RX_BIS_AVERAGE_FRAME:

         gs_RxSubStateCnt++;

         /*  accumulate representative frame of frequency domain samples */
         if(gs_RxSubStateCnt <= R_C_COMB2_AC_LEN_BIS)
            Accum16to32(gla_RxAccumBuf, 0, gsa_RxToneBuf, 0, gs_RxSamplesPerFrame);

         if(gs_RxSubStateCnt == (R_C_COMB2_AC_LEN_BIS+1)) {
            guc_AccumState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgRightShiftAndRound32to16);

         }

         if(guc_AccumState == TRAINING_DONE)
         {
            guc_AccumState = TRAINING_WAITING;
            MemCopyWords(gsa_Comb2SignalBuf, 0, gsa_RxRepFrameAlignBuf, 0, (int16)(2*gs_RxNumTones));

            gs_RxSubStateCnt =0;
#ifdef NOISEACC_COMB2
            MemSetBuffer(gla_AccumBufComb, 0, 0,(2*(C_COMB_INDEX_CNT_G992_5 + 20)));
#else
            MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*2*gs_RxNumTones));
#endif //NOISEACC_COMB2
            gs_RxSubState = R_C_COMB2_RX_BIS_SELECT_PILOT;

            // Determine gs_C_COMB_FIRSTCHAN_IDX and gs_C_COMB_LASTCHAN_IDX depending
            // on what mode we are running i.e. depeding on DS supported channels
            for (i = 0; i < C_COMB_INDEX_CNT_G992_5; i++)
            {
               if (gsa_C_COMB_index[C_COMB_INDEX_CNT_G992_5-i-1] >= gs_RxFirstChannel)
                  gs_C_COMB_FIRSTCHAN_IDX = C_COMB_INDEX_CNT_G992_5-i-1;
               if (gsa_C_COMB_index[i] <= gs_RxLastChannel)
                  gs_C_COMB_LASTCHAN_IDX = i;
            }
         }
         break;

      case R_C_COMB2_RX_BIS_SELECT_PILOT:
         gs_RxSubStateCnt ++;
         if(gs_RxSubStateCnt <=(NUM_SNR_TRAINING_SYMBOLS_TEST))
         {
#ifdef NOISEACC_COMB2
            NoiseAccComb2(gla_AccumBufComb,  gsa_RxToneBuf, gsa_Comb2SignalBuf);
#else
            NoiseAcc(gla_RxAccumBuf, (int16)(2*gs_RxFirstChannel), gsa_RxToneBuf, 0/* Indicates Not Medley*/, -1, -1,/* -1 => Unused input parameters */
                  gsa_Comb2SignalBuf, gs_RxFirstChannel, gs_RxLastChannel);
#endif //NOISEACC_COMB2
         }
         if(gs_RxSubStateCnt == (NUM_SNR_TRAINING_SYMBOLS_TEST))
         {

               guc_SnrCalcState = TRAINING_IN_PROGRESS;
               AddFunctionToBkgdFifo((PtrToBkgdFunc)BGComb2SnrCalc_bis);
               guc_AccumState = TRAINING_WAITING;
         }

         if(guc_SnrCalcState ==TRAINING_DONE)
         {
            if (guc_AccumState == TRAINING_WAITING) {   // Start search
               guc_AccumState = TRAINING_IN_PROGRESS;
               AddFunctionToBkgdFifo((PtrToBkgdFunc)BGChoosePilot);
            }
            if (guc_AccumState == TRAINING_DONE) {      // Goto next substate when search complete
               gt_RMsgPcb_bis.us_C_PILOT = gs_CPilotTone;

               // Pilot tone is in the MEDLEYset as it is defined by the
               // g.992.3/.5 spec, but for convenience we clear its bit to ensure it is not bitloaded.
               CLEARTONEFLAG(p_MEDLEYset_DS, gs_CPilotTone);

                    if(gs_ChosenPilot_CD != gs_ChosenPilot_preSNR)
               {
                  gs_PilotToneIdx = gs_ChosenPilot_CD;
                  gft_EnablePLL = FALSE;
               }

// We dont need to clear this buffer. Also, not clearing this buffer
// enables us to look @ Comb Snrs by jumping to Done state before RCReverb3
//             MemSetBuffer(gsa_ReverbSnrBuf, 0, 0, gs_RxNumTones);

               MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*2*gs_RxNumTones));
               MemCopyWords(gsa_RxRepFrameAlignBuf, 0, gsa_Comb2SignalBuf, 0, (int16)(2*gs_RxNumTones));

               gs_RxSubStateCnt = 0;
               gs_RxSubState = R_C_COMB2_RX_BIS_PREDETECT1_ICOMB;
            }
         }

         break ;

       case R_C_COMB2_RX_BIS_PREDETECT1_ICOMB:

         gs_RxSubStateCnt++;

         if((gs_ChosenPilot_CD != gs_ChosenPilot_preSNR)
            && (gs_RxSubStateCnt == 1))
         {
         gft_EnablePLL = TRUE;
              ResetPllRefTone(gsa_RxPilotTone[0], gsa_RxPilotTone[1]);
              ResetPLL((int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);
              ScalePLL(gs_PllScaling_bis_CD);
         }

         if(gl_RxSymbolCount == R_C_COMB2_SHORT_RX_LEN_BIS - gs_ChanDiscDetCnt - 1)
         {
            gft_EnablePLL = FALSE;
            gs_RxSubState = R_C_COMB2_RX_BIS_DETECT1_ICOMB;
            gs_RxSubStateCnt = 0;
                gs_COMB_counter = 0;
            gs_ICOMB_counter =0;
         }

         break;

      case R_C_COMB2_RX_BIS_DETECT1_ICOMB:

         if((gl_RxSymbolCount % 2) == 0)
         {  /* Check if CO is sending C-ICOMB/C-COMB instead of C-QUIET */
            if(DetectMultiTones(gsa_RxToneBuf, (short *)gsa_COMB_ICOMB_DetectionBins, (int16) guc_NUM_OF_BINS_FOR_COMB_DETECTION,  (int16)((guc_NUM_OF_BINS_FOR_COMB_DETECTION+1)>>1), (int16)(gs_ToneDetectScale*256)) )
               gs_RxSubStateCnt++;     /*  C-ICOMB or C-COMB symbol present, inc its counter */
         }
         else  /* ((gl_RxSymbolCount % 2) == 1) */
         {
                s_detection_result = DetectComb(gsa_RxRepFrameAlignBuf, 0);

               if(s_detection_result == C_COMB_DETECTED)
               gs_COMB_counter++;         /* This frame looks like a C-COMB symbol */
               else if(s_detection_result == C_ICOMB_DETECTED)
               gs_ICOMB_counter++;     /* This frame looks like a C-ICOMB symbol */

         }


         if(gl_RxSymbolCount == R_C_COMB2_SHORT_RX_LEN_BIS - gs_ChanDiscDetCnt + R_C_ICOMB1_RX_LEN_BIS)
         {

            if((gs_RxSubStateCnt >= (int16)(R_C_ICOMB1_THRESHOLD/2))
               && (gs_COMB_counter >= gs_ICOMB_counter))
            {
               /* C-COMB signal detected, that is, length of C-COMB2 is 3872 */
               gft_EnablePLL = TRUE;
               gs_RxSubState = R_C_COMB2_RX_BIS_PREDETECT2_ICOMB;
            }
            else if ((gs_RxSubStateCnt >= (int16)(R_C_ICOMB1_THRESHOLD/2))
               && (gs_COMB_counter < gs_ICOMB_counter))
            {
                  /* C-COMB signal detected, that is, length of C-COMB2 is 1024 and C-LINEPROBE will follow C-ICOMB2 state */
                   gs_RxSubState = R_C_COMB2_RX_BIS_SKIP_LINEPROBE;
            }
            else
            {
            /*   C-QUIET signal detected, that is, length of C-COMB2 is 1024 and C-LINEPROBE is not sent out */
               gs_RxSubState = R_C_COMB2_RX_BIS_END;
                }

         }

         break;




      case R_C_COMB2_RX_BIS_PREDETECT2_ICOMB:

            if(gl_RxSymbolCount == R_C_COMB2_NORMAL_RX_LEN_BIS - gs_ChanDiscDetCnt - 2)
            gft_EnablePLL = FALSE;

         if(gl_RxSymbolCount == R_C_COMB2_NORMAL_RX_LEN_BIS - gs_ChanDiscDetCnt - 1)
         {
            // C-COMB2 should end now. We will check if CO wants to do lineprobe.
            gs_RxSubState = R_C_COMB2_RX_BIS_DETECT2_ICOMB;
            gs_RxSubStateCnt = 0;
         }

         break;

      case R_C_COMB2_RX_BIS_DETECT2_ICOMB:

         if(gl_RxSymbolCount <= R_C_COMB2_NORMAL_RX_LEN_BIS - gs_ChanDiscDetCnt - 1 + R_C_ICOMB1_RX_LEN_BIS)
         {  /* Check if CO is sending C-ICOMB instead of C-QUIET */
            if(DetectMultiTones(gsa_RxToneBuf, (short *)gsa_COMB_ICOMB_DetectionBins, guc_NUM_OF_BINS_FOR_COMB_DETECTION,  (int16)((guc_NUM_OF_BINS_FOR_COMB_DETECTION+1)>>1), (int16)(gs_ToneDetectScale*256)) )
               gs_RxSubStateCnt++;     /*  C-ICOMB symbol present, inc its counter */
         }
         else
         {  /* Decide whether we should skip C-LINEPROBE */
            if(gs_RxSubStateCnt >= R_C_ICOMB1_THRESHOLD)
               gs_RxSubState = R_C_COMB2_RX_BIS_SKIP_LINEPROBE;
            else
               gs_RxSubState = R_C_COMB2_RX_BIS_END;

               gs_RxSubStateCnt = 0;
         }

         break;

      case R_C_COMB2_RX_BIS_SKIP_LINEPROBE:

         gs_RxSubStateCnt++;
         if(gs_RxSubStateCnt == R_C_LINEPROBE_RX_LEN_BIS)
         {
            gs_RxSubState = R_C_COMB2_RX_BIS_END;
            gs_RxSubStateCnt = 0;
         }
         break;

      case R_C_COMB2_RX_BIS_END:

         /* Detect the beginning of C-QUIET3 */
            if(!DetectMultiTones(gsa_RxToneBuf, (short *)gsa_COMB_ICOMB_DetectionBins, (int16)guc_NUM_OF_BINS_FOR_COMB_DETECTION,  (int16)((guc_NUM_OF_BINS_FOR_COMB_DETECTION+1)>>1), (int16)(gs_ToneDetectScale*256)) )
            gs_RxSubStateCnt++;     /*  C-QUIET symbol present, inc its counter */
         else
            gs_RxSubStateCnt = 0;

         if(gs_RxSubStateCnt == R_C_TRANSITION_CNT_BIS)
         {
            gs_RxNextState = R_C_QUIET3_RX_BIS;
            gpF_RxStateFunc = (PtrToFunc)RCQuiet3RxF_BIS;
            gft_BIS_TX_transition = TRUE; // Can start sending R-COMB2 on TX path
         }

         break;
   }
}


#undef R_C_COMB2_RX_BIS_RESET_PGA
#undef R_C_COMB2_RX_BIS_RESET_PGA_WAIT
#undef R_C_COMB2_RX_BIS_INITIALIZE2
#undef R_C_COMB2_RX_BIS_COMPUTE_DS_POWER_CUTBACK
#undef R_C_COMB2_RX_BIS_RESTORE_PGA
#undef R_C_COMB2_RX_BIS_RESTORE_PGA_WAIT
#undef R_C_COMB2_RX_BIS_INITIALIZE1
#undef R_C_COMB2_RX_BIS_LOCK_PHASE
#undef R_C_COMB2_RX_BIS_INITIALIZE3
#undef R_C_COMB2_RX_BIS_AVERAGE_FRAME
#undef R_C_COMB2_RX_BIS_SELECT_PILOT
#undef R_C_COMB2_RX_BIS_PREDETECT1_ICOMB
#undef R_C_COMB2_RX_BIS_DETECT1_ICOMB
#undef R_C_COMB2_RX_BIS_PREDETECT2_ICOMB
#undef R_C_COMB2_RX_BIS_DETECT2_ICOMB
#undef R_C_COMB2_RX_BIS_SKIP_LINEPROBE
#undef R_C_COMB2_RX_BIS_END

