/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RCComb3RxF_BIS.c
 * DESCRIPTION:      Implements the RX state function for the C-COMB3 state
 *                   in G.dmt.bis.
 *
 **********************************************************************/

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "DetectComb.h"
#include "const_bis.h"
#include "pll.h"
#include "states.h"
#include "RCMsgFmtRxF_bis.h"
#include "accum32.h"
#include "bufmisc.h"
#include "memcopy.h"
#include "memsetbf.h"
#include "fifo.h"

#define R_C_COMB3_RX_BIS_SKIP_COMB     0
#define R_C_COMB3_RX_BIS_DETECT_ICOMB  1
#define R_C_COMB3_RX_BIS_END        2

/******************************************************************************
 * Function: RCComb3RxF_BIS
 *
 * Description: Implements the states R_C_COMB3_RX_BIS and R_C_ICOMB2_RX_BIS.
 ******************************************************************************/

void RCComb3RxF_BIS(void)
{
   switch(gs_RxSubState)
   {
      case R_C_COMB3_RX_BIS_SKIP_COMB:

         gs_RxSubStateCnt++;

            if(gs_RxSubStateCnt == 1)
         {

               /* Clear gla_RxAccumBuf before use it */
      //    MemSetBuffer((int16 *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*2*gs_RxNumTones));

              /* Recapture the reference phase of pilot signal */
            ResetPllRefTone(gsa_RxPilotTone[0], gsa_RxPilotTone[1]);

            gft_EnablePLL = TRUE;
         }

      /*  accumulate representative frame of frequency domain samples */
         if(gs_RxSubStateCnt <= (R_C_COMB2_AC_LEN_BIS >>1))
            Accum16to32(gla_RxAccumBuf, 0, gsa_RxToneBuf, 0, gs_RxSamplesPerFrame);

         if(gs_RxSubStateCnt == ((R_C_COMB2_AC_LEN_BIS >>1)+1)) {
            guc_AccumState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgRightShiftAndRound32to16);
         }

         if(guc_AccumState == TRAINING_DONE)
         {
            guc_AccumState = TRAINING_WAITING;
            MemCopyWords(gsa_Comb2SignalBuf, 0, gsa_RxRepFrameAlignBuf, 0, (int16)(2*gs_RxNumTones));
            MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*2*gs_RxNumTones));
         }

         if(gs_RxSubStateCnt == R_C_COMB3_RX_LEN_BIS - R_C_TRANSITION_CNT_BIS - 5)
         {
               //     MemSetBuffer((int16 *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*2*gs_RxNumTones));
               MemCopyWords(gsa_RxRepFrameAlignBuf, 0, gsa_Comb2SignalBuf, 0, (int16)(2*gs_RxNumTones));


            gft_EnablePLL = FALSE;
            // Prepare to detect C-ICOMB 5 frames in advance to avoid missing the first C-ICOMB symbol.
            gs_RxSubState = R_C_COMB3_RX_BIS_DETECT_ICOMB;
            gs_RxSubStateCnt = 0;
         }

         break;

      case R_C_COMB3_RX_BIS_DETECT_ICOMB:

         if(DetectComb(gsa_RxRepFrameAlignBuf, 0) == C_ICOMB_DETECTED)
            gs_RxSubStateCnt++;
         else
            gs_RxSubStateCnt = 0;

         if(gs_RxSubStateCnt == R_C_TRANSITION_CNT_BIS)  // Decide that this is the beginning of C-ICOMB2
            gs_RxSubState = R_C_COMB3_RX_BIS_END;

         break;

      case R_C_COMB3_RX_BIS_END:
         // gs_RxSubStateCnt is equal to R_C_TRANSITION_CNT_BIS when we
         // first reach this substate.
         gs_RxSubStateCnt++;

         if(gs_RxSubStateCnt == R_C_ICOMB2_RX_LEN_BIS) { // Count to R_C_ICOMB2_RX_LEN_BIS
            gs_RxNextState = R_C_MSG_FMT_RX_BIS;
            gpF_RxStateFunc = (PtrToFunc)RCMsgFmtRxF_BIS;
         }
         break;
   }
}


#undef R_C_COMB3_RX_BIS_SKIP_COMB
#undef R_C_COMB3_RX_BIS_DETECT_ICOMB
#undef R_C_COMB3_RX_BIS_END
