/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCExchMarkerRxF_bis.c
 *
 *   Transceiver Training Phase RX State Functions for ATU-R.
 *   Covering the RX states: R_C_EXCHMARKER_RX_BIS
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "fifo.h"
#include "detect.h"
#include <string.h>
#include "const_bis.h"
#include "gdata_bis.h"
#include "states.h"
#include "RCMsg2RxF_BIS.h"
#include "cmv.h"
#include "RCTref1LDRxF_bis.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCExchmarkerRxF_BIS
 *
 *  Description:
 *
 *  Prototype: void RCExchmarkerRxF_BIS(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gl_RxSymbolCount           - (I/O) RX symbol count
 *      gs_RxSubStateCnt             - (I/O) R_C_SEGUE1 count
 *      gs_RxState                   - State of the receiver state machine
 *    gsa_RxToneBuf[]               - (O) FFT output buffer
 *
 *  Notes: implements state R_C_EXCHMARKER_RX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RCExchMarkerRxF_BIS(void) {

   int16 s_ToneType;

   /* DetectReverbSegue() returs a 0 when Reverb is detected. */
   s_ToneType = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

   /*  if incoming symbol is C_Segue, then incr. counter */
   /*  else decre counter */
   if (s_ToneType == C_SEGUE)
      gs_RxSubStateCnt++;
   else
      gs_RxSubStateCnt--;

    if(gl_RxSymbolCount == (R_C_EXCHMARKER_RX_LEN_BIS - 1))
   {

   if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
   {
      gs_RxNextState = R_C_MSG2_RX_BIS;
      gpF_RxStateFunc = (PtrToFunc)RCMsg2RxF_BIS;

      if (gs_RxSubStateCnt > 0)
         gft_SkipCparams = TRUE;
      else
         gft_SkipCparams = FALSE;
   }
   else
   {
          gs_RxNextState = R_C_TREF1_LD_RX_BIS;
         gpF_RxStateFunc = (PtrToFunc)RCTref1LDRxF_BIS;
   }
   }
}


