/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCMedleyRxF_Bitload_BIS.c
 *
 *   Functions implementing the bitloading phase of RCMedley processing.
 *
 *   RX: R_C_MEDLEY_BIS
 *
 *------------------------------------------------------------------------
 */
// ****************************************************************************
// RCMedleyRxF_Bitload_BIS.c
//
// History
//
// 06/10/2010 Bhadra/AdeelJ : Our CPE is on the edge for CRC Error performance against ABLT-D (BRCM) at FT Lannion.
//              FT lays more stress on correct display of Margin than slightly degraded data rates.
//              Boosted DS Margin by 0.2 dB(Value reached after On-Site experimentation at FT) if DSLAM is BRCM.
//              This change is additionally protected under cmv INFO 103 1 :bitmask 0x0080 which already boosts margin
//              by 0.2dB against all DSLAMs which makes boost against BRCM equal 0.4dB. This cmv is already a
//              prerequisite for tests at FT.
//     Grep for SMS01501986 SMS01294409 IOP_DS_BisPlus_BDCM_FTMarginVerification
//
// 06/10/2010 Bhadra/Abu :Added changes for UTP SMS01387095:FT Margin verification against Connexant.
//             Slight failures in margin verification tests at FT are seen against a Connexant based
//             Lucent Stinger DSLAM.The issue should be fixed by adding 0.2dB of margin similar to
//             the same issue observed at FT against the BRCM DSLAM (SMS01294409).
//     Grep for SMS01501988 SMS01387095 FT_Margin_verification_against_Connexant
//
// 19/12/2011 Balabath: Noise margin test (NMCPE A224) is fail on Lucent linecard models AP72 and AP72-HBI.
//                      Reported margin of 9dB in Annex L mode after reaching showtime. In Annex L modes OPTNArray[OPTN_MarginDelta]
//                      is kikcing in and value is set to 0x0300. (ie.,3dB). And this value is considered twice while
//                      calculating the average margin.once @ ComputeMarginPerTone and also after the function call of
//                      "ComputeMarginPerTone" (In file CalcAvgMargin.c@fn CalcAvgMrgInnerLoop). Hence we report the wrong margin.
//                      Reason for failing the margin test is, during the bitloading we do bit allocation with 3dB desired margin.
//                      (ie., targetmargin (6dB) - OPTNArray[OPTN_MarginDelta](3dB)). So we really don't have margin of 6dB.)
//                      It seems we pass Noise margin verfication test with OPTNArray[OPTN_MarginDelta] value of 2dB.
//                      Hence change 2dB for CNXT to reduce the imapct on performance.
//                      Grep for XDSLRTFW-357 IOP_DS_BisAnnexL_CNXT_MarginVerification
//
//  22/12/2011 AdeelJ/Balabath: Fix for "DS CRCs in Sparnex Long Loops at Telefonica"
//          DS CRCs observed in loop reach tests at long loops
//          In this file we check the looplength and increase the margin correction
//            in order to compensate for the loss of Data Rate incurred by increasing the
//            DS INP.
//              DS INP was increased to 1 in these cases as it was observed that the noise
//            causing CRCs has impulse like behavior.
//            This Change is protected by mode (ADSL2+) Annex (A), loop >= 2300m
//            and cmv (INFO 26 0 :0x0020)
//            In future check should be added for Sparnex Simulator
//          Grep for ADSLRTFW-1362 IOP_A_DS_Plus_ALL_TelefonicaSparnexDSCRCs
//
//  22/12/2011 Shakil/Balabath: Fix for a bug introduced with ADSLRTFW-1362 for Telefonica Spain
//          where we forced non-zero INP independant of fast or interleaved profile if
//          the selected mode was ADSL2p and loop lenghth >= 2.5km. As a result we saw link
//            holes in ADSL2p, fast path if the loop length >= 2.5km against all DSLAMs, since
//       in fast path R = 0, L = 8*R*D/INP = 0 giving Bitloading Exception. As a solution
//            we restricted the fix "ADSLRTFW-1362 IOP_A_DS_Plus_ALL_TelefonicaSparnexDSCRCs"
//            to interleaved profile only
//          Grep for XDSLRTFW-372 PERF_A_DS_Plus_ALL_LinkHoles_Fast_Long_Loop
//
// 30/01/2012 Raghu: Add margin fudge of 1dB to increase the DS data rates to meet
//          telefonica requirements. This is controlled by CMV info 103 27 bit13(0x2000).
//          and will be enabled for CNXT /IKANOS DSLAMs for above 9kft. For code changes
//          Grep for   XDSLRTFW-383 Enh_DS_ADSL2_CNXTIKNS_DSRate
//
// 02/02/2012 Sabrina/Balabath: It's seen in the field that AR9 has quite low DS
//            rates compared to AR7 with the ABLT-D BRCM DSLAM. Looks like
//            the CO sends out a low MAXNOMATP (-3dB) in GHS. We use this
//            parameter as a constrain during bitloading. Therefore, the
//            finegains are all -2.5dB on the tones with bits loaded and
//            the DS rate is low. By checking the AR7 code, it's not using
//            this parameter at all. In order to improve the DS performance,
//            the workaround is to set his parameter to 0 against BRCM
//            in ADSL2+ mode. This feature is CMV protected.
//            info 103 26 0x010 Disabled by default
//            Grep for XDSLRTFW-406  IOP_A_DS_Plus_BRCM_Set_MAXNOMATP_ToZero
//
//09/11/2012 Anantha: Removing margin fudge to pass margin test
//            grep for XDSLRTFW-534:IOP_DS_BisAnnexL_ALL_MarginVarification
//
//05/03/2013 Hanyu: Enable the fix of "XDSLRTFW-406  IOP_A_DS_Plus_BRCM_Set_MAXNOMATP_ToZero"
//                  for both ADSL2 and ADSL2+. It is disabled by default CMV and can be
//                  enabled by CMV info 103 26 0x010.
//                  Grep for ADSLRTFW-1677 IOP_A_DS_BisPlus_BRCM_Set_MAXNOMATP_ToZero
//
//30/09/2013 Balabath:It has been observed that during  loops 2500m ,3250m L3
// simple request was issued from DSLAM side after around 30s. and have a stable
// connection in the second session.This shows as a sync loss in the automation
// tests. This is CO generic problem. And more details can be found in
// jira XDSLRTFW-1214 attachments.
// Solution : To prove this TX clipping issue,some experiments were
// carried such as reduce fine gain RMS, I.e. set RMS to -2.5dB, By adjusting
// gt_TxPMDControl.s_MAXNOMATP_DS through  CMV OPTN 23 and allow min fine
// gain range [RMSGi-2.5]dB and  max fine gain range of [RMSGi+2.5dB].
// This is This is added under CMV control of INFO 103 28 bit#14(mask #0x4000),
// And by default this is disabled.
// For testing we need to enable this bit from outside through dmms 6743 1C 1 4000 4000
// Grep pattern  " XDSLRTFW-1214 IOP_DS_Plus_IKNS_ST_Stable "
//
//
// 30/03/2015 Sriram Shastry:TR100 A2.2.4 NM verification fail with NALT-J
//    Grep  for : XDSLRTFW-2009
//
// 19/12/2017 Chih-Wen: BER failed in TR100A 12ADSL2p DS FEXT MV test against Lucent Stinger.
//            In this test, new NMS was not kicked in. BER failed with 0.5dB more margin(optn 20 = 0xFF80).
//            BER passed with 1dB more margin(optn 20 = 0xFF00).
//
//            To kick in the fix of adding 1dB margin, the following conditions must be met.
//            1. ADSL2+ AnnexA.
//            2. CNXT CO.
//            3. FB noise is detected where STAT[STAT_Performance] sets "STAT_FBNoise" and "STAT_FBNoiseLowThreshold".
//               This is the case for TR100A 12ADSL2p DS FEXT MV test, TR100E FB RA 250m, 750m, 1250m.
//            4. STAT[STAT_Performance] does not set STAT_M90M100Noise. This is the case for TR100A 12ADSL2p DS FEXT MV test.
//
//            Grep for XDSLRTFW_3663_TR100A_MV_12ADSL2Plus_AddMargin
//
// ****************************************************************************
#include "common.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "rt_tones.h"
#include "gdata.h"
#include "pll.h"
#include "medley.h"
#include "crc16.h"
#include "bitload.h"
#include "exchmsgs.h"
#include "showtime.h"
#include "pn_tab.h"
#include "fifo.h"
#include "accum32.h"
#include "cmv.h"
#include "DSLEngin.h"
#include "detect.h"
#include <string.h>
#include "memcopy.h"
#include "memsetbf.h"
#include "rinfotbl.h"
#include "exchdata.h"
#include "gdata_bis.h"
#include "bitload_bis.h"
#include "tx_ops_bis.h"
#include "showinit.h"
#include "states.h"
#include "const_bis.h"
#include "RCMedleyRxF_Bitload_bis.h"
#include "RMedleyTxF_bis.h"
#include "Gen_PNMedley_14thorder.h"
#include "hndshk_Data.h"
#include "aux_reg_danube.h"
//Socrates codeswap purpose
#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif //BIS_CODESWAP
//#ifdef DANUBE
#ifdef TARGET_HW
#include "dataswap.h"
#endif
//#endif

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCMedleyRxF_Bitload_BIS
 *
 *  Description: Processes the bitloading phase of RCMedleyRxF processing.
 *
 * NOTE:
 * Medley NTC function is split into two functions for codeswap purposes
 * Namely RCMedleyRxF_BIS() and RCMedleyRxF_Bitload_BIS()
 *
 *  Prototype: RCMedleyRxF_Bitload_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_RxSymbolCount            - (I) number of symbol periods in current state
 *      gs_RxNextState              - (O) RX state beginning next symbol period
 *    gusa_PN512Tab[]            - (I) PN512 sequence table
 *    gs_RxToneBuf[]          - (I) received DMT tones (FDQ output)
 *    gsa_MedleySnrBuf[]          - (O) computed SNR per tone
 *    guc_BitloadOK           - (O) indicator if bit loading succeeds
 *
 * Substates:
 * ----------
 * Below States are implemented in function RCMedleyRxF_BIS()
 * R_C_MEDLEY_RX_INITIALIZE            - Initialization
 * R_C_MEDLEY_RX_LOAD_CURRENT_TDQ      - Loads current TDQ or turns it off if required
 * R_C_MEDLEY_RX_FDQ_INIT           - Initialize parameters for FDQ training
 * R_C_MEDLEY_RX_AVERAGE_FRAME         - Gather average frame for FDQ training
 * R_C_MEDLEY_RX_FDQ_TRAIN          - Compute FDQ coefficients
 * R_C_MEDLEY_RX_ADJUST_SYNCH       - Adjust buffer alignments and FDQ coefficients
 * R_C_MEDLEY_RX_PRE_TEST_SNR_INIT     - Rotate the reference tone corresponding to post-sync
 * R_C_MEDLEY_RX_TEST_SNR_INIT         - Initialize for SNR calculation
 * R_C_MEDLEY_RX_CALCULATE_TEST_SNR    - Gather average frame and calculate SNR
 * R_C_MEDLEY_RX_KEEP_BEST          - Keep the best TDQ and throw out others
 * R_C_MEDLEY_RX_LOAD_BEST          - Load the best TDQ (or turned it off it achieves best capacity)
 * R_C_MEDLEY_RX_FINAL_SNR_INIT        - Initialize for final SNR computation
 * R_C_MEDLEY_RX_CALCULATE_FINAL_SNR   - Gather average frame and calculate final SNR
 *
 * Below States are implemented in function RCMedleyRxF_Bitload_BIS()
 * R_C_MEDLEY_RX_BITLOAD            - Perform bitloading or selecting profile
 * R_C_MEDLEY_RX_DS_ATTEN           - Calculate downstream loop attenuation
 * R_C_MEDLEY_RX_WAIT               - Wait for the end of the R_C_MEDLEY state.
 * R_C_MEDLEY_RX_CAPTURE_FRAMES        - Capture time-domain frames.
 * R_C_MEDLEY_RX_DETECT_SEGUE       - Detect C_SEGUE2 and check for time out.
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
/* Below States are implemented in function RCMedleyRxF_Bitload_BIS() */
#define  R_C_MEDLEY_RX_BIS_BITLOAD           (14)

/* Below States are implemented in function RCMedleyRxF_RxInit_BIS() */
#define  R_C_MEDLEY_RX_BIS_SHOWTIME_INIT        (15)

//XDSLRTFW-357 IOP_DS_BisAnnexL_CNXT_MarginVerification (start)
#define  THR1_MARGIN_DELTA  60   // Capacity (MaxBits)threshold values to declare OPTN_MarginDelta
#define  THR2_MARGIN_DELTA  95
#define  THR3_MARGIN_DELTA  150
//XDSLRTFW-357 IOP_DS_BisAnnexL_CNXT_MarginVerification (end)

//XDSLRTFW-1214 IOP_DS_Plus_IKNS_ST_Stable(Start)
#define MINIMUM_GHS_TONE_PWR_IKNS_2050M   0x39B0  //14768
#define MINIMUM_GHS_TONE_PWR_IKNS_2100M   0x38D6  //14550
#define MINIMUM_GHS_TONE_PWR_IKNS_2150M   0x3842  //14402
#define MINIMUM_GHS_TONE_PWR_IKNS_2550M   0x3354  //13152
#define MINIMUM_GHS_TONE_PWR_IKNS_2650M   0x3206  //12806
#define MINIMUM_GHS_TONE_PWR_IKNS_2700M   0x3148  //12616
#define MINIMUM_GHS_TONE_PWR_IKNS_2750M   0x30B4  //12468
#define MINIMUM_GHS_TONE_PWR_IKNS_3650M   0x2420  //9248
#define MINIMUM_GHS_TONE_PWR_IKNS_3700M   0x2386  //9094
#define MINIMUM_GHS_TONE_PWR_IKNS_3850M   0x2185  //8581

//XDSLRTFW-1214 IOP_DS_Plus_IKNS_ST_Stable(End)



void RCMedleyRxF_Bitload_BIS(void) {

    int16 s_PN512_LEN, s_SequenceLengthMultiplier;

    //XDSLRTFW-357 IOP_DS_BisAnnexL_CNXT_MarginVerification (start)
    int16 s_threshold_1,s_threshold_2,s_threshold_3;
    s_threshold_1 = THR1_MARGIN_DELTA;
    s_threshold_2 = THR2_MARGIN_DELTA;
    s_threshold_3 = THR3_MARGIN_DELTA;
    //XDSLRTFW-357 IOP_DS_BisAnnexL_CNXT_MarginVerification (end)

    if ((( gl_SelectedMode & (MODE_G992_5)  )) != 0)
    {
        s_SequenceLengthMultiplier = 2;
    }
    else
        s_SequenceLengthMultiplier = 1;

    s_PN512_LEN = s_SequenceLengthMultiplier * PN512_LEN;

    /* ============================================================================== */
    /* Generate Medley reference frame */
    /* ============================================================================== */
    /* Get offset to first unpacked bit */
    if (gs_RxFirstPNbit >= s_PN512_LEN)
        gs_RxFirstPNbit -= s_PN512_LEN;

    if (gft_G992_5_Medley14thOrderPRBS == TRUE)
    {
        if(gl_RxSymbolCount > 0)
        {
            //Generate new packed PN sequence
            Gen_PNMedley_14thOrder(guca_RxMedleyBuffer, (int16)NUM_R_C_MEDLEY_BYTES, &gul_RxMedleyState, 0);
        }
    }


    if (gs_RxSubState == R_C_MEDLEY_RX_BIS_BITLOAD)
    {
        /* ============================================================================== */
        /* Perform Bitloading  */
        /* ============================================================================== */

//#ifdef DANUBE
#ifdef TARGET_HW
        /* Swap Medley SNR buffer to XMEM */
        RequestSwap_MedleySnrBuf_ToXmem();
#endif
//#endif
#ifdef BIS_CODESWAP
        if((gs_CodeSwapStatus == CODESWAP_IDLE) && (gs_CodeSwapSection == CSPAGE_BIS_RXINIT))
        {
            gs_CodeSwapStatus = CODESWAP_START;
        }
        if((gs_CodeSwapStatus == CODESWAP_IDLE) && (gs_CodeSwapSection == CSPAGE_BIS_EXCH1))
        {
#endif //BIS_CODESWAP

            /* For diagnostics mode, no need to perform bitloading */
            if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
            {
                /* Fine gain adjustment calibrations -- unless user has initialized for debug purposes */
                if (!gs_fgain_adjust)
                {
                    /* Currently we clear ALL the 3 fgain adjustment cmvs listed below post handshake for ADSL2/+ modes */
                    if (gus_ncloaded <= OPTNArray[OPTN_FgainAjust_Threshold])
                    {
                        gs_fgain_adjust = OPTNArray[OPTN_FgainAdjust_LongLoop];
                    }
                    else if (gus_ncloaded <= OPTNArray[OPTN_FgainAjust_Threshold2])
                    {
                        gs_fgain_adjust = OPTNArray[OPTN_FgainAdjust_MedLoop];
                    }
                    else
                    {
                        gs_fgain_adjust = OPTNArray[OPTN_FgainAdjust_ShortLoop];
                    }
                }

                //XDSLRTFW-2031 Enhc_A_DS_BisPlus_BRCM_WorkaroundForAskeyLabTesting (START)
#ifndef ISDN
                   if ( (gt_INFX_CMV.us_SRA_IOP_Bits & CMV_TO_ENABLE_WORKAROUND_ASKEY_LAB) &&
                        (gl_SelectedMode & (MODE_G992_3 | MODE_G992_5)) &&
                        (gs_CurrentCoChipset == BDCM_CO_CHIPSET) &&
                        (gs_CurrentCoVendorID == 0x6291) &&
                        (gt_NearEndParam.us_LoopAttenuation >= 500) && //3250m LATN = 54.3 dB
                        (STATArray[STAT_Performance] == STAT_M140WhiteNoise) )
                   {
                      OPTNArray[OPTN_MarginDelta] += 0x0100;
                      OPTNArray[OPTN_MaxNomAtpAdjust] = -(gt_TxPMDControl.s_MAXNOMATP_DS);
                   }
#endif
                //XDSLRTFW-2031 Enhc_A_DS_BisPlus_BRCM_WorkaroundForAskeyLabTesting (END)


               //XDSLRTFW-1214 IOP_DS_Plus_IKNS_ST_Stable(Start)
               //CMV Bit ,IKNS chipset AWGN-140 Test case, Fastpath

               if ( (gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_ENABLE_DS_ST_STABLE_WITH_IKNS)
                     &&(gs_CurrentCoChipset == IKNS_CO_CHIPSET)
                     &&(gt_HandshakeBis.sa_DS_MaxLatencyBC[LP0_DATA_PATH] == 1)
                     &&((gl_SelectedMode & MODE_G992_5) != 0)
                     &&(gft_M140WhiteNoise == TRUE)
                   )
               {
                  if((gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_IKNS_2050M)&&( gs_hsk_tone_power_dB >= MINIMUM_GHS_TONE_PWR_IKNS_2550M ))
                  {
                    OPTNArray[OPTN_MaxNomAtpAdjust]+= (int16) 0xFFF1;//-15
                  }
                  else if((gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_IKNS_2550M)&&( gs_hsk_tone_power_dB >= MINIMUM_GHS_TONE_PWR_IKNS_3850M ))

                  {
                    OPTNArray[OPTN_MaxNomAtpAdjust]+= (int16)0xFFE7; //-25

                  }

                  if (OPTNArray[OPTN_MaxNomAtpAdjust] != 0)
                  {
                     gs_max_fine_gain += ((OPTNArray[OPTN_MaxNomAtpAdjust])<<8)/10;
                     gs_min_fine_gain += ((OPTNArray[OPTN_MaxNomAtpAdjust])<<8)/10;
                     // Below lines are commented as gs_fgain_adjust is "0" check stateini.c file.
                     //if(gs_fgain_adjust != 0)
                     //   gs_fgain_adjust += ((OPTNArray[OPTN_MaxNomAtpAdjust])<<8)/10;
                  }
               }
               //XDSLRTFW-1214 IOP_DS_Plus_IKNS_ST_Stable(end)


                /* Nomatp adjustment calibrations for debug purposes */
                gt_TxPMDControl.s_MAXNOMATP_DS += OPTNArray[OPTN_MaxNomAtpAdjust];

#ifndef ISDN         // Only for Annex-A
          //XDSLRTFW-406  IOP_A_DS_Plus_BRCM_Set_MAXNOMATP_ToZero (START)
          //ADSLRTFW-1677 IOP_A_DS_BisPlus_BRCM_Set_MAXNOMATP_ToZero (START_END)
          if ( (gs_CurrentCoChipset == BDCM_CO_CHIPSET) &&
            (gl_SelectedMode & (MODE_ADSL2)) &&
            (gt_NearEndParam.us_LoopAttenuation > 190) && //from around 900m
            (gt_INFX_CMV.us_OperatorSpBits4 & CMV_TO_ENABLE_BRCM_MAXNOMATP_DS_SettoZero))
            {
              gt_TxPMDControl.s_MAXNOMATP_DS = 0;
            }
          //XDSLRTFW-406  IOP_A_DS_Plus_BRCM_Set_MAXNOMATP_ToZero (END)
#endif   // #ifndef ISDN

                //SMS01501986 SMS01294409 IOP_DS_BisPlus_BDCM_FTMarginVerification (START)
                //SMS01501988 SMS01387095 FT_Margin_verification_against_Connexant (START)
                if ( (gt_INFX_CMV.s_DFE_Options & CMV_INFX_DFE_FT_INTERP13_ENABLE)
                      && (gt_ReTxConfigInfo.ft_ReTxOn == 0)             //XDSLRTFW-2066
                      && ((gs_CurrentCoChipset == BDCM_CO_CHIPSET)||
                         (gs_CurrentCoChipset == GSI_CO_CHIPSET))
                    )
                    OPTNArray[OPTN_MarginDelta] -= 0x0033;  // increase margin by 0.2dB to aid margin verification against ABLT-D
                // BRCM based DSLAM at FT and also for CNXT at FT
                //SMS01501988 SMS01387095 FT_Margin_verification_against_Connexant (END)
                //SMS01501986 SMS01294409 IOP_DS_BisPlus_BDCM_FTMarginVerification (END)

#ifndef ISDN         // Only for Annex-A

                //ADSLRTFW-1362 IOP_A_DS_Plus_ALL_TelefonicaSparnexDSCRCs (START)

                if ( // ((guca_QLN[125] + guca_QLN[150] + guca_QLN[175] + guca_QLN[200] )< 900) && // Test for Sparnex
                    (gt_INFX_CMV.us_OperatorSpBits4 & CMV_TO_ENABLE_FIX_Sparnex_DS_CRC) &&
                    (gl_SelectedMode & (MODE_G992_5)) && (gs_hsk_tone_power_dB_PCB < 12500) //MINIMUM_GHS_TONE_PWR_AT_7500F
               //XDSLRTFW-372 PERF_A_DS_Plus_ALL_LinkHoles_Fast_Long_Loop (START)
                    && (gt_HandshakeBis.sa_DS_MaxLatencyBC[LP0_DATA_PATH] > 1)         //XDSLRTFW-372 PERF_A_DS_Plus_ALL_LinkHoles_Fast_Long_Loop (START) (END)
               //XDSLRTFW-372 PERF_A_DS_Plus_ALL_LinkHoles_Fast_Long_Loop (END)
                )
                    OPTNArray[OPTN_MarginDelta] += 0x100;  /* 1.0dB */


                //ADSLRTFW-1362 IOP_A_DS_Plus_ALL_TelefonicaSparnexDSCRCs (END)
                //XDSLRTFW-383 Enh_DS_ADSL2_CNXTIKNS_DSRate (start)
                if((gl_SelectedMode & (MODE_G992_3 | ANNEX_L)) == (MODE_G992_3 | ANNEX_L))
                {
                    //XDSLRTFW-357 IOP_DS_BisAnnexL_CNXT_MarginVerification (start)
                    if(gs_CurrentCoChipset == GSI_CO_CHIPSET)
                    {
                        s_threshold_1 -= 5;
                        // XDSLRTFW-2027 IOP_A_DS_AnnexL_CNXT_DataRate(START)
                        if ( (gt_HandshakeBis.sa_DS_MinNetDataRateBC[0] > 100) &&  // minNDR > 400kbps
                             (gs_Capacity < s_threshold_3)&& // Loop length > 5.5km/0.4mm in white noise case
                             (gt_INFX_CMV.s_DFE_Options & CMV_INFX_DFE_FT_INTERP13_ENABLE) )
                        {
                            // Reduce DS target margin by additional 1.5dB to increase DS data rate to pass FT Net1Light profile with min DS NDR 500kbps
                            OPTNArray[OPTN_MarginDelta] += 0x180;
                        }
                        // XDSLRTFW-2027 IOP_A_DS_AnnexL_CNXT_DataRate (END)
                    }

                    if(gs_Capacity < s_threshold_1) /* Loop length is about 21kft in white noise case */
                        OPTNArray[OPTN_MarginDelta] += 0x300;  /* 3dB */
                    else if(gs_Capacity < s_threshold_2) /* Loop length is about 20kft in white noise case */
                        OPTNArray[OPTN_MarginDelta] += 0x200;  /* 2dB */
                    else if(gs_Capacity < s_threshold_3) /* Loop length is about 19kft in white noise case */
                        OPTNArray[OPTN_MarginDelta] += 0x100;  /* 1dB */
               //XDSLRTFW-534:IOP_DS_BisAnnexL_ALL_MarginVarification
               // XDSLRTFW-2009(Start)
               //Sriram Shastry: Below  Table is arrived to  estimate DS performance against BroadCom DSLAM
/* DS performance  estimation
|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|Test Case@5250M  |Margin-Delta  |NoiseMargin Test |Loop Reach test(WhiteNoise)  |Loop Reach test(FSAN D Noise)|  Apply w.r.t  Margin Delta| DS Data Rate[Reference DS Data Rate : 490 Kbps] |Apprx.Exp.DS Data Rate[Reference DS Data Rate : 490 Kbps] |
------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|        1     |     2     |       FAIL        | PASS                         |           PASS              |    0                  |    0                                             |       490                                                |
|        2     |     1.5   |       FAIL        | PASS                         |           PASS              |    0.5                   |    32                                         |       458                                                |
|        3     |     1     |       PASS        | FAIL                         |           FAIL              |    1                  |    64                                         |       426                                                |
|        4     |     0.5   |       PASS        | FAIL                         |           FAIL              |    1.5                   |    96                                         |       394                                                |
|        5     |     0     |       PASS        | FAIL                         |           FAIL              |    2                  |    128                                           |       362                                                |
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
*/

               if(gs_CurrentCoChipset == BDCM_CO_CHIPSET)
               {
                  // To Fix, 5250Meter FSAN-D[A2L_RA_I_16000k{INP-2,delay16ms}] Noise Margin  Verification failure and not too aggressive DS Data Rate
                  if(gs_Capacity < s_threshold_1) /* Loop length is about 21kft in white noise case */
                     OPTNArray[OPTN_MarginDelta] = 0x100;  /* 1dB */
                  else if(gs_Capacity < s_threshold_2) /* Loop length is about 20kft in white noise case */
                     OPTNArray[OPTN_MarginDelta] = 0x080;  /* 0.5dB */
                  else if(gs_Capacity < s_threshold_3) /* Loop length is about 19kft in white noise case */
                     OPTNArray[OPTN_MarginDelta] = 0x000;  /* 0dB */
#ifdef VRX518
                  if (OPTNArray[OPTN_AlgControl2] & VRX518_Margin_delta_3L_BDCM)
                  {
                     OPTNArray[OPTN_MarginDelta] = 0x000;
                  }

#endif
               }
               // XDSLRTFW-2009(End)
                     //XDSLRTFW-2033 (start)
                     // Observed CRCs on BT loops with 3dB fudge, so reduce 1dB
                     if((gt_INFX_CMV.us_OperatorSpBits7 & CMV_CNXT_ATT_CONTROL)
                        &&(gs_CurrentCoChipset == BDCM_CO_CHIPSET)
                        &&(OPTNArray[OPTN_MarginDelta] >= 0x300) && (gs_LoadHybIndex > 3)
                        )
                     {
                        OPTNArray[OPTN_MarginDelta] -= 0x100;
                     }

                     if( (OPTNArray[OPTN_MarginDelta] > 0)
                        && (gt_INFX_CMV.us_OperatorSpBits7 & CMV_TO_NO_MARGIN_FUDGE_BTTESTs)
                        && (gft_CNXT_A_LongLoops == TRUE)
                        && (gs_LoadHybIndex > 10)
                        )
                     {
                        OPTNArray[OPTN_MarginDelta] = 0;
                     }
                     //XDSLRTFW-2033 (end)
                    //XDSLRTFW-357 IOP_DS_BisAnnexL_CNXT_MarginVerification (end)
                }
                else
                {
                    // XDSLRTFW-383 : Check if CMV is set to increase the DS Rates by changing the DS margin delta
                    // this is ony against CNXT CO's
                    if(gt_INFX_CMV.us_OperatorSpBits5 & CMV_TO_ENABLE_DS_MARG_DELTA_3A_5A)
                    {
                        if ( (gl_SelectedMode & (MODE_ADSL2)) && (!(gl_SelectedMode & ANNEX_L)) && // Only for 3A and 5A not for Annex L
                             (gs_hsk_tone_power_dB <= MINIMUM_GHS_TONE_PWR_AT_9000F) &&            // Loop length > 9Kft
                             (gft_M140WhiteNoise != FALSE) &&                                      // -140dB/Hz White noise only
                             (gs_LoadHybIndex <= 1))                                                // straight gauge loop
                        {
                           if (gs_CurrentCoChipset == GSI_CO_CHIPSET)
                              OPTNArray[OPTN_MarginDelta] += 0x100;  /* 1dB */
                           else if (gs_CurrentCoChipset == IKNS_CO_CHIPSET)
                              OPTNArray[OPTN_MarginDelta] += 0x100;  /* 1dB */
                        }
                    }
                }
            //XDSLRTFW_3663_TR100A_MV_12ADSL2Plus_AddMargin (START)
            //Add 1dB margin in the case of TR100A 12ADSL2p DS FEXT MV test.
            if ( (gl_SelectedMode & MODE_G992_5) &&
                 (gs_CurrentCoChipset == GSI_CO_CHIPSET) &&
                 (STATArray[STAT_Performance] == (STAT_FBNoiseLowThreshold|STAT_FBNoise)) )
            {
               OPTNArray[OPTN_MarginDelta] -= 0x0100;
            }
            //XDSLRTFW_3663_TR100A_MV_12ADSL2Plus_AddMargin (END)
#endif   // #ifndef ISDN
               //XDSLRTFW-383 Enh_DS_ADSL2_CNXTIKNS_DSRate (End)
                /* Perform bitloading or loading profile */
                gft_BitloadState = TRAINING_IN_PROGRESS;
                AddFunctionToBkgdFifo((PtrToBkgdFunc) BgMedleyBitload_bis);
            }

            gs_RxSubStateCnt = 0;
            gs_RxSubState =   R_C_MEDLEY_RX_BIS_SHOWTIME_INIT;

            // Socrates codeswap purpose
            gpF_RxStateFunc = (PtrToFunc)RCMedleyRxF_RxInit_BIS;
            gpF_TxStateFunc = (PtrToFunc)RMedleyTxF_RxInit_BIS;
            // Save the Rx overflow counters for the current state
            memcpy(gusa_RCMedley_RxOverflowCnts, gusa_RxOverflowCnts, NUM_RX_OVFLOW_CNTRS*sizeof(uint16));

#ifdef BIS_CODESWAP
        }
#endif
    }

    /* ============================================================================== */
    /* increment RxFirstPNbit following its use in the NoiseAccum function       */
    /* ============================================================================== */

    gs_RxFirstPNbit += s_SequenceLengthMultiplier;

}

/* undefine substates */
#undef R_C_MEDLEY_RX_BIS_BITLOAD
#undef R_C_MEDLEY_RX_BIS_SHOWTIME_INIT

