/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCMedleyRxF_RxInit_BIS.c
 *
 *   Functions implementing the showinit Rx phase of RCMedley processing.
 *
 *   RX: R_C_MEDLEY_BIS
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "rt_tones.h"
#include "gdata.h"
#include "pll.h"
#include "medley.h"
#include "crc16.h"
#include "bitload.h"
#include "exchmsgs.h"
#include "showtime.h"
#include "pn_tab.h"
#include "fifo.h"
#include "accum32.h"
#include "cmv.h"
#include "DSLEngin.h"
#include "detect.h"
#include <string.h>
#include "memcopy.h"
#include "memsetbf.h"
#include "rinfotbl.h"
#include "exchdata.h"
#include "gdata_bis.h"
#include "bitload_bis.h"
#include "tx_ops_bis.h"
#include "showinit.h"
#include "states.h"
#include "const_bis.h"
#include "Gen_PNMedley_14thorder.h"
//Socrates codeswap purpose
#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif
#include "diagparam_bis.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCMedleyRxF_CSwap_BIS
 *
 *  Description: Processes the codeswaps of exchange pages and segue detections
 *             of RCMedleyRxF processing.
 *
 * NOTE:
 * Medley NTC function is split into two functions for codeswap purposes
 * Namely RCMedleyRxF_BIS(), RCMedleyRxF_TDQTest_BIS(), RCMedleyRxF_Bitload_BIS()
 *  RCMedleyRxF_RxInit_BIS() and RCMedleyRxF_CSWap_BIS().
 *
 *  Prototype: RCMedleyRxF_CSwap_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_RxSymbolCount            - (I) number of symbol periods in current state
 *      gs_RxNextState              - (O) RX state beginning next symbol period
 *    gusa_PN512Tab[]            - (I) PN512 sequence table
 *    gs_RxToneBuf[]          - (I) received DMT tones (FDQ output)
 *    gsa_MedleySnrBuf[]          - (O) computed SNR per tone
 *    guc_BitloadOK           - (O) indicator if bit loading succeeds
 *
 * Substates:
 * ----------
 * Below States are implemented in function RCMedleyRxF_BIS()
 * R_C_MEDLEY_RX_INITIALIZE            - Initialization
 * R_C_MEDLEY_RX_LOAD_CURRENT_TDQ      - Loads current TDQ or turns it off if required
 * R_C_MEDLEY_RX_FDQ_INIT           - Initialize parameters for FDQ training
 * R_C_MEDLEY_RX_AVERAGE_FRAME         - Gather average frame for FDQ training
 * R_C_MEDLEY_RX_FDQ_TRAIN          - Compute FDQ coefficients
 * R_C_MEDLEY_RX_ADJUST_SYNCH       - Adjust buffer alignments and FDQ coefficients
 * R_C_MEDLEY_RX_PRE_TEST_SNR_INIT     - Rotate the reference tone corresponding to post-sync
 * R_C_MEDLEY_RX_TEST_SNR_INIT         - Initialize for SNR calculation
 * R_C_MEDLEY_RX_CALCULATE_TEST_SNR    - Gather average frame and calculate SNR
 * R_C_MEDLEY_RX_KEEP_BEST          - Keep the best TDQ and throw out others
 * R_C_MEDLEY_RX_LOAD_BEST          - Load the best TDQ (or turned it off it achieves best capacity)
 * R_C_MEDLEY_RX_FINAL_SNR_INIT        - Initialize for final SNR computation
 * R_C_MEDLEY_RX_CALCULATE_FINAL_SNR   - Gather average frame and calculate final SNR
 *
 * Below States are implemented in function RCMedleyRxF_Bitload_BIS()
 * R_C_MEDLEY_RX_BITLOAD            - Perform bitloading or selecting profile
 * R_C_MEDLEY_RX_DS_ATTEN           - Calculate downstream loop attenuation
 * R_C_MEDLEY_RX_WAIT               - Wait for the end of the R_C_MEDLEY state.
 * R_C_MEDLEY_RX_CAPTURE_FRAMES        - Capture time-domain frames.
 * R_C_MEDLEY_RX_DETECT_SEGUE       - Detect C_SEGUE2 and check for time out.
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
/* Below States are implemented in function RCMedleyRxF_CSwap_BIS() */
#define R_C_MEDLEY_RX_BIS_WAIT               (17)
#define R_C_MEDLEY_RX_BIS_CAPTURE_FRAMES     (18)
#define R_C_MEDLEY_RX_BIS_DETECT_SEGUE       (19)

void RCMedleyRxF_CSwap_BIS(void) {

   // check for timeout in Medley state. If Medleylength is exceeded, we should breakout
   // by setting exception code
   if (gl_RxSymbolCount > gt_StateMachCntrl.l_RXCurrentStateLen)
   {
      gs_RxNextState = FAIL_RX;
      gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

      /* Set exception handler variables */
      gus_ExceptionState   = gs_RxState;
      gus_ExceptionCode = E_CODE_MEDLEY_BIS_TIMEOUT; // we set the same exception code here
   }

   switch (gs_RxSubState) {

   case R_C_MEDLEY_RX_BIS_WAIT:

         /* ============================================================================== */
         /* we need to do codeswap first (Socrates codeswap only)*/
         /* ============================================================================== */
#ifdef BIS_CODESWAP
      if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
      {

         //Codeswap the exchange page EXCH3 (overlaps with RXINIT page)
         if ((gs_CodeSwapStatus == CODESWAP_IDLE) && (gs_CodeSwapSection == CSPAGE_BIS_EXCH3))
         {
            gs_CodeSwapStatus = CODESWAP_START; // Swap EXCH3 only in data mode.
            gs_RxSubState =   R_C_MEDLEY_RX_BIS_DETECT_SEGUE;
         }
      } else
#endif //BIS_CODESWAP
      {
         gs_RxSubState =   R_C_MEDLEY_RX_BIS_DETECT_SEGUE;
      }

      break;


   case R_C_MEDLEY_RX_BIS_DETECT_SEGUE:

      /* Wait to  */
        if(gl_RxSymbolCount == gt_StateMachCntrl.l_RXCurrentStateLen)
      {
         /* Socrates Specific -- Check if all exchange pages swapped in successfully */
#ifdef BIS_CODESWAP
         if (STATArray[STAT_MacroState] != STAT_LoopDiagMode) {
            if (gs_CodeSwapSection != CSPAGE_BIS_SHOW1)
            {
               gs_RxNextState = FAIL_RX;
               gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

               /* Set exception handler variables */
               gus_ExceptionState   = gs_RxState;
               gus_ExceptionCode = E_CODE_CODESWAP_ERR;
            }
         }
#endif
         gs_RxNextState = gt_StateMachCntrl.s_RXFollowingState;
         gpF_RxStateFunc = (PtrToFunc)gt_StateMachCntrl.pF_RxFollowingState;
      }

        break;
   }


}

/* undefine substates */
#undef R_C_MEDLEY_RX_BIS_WAIT
#undef R_C_MEDLEY_RX_BIS_CAPTURE_FRAMES
#undef R_C_MEDLEY_RX_BIS_DETECT_SEGUE
