/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCMedleyRxF_RxInit_BIS.c
 *
 *   Functions implementing the showinit Rx phase of RCMedley processing.
 *
 *   RX: R_C_MEDLEY_BIS
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "rt_tones.h"
#include "gdata.h"
#include "pll.h"
#include "medley.h"
#include "crc16.h"
#include "bitload.h"
#include "exchmsgs.h"
#include "showtime.h"
#include "pn_tab.h"
#include "fifo.h"
#include "accum32.h"
#include "cmv.h"
#include "DSLEngin.h"
#include "detect.h"
#include <string.h>
#include "memcopy.h"
#include "memsetbf.h"
#include "rinfotbl.h"
#include "exchdata.h"
#include "gdata_bis.h"
#include "bitload_bis.h"
#include "tx_ops_bis.h"
#include "showinit.h"
#include "states.h"
#include "const_bis.h"
#include "Gen_PNMedley_14thorder.h"
#include "RCMedleyRxF_Bitload_bis.h"
#include "RMedleyTxF_bis.h"
//Socrates codeswap purpose
#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif
#include "diagparam_bis.h"
#ifdef DANUBE
#ifdef TARGET_HW
#include "trail.h"
#include "aux_regs.h"
#include "dataswap.h"
#endif
#endif

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCMedleyRxF_RxInit_BIS
 *
 *  Description: Processes the showinit Rx phase of RCMedleyRxF processing.
 *
 * NOTE:
 * Medley NTC function is split into two functions for codeswap purposes
 * Namely RCMedleyRxF_BIS(), RCMedleyRxF_TDQTest_BIS(), RCMedleyRxF_Bitload_BIS()
 *  RCMedleyRxF_RxInit_BIS().
 *
 *  Prototype: RCMedleyRxF_RxInit_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_RxSymbolCount            - (I) number of symbol periods in current state
 *      gs_RxNextState              - (O) RX state beginning next symbol period
 *    gusa_PN512Tab[]            - (I) PN512 sequence table
 *    gs_RxToneBuf[]          - (I) received DMT tones (FDQ output)
 *    gsa_MedleySnrBuf[]          - (O) computed SNR per tone
 *    guc_BitloadOK           - (O) indicator if bit loading succeeds
 *
 * Substates:
 * ----------
 * Below States are implemented in function RCMedleyRxF_BIS()
 * R_C_MEDLEY_RX_INITIALIZE            - Initialization
 * R_C_MEDLEY_RX_LOAD_CURRENT_TDQ      - Loads current TDQ or turns it off if required
 * R_C_MEDLEY_RX_FDQ_INIT           - Initialize parameters for FDQ training
 * R_C_MEDLEY_RX_AVERAGE_FRAME         - Gather average frame for FDQ training
 * R_C_MEDLEY_RX_FDQ_TRAIN          - Compute FDQ coefficients
 * R_C_MEDLEY_RX_ADJUST_SYNCH       - Adjust buffer alignments and FDQ coefficients
 * R_C_MEDLEY_RX_PRE_TEST_SNR_INIT     - Rotate the reference tone corresponding to post-sync
 * R_C_MEDLEY_RX_TEST_SNR_INIT         - Initialize for SNR calculation
 * R_C_MEDLEY_RX_CALCULATE_TEST_SNR    - Gather average frame and calculate SNR
 * R_C_MEDLEY_RX_KEEP_BEST          - Keep the best TDQ and throw out others
 * R_C_MEDLEY_RX_LOAD_BEST          - Load the best TDQ (or turned it off it achieves best capacity)
 * R_C_MEDLEY_RX_FINAL_SNR_INIT        - Initialize for final SNR computation
 * R_C_MEDLEY_RX_CALCULATE_FINAL_SNR   - Gather average frame and calculate final SNR
 *
 * Below States are implemented in function RCMedleyRxF_Bitload_BIS()
 * R_C_MEDLEY_RX_BITLOAD            - Perform bitloading or selecting profile
 * R_C_MEDLEY_RX_DS_ATTEN           - Calculate downstream loop attenuation
 * R_C_MEDLEY_RX_WAIT               - Wait for the end of the R_C_MEDLEY state.
 * R_C_MEDLEY_RX_CAPTURE_FRAMES        - Capture time-domain frames.
 * R_C_MEDLEY_RX_DETECT_SEGUE       - Detect C_SEGUE2 and check for time out.
 *
 *------------------------------------------------------------------------
 *^^^
 */
void BgCalcAggregateTxPower(void);

/* =============================================== */
/* substates */
/* =============================================== */
/* Below States are implemented in function RCMedleyRxF_RxInit_BIS() */
#define  R_C_MEDLEY_RX_BIS_SHOWTIME_INIT        (15)
#define R_C_MEDLEY_RX_BIS_DATA_PUMP_SETUP    (16)
#define R_C_MEDLEY_RX_BIS_WAIT               (17)

void RCMedleyRxF_RxInit_BIS(void) {

   int16 s_PN512_LEN, s_SequenceLengthMultiplier;

   if ((( gl_SelectedMode & (MODE_G992_5)  )) != 0)
   {
      s_SequenceLengthMultiplier = 2;
   }
   else
      s_SequenceLengthMultiplier = 1;

   s_PN512_LEN = s_SequenceLengthMultiplier * PN512_LEN;

   // check for timeout in Medley state. If Medleylength is exceeded, we should breakout
   // by setting exception code
   if (gl_RxSymbolCount > gt_StateMachCntrl.l_RXCurrentStateLen)
   {
      gs_RxNextState = FAIL_RX;
      gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

      /* Set exception handler variables */
      gus_ExceptionState   = gs_RxState;
      gus_ExceptionCode = E_CODE_MEDLEY_BIS_TIMEOUT;
   }

   /* ============================================================================== */
   /* Generate Medley reference frame */
   /* ============================================================================== */
   if(gs_RxSubState < R_C_MEDLEY_RX_BIS_WAIT) {
      /* Get offset to first unpacked bit */
      if (gs_RxFirstPNbit >= s_PN512_LEN)
         gs_RxFirstPNbit -= s_PN512_LEN;

//    if(gl_RxSymbolCount > 0)
//    {
//       //Generate new packed PN sequence
//       Gen_PNMedley(guca_RxMedleyBuffer, (int16)NUM_R_C_MEDLEY_BYTES, &gul_RxMedleyState);
//    }

      if (gft_G992_5_Medley14thOrderPRBS == TRUE)
      {
         if(gl_RxSymbolCount > 0)
         {
            //Generate new packed PN sequence
            Gen_PNMedley_14thOrder(guca_RxMedleyBuffer, (int16)NUM_R_C_MEDLEY_BYTES, &gul_RxMedleyState, 0);
         }
      }

   }

   switch (gs_RxSubState) {

   case R_C_MEDLEY_RX_BIS_SHOWTIME_INIT:

      if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
      {
      if (gft_BitloadState == TRAINING_DONE)
      {
         if (gft_BitloadOK != SUCCEED)
         {
            // We check to see if the bit loading algorithm returned with correct
            // framing and control parameters.  These include all possible checks on
            // parameters like Mp, Tp, Sp, Rp, Dp, CWSize, Bpn, ORp etc,.  The bit loading
            // routine calls a function that checks for all these conditions, and in case
            // any or all of these conditions are violated, then it sets gft_BitLoadParameters
            // flag to a non-zero value, and sets gft_BitloadOK to FAIL.

            gs_InitFailCauseNearEnd = 2;
            gus_ExceptionCode = E_CODE_BIT_LOADING_FAILURE;

         } // if (gft_BitloadOK != SUCCEED)

         /* ============================================================================== */
         /* we need to do codeswap first (Socrates codeswap only)*/
         /* ============================================================================== */
#ifdef BIS_CODESWAP
            //Codeswap the exchange page (EXCH1) that overlaps with BTLD page
         if (gs_CodeSwapSection == CSPAGE_BIS_EXCH1)
            gs_CodeSwapStatus = CODESWAP_START;
#endif

         guc_ShowTimeRxState = TRAINING_IN_PROGRESS;  /* indicates the BG is active */

#ifdef ADSL_62
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ClearRxZephyrRegs);
#endif
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgInitShowTimeRx);
         guc_RxDataPumpState = TRAINING_WAITING;
         gs_RxSubState = R_C_MEDLEY_RX_BIS_DATA_PUMP_SETUP;
      }
      }
      else  /*if(STATArray[STAT_MacroState] == STAT_LoopDiagMode) */
      {
#ifdef BIS_CODESWAP
         if ((gs_CodeSwapStatus == CODESWAP_IDLE) && (gs_CodeSwapSection == CSPAGE_BIS_EXCH1))
         {
            gs_CodeSwapStatus = CODESWAP_START;
#endif

         /* In diagnostics mode, no need to perform BgInitShowTimeRx and RxDataPumpSetUp */
            // Instead we run a background task to compute Diag mode information.
            guc_RxDataPumpState = TRAINING_IN_PROGRESS;  /* indicates the BG is active */
            //guc_RxDataPumpState = TRAINING_DONE;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgCalcDiagModeData);

            gs_RxSubState = R_C_MEDLEY_RX_BIS_DATA_PUMP_SETUP;

#ifdef BIS_CODESWAP
         }
#endif
      }

      break;

   case R_C_MEDLEY_RX_BIS_DATA_PUMP_SETUP:

      if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
      {
         if ((guc_ShowTimeRxState == TRAINING_DONE) &&
            (guc_RxDataPumpState != TRAINING_DONE))
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,RxDataPumpSetUp);
         }
      }

      if (guc_RxDataPumpState == TRAINING_DONE)
         gs_RxSubState = R_C_MEDLEY_RX_BIS_WAIT;

#ifdef DANUBE
#ifdef TARGET_HW
      if ((gus_DataBuf_InXmem & STATES_TRAIL_BUF_IN_XMEM) == 0)
      {
            /* Swap training states trail buffer to XMEM */
            RequestSwap_StatesTrailBuf_ToXmem();

         if (gt_DataSwap.c_State == DATASWAP_REQUESTED)
         {
               /* Switch states trail buffer to a smaller one in bulk memory */
               gsa_StatesTrail = &gsa_ShowTimeStatesTrail[0];
               INFOMap[INFO_DebugTrail] = (int16*)&gsa_ShowTimeStatesTrail;
               gt_TrailXmemCollectControl.s_debugTrailLen = (gt_debugTrailCollectControl.s_debugTrailLen + 1)/2*2; // roundup to even number for XDMA longword alignment
               gt_TrailXmemCollectControl.s_debugTrailSize = (XMEM_STATES_TRAIL_BUF_END - XMEM_STATES_TRAIL_BUF_ADDR);
               gt_debugTrailCollectControl.s_debugTrailLen = 0;    // reset index to 0
               gt_debugTrailCollectControl.s_debugTrailSize = DEBUG_TRAIL_SMALL_SIZE;
               gt_debugTrailTriggerControl.s_cyclicTrailUpdate = 1; // force buffer wrap around
               gs_ShowtimeTrailBufferIndex = 0;

               /* Switch INFO 87 pointer to point to Xmem struct */
               INFOMap[INFO_DebugTrail_Collect] = (int16*)&gt_TrailXmemCollectControl;
         }
      }
#endif
#endif

      break;

   case R_C_MEDLEY_RX_BIS_WAIT:

         /* ============================================================================== */
         /* we need to do codeswap first (Socrates codeswap only)*/
         /* ============================================================================== */
#ifdef BIS_CODESWAP
         //Codeswap the exchange page EXCH2 (overlaps with RXINIT page)
      if ((gs_CodeSwapStatus == CODESWAP_IDLE) && (gs_CodeSwapSection == CSPAGE_BIS_EXCH2))
      {
         if(STATArray[STAT_MacroState] != STAT_LoopDiagMode) // Swap EXCH2 only in data mode.
         {
               gs_CodeSwapStatus = CODESWAP_START;
         }
         gpF_RxStateFunc = (PtrToFunc)RCMedleyRxF_CSwap_BIS;
         gpF_TxStateFunc = (PtrToFunc)RMedleyTxF_CSwap_BIS;
      }
#else

         gpF_RxStateFunc = (PtrToFunc)RCMedleyRxF_CSwap_BIS;
         gpF_TxStateFunc = (PtrToFunc)RMedleyTxF_CSwap_BIS;

#endif //BIS_CODESWAP

      break;
   }

   /* ============================================================================== */
   /* increment RxFirstPNbit following its use in the NoiseAccum function        */
   /* ============================================================================== */
   if(gs_RxSubState < R_C_MEDLEY_RX_BIS_WAIT)
   {

      gs_RxFirstPNbit += s_SequenceLengthMultiplier;
   }

}

#ifdef DANUBE
#ifdef TARGET_HW
/****************************************************************************
;   Prototype: void RequestSwap_StatesTrailBuf_ToXmem (void)
;
;   Description: Function makes a request for XDMA by loading the Data Swap
;  Control structure with all necessary parameters required to program the
;  XDMA engine.
;
;  Two global flags will be set:
;     (1) gt_DataSwap.c_State = DATASWAP_REQUESTED
;     (2) gus_DataBuf_InXmem |= STATES_TRAIL_BUF_IN_XMEM
;
;  The first flag indicates that XDMA transfer is pending and structure
;  gt_DataSwap is occupied.
;
;  The second flag indicates that this particular buffer will be in external
;  memory when DMA is completed.
;
;   Arguments:
;       None
;
;   Return Value:
;       None
;
;****************************************************************************/
C_SCOPE void RequestSwap_StatesTrailBuf_ToXmem (void)
{
    if (gt_DataSwap.c_State == DATASWAP_READY)
    {
        gt_DataSwap.c_State   = DATASWAP_REQUESTED;
        gt_DataSwap.l_SrcAddr = (int32)&gsa_TrainStatesTrail[0];
        gt_DataSwap.l_DstAddr = XMEM_STATES_TRAIL_BUF_ADDR;
        gt_DataSwap.s_BufSize = (gt_debugTrailCollectControl.s_debugTrailLen + 1)/2*4; // byte size, longword aligned
        gt_DataSwap.c_XferDir = XDMA_WRITE_XMEM;
        gus_DataBuf_InXmem   |= STATES_TRAIL_BUF_IN_XMEM;
    }
}
#endif
#endif

/* undefine substates */
#undef R_C_MEDLEY_RX_BIS_SHOWTIME_INIT
#undef R_C_MEDLEY_RX_BIS_DATA_PUMP_SETUP
#undef R_C_MEDLEY_RX_BIS_WAIT
