/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCMedleyRxF_bis.c
 *
 *   Functions implementing states in the Channel Analysis phase of
 *   Initialization for RX.
 *
 *   RX: R_C_MEDLEY_BIS
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RCMedleyRxF_bis.c
//
// History
//
// 26/07/10  Bhadra/Kannan: Force Unity TDQ for ADSL2 mode in short loops( < 1500m )
//                    to avoid DS CRC errors against Connexant D57 DSLAM.
//                    And also enable Noise margin seperation calculation while forcing
//                    unity TDQ to improve the DS Data Rate.
//                    To enable uinty TDQ for CNXT, cw INFO 103 0 0x2
//                    Grep for "PERF_DS_Bis_CNXT_ForceUnityTDQ" to check the changes.
// ******************************************************************

#include "common.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "rt_tones.h"
#include "gdata.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "pll.h"
#include "medley.h"
#include "crc16.h"
#include "bitload.h"
#include "exchmsgs.h"
#include "showtime.h"
#include "pn_tab.h"
#include "pwr_ctbk.h"
#include "fifo.h"
#include "accum32.h"
#include "noiseacc.h"
#include "cmv.h"
#include "med2rev.h"
#include "DSLEngin.h"
#include "detect.h"
#include <string.h>
#include "vecpwr.h"
#include "memcopy.h"
#include "memsetbf.h"
#include "rinfotbl.h"
#include "exchdata.h"
#include "rcmedley_Data.h"
#include "rcmedly2.h"
#include "gdata_bis.h"
#include "bitload_bis.h"
#include "tx_ops_bis.h"
#include "RCMedleyRxF_Bitload_bis.h"
#include "states.h"
#include "RCExchMarkerRxF_BIS.h"
#include "RCMedleyRxF_bis.h"
#include "RMedleyTxF_bis.h"
#include "Gen_PNMedley_14thorder.h"
#include "fdq_init.h"
#include "fdq_adj.h"
#include "tdq_init.h"
#include "fft_bg.h"

//Socrates codeswap purpose
#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCMedleyRxF_BIS
 *
 *  Description: Processes the C_Medley signal.
 *  C_Medley is used by the ATU-R to calculate the downstream SNR per tone, which
 *  is then used to determine the number of bits per tone.
 *
 * NOTE:
 * Medley NTC function is split into two functions for codeswap purposes
 * Namely RCMedleyRxF_BIS() and RCMedleyRxF_Bitload_BIS()
 *
 *  Prototype: RCMedleyRxF_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_RxSymbolCount            - (I) number of symbol periods in current state
 *      gs_RxNextState              - (O) RX state beginning next symbol period
 *    gusa_PN512Tab[]            - (I) PN512 sequence table
 *    gs_RxToneBuf[]          - (I) received DMT tones (FDQ output)
 *    gsa_MedleySnrBuf[]          - (O) computed SNR per tone
 *    guc_BitloadOK           - (O) indicator if bit loading succeeds
 *
 * Substates:
 * ----------
 * Below States are implemented in function RCMedleyRxF_BIS()
 * R_C_MEDLEY_RX_INITIALIZE            - Initialization
 * R_C_MEDLEY_RX_LOAD_CURRENT_TDQ      - Loads current TDQ or turns it off if required
 * R_C_MEDLEY_RX_FDQ_INIT           - Initialize parameters for FDQ training
 * R_C_MEDLEY_RX_AVERAGE_FRAME         - Gather average frame for FDQ training
 * R_C_MEDLEY_RX_FDQ_TRAIN          - Compute FDQ coefficients
 * R_C_MEDLEY_RX_ADJUST_SYNCH       - Adjust buffer alignments and FDQ coefficients
 * R_C_MEDLEY_RX_PRE_TEST_SNR_INIT     - Rotate the reference tone corresponding to post-sync
 * R_C_MEDLEY_RX_TEST_SNR_INIT         - Initialize for SNR calculation
 * R_C_MEDLEY_RX_CALCULATE_TEST_SNR    - Gather average frame and calculate SNR
 * R_C_MEDLEY_RX_KEEP_BEST          - Keep the best TDQ and throw out others
 * R_C_MEDLEY_RX_LOAD_BEST          - Load the best TDQ (or turned it off it achieves best capacity)
 * R_C_MEDLEY_RX_FINAL_SNR_INIT        - Initialize for final SNR computation
 * R_C_MEDLEY_RX_CALCULATE_FINAL_SNR   - Gather average frame and calculate final SNR
 *
 * Below States are implemented in function RCMedleyRxF_Bitload_BIS()
 * R_C_MEDLEY_RX_BITLOAD            - Perform bitloading or selecting profile
 * R_C_MEDLEY_RX_DS_ATTEN           - Calculate downstream loop attenuation
 * R_C_MEDLEY_RX_WAIT               - Wait for the end of the R_C_MEDLEY state.
 * R_C_MEDLEY_RX_CAPTURE_FRAMES        - Capture time-domain frames.
 * R_C_MEDLEY_RX_DETECT_SEGUE       - Detect C_SEGUE2 and check for time out.
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
/* Below States are implemented in function RCMedleyRxF_BIS() */
#define  R_C_MEDLEY_RX_BIS_INITIALIZE        (0)
#define R_C_MEDLEY_RX_SWAP_BTLDBIS           (1001)

/* Below States are implemented in function RCMedleyMultiTdq() */
#define  R_C_MEDLEY_RX_LOAD_TDQ           (1)
#define R_C_MEDLEY_RX_FINAL_SNR_INIT      (12)
#define  R_C_MEDLEY_RX_COMPUTE_NMS_INIT   (25)


void RCMedleyRxF_BIS(void) {

   int16 i;
   int16 j;
   int16 s_PN512_LEN, s_SequenceLengthMultiplier;

   if ((( gl_SelectedMode & (MODE_G992_5)  )) != 0)
   {
      s_SequenceLengthMultiplier = 2;
   }
   else
      s_SequenceLengthMultiplier = 1;

   s_PN512_LEN = s_SequenceLengthMultiplier * PN512_LEN;

   /* ============================================================================== */
   /* Generate Medley reference frame */
   /* ============================================================================== */

   switch (gs_RxSubState) {

   case R_C_MEDLEY_RX_BIS_INITIALIZE:

   /* ============================================================================== */
   /* Wait until TX transmits R_MEDLEY signal */
   /* ============================================================================== */
   /* ============================================================================= */
   /* Perform necessary initialization at symbol 0 */
   /* ============================================================================= */
      if(gl_RxSymbolCount == 0)
      {
         gs_RxSubStateCnt = 0;

         if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
         {
         if(gt_RMsgs1_bis.uc_CA_MEDLEYds >= gt_RCMsgs1_bis.uc_CA_MEDLEYus)
            gt_StateMachCntrl.l_RXCurrentStateLen  = (gt_RMsgs1_bis.uc_CA_MEDLEYds<<9)-1;
         else
            gt_StateMachCntrl.l_RXCurrentStateLen  = (gt_RCMsgs1_bis.uc_CA_MEDLEYus<<9)-1;
         }
         else
              gt_StateMachCntrl.l_RXCurrentStateLen = MEDLEY_LEN_BIS_DIAG -1;

         gt_StateMachCntrl.s_RXFollowingState   = R_C_EXCHMARKER_RX_BIS;
         gt_StateMachCntrl.psa_RXSNRBuf         = gsa_MedleySnrBuf;
         gt_StateMachCntrl.pF_RxFollowingState = (PtrToFunc)RCExchMarkerRxF_BIS;

         if ((( gl_SelectedMode & (MODE_G992_5)  )) != 0)
         {
            gpusa_MedleySeq = gusa_PN512Tab;

#ifndef TARGET_HW
            // Medley 14th order PRBS is supported only on Cocomo currently
            // since its not been optimized to run on hardware
            if ((gt_RCMsgFmt_bis.uc_MedleyPRBSds == 1) && (gt_RMsgFmt_bis.uc_MedleyPRBSus == 1))
            {
               /* use 14th order PRBS medley sequence */
               gft_G992_5_Medley14thOrderPRBS = TRUE;
               gpusa_MedleySeq = gusa_14Order_PN1024Tab;
            }
#endif
         }

         gs_RxFirstPNbit = 0;
         gs_MedleyModulo = s_PN512_LEN;
         gsa_ref_tones = gsa_unpk_PN512;

#ifdef ADSL_62_XYMEM
         gsa_FDQ_coef_best = (int16 *) ( gsa_YBlock_Extended+ 2*(RX_NUM_TONES));
#endif
         if (gft_G992_5_Medley14thOrderPRBS == TRUE)
         {
            /* ul_MedleyState holds previous 32 bits of Medley sequence. First symbol has to be
            treated separately because we need to initialize first 14 bits of PN sequence to 1 */
            gul_RxMedleyState = 0x00003FFF;

            guca_RxMedleyBuffer[0] = 0xFF; // copy to byte buffer
            guca_RxMedleyBuffer[1] = 0x3F;

            // Generate PN sequence (different for first frame: 126 extra bytes (in the DS) to be generated because first 2 bytes are defined as above)
            Gen_PNMedley_14thOrder(guca_RxMedleyBuffer, (int16)(NUM_R_C_MEDLEY_BYTES), &gul_RxMedleyState, 1);
         }

         /* Unpack PN512 sequence so that the array gsa_ref_tones will contain the Reverb signal, and the Medley Reference */
         /* will be calculated in BgMedleyToReverbAccum() and BgNoiseAcc() and saved in the local array */
         gs_UnpackPNState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc) BgUnpackPN);

         /* initialize Accumulation pointers for NoiseAcc() and BgMedleyToReverbAccum()*/
         gla_NoisePower = gla_RxAccumBuf+2*gs_RxFirstChannel;
         gsa_recv_tones = &gsa_RxToneBuf[0];
         gs_TrainCnt = 0;

         // zero out SNR which may have been overwritten in other states
         MemSetBuffer(gt_StateMachCntrl.psa_RXSNRBuf, 0, 0, (int16)(sizeof(int16)*gs_RxNumTones));

         /* Medley Tdq Enabled */
         if ((OPTNArray[OPTN_AlgControl] & OPTN_MedleyTdqEnable) != 0)
         {
            /* Initialize alignment counters */
            gs_AlignmentOffset = 0;
            gs_CumulativeAlignmentOffset = 0;

            /* Initialize Unity TDQ FDQ coefficient */
            gsa_FDQ_coef_pilot_UnityTdq[0] = gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)];
            gsa_FDQ_coef_pilot_UnityTdq[1] = gsa_pre_FDQ_coef[(gs_PilotToneIdx<<1)+1];
            guc_FDQ_exp_pilot_UnityTdq = guca_pre_FDQ_exp[gs_PilotToneIdx];

            gs_TdqIdx = 0;
            // AR8_TF: PERF_DS_Bis_CNXT_ForceUnityTDQ (Start)
#ifndef ISDN   // Only for Anx-A
            // Force Unity TDQ for ADSL2 Mode against D57 Connexant DSLAM
            // (Vendor ID: "0xFF, 0xB5, 0x47(G), 0x53(S), 0x50(P), 0x4E(N), 0x00, 0x0B" only.
            // This is done to avoid DS CRC Errors in short loops < 1500m.
            // TODO: If the data rate degradation was observed due to this change,
            // need to cross check the Noise Margin Separation Algorithm.
            // With these 2 changes(Forcing of Unity TDQ and Enabling of Noise Margin Separation)
            // DS data rate improved and DS CRC not observed.
            // DS CRC Errors was observed for the Loops < 1500m ETSI Loops in white Noise and FB
            // Noise cases.
            // Near end Loop attenuation measured for the Loop @1500m is 27.0dB.

            if ((gl_SelectedMode & (MODE_G992_3)) &&
               (gs_CurrentCoChipset == GSI_CO_CHIPSET) &&
               (gt_INFX_CMV.us_OperatorSpBits & CMV_TO_FORCE_UNITY_TDQ) &&
               (gt_NearEndParam.us_LoopAttenuation < 270))
            {
              gs_TdqIdx = gs_NumMultiTdq; // Force Unity TDQ, 5, Last Index is Unity TDQ
              gft_ForceUnityTDQ = TRUE;   // Enabled here to use Noise Margin Separation
            }
#endif // ifndef ISDN
            // AR8_TF: PERF_DS_Bis_CNXT_ForceUnityTDQ (End)

            gs_TdqOffIdx = -1;
            gs_last_tdq_idx = gs_NumMultiTdq-1;
            /* Determine whether or not to test TDQ-off case */
            if ((OPTNArray[OPTN_AlgControl] & OPTN_MedleyTdqOffEnable) != 0)
            {
               gs_last_tdq_idx++;
               /* last case is TDQ off */
               gs_TdqOffIdx = gs_last_tdq_idx;
            }
            //ISDN compile switch not added here to make it general.
            // AR8_TF: PERF_DS_Bis_CNXT_ForceUnityTDQ (Start)
            if (gft_ForceUnityTDQ == TRUE)
            {
              gs_last_tdq_idx = gs_NumMultiTdq; // Force Unity TDQ, 5, Last Index is Unity TDQ
            }
            // AR8_TF: PERF_DS_Bis_CNXT_ForceUnityTDQ (End)

            if (gft_OfflinePreSyncs == FALSE) {
               j = -gs_presync_stepsize*(gs_NumMultiTdq>>1);
               for (i=0; i<gs_NumMultiTdq; i++){
                  gsa_MultiTdqPreSyncs[i] = j;
                  j = j + gs_presync_stepsize;        /* set Multiple TDQ Pre Sync points    */
               }
            }
            gs_MultiTdqTrainingState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc) BGMultiTdqCalc);

            gft_CopyRxBuffer = FALSE;
         }
      } /* End of if (gs_RxSymbolCount == 0) */

         // For Socrates BIS codeswap purpose only
#ifdef BIS_CODESWAP
      //if we have completed swaping the correct page
      if (gs_CodeSwapStatus == CODESWAP_IDLE &&
         gs_CodeSwapSection == CSPAGE_BIS_TDQTEST &&
         gs_TxState == R_MEDLEY_TX_BIS &&
         gs_RxState == R_C_MEDLEY_RX_BIS)
      {
         gs_CodeSwapStatus = CODESWAP_START;
         gs_RxSubState = R_C_MEDLEY_RX_SWAP_BTLDBIS;
      }
#else
      gs_RxSubState = R_C_MEDLEY_RX_SWAP_BTLDBIS;
#endif //BIS_CODESWAP
      break;

   case R_C_MEDLEY_RX_SWAP_BTLDBIS:
#ifdef USE_ENGINE_FOR_BG_FFTS
      if (gft_StartEngineFFT)
         EngineFFT_StateMachine();
#endif

#ifdef BIS_CODESWAP
      // Wait for pending (TDQTEST page) codeswap to be finished
      if (gs_CodeSwapStatus != CODESWAP_IDLE)
         break;
#endif
      /* If Medley Multi Tdq Done or Disabled */
      if (gs_MultiTdqTrainingState == TRAINING_DONE ||
         (OPTNArray[OPTN_AlgControl] & OPTN_MedleyTdqEnable) == 0)
      {
#ifdef BIS_CODESWAP
         // Start overwrite of multitdq codeswap page with bitload page
         gs_CodeSwapStatus = CODESWAP_START;
         gpF_TxStateFunc = (PtrToFunc)RMedleyTxF_TDQTest_BIS;
#endif
         gpF_RxStateFunc = (PtrToFunc)RCMedleyRxF_TDQTest_BIS;
         if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & (OPTN_NoiseMarginChange_NM_Ctrl_ADC_MEDLEY_EN))
         {
            gs_RxSubState = R_C_MEDLEY_RX_COMPUTE_NMS_INIT;
         }
         else

         {
            if (((OPTNArray[OPTN_AlgControl] & OPTN_MedleyTdqEnable) == 0) && (gft_TrainFdqIfMultiTdqDisabled == FALSE))
               gs_RxSubState = R_C_MEDLEY_RX_FINAL_SNR_INIT;
            else
               gs_RxSubState = R_C_MEDLEY_RX_LOAD_TDQ;
         }
      }
      break;
   }

   /* ============================================================================== */
   /* increment RxFirstPNbit following its use in the NoiseAccum function        */
   /* ============================================================================== */
   gs_RxFirstPNbit += s_SequenceLengthMultiplier;

    if (gs_RxFirstPNbit >= s_PN512_LEN)
   gs_RxFirstPNbit -= s_PN512_LEN;

}

/* undefine substates */
#undef R_C_MEDLEY_RX_BIS_INITIALIZE
#undef R_C_MEDLEY_RX_SWAP_BTLDBIS
#undef R_C_MEDLEY_RX_LOAD_TDQ
#undef R_C_MEDLEY_RX_FINAL_SNR_INIT
#undef R_C_MEDLEY_RX_COMPUTE_NMS_INIT

