/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCRates1RxF.c
 *
 *   Functions implementing states in the Channel Analysis phase of
 *   Initialization for both TX and RX.
 *
 *   Only the following states are covered in this file:
 *   RX: R_C_MSG1_RX_BIS
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RCMsg1RxF_bis.c
//
// History
//
// 20/08/2010  Sriram Shastry. Some BRCM COs prefer AnnexL
//                       in mid loops which causes failing test requirements
//                       due to low US rates. We retrain at this loop range,
//                       around 8kft to 15kft, and disable AnnexL so that
//                       ADSL2+ will be selected.
//                      Grep for SMS00790593 IOP_DS_BRCM_BisPlus_DisableAnxL
//
// 20/08/2010  Sriram Shastry. The fix for SMS00790593 IOP_DS_BRCM_BisPlus_DisableAnxL
//                       introduces retrain against all BRCM COs at the range of
//                       8kft to 15kft and adds around 14 seconds to training time.
//                       Since FG11 already has relatively long training time
//                       (around 57 seconds) at the some test loops, there are
//                       several failure sections observed in TR100 A2.
//                       We added code to check Vender Specific Information and
//                       differentiate FG10 from FG11 and ISAM7330. CPE initiates
//                       retrain only FG10 is detected. For other cases, including
//                       FG11 and ISAM7330, we just set AnnexL disabling flag and
//                       CO initiate the retrain.
//                       Grep for SMS00815882 IOP_US_BRCM_BisPlus_DisableAnxLFG10Retrain
//
//      19/08/2010 AdeelJ/Palaksh/Bhadra:   Fix for ADSL2+ low US rates against Intracom CNXT DSLAM.
//                       In case fix conditions are true, The code will check the Target Margin requested
//                       by the CO. In case TARMARds is above or equal to 10dB and the fix is already not enabled then the
//                       fix will be enabled and a retrain will be triggered, otherwise the code will proceed
//                       normally. In case the target margin is less than 10dB and the fix is enabled then the fix will be
//                       disabled alongwith retrain. In case other conditions for the fix are not true and the fix flag is non-zero
//                       then the flag will be reset and a retrain triggered.
//                       The US Margin 10dB condition is set because during experiments it was seen that the
//                       fix causes CRC errors with US Target Margin of 6dB. The customer Intracom(Greece)
//                       was using a 10dB profile but this check was needed for additional protection against changes of profile.
//                       Since we do not receive the information regarding TARMARus during training, we are tying
//                       this fix to TARMARds with the assumption that mostly operators set an equal US and DS Margin in the
//                       CO profile.
//                       Grep for SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement
//
// 09/02/2011 Sriram: Use the special TSSI set from SMS00910375 in the range of
//            2100m to 4200m to improve the US rates against CNXT DSLAMs with FW
//            version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
//14/03/2012 Kannan: 08/04/2009 Bhadra: Added code for uinversal ReTx C-Msg1 related changes
//                                  Increased "guca_R_C_Msgs1_bis size".by 10 bytes
//                   Added variables required for DFE<->PPE and cntrs.
//                     Grep for SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod to see changes.
//                  Also added changes to C_MSG1 to include additional extra bytes
//                    for Channel Iniitalisation policy (CI) and Leftr threshold
//                   Grep for FEATURE_DS_BisPlus_ALL_ReTxCMSG1_New to check these changes.
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 26/12/2012 Stefan/Vinjam: Integrated R3.5 fix to R5.2 Mainline.
//            To avoid long training times in ADSL mode and too early false mode switches to VDSL binary,
//                FW sends the intentional retrain information (using a global variable guc_Forced_Retrain) to SW/DSL API.
//                Grep for XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime
//
// 27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx(C-MSG1)
//                   training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 10/04/2014 Sriram Shastry: Added the workaround requested by AT&T for their special profile
//                   on Alcatel BRCM DSLAMs (ABLT-D, ABLT-A and EBLT-K)
//                   in T1.413, G.dmt, G.lite and Annex L multimode, i.e.
//                   Multimode CPE needs to disable Annex L on short loops.
//                   This workaround is disabled by default with
//                   CMV bit7 = 0 for INFO 103 26.
//                   To enable it, set bit7 = 1 by cw INFO 103 26 0x0080.
//                   Grep for ADSLRTFW-1400_XDSLRTFW-1596_IOP_DS_BisPlus_BRCM_ATT_DisableAnxL
//
// 15/04/2014 ChiWen/Hanyu: Fine tuned US performance against CNXT DSLAMs based on ADSLRTFW-1480 and ADSLRTFW-1591 with the following changes
//  (1) Added special flat US TSSI;
//  (2) Set tone 32 to zero(gusa_US_Tssi_Value[32] = 0);
//  (3) Enabled special flat US TSSI in C-REVERB1/R-REVERB1 (might have influence over the final PGA training);
//  (4) Enabled special flat US TSSI in C-REVERB2;
//  (5) Renamed gft_USPerf_Midloop_Gspn to gft_USPerf_Gspn for all CNXT CO's;
//  (6) Above changes are applied to all CNXT CO/DSLAMs regardless of CO FW versions and controlled by CMV bit4 (MASK 0x0010) of info 103 27
//      that is ENABLED (bit4=1) by default. This is especially recommended at CenturyLink/USA. So far no side effect has been observed.
//  Grep for XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement
//
//  30/3/2015 Sriram Shastry:Jira XDSLRTFW-1843 :CPE  is unable to  link in ADSL2/ADSL2P under Multi-mode configuration.
//  Solution is force CPE  to  G.DMT  mode after 3 fails attempts during  training in ADSL2/ASDL2P mode.
//      Grep for  XDSLRTFW-1843
//
// ***********************************************************************
#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "rx_ops.h"
#include "crc16.h"
#include "detect.h"
#include "const_bis.h"
#include "rinfo_bis.h"
#include "states.h"
#include "RCReverb5RxF_BIS.h"
#include "cmv.h"
#include "DebugBuffer.h"





//XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove (START_End)

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCMsg1RxF_BIS
 *
 *  Description: Receives messages encoded as one symbol of C_Reverb as a 1 bit
 *  and one symbol of C_Segue as a 0 bit.  These messages include:
 *      MESSAGE         STORAGE LOCATION
 *      C_Msgs1         guca_R_C_Msgs1_bis[];
 *
 *  Prototype: void RCMsg1RxF_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gus_RC_CRC_computed     - (O) R_C_CRC1 computed over recevied message
 *      guca_R_C_Msgs1_bis[]    - (O) received R_C_MSGS1 message
 *      gusa_PN512Tab[]     - (I) packed PRD sequence
 *      gsa_RxToneBuf[]     - (O) output of FFT
 *      gl_RxSymbolCount    - (I) number of symbol periods in current state
 *      gs_RxNextState      - (O) RX state beginning next symbol period
 *              gs_RxState                      - (I) current RX state
 *              gs_RxSubStateCnt        - (I/O) substate count
 *
 *  Notes: implements states R_C_MSG1_RX_BIS.
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RCMsg1RxF_BIS(void) {

        uint16  us_infobit;
        int16   s_bitpos, s_index, i, s_err;
        int16 s_R_C_MSG1_NUM_BITS_BIS;
        //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START_END)
        //SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod (Start End)
    int16 s_R_C_MSG1_NUM_BYTES;
   // Observed No connectivity due longer trainig time if ANNEXL is disabled with
   //FG11 DSLAM. This fix will be enabled if we see any failures or lower data rates.
   //IOP_DS_BRCM_BisPlus_DisableAnxL_Remove (Start_End)
#if 0 //ndef ISDN   // Only for Anx-A
    //IOP_DS_BRCM_BisPlus_DisableAnxL (START)
    //Retrain and disable AnnexL if the CO is BRCM, in the loop range
    //from 8kft to 15kft and the selected mode is not Annex L.
    if ((gs_CurrentCoChipset == BDCM_CO_CHIPSET) && (!gft_disableAnnexL) &&
            ((gl_SelectedMode & (MODE_G992_3 | ANNEX_L)) == 0) &&
            (gs_PGAforLoopLengthEstimation > PGA_THRESHOLD_8_KFT) &&
            (gs_PGAforLoopLengthEstimation <= PGA_THRESHOLD_15_KFT))
    {
        gft_disableAnnexL = 1;
        //IOP_US_BRCM_BisPlus_DisableAnxLFG10Retrain (START)
        //Originally we retrained and disabled AnnexL for all BRCM COs(SMS00790593).
        //This added around 14s to training time. FG11 and EBLT-E already have
        //training time about 60s in mid-long loops, the retrain will cause failure
        //in some single mode test cases. It seems all major BRCM CO will retrain
        //before SHOWTIME from ~13kft anyway, we don't need to kick off
        //retrains for some BRCM DSLAMs to save time.
        //However, we have to initiate retrain and disable Annex L against FG10 BRCM.
        //Otherwise the DSLAM will retrain after REVERB7 and choose Annex L from
        //~13kft. The US connection rate will be lower than the TR67 requirements
        //in Automode (Some operators use TR67 requirements for all the connection
        //modes). Here we check Vender Specific Information to decide if retrain or not.
        //This change is applied for FG10 BRCM CO only. If later on we see DSLAMs
        //behave the same, we may have to add them to the list.
        //Below is the Vender Specific Information of three major BRCM DSLAMs. We
        //parsed it in GHS and saved in guca_fe_G9941_VendorID[6] and [7]
        //FG10 ABLT-D guca_fe_G9941_VendorID[6] = 0x54, [7]= 0x4D
        //FG11 ABLT-D guca_fe_G9941_VendorID[6] = 0x61, [7]= 0x8F
        //ISAM7330 EBLT-E guca_fe_G9941_VendorID[6] = 0x91, [7]= 0x8F
        if(guca_fe_G9941_VendorID[6] == 0x54 && guca_fe_G9941_VendorID[7] == 0x4D)
        {
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
            /* Set exception handler variables */
            gus_ExceptionState = gs_RxState;
            gus_ExceptionCode = E_CODE_BRCM_DISABLE_ANNEX_L;
                        //XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime (Start_End)
            guc_Forced_Retrain = 0x9;     // Tell SW that this is a forced intentional retrain
        }
    }
    // IOP_DS_BRCM_BisPlus_DisableAnxL (END)
#endif   // ifndef ISDN

//ADSLRTFW-1400_XDSLRTFW-1596_IOP_DS_BisPlus_BRCM_ATT_DisableAnxL  (START)
//Added the workaround requested by AT&T for their field profile on
//Alcatel BRCM DSLAMs (ABLT-D, ABLT-A and EBLT-K) in T1.413, G.dmt, G.lite
//and Annex L multimode with maximum DS data rate of 8Mbps. Due to BRCM CO
//old FW design, it always connects to Annex L on any loops, which results
//in lower DS margin on short loop.
//Therefore AT&T requests that multimode CPE disable Annex L on
//short loops less than ~9.5kft to connect to G.dmt for better DS margin.
//According to the Tracespan log captured at AT&T lab, the old BRCM DSLAM
//only responded Annex L mode (i.e. ADSL2 is also disabled by CO!) in CL
//for multimode CPE. We can only use BRCM CO VID and loop length < 9.5kft
//to narrow dwon side effect.
//The side effect is about 15 sec additional time to resend G.hs messages
//with disabling Annex L mode. Then the BRCM DSLAM responds G.dmt single
//mode in CL. The risk is what if DSLAM or/and CPE is really configured in AnnexL
//single mode although this should never be the case in real world.
//For all normal DSLAMs and CPEs, Annex L is always enabled along with ADSL2.
//I.E. if CPE disables Annex L, they can still connect to ADSL2 mode.
//The risk of no common mode is low.
//This code should be done as soon as CO VID and loop length are available in G.hs.
//Due to memory shortage in G.hs overlay page, it is moved to here.

#ifndef ISDN
   if (  (gs_CurrentCoChipset == BDCM_CO_CHIPSET) &&
         (!gft_disableAnnexL) &&
         (gl_SelectedMode & (MODE_G992_3 | ANNEX_L)) &&
         (gs_PGAforLoopLengthEstimation < PGA_THRESHOLD_12_KFT) &&
         (gt_INFX_CMV.us_OperatorSpBits4 & CMV_TO_ENABLE_ATT_DISABLE_ANNEXL_SHORTLOOP))
   {
      gft_disableAnnexL = 1;
      gs_RxNextState = FAIL_RX;
      gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
      /* Set exception handler variables */
      gus_ExceptionState = gs_RxState;
      gus_ExceptionCode = E_CODE_BRCM_ATT_DISABLE_ANNEXL;
   }
#endif
   // ADSLRTFW-1400_XDSLRTFW-1596_IOP_DS_BisPlus_BRCM_ATT_DisableAnxL (End)
   if (( gl_SelectedMode & (MODE_G992_5)  ))
   {
      if( gft_DS_Windowing == TRUE)
      {
         s_R_C_MSG1_NUM_BITS_BIS = R_C_MSG1_NUM_BITS_BIS;
      }
      else
      {
         /* decrease the c-msg1 size to exclude the DS windowing samples */
         s_R_C_MSG1_NUM_BITS_BIS = R_C_MSG1_NUM_BITS_BIS - (DS_WINDOWING_BYTES * 8);
      }
   }
   else
   {
      /* decrease the c-msg1 size to exclude the DS windowing samples */
      s_R_C_MSG1_NUM_BITS_BIS = R_C_MSG1_NUM_BITS_BIS - (DS_WINDOWING_BYTES * 8);
   }
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   //SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod Begin
   s_R_C_MSG1_NUM_BYTES = R_C_MSG1_NUM_BYTES_BIS;

#ifdef UNV_RETX_MSGS
   if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
      s_R_C_MSG1_NUM_BITS_BIS += (R_C_MSG1_UNIV_RETX_PMS_TPS_TC_EXTRA_BYTES*8) ;//considering 11 octets of TPS-TC
      s_R_C_MSG1_NUM_BYTES = R_C_MSG1_RETX_NUM_BYTES_BIS;                       //  and 3 octets of PMS-TC in C-MSG1
      //FEATURE_DS_BisPlus_ALL_ReTxCMSG1_New Start
      if(gt_ReTxConfigInfo.s_CMSG1_CI_LeftrThresh == 1)
      {
         s_R_C_MSG1_NUM_BITS_BIS += (R_C_MSG1_UNIV_RETX_TPS_CI_LEFTR_BYTES*8);
         s_R_C_MSG1_NUM_BYTES += R_C_MSG1_UNIV_RETX_TPS_CI_LEFTR_BYTES;
      }
      //FEATURE_DS_BisPlus_ALL_ReTxCMSG1_New End
   }
#endif
   if (gl_RxSymbolCount == 0)
   {
      gft_RCExch1RcvFlag = NOT_RECEIVE;

      for (i = 0; i < s_R_C_MSG1_NUM_BYTES; i++)
         guca_R_C_Msgs1_bis[i] = 0;

      gus_RC_CRC_computed = 0x0000;
      gus_RC_CRC_received = 0x0000;

      gs_RxSubStateCnt = 0;
      gs_RxCrcSubstateCnt = 0;
   }

   // SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod End
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
   /*  get infobit */
   /* DetectReverbSegue() returs a 0 when Reverb is detected. */
   us_infobit = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

   if(gs_RxSubStateCnt < R_C_MSG1_PRFX_LEN_BIS)
   {
           gul_Preamble_CMSG1|=(us_infobit<<gs_RxSubStateCnt);
   }
   else
   {
      if(gs_RxSubStateCnt < (R_C_MSG1_PRFX_LEN_BIS+s_R_C_MSG1_NUM_BITS_BIS))
      {
         /*  put infobit into message */
         i = (gs_RxSubStateCnt-R_C_MSG1_PRFX_LEN_BIS);
         s_bitpos = i & 0x7;
         s_index = i >> 3;

         guca_R_C_Msgs1_bis[s_index] |=  (us_infobit << s_bitpos);

         /*  update CRC count */
         CalcCRC16(&gus_RC_CRC_computed, us_infobit);
      }
      else if(gs_RxSubStateCnt >= (R_C_MSG1_PRFX_LEN_BIS+s_R_C_MSG1_NUM_BITS_BIS))
      {

         /* Now receiving crc */
         /* build received RC_CRC1 */
         gus_RC_CRC_received |=  (us_infobit << gs_RxCrcSubstateCnt);

         /*  compare CRC's when all bits received */
         gs_RxCrcSubstateCnt++;
         if (gs_RxCrcSubstateCnt == R_C_CRC1_LEN_BIS)
         {
#ifdef DEBUG_TRACES // XDSLRTFW-597
            LogMessages(4,NOT_END_OF_MSG,(uint16)C_MSG1_MSG,4, (uint8 *)(void *)(&gul_Preamble_CMSG1), DEBUG_BUFFER_DELIMITER_ADSL);
            LogMessageSegments(NOT_END_OF_MSG,(uint16)(s_R_C_MSG1_NUM_BITS_BIS>>3),(uint8 *)(guca_R_C_Msgs1_bis), DEBUG_BUFFER_DELIMITER_ADSL);
            LogMessageSegments(END_OF_THE_MSG,(uint16)2,(uint8 *)(void *)(&gus_RC_CRC_received), DEBUG_BUFFER_DELIMITER_ADSL);
#endif
#ifdef DEBUG_STREAMING
            DSH_SendStream(DSH_C_MSG1,(uint16)(s_R_C_MSG1_NUM_BITS_BIS>>3),&guca_R_C_Msgs1_bis[0]);
#endif

            /* ============================================================ */
            /* If received CRC equals to the computed CRC */
            /* ============================================================ */
            if ( gus_RC_CRC_received == gus_RC_CRC_computed )
            {
               /* Decode C_MSG1 msg. */
               s_err = DecodCMsg1_BIS();

               if(s_err == NO_DECODE_ERROR_BIS)
               {
                  /*  Set the flag to indicate C_MSG1 has been correctly received */
                  gft_RCExch1RcvFlag = RECEIVE_OK1;
                  gs_RxNextState = R_C_REVERB5_RX_BIS;
                  gpF_RxStateFunc = (PtrToFunc)RCReverb5RxF_BIS;
//SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (START)
#ifndef ISDN
                  if( (gs_CurrentCoChipset == GSI_CO_CHIPSET) &&        // if CO is CNXT
                      (gs_CurrentCoVendorID == 0x10 )         &&        // CNXT FW version
                      (gt_INFX_CMV.us_OperatorSpBits2 & CMV_TO_ENABLE_CNXT_US_RateImprovement) &&  // IOP cmv bit 0x2000 of INFO 103 20 enabled
                      (gl_SelectedMode & (MODE_G992_5)))
                  {
                     // check if The Target margin and fix flag match. fix should be enabled when Target margin>=10dB.
                     if( ((gs_RxDesiredMargin <  0xA00) &&  (gft_USPerf_Intracom_Gspn==1))   ||
                       ((gs_RxDesiredMargin >= 0xA00) &&  (gft_USPerf_Intracom_Gspn!=1)) )
                     {
                        gft_USPerf_Intracom_Gspn = 1 - gft_USPerf_Intracom_Gspn; //toggle flag
                        gs_RxNextState = FAIL_RX;
                        gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
                        /* Set exception handler variables */
                        gus_ExceptionState = gs_RxState;
                        gus_ExceptionCode = E_CODE_RCMsg1_Bis_CNXT_USPerfFixFlagError;
                     }
                  }
                  else
                  {
                     if(gft_USPerf_Intracom_Gspn) // If the flag accidentally has a non zero value
                     {
                        gft_USPerf_Intracom_Gspn = 0x0; //reset flag
                        gs_RxNextState = FAIL_RX;      // retrain because false operations have been done.
                        gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
                        /* Set exception handler variables */
                        gus_ExceptionState = gs_RxState;
                        gus_ExceptionCode = E_CODE_RCMsg1_Bis_CNXT_USPerfFixFlagError;
                     }
                  }
                  //SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (END)
                                                //XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove (START)
//XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining (Start)
// TSSI can be changed during HS phase  (to save time to showtime)
#if 0
                  if( (gs_CurrentCoChipset == GSI_CO_CHIPSET)            && // if CO is CNXT
                      (gs_CurrentCoVendorID == 0x10 )                    && // CNXT FW version
                      (gt_INFX_CMV.us_OperatorSpBits4 & CMV_TO_ENABLE_CNXT_Midloop_USPerf))
                  {
                     // gl_SelectedMode = MODE_G992_3 (0x4)| ANNEX_L ((20) <<16) , i.e. Selected mode is Annex G.992.3.L
                     if ((gft_USPerf_Gspn != 1) && ((gl_SelectedMode & (ANNEX_L)) != ANNEX_L)) //XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (START_END)
                     {
                        gft_USPerf_Gspn = 1; //XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (START_END)
                        gs_RxNextState = FAIL_RX;
                        gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
                        /* Set exception handler variables */
                        gus_ExceptionState = gs_RxState;
                        gus_ExceptionCode = E_CODE_RCMsg1_Bis_CNXT_USPerfMidLoopTSSI;
                     }
                  }
                  //XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove (END)
                  //}
                  else
                  {
                     if (gft_USPerf_Gspn) //XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (START_END)
                     {
                        gft_USPerf_Gspn = 0x0; //XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (START_END)
                        gs_RxNextState = FAIL_RX;      // retrain because false operations have been done.
                        gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
                        /* Set exception handler variables */
                        gus_ExceptionState = gs_RxState;
                        gus_ExceptionCode = E_CODE_RCMsg1_Bis_CNXT_USPerfMidLoopTSSI;
                     }
                  }
                  //ADSLRTFW-1348 IOP_A_US_Plus_CNXT_ShortloopUSLATNAdjustment (START_END)

#endif
#endif
               } // end: if(s_err == NO_DECODE_ERROR_BIS)
               else
               {
                  gs_RxNextState = FAIL_RX;
                  gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

                  /* Set exception handler variables */
                  gus_ExceptionState  = gs_RxState;
                  gus_ExceptionCode   = E_CODE_RCMsg1_Bis_MAX_BITS_PER_TONE_ERROR;
               }
            } // end: if ( gus_RC_CRC_received == gus_RC_CRC_computed )
            else
            {
               /* ============================================================ */
               /*  CRC's don't match:  go to FAIL state */
               /* ============================================================ */
               gft_RCExch1RcvFlag = NOT_RECEIVE;
               gs_RxNextState = FAIL_RX;
               gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

               /* Set exception handler variables */
               gus_ExceptionState      = gs_RxState;
               gus_ExceptionCode       = E_CODE_RCMsg1_Bis_CRC_MISMATCH_ERR;
               // XDSLRTFW-1843(Start)
               if((((guca_fe_G9941_VendorID[6] << 8) | (guca_fe_G9941_VendorID[7])) == (0X71B3))&& (gs_CurrentCoChipset == IFTN_CO_CHIPSET))
               {
                  guc_IFTN_CRC_MISMATCH_ERR_cnt++;
                  guc_Forced_Retrain       = 10;
               }
               // XDSLRTFW-1843(End)
            }
         }
      } /* else if(gs_RxSubStateCnt > (R_C_MSG1_PRFX_LEN+R_C_MSG1_NUM_BITS)) */
   } /* if(gs_RxSubStateCnt >= R_C_MSG1_PRFX_LEN) */
   gs_RxSubStateCnt++;
}
