/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCMsg2RxF_bis.c
 *
 *   Only the following states are covered in this file:
 *   RX: R_C_MSG2_RX_BIS
 *
 *------------------------------------------------------------------------
 */

 // ****************************************************************************************************
//  RCMsg2RxF_bis.c
// History :
//  27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx(C-MSG2)
//                   training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
//****************************************************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "rx_ops.h"
#include "crc16.h"
#include "detect.h"
#include "const_bis.h"
#include "rinfo_bis.h"
#include "tx_ops_bis.h"
#include "fifo.h"
#include "states.h"
#include "RCReverb7RxF_BIS.h"
#include "RCReverb6RxF_BIS.h"
#include "DebugBuffer.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCMsg2RxF_BIS
 *
 *  Description: Receives messages encoded as one symbol of C_Reverb as a 1 bit
 *  and one symbol of C_Segue as a 0 bit.  These messages include:
 *      MESSAGE         STORAGE LOCATION
 *      C_Msgs2         guca_R_C_Msgs2_bis[];
 *
 *  Prototype: void RCMsg2RxF_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gus_RC_CRC_computed   - (O) R_C_CRC1 computed over recevied message
 *      guca_R_C_Msgs2_bis[]  - (O) received R_C_MSGS2 message
 *      gusa_PN512Tab[]     - (I) packed PRD sequence
 *      gsa_RxToneBuf[]     - (O) output of FFT
 *      gl_RxSymbolCount    - (I) number of symbol periods in current state
 *      gs_RxNextState      - (O) RX state beginning next symbol period
 *    gs_RxState        - (I) current RX state
 *    gs_RxSubStateCnt  - (I/O) substate count
 *
 *  Notes: implements states R_C_MSG2_RX_BIS.
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RCMsg2RxF_BIS(void) {

   uint16  us_infobit;
   int16   s_bitpos, s_index, i, s_R_C_MSG2_NUM_BYTES_BIS;

   if (gl_RxSymbolCount == 0) {

      s_R_C_MSG2_NUM_BYTES_BIS = (gs_TxNumTones>>3);
      for(i=0; i<s_R_C_MSG2_NUM_BYTES_BIS; i++)
         guca_R_C_Msgs2_bis[i] = 0;

      gus_RC_CRC_computed = 0x0000;
      gus_RC_CRC_received =  0x0000;

      gs_RxSubStateCnt = 0;
      gs_RxCrcSubstateCnt = 0;
      gs_NSC_RParams = 0; /* number of tones to use in R_PARAMS state */
   }

      /*  get infobit */
      us_infobit = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

      if(gs_RxSubStateCnt < gs_TxNumTones)
      {
            if(us_infobit == 1)
         {
            guca_Tones_RParams[gs_NSC_RParams] = (uint8)gs_RxSubStateCnt;
            gs_NSC_RParams++;
         }

         /*  put infobit into message */
         s_bitpos = gs_RxSubStateCnt & 0x7;
         s_index = gs_RxSubStateCnt >> 3;

         guca_R_C_Msgs2_bis[s_index] |=  (us_infobit << s_bitpos);

         /*  update CRC count */
         CalcCRC16(&gus_RC_CRC_computed, us_infobit);
      }
      else if(gs_RxSubStateCnt >=  gs_TxNumTones)
      {

         /* Now receiving crc */
         /* build received RC_CRC1 */
         gus_RC_CRC_received |=  (us_infobit << gs_RxCrcSubstateCnt);

         /*  compare CRC's when all bits received */
         gs_RxCrcSubstateCnt++;
         if (gs_RxCrcSubstateCnt == R_C_CRC1_LEN_BIS)
         {
#ifdef DEBUG_TRACES // XDSLRTFW-597
            LogMessages(4,NOT_END_OF_MSG,(uint16)C_MSG2_MSG, (uint16)(gs_TxNumTones>>3), (uint8 *)guca_R_C_Msgs2_bis, DEBUG_BUFFER_DELIMITER_ADSL);
            LogMessageSegments(END_OF_THE_MSG,(uint16)2,(uint8 *)(void *)(&gus_RC_CRC_received), DEBUG_BUFFER_DELIMITER_ADSL);
#endif
#ifdef DEBUG_STREAMING
            DSH_SendStream(DSH_C_MSG2,(uint16)(gs_TxNumTones>>3),&guca_R_C_Msgs2_bis[0]);
#endif

            /* ============================================================ */
            /* If received CRC equals to the computed CRC */
            /* ============================================================ */
            if ( gus_RC_CRC_received == gus_RC_CRC_computed )
            {
               /* Call the background task to pack C_Params messages */
               /* We assume that this background task can be finished before */
               /* TX state enters R_PARAMS_TX_BIS, that is, it should be done  */
               /* within (272-48+80+10) frames in the worst case */
                  guc_FormRParamsState = TRAINING_IN_PROGRESS;
               AddFunctionToBkgdFifo((PtrToBkgdFunc)BgFormRParams);

               if (gft_SkipCparams == TRUE) {
                  gs_RxNextState = R_C_REVERB7_RX_BIS;
                  gpF_RxStateFunc = (PtrToFunc)RCReverb7RxF_BIS;
               }
               else {
                  gs_RxNextState = R_C_REVERB6_RX_BIS;
                  gpF_RxStateFunc = (PtrToFunc)RCReverb6RxF_BIS;
               }
            }
            else
            {
               /* ============================================================ */
               /*  CRC's don't match:  go to FAIL state */
               /* ============================================================ */
               gs_RxNextState = FAIL_RX;
               gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

               /* Set exception handler variables */
               gus_ExceptionState   = gs_RxState;
               gus_ExceptionCode = E_CODE_RCCRC1Rx_Bis_C_MSG2_DECOD_ERR;
            }
         }

      }


   gs_RxSubStateCnt++;
}
