/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
*
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
* TELEPHONE:        (781) 276-4000
* FAX:              (781) 276-4001
* WEB:              http://www.aware.com
*
* FILE:             RCMsgFmtRxF_BIS.c
* DESCRIPTION:      Implements the RX state function for the C-MSG-FMT state
*                   and the C-MSG-PCB state in G.dmt.bis.
*
**********************************************************************/
// ******************************************************************
// RCMsgFmtRxF_BIS.c
//
// History
//
// 09/08/2010 Nihar: At present in the CPE FW, if the CO request the US blackout tones above bin #31,
//             it will not blackout the requested bins . It is because CPE FW copy only 4 bytes
//             (that means only 32 bits)  from the array guca_RCMsgPCBTab(packed C-MSG-PCB message received
//             from ATU-C) to gp_BlackoutBits_US( US BlackoutBits array in CPE). This is perfectly fine in
//             case of annex A , but  not for Annex B and Annex M where the US is up Tone #63.Modified the
//             code to handle the US blackout bins based annex A,B,I,J,M
//             Grep for IOP_AB_DS_BisPlus_ALL_USblackoutbits
//
// 06/05/2012 Vinjam: Added code changes to extract the Transmitter referred downstream
//            virtual noise break points.
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 06/05/2012 Vinjam: Increased the "C-MSG_PCB" state length to consider the
//           virtual noise break points in LDM (DELT) mode.
//          Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx(C-MSG-FMT and C-MSG-PCB)
//                   training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
// **************************************************************************************************
#include <string.h>
#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "DetectComb.h"
#include "const_bis.h"
#include "crc16.h"
#include "rinfo_bis.h"
#include "states.h"
#include "RCQuiet4RxF_BIS.h"
#include "fifo.h"
#include "cmv.h"
#include "pll.h"
#include "DebugBuffer.h"

/**********************************************************************
* Function: RCMsgFmtRxF_BIS
*
* Description: Implements the states R_C_MSG_FMT_RX_BIS and
*              R_C_MSG_PCB_RX_BIS.
**********************************************************************/

void RCMsgFmtRxF_BIS(void)
{
    int16 s_detection_result, s_bytelocation, s_temp;
    uint16 us_infobit, us_mod_symb_per_byte;
    int16  s_R_C_MSG_PCB_LenBlackout;
   uint16 us_NumberOf_DS_VN_BreakPoints; //XDSLRTFW-438 XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise

    if (gl_RxSymbolCount == 0)
    {
        gs_TrainCnt = 0;

        if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
        // In normal mode, each bit in C_MSG_PCB is modulated by 3 symbols
        us_mod_symb_per_byte = 3*8;
        else
        // In Diag mode, each bit in C_MSG_PCB is modulated by 8 symbols
        us_mod_symb_per_byte = 8*8;

        if(gs_RxState == R_C_MSG_FMT_RX_BIS)
        {
            gt_StateMachCntrl.puc_RXmessage = guca_RCMsgFMTTab;
            gt_StateMachCntrl.s_RXFollowingState = R_C_MSG_PCB_RX_BIS;
            gt_StateMachCntrl.pF_RxFollowingState = (PtrToFunc)RCMsgFmtRxF_BIS;

            if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
            gt_StateMachCntrl.l_RXCurrentStateLen = R_C_MSG_FMT_RX_LEN_BIS - 1;
            else
            gt_StateMachCntrl.l_RXCurrentStateLen = R_C_MSG_FMT_RX_LEN_BIS_DIAG - 1;

            gs_Num_MsgBytes = 2;
        }
        else      // if(gs_RxState == R_C_MSG_PCB_RX_BIS)
        {
            gt_StateMachCntrl.puc_RXmessage = guca_RCMsgPCBTab;
            gt_StateMachCntrl.s_RXFollowingState = R_C_QUIET4_RX_BIS;
            gt_StateMachCntrl.pF_RxFollowingState = (PtrToFunc)RCQuiet4RxF_BIS;

            //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START_END)
         us_NumberOf_DS_VN_BreakPoints = gt_DS_RefVirtNoiseLevel_ADSL2.us_NumberOfTones;

            if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
            {
                if(gt_RCMsgFmt_bis.us_FMT_C_MSG_PCB == 0)
                {
               //XDSLRTFW-438  SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
               if(us_NumberOf_DS_VN_BreakPoints == 0) //No DS Virtual noise break points
               {
                     gt_StateMachCntrl.l_RXCurrentStateLen =
                        R_C_MSG_PCB_RX_LEN1_BIS - 1;
                     gs_Num_MsgBytes =
                        ((int16) (R_C_MSG_PCB_RX_LEN1_BIS) -
                        (int16) (C_MSGFMT_CRC_NUM_OF_SYMBOLS)) /
                        us_mod_symb_per_byte;
               }
               else //Downstream Virtual Noise break points are present in C-MSG-PCB
               {
                     gt_StateMachCntrl.l_RXCurrentStateLen =
                        R_C_MSG_PCB_RX_LEN1_BIS + (72*us_NumberOf_DS_VN_BreakPoints) - 1;
                     gs_Num_MsgBytes =
                        (((int16) (R_C_MSG_PCB_RX_LEN1_BIS) + (72*us_NumberOf_DS_VN_BreakPoints)) -
                        (int16) (C_MSGFMT_CRC_NUM_OF_SYMBOLS)) /
                        us_mod_symb_per_byte;
               }
               //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)
               }
               else
               {
                    // IOP_AB_DS_BisPlus_ALL_USblackoutbits (START)
                    //16(Msg bits) + 32(blackout) + 16(CRC)=64*3 = 192 (ANNEX_A | ANNEX_L | ANNEX_I)
                    //16(Msg bits) + 64(blackout) + 16(CRC)=96*3 = 288 (ANNEX_B | ANNEX_J | ANNEX_M)
                    s_R_C_MSG_PCB_LenBlackout = (32 + gs_TxNumTones) * 3;
                  //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
               if(us_NumberOf_DS_VN_BreakPoints == 0) //No DS Virtual noise break points
               {
                     gt_StateMachCntrl.l_RXCurrentStateLen =
                        s_R_C_MSG_PCB_LenBlackout - 1;
                     gs_Num_MsgBytes =
                        ((int16) (s_R_C_MSG_PCB_LenBlackout) -
                        (int16) (C_MSGFMT_CRC_NUM_OF_SYMBOLS)) /
                        us_mod_symb_per_byte;
               }
               else //Downstream Virtual Noise break points are present in C-MSG-PCB
               {
                     gt_StateMachCntrl.l_RXCurrentStateLen =
                        s_R_C_MSG_PCB_LenBlackout + (72*us_NumberOf_DS_VN_BreakPoints) - 1;
                     gs_Num_MsgBytes =
                        (((int16) (s_R_C_MSG_PCB_LenBlackout) + (72*us_NumberOf_DS_VN_BreakPoints)) -
                        (int16) (C_MSGFMT_CRC_NUM_OF_SYMBOLS)) /
                        us_mod_symb_per_byte;
               }
               //SMS00859763 IOP_AB_DS_BisPlus_ALL_USblackoutbits (END)
               //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)
               }
            }
             else  /* (STATArray[STAT_MacroState] == STAT_LoopDiagMode)  */
             {
               //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
               if((gs_DSL_FeaturesControl & DSL_Enable_DS_VirtualNoise) == DSL_Enable_DS_VirtualNoise)
               {
                  gt_StateMachCntrl.l_RXCurrentStateLen = 384 + (192 * us_NumberOf_DS_VN_BreakPoints)
                                                               + (8 * gs_TxNumTones) - 1;
               }
               else  //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)
               {
                  gt_StateMachCntrl.l_RXCurrentStateLen = 384 + 8 * gs_TxNumTones - 1;
               }
               gs_Num_MsgBytes = ((int16) (gt_StateMachCntrl.l_RXCurrentStateLen + 1) -
                                    (int16) (C_MSGFMT_CRC_NUM_OF_SYMBOLS_DIAG)) / us_mod_symb_per_byte;
            }
         }

          gs_C_PCB_Frame_Len = gs_Num_MsgBytes;

         // initialize the msg buffer before decoding
         memset(gt_StateMachCntrl.puc_RXmessage, 0,
               (gt_StateMachCntrl.l_RXCurrentStateLen / us_mod_symb_per_byte));

         gus_RC_CRC_computed = 0x0000;
    }

    if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
      s_temp = (int16)(gl_RxSymbolCount % 3);
    else
      s_temp = (int16)(gl_RxSymbolCount % 8);

    if(s_temp == 0)     // Clear counters in the beginning of a 3-frame or 8-frame period
    {
        gs_COMB_counter = 0;
        gs_ICOMB_counter = 0;

        gs_TrainCnt++; /* This variable contains the number of received message bits. */
        gft_EnablePLL = TRUE;
    }
    else if((s_temp == 1) && (STATArray[STAT_MacroState] != STAT_LoopDiagMode))
      gft_EnablePLL = FALSE;
    else if((s_temp == 6) && (STATArray[STAT_MacroState] == STAT_LoopDiagMode))
      gft_EnablePLL = FALSE;

    s_detection_result = DetectComb(gsa_RxRepFrameAlignBuf, 0);

    if(s_detection_result == C_COMB_DETECTED)
      gs_COMB_counter++;         // This frame looks like a C-COMB symbol
    else
    {
        if(s_detection_result == C_ICOMB_DETECTED)
        gs_ICOMB_counter++;      // This frame looks like a C-ICOMB symbol
    }

    if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
    {
        if(s_temp == 2)
        {
            // 3 frames have been detected
            // Use majority vote to decide whether the signal is C-COMB or C-ICOMB

            s_bytelocation = gs_RxSubStateCnt >> 3;      // gs_RxSubStateCnt is used as a bit index

            if(gs_COMB_counter >= gs_ICOMB_counter)      // Choose C-COMB when there is a tie
            us_infobit = 0;         // Message bit is 0 if C-COMB is received
            else
            us_infobit = 1;         // Message bit is 1 if C-ICOMB is received

            gt_StateMachCntrl.puc_RXmessage[s_bytelocation] |= us_infobit << (gs_RxSubStateCnt & 0x07);

            if(s_bytelocation < gs_Num_MsgBytes)      // Calculate CRC for the C-MSG-FMT or C-MSG-PCB message
            CalcCRC16(&gus_RC_CRC_computed, us_infobit);

            gs_RxSubStateCnt++;
        }
    }
    else  //if(STATArray[STAT_MacroState] == STAT_LoopDiagMode)
    {
        if(s_temp == 7)
        {
            /* 8 frames have been detected. If 4 and more frames are decoded as Comb signal, */
            /* then 0 is considered as the transmitted bit. */

            s_bytelocation = gs_RxSubStateCnt >> 3;      // gs_RxSubStateCnt is used as a bit index

            if(gs_COMB_counter >= gs_ICOMB_counter)   // Choose C-COMB when there is a tie
            us_infobit = 0;         // Message bit is 0 if C-COMB is received
            else
            us_infobit = 1;         // Message bit is 1 if C-ICOMB is received

            gt_StateMachCntrl.puc_RXmessage[s_bytelocation] |= us_infobit << (gs_RxSubStateCnt & 0x07);

            if(s_bytelocation < gs_Num_MsgBytes)      // Calculate CRC for the C-MSG-FMT or C-MSG-PCB message
            CalcCRC16(&gus_RC_CRC_computed, us_infobit);

            gs_RxSubStateCnt++;
        }
    }

    if(gl_RxSymbolCount == gt_StateMachCntrl.l_RXCurrentStateLen)
    {
        gs_TrainCnt = gs_TrainCnt>>3; /* After this righshift operation, gs_TrainCnt contains the number of received bytes */

        // Just received last bit of message.  Check the CRC.
        gus_RC_CRC_received = gt_StateMachCntrl.puc_RXmessage[gs_TrainCnt-1];
        gus_RC_CRC_received <<= 8;
        gus_RC_CRC_received |= gt_StateMachCntrl.puc_RXmessage[gs_TrainCnt-2];

        if(gus_RC_CRC_received == gus_RC_CRC_computed)   // Check CRC
        {
            if(gs_RxState == R_C_MSG_FMT_RX_BIS)
            {
#ifdef DEBUG_TRACES // XDSLRTFW-597
               LogMessages(4,END_OF_THE_MSG,(uint16)C_MSG_FMT_MSG, (uint16)gs_TrainCnt, (uint8 *)guca_RCMsgFMTTab, DEBUG_BUFFER_DELIMITER_ADSL);
#endif

#ifdef DEBUG_STREAMING
               DSH_SendStream(DSH_C_MSG_FMT,(uint16)gs_TrainCnt,&guca_RCMsgFMTTab[0]);
#endif

               DecodCMsgFmt_BIS();
            }
            else
            {
#ifdef DEBUG_TRACES // XDSLRTFW-597
               LogMessages(4,END_OF_THE_MSG,(uint16)C_MSG_PCB_MSG, (uint16)gs_TrainCnt, (uint8 *)guca_RCMsgPCBTab, DEBUG_BUFFER_DELIMITER_ADSL);
#endif
#ifdef DEBUG_STREAMING
               DSH_SendStream(DSH_C_MSG_PCB,(uint16)gs_TrainCnt,&guca_RCMsgPCBTab[0]);
#endif
                DecodCMsgPcb_BIS();

                // Signal Tx state machine to transition from R-Quiet3 to R-Comb3 for non-diagnostics mode.
                gft_BIS_TX_transition = TRUE;
                // We have finished decoding C_MSG_PCB and now we kick off a task that
                // generates the R-Reverb signal that will be used during Transceiver Training.
                // This background task needs to complete by the time the Tx state machine
                // reaches R-Reverb1.
                guc_BkgdTaskState = BKGDTASK_WAITING;
                AddFunctionToBkgdFifo((PtrToBkgdFunc)BgGenRReverb_XcvrTrain);
            }
            gs_RxNextState = gt_StateMachCntrl.s_RXFollowingState;
            gpF_RxStateFunc = (PtrToFunc)gt_StateMachCntrl.pF_RxFollowingState;
        }
        else
        {
            // CRC Error
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* Set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_RCMsgFmtRx_Bis_DECOD_ERR;
        }
    }
}
