/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
*
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
* TELEPHONE:        (781) 276-4000
* FAX:              (781) 276-4001
* WEB:              http://www.aware.com
*
* FILE:             RCMsgLDRxF_BIS.c
* DESCRIPTION:      Implements the RX state function for the state
*                   C-MSGx-LD state in diagnostics mode.
*
**********************************************************************/
#include <string.h>
#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "gdata_bis_diag.h"
#include "const_bis.h"
#include "crc16.h"
#include "states.h"
#include "RCTref3LDRxF_bis.h"
#include "detect.h"
#include "rt_tones.h"

/**********************************************************************
* Function: RCMsgLDRxF_BIS
*
* Description: Implements the state R_C_MSG_LD_RX_BIS.
**********************************************************************/

#define R_C_MSG_LD_RX_BIS_SEQ_NUM         0
#define R_C_MSG_LD_RX_BIS_MESSAGE         1
#define R_C_MSG_LD_RX_BIS_CRC          2
#define R_C_MSG_LD_RX_BIS_IGNORE_MESSAGE  3

#define RX_SEQ_NUM_BYTES               (2)
#define NUM_REVERBS_PER_MSG_BYTES         (8*8)

void RCMsgLDRxF_BIS(void)
{
   int16 s_ToneType;
   int16 s_bytelocation, s_temp;
   uint16 us_infobit = 0;

   if (gl_RxSymbolCount == 0)
   {
      gs_RxSubStateCnt = 0;
      gft_RCExch1RcvFlag = NOT_RECEIVE;
      gt_StateMachCntrl.s_RXFollowingState = R_C_TREF3_LD_RX_BIS;
      gt_StateMachCntrl.pF_RxFollowingState = (PtrToFunc)RCTref3LDRxF_BIS;
      gus_RC_CRC_computed = 0x0000;

      // Initialization
      guc_msg_seq_num = 0;
   }

    s_temp = (int16)(gl_RxSymbolCount % 8);
   if(s_temp == 0)      /* Clear counters at the beginning of a  8-frame period */
   guc_Reverb_Counter = 0;

   s_ToneType = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

   if (s_ToneType == C_REVERB)
      guc_Reverb_Counter++;

   if(s_temp == 7)
   {
      /* 8 frames have been received. If 4 or more frames are decoded as REVERB signal, */
      /* then 0 is considered as the transmitted bit. */
   if(guc_Reverb_Counter > 3) // Choose C-REVERB when there is a tie
      us_infobit = 0;         // Message bit is 0 if C-REVERB is received
   else
      us_infobit = 1;
   }


    switch (gs_RxSubState)
   {
   case R_C_MSG_LD_RX_BIS_SEQ_NUM:
      if(s_temp  == 7)
      {
         /* The sequence number will be received within the first 64 frames */
         if(gl_RxSymbolCount < 64)
            guc_msg_seq_num |= us_infobit << (gs_RxSubStateCnt & 0x07);

         gs_RxSubStateCnt++;
         CalcCRC16(&gus_RC_CRC_computed, us_infobit);
      }


      if(gl_RxSymbolCount == 127)
      {
         guc_msg_seq_num = (guc_msg_seq_num & 0xF);
         if(guc_msg_seq_num == 1)
         {
            gt_StateMachCntrl.puc_RXmessage = gpuca_R_C_MSG1_LD;
         gt_StateMachCntrl.l_RXCurrentStateLen = 16*NUM_REVERBS_PER_MSG_BYTES + R_C_CRC_LEN_LD - 1;
         }
         else if(guc_msg_seq_num == 2)
         {
            gt_StateMachCntrl.puc_RXmessage = gpuca_R_C_MSG2_LD;
         gt_StateMachCntrl.l_RXCurrentStateLen = (RX_SEQ_NUM_BYTES+4*gs_TxNumTones)*NUM_REVERBS_PER_MSG_BYTES + R_C_CRC_LEN_LD  - 1;
         }
         else if(guc_msg_seq_num == 3)
         {
            gt_StateMachCntrl.puc_RXmessage = gpuca_R_C_MSG3_LD;
         gt_StateMachCntrl.l_RXCurrentStateLen = (RX_SEQ_NUM_BYTES+2*gs_TxNumTones)*NUM_REVERBS_PER_MSG_BYTES + R_C_CRC_LEN_LD  - 1;;
         }
         else if(guc_msg_seq_num == 4)
         {
            gt_StateMachCntrl.puc_RXmessage = gpuca_R_C_MSG4_LD;
         gt_StateMachCntrl.l_RXCurrentStateLen = (RX_SEQ_NUM_BYTES+gs_TxNumTones)*NUM_REVERBS_PER_MSG_BYTES + R_C_CRC_LEN_LD  - 1;;
         }
         else if(guc_msg_seq_num == 5)
         {
            gt_StateMachCntrl.puc_RXmessage = gpuca_R_C_MSG5_LD;
         gt_StateMachCntrl.l_RXCurrentStateLen = (RX_SEQ_NUM_BYTES+gs_TxNumTones)*NUM_REVERBS_PER_MSG_BYTES + R_C_CRC_LEN_LD  - 1;;
         }

         /* recieve new message */
         if(guc_msg_ld_idx_ds == guc_msg_seq_num)
         {
            // Initialize memory
            memset(gt_StateMachCntrl.puc_RXmessage, 0, sizeof(uint8)*((gt_StateMachCntrl.l_RXCurrentStateLen+1)>>6));
            gs_RxSubState = R_C_MSG_LD_RX_BIS_MESSAGE;
         }
         /* Possibly last ACK did not get through successfully, ignore this message and send R-ACK */
         else if((int16)(guc_msg_ld_idx_ds-1) == (int16)guc_msg_seq_num)
         {
            gft_RCExch1RcvFlag = RECEIVE_OK1; /* This flag will be used at TX side to determine whether R-ACK or R-NACK should be sent out to CO */
            gs_RxSubState = R_C_MSG_LD_RX_BIS_IGNORE_MESSAGE;
         }
         /* Based on sequence number, CO and RT are totally out of sync, goto fail state */
         else
         {
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* Set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_RCMsgLDRx_BIS_SyncLoss;
         }

         gs_RxSubStateCnt = 0;
      }
      break;

   case R_C_MSG_LD_RX_BIS_MESSAGE:
       if(s_temp == 7)
      {
      s_bytelocation = gs_RxSubStateCnt >> 3;      // gs_RxSubStateCnt is used as a bit index

      gt_StateMachCntrl.puc_RXmessage[s_bytelocation] |= us_infobit << (gs_RxSubStateCnt & 0x07);

      gs_RxSubStateCnt++;
       CalcCRC16(&gus_RC_CRC_computed, us_infobit);
      }

      /* Don't reset gs_RxSubStateCnt */
      if(gl_RxSymbolCount == gt_StateMachCntrl.l_RXCurrentStateLen - R_C_CRC_LEN_LD)
          gs_RxSubState = R_C_MSG_LD_RX_BIS_CRC;

      break;

   case R_C_MSG_LD_RX_BIS_CRC:
       if(s_temp == 7)
      {
      s_bytelocation = gs_RxSubStateCnt >> 3;      // gs_RxSubStateCnt is used as a bit index
      gt_StateMachCntrl.puc_RXmessage[s_bytelocation] |= us_infobit << (gs_RxSubStateCnt & 0x07); /* This array contains the received CRCs */

      gs_RxSubStateCnt++;
      }

      if(gl_RxSymbolCount == gt_StateMachCntrl.l_RXCurrentStateLen)
      {

      gs_TrainCnt = gs_RxSubStateCnt>>3; /* After this righshift operation, gs_TrainCnt contains the number of received bytes except sequence number and reserved bits */

      gus_RC_CRC_received = gt_StateMachCntrl.puc_RXmessage[gs_TrainCnt-1];
      gus_RC_CRC_received <<= 8;
      gus_RC_CRC_received |= gt_StateMachCntrl.puc_RXmessage[gs_TrainCnt-2];

      //Corrected type casting. Code changes added during XDSLRTFW-894 BugFix_US_BisPlus_ALL_LessUsRateLdm (Start)
      /* Populate array */
      gt_US_LDParam.s_Hlin_scale = (int16)(gpuca_R_C_MSG1_LD[1]<<8)+gpuca_R_C_MSG1_LD[0];
      gt_FarEndParam.us_LoopAttenuation = (uint16)(gpuca_R_C_MSG1_LD[3]<<8)+gpuca_R_C_MSG1_LD[2];
      gt_FarEndParam.us_SignalAttenuation = (uint16)(gpuca_R_C_MSG1_LD[5]<<8)+gpuca_R_C_MSG1_LD[4];
      gt_FarEndParam.s_SnrMargin = (int16)(gpuca_R_C_MSG1_LD[7]<<8)+gpuca_R_C_MSG1_LD[6];
      gt_FarEndParam.ul_AttainableDataRate = ((uint32)gpuca_R_C_MSG1_LD[11]<<24)+(gpuca_R_C_MSG1_LD[10]<<16)+(gpuca_R_C_MSG1_LD[9]<<8)+gpuca_R_C_MSG1_LD[8];
      gt_FarEndParam.s_ActualAggregateXmtPwr = (int16)(gpuca_R_C_MSG1_LD[13]<<8)+gpuca_R_C_MSG1_LD[12];
      //Corrected type casting. Code changes added during XDSLRTFW-894 BugFix_US_BisPlus_ALL_LessUsRateLdm (Start)

      /* Check if CRC matches */
      if(gus_RC_CRC_received == gus_RC_CRC_computed)
      {
      guc_msg_ld_idx_ds++;          // Increase the index
      gft_RCExch1RcvFlag = RECEIVE_OK1; /* This flag will be used at TX side to determine whether R-ACK or R-NACK should be sent out to CO */
      }
          gs_RxNextState = gt_StateMachCntrl.s_RXFollowingState;
      gpF_RxStateFunc = (PtrToFunc)gt_StateMachCntrl.pF_RxFollowingState;
      }

      break;

   case R_C_MSG_LD_RX_BIS_IGNORE_MESSAGE:

      if(gl_RxSymbolCount == gt_StateMachCntrl.l_RXCurrentStateLen)
      {
          gs_RxNextState = gt_StateMachCntrl.s_RXFollowingState;
      gpF_RxStateFunc = (PtrToFunc)gt_StateMachCntrl.pF_RxFollowingState;
      }
   break;
   }
}

#undef RX_SEQ_NUM_BYTES
#undef NUM_REVERBS_PER_MSG_BYTES

#undef R_C_MSG_LD_RX_BIS_SEQ_NUM
#undef R_C_MSG_LD_RX_BIS_MESSAGE
#undef R_C_MSG_LD_RX_BIS_CRC
#undef R_C_MSG_LD_RX_BIS_IGNORE_MESSAGE


