/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCParamsRxF_bis.c
 *
 *   Only the following states are covered in this file:
 *   RX: R_C_PARAMS_RX_BIS
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RCParamsRxF_bis.c
//
// History
//

// 15/03/2012 Kannan: 03/05/2010 Bhadra: Added changes as per G.INP standard (G.998.4) for Repeatetive
//                    C-PARAMS symbols.They are repeated (2 * INP_min_rein + 1) times.
//                    based on "CPARAMS_INP_FLAG"  bit in R-MSG1.
//                   ToBeDone:Each set of "guca_R_C_PARAMS_bis" will require
//                   (12+4*NSCus)+28+2 Bytes.So to receive (2*INP_min_REIN+1)times we
//                   may need "13*(170)=> 2210 (for NSCus =32)" bytes. Here INP_min_REIN
//                   max value is taken as 7. which is quite high.
//                   Proposal: Since each set of C-PARAMS also includes CRC.Have 2 sets of
//                   guca_R_C_PARAMS_bis, compute the CRC over provious set
//                   while receiving the the current set.If CRC matches then skip over
//                   rest of the symbols.
//                   Grep for FEATURE_BisPlus_ALL_CPARAMS_INP_FLAG_Modifications
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// ******************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "rx_ops.h"
#include "crc16.h"
#include "detect.h"
#include "const_bis.h"
#include "rinfo_bis.h"
#include "tx_ops_bis.h"
#include "fifo.h"
#include "states.h"
#include "RCReverb7RxF_BIS.h"
#include "cmv.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCParamsRxF_BIS
 *
 *  Description:
 *
 *  Prototype: void RCParamsRxF_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gus_RC_CRC_computed   -   (O) R_C_CRC1 computed over recevied message
 *      guca_R_C_PARAMS_bis[] - (O) decoded R_C_PARAMS message
 *      gsa_RxToneBuf[]     -   (O) output of FFT
 *      gl_RxSymbolCount    -   (I) number of symbol periods in current state
 *      gs_RxNextState      -   (O) RX state beginning next symbol period
 *    gs_RxState        -   (I) current RX state
 *    gs_RxSubStateCnt  -   (I/O) substate count
 *
 *  Notes: implements states R_C_PARAMS_RX_BIS.
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RCParamsRxF_BIS(void)
{
    int16 s_LEN_C_PARAMS_BITS;

      if(gl_RxSymbolCount == 0)
   {
      /* guca_R_C_PARAMS_bis is set to zero in InitGlobalVariables() */

      if (( gl_SelectedMode & (MODE_G992_5)  ))
         s_LEN_C_PARAMS_BITS = (((LEN_C_PARAMS_PMD_HEADER + 2 + 2*(gs_TxNumTones-1) + 2*(gs_TxNumTones-1)) + LEN_C_PARAMS_PMS + LEN_C_PARAMS_CRC))*8;
      else
         s_LEN_C_PARAMS_BITS = (((LEN_C_PARAMS_PMD_HEADER + 1 + 2*(gs_TxNumTones-1) + (gs_TxNumTones-1)) + LEN_C_PARAMS_PMS + LEN_C_PARAMS_CRC))*8;

      gs_C_Params_Frame_Len = s_LEN_C_PARAMS_BITS/(2*NSC_C_PARAMS);
      if((gs_C_Params_Frame_Len*2*NSC_C_PARAMS) < s_LEN_C_PARAMS_BITS)
      gs_C_Params_Frame_Len++;
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
      //FEATURE_BisPlus_ALL_CPARAMS_INP_FLAG_Modifications (Start)
      if((gt_ReTxConfigInfo.ft_ReTxOn == 1)&&(gt_ReTxConfigInfo.us_CPARAMS_INP_FLAG == 1))
         gs_C_Params_Frame_Complte_Len = gs_C_Params_Frame_Len *((gt_ReTxConfigInfo.us_INP_min_rein << 1) + 1);
      else
         gs_C_Params_Frame_Complte_Len =  gs_C_Params_Frame_Len;
      //FEATURE_BisPlus_ALL_CPARAMS_INP_FLAG_Modifications (End)
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
   }

   if(gl_RxSymbolCount < gs_C_Params_Frame_Len)
   {
      //Get current symbol
      RxParamsSig(gsa_RxToneBuf, (int16)gl_RxSymbolCount,
      &gus_RC_CRC_computed);
   }

   /* The following part should be moved to a BG task later */
   if(gl_RxSymbolCount == (gs_C_Params_Frame_Len-1))
   {
      gus_RC_CRC_computed = 0x0000;
      gus_RC_CRC_received = 0x0000;
      gul_RxDescrambleState = 0xFFFFFFFF;

      guc_CrcCalcState = TRAINING_IN_PROGRESS;
      /* We assume that this Background task can be finished when */
      /* the C-SEGUE4 signal is received, that is, it should be done      */
      /* within 128 frames in the worst case */
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgCrcComp);
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
      //FEATURE_BisPlus_ALL_CPARAMS_INP_FLAG_Modifications (Start)
      // Moved out side  if (gl_RxSymbolCount == (gs_C_Params_Frame_Len - 1))
      //gs_RxNextState = R_C_REVERB7_RX_BIS;
      //gpF_RxStateFunc = (PtrToFunc) RCReverb7RxF_BIS;
   }
   if (gl_RxSymbolCount == (gs_C_Params_Frame_Complte_Len - 1))
   {

      //FEATURE_BisPlus_ALL_CPARAMS_INP_FLAG_Modifications (End)
      gs_RxNextState = R_C_REVERB7_RX_BIS;
      gpF_RxStateFunc = (PtrToFunc) RCReverb7RxF_BIS;
   }
   //FEATURE_BisPlus_ALL_CPARAMS_INP_FLAG_Modifications (End)
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
}
