/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCPilot3Tref2RxF.c
 *
 *   State Function for states R-C-PILOT3 (DMT), R-C-TREF2 (Bis/Plus), and
 *   R-C-PILOT-FR3 (Lite).
 *
 *   Notes:
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RCPilot3Tref2RxF.c
//
// History
//
// 24/06/2011 Kannan: Added debug feature to measure the residual Echo on BT loops.
//                    It is disabled by default. It can be enabled using
//                    "VR9_DEC_TRAIN_DBG" defined ec_data.h
//                    Grep for XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA
//
// 23/08/2011 Kannan: DS Performance improvement in DEC training.
//    Increase of DEC length from 400 to 480 causes link drop
//      in showtime(Plus mode). Hence DEC adaptation is
//      disabled for plus mode till dec adaptation issue is resolved.
//      Grep for XDSLRTFW-251 PERF_DS_PlusBisDmt_ALL_DECTraining
//
// 15/09/2011 Kannan: DS Performance improvement in DEC training.
//    Increase of DEC length from 400 to 480 causes link drop
//      in showtime(Plus mode) due the MIPS contraints while downloading
//      the DEC & TDQ coefficients into the DEC adaptation memory in one symbol.
//      Hence downloading of DEC & TDQ coefficients into the DEC adaptation
//      RAM is spread across 3 symbols(Plus mode),
//      i.e 1symbol (TDQ coefficient) + 1 symbol(DEC_Phase_1) + 1symbol(DEC_Phase_0)
//      But in DMT/Bis mode DEC coefficient downloading is done in 2 symbols.
//      i.e 1symbol (TDQ coefficient) + 1 symbol(DEC_Phase_1).
//      Note: DEC Upsampling factor = 2 (Plus Mode),
//            DEC Upsampling factor = 1 (DMT/BIS Mode)
//      Grep for XDSLRTFW-251 PERF_DS_PlusBisDmt_ALL_DECTraining
//
// 10/10/2017 Abu Rahman
//            XDSLRTFW-3500 ADSL2/2+ mode Missing excpetion state in case of C-TREF2 timeout
//            Introduced two new exception codes. One exception code (E_CODE_TREF2_BIS_TIMEOUT) in case
//            of timeout in C-TREF2 Rx state in ADSL2/2+ mode and another exception
//            code (E_CODE_RCPILOT3_TIMEOUT) in case of timeout in C-PILOT3 Rx State
//            in DMT mode.
//            Grep for XDSLRTFW-3500
// ******************************************************************
#include "common.h"
#include "rt_state.h"
#include "dsp_op.h"
#include "tx_ops.h"
#include "pll.h"
#include "gdata.h"
#include "ec_init.h"
#include "DSLEngin.h"
#include "xrtstate.h"
#include "fifo.h"
#include "ec_data.h"
#include "accum32.h"
#include "cmv.h"
#include "memcopy.h"
#include "memsetbf.h"
#include <string.h>
#include "DecTrain_Data.h"
#include "DecTrain_b.h"
#include "engine_const.h"
#include "CalcDECPathDelay.h"
#include "states.h"
#include "RCReverb3RxF.h"
#include "RCReverb4RxF_BIS.h"
#include "RCReverbFR6RxF.h"
#include "noiseacc.h"
#include "ReverbSnr_b.h"
#include "snr.h"
#include "hndshk_Data.h"
#include "AFED_Functions.h"

//#ifdef DANUBE
#ifdef TARGET_HW
#include "dataswap.h"
#endif
#include "const.h"
//#endif

#define DEBUG_IO           /* turn off file write if DEBUG_IO is defined */
int16 gs_DEC_FIFO_DELAY=15;
// XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START)
#ifdef VR9_DEC_TRAIN_DBG
int16 gs_dbg_dec = 0;
int16 gs_dbg_dec_avg = 64; //No of of symbols to be averaged for dec train debugging
int16 gs_dbg_log2_dec_avg_symbols = 6;
int16 gs_dbg_DEC_TxSignal = 0;
int16 gs_dbg_deccnt = 0;
int16 gs_dbg_dec_signal = 1; //1 ==> Tx Medley; 2 ==> Tx REVERB
int16 gs_dbg_dec_output = 1; // 1 => enable DEC output; 0 => Mask DEC output
extern int16 gsa_RxDecTrainSilenceBuf[1024];
extern int16 gsa_RxDecTrainMedleyBuf[1024];
#endif //VR9_DEC_TRAIN_DBG
// XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (END)
/*^^^
*-------------------------------------------------------------------
########               ########
######## RX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCPilot3Tref2RxF
 *
 *  Description: This state should coincide with the R_ECT state.
 * Echo Canceller training is done in this state.
 * The following three steps are used to train the echo canceller:
 *
 * 1) Estimate pilot signal
 * 2) Compute average cross-correlation between TX and RX signal
 * 3) Compute the impulse response of the EC filter.
 *
 *  Prototype: void RCPilot3Tref2RxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gl_RxSymbolCount           - (I) count of symbols passed in current
 *                                     state
 *    gs_RxState                 - (I) current RX state
 *    gs_RxSubState              - (I/O) current RX substate
 *    gs_RxSubStateCnt           - (I/O) count of symbols passed in current
 *                                     substate
 *    gs_RxNextState             - (O) RX next state
 *    gus_ExceptionState            - (O) Exception state
 *    gus_ExceptionCode          - (O) Exception code
 *    gt_StateMachCntrl          - (I/O) state machine control variables
 *    gl_Rx_Total_Power          - (O) TX energy estimate
 *    gla_RxAccumBuf[]           - (I/O) accumulated X-correlation between
 *                                     TX and RX signal
 *    gsa_dec_state[]               - (I/O) DEC filter state buffer
 *    gsa_dec_h[]                - (O) mantissas of DEC filter coefficients
 *    gs_dec_h_exp               - (O) exponent of DEC filter coefficients
 *    guc_EcTrainingState        - (I/O) EC init. flag
 *
 *  Substates:
 *      R_C_PILOT3_RX_INITIALIZE     - Waits for the channel to stabilize, then
 *                                     initializes the various parameters used
 *                                     in echo canceller training.
 *      R_C_PILOT3_RX_ESTIMATE_PILOT - Computes an estimate of the pilot tone
 *                                     by averaging a pre-determined number of
 *                                     symbols (frames) in the time domain.
 *                                     During this averaging process, only the
 *                                     pilot tone should be transmitted from
 *                                     the ATU-C device, and the ATU-R device
 *                                     is silent.
 *    R_C_PILOT3_RX_DEC_PATH_DELAY - Receives a unit impulse sequence sent
 *                            through the DEC path so that the delay
 *                            between the Tx input and the Rx output
 *                            going through that path can be determined.
 *                            The observed delay is used to align the
 *                            Tx and Rx data for DEC training.
 *      R_C_PILOT3_RX_QUIET          - Waits until the DEC training signal starts
 *                            being transmitted.
 *      R_C_PILOT3_RX_ACCUM          - Averages adjacent pairs of frames of
 *                                     the received signal. During this time
 *                                     the ATU-C should only transmit the pilot
 *                            tone, and the ATU-R should transmit the
 *                                     DEC training signal.
 *      R_C_PILOT3_RX_DEC_TRAIN      - Substracts the estimate of the pilot tone
 *                            from the averaged received sequence.
 *                            Estimates the DEC impulse response and input
 *                            delay from the circular cross-correlation
 *                            of the received sequence with a sequence
 *                            related to the training sequence.
 *    R_C_PILOT3_RX_TRAINING_DONE   - Waits for the DEC training algorithm to
 *                            finish running in the background.
 *    R_C_PILOT3_RX_DEC_SETTLE   - Waits four frames and captures two echo
 *                            cancelled received frames (no averaging)
 *                            with the estimate of the pilot tone removed.
 *      R_C_PILOT3_RX_WAIT           - Waits until the end of the R_C_PILOT3_RX
 *                                     or R_C_PILOT_FR3_RX states.
 *
 *
 *  Notes: implements states R_C_PILOT3_RX, R_C_TREF2_RX_BIS, and R_C_PILOT_FR3_RX
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_PILOT3_RX_INITIALIZE     (0)
#define R_C_PILOT3_RX_DEC_PATH_DELAY (1)
#define R_C_PILOT3_RX_ESTIMATE_PILOT (2)
#define  R_C_PILOT3_RX_QUIET        (3)
#define R_C_PILOT3_RX_WAIT_TX        (4)
#define R_C_PILOT3_RX_ACCUM          (5)
#define R_C_PILOT3_RX_DEC_TRAIN      (6)
#define R_C_PILOT3_RX_TRAINING_DONE  (7)
#define R_C_PILOT3_RX_WAIT           (8)
#define R_C_PILOT3_RX_DEC_SETTLE    (9)
#define R_C_PILOT3_RX_NOISE_ACCUM    (10)
#define R_C_PILOT3_RX_SNR_CALC       (11)
// XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START)
#ifdef VR9_DEC_TRAIN_DBG
#define R_C_PILOT3_RX_ECHO_QUIET_ACCUM    (12)
#define R_C_PILOT3_RX_ECHO_MEDLEY_ACCUM   (13)
#endif //VR9_DEC_TRAIN_DBG
// XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (END)
int8 gft_DbgEcLoopBack=0;
void RCPilot3Tref2RxF(void)
{
   int16 i;
   static int16 s_dec_getptr, s_ref_symbolcount, s_dec_path_sdelay;

   /* Start counting when transmitter gives the signal. */
   if (gs_StartDECTraining == TRUE)
   {
      gs_RxDECTrainSymbolCount++;
   }

   switch (gs_RxSubState)
   {
      case R_C_PILOT3_RX_INITIALIZE:
         /* Init. State Machine Control */
         switch (gs_RxState)
         {
            case R_C_PILOT3_RX:
               gt_StateMachCntrl.l_RXCurrentStateLen = R_C_PILOT3_RX_LEN-1;
               gt_StateMachCntrl.s_RXFollowingState  = R_C_REVERB3_RX;
               gt_StateMachCntrl.pF_RxFollowingState = (PtrToFunc)RCReverb3RxF;
               break;

            case R_C_TREF2_RX_BIS:
               gt_StateMachCntrl.l_RXCurrentStateLen = R_C_TREF2_RX_LEN_BIS-1-(R_C_REVERB1_DET_CNT+1);
               gt_StateMachCntrl.s_RXFollowingState  = R_C_REVERB4_RX_BIS;
               gt_StateMachCntrl.pF_RxFollowingState = (PtrToFunc)RCReverb4RxF_BIS;
               break;

            case R_C_PILOT_FR3_RX:
               gt_StateMachCntrl.l_RXCurrentStateLen = R_C_PILOT_FR3_RX_LEN-1;
               gt_StateMachCntrl.s_RXFollowingState  = R_C_REVERB_FR6_RX;
               gt_StateMachCntrl.pF_RxFollowingState = (PtrToFunc)RCReverbFR6RxF;
               AddFunctionToFifo(gp_RxLoadingFunctionFifo,UnityTDQ);
               gft_EnablePLL = FALSE;
               break;
         }

         /* Initialize C-PILOT3 frame estimate buffer. */
         MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*gs_RxSamplesPerFrame));
         /* Reset the DEC training flag (initialized to TRUE in statein1.c). This */
         /* will also notify the TX side that the RX side is ready and waiting */
         /* for the ramp signal to be generated. */
         gs_StartDECTraining = FALSE;


         /* Initialize Rx training symbol counter */
         gs_RxDECTrainSymbolCount = -1;

         /* Go to next substate and wait there until TX side starts sending the ramp. */
         gs_RxSubState = R_C_PILOT3_RX_DEC_PATH_DELAY;
         break;

      case R_C_PILOT3_RX_DEC_PATH_DELAY:
         /* Determine delay through DEC path by receiving a unit impulse */
         /* sent by the transmitter at the beginning (first sample) of frame */
         /* 2 (gs_RxDECTrainSymbolCount = 2). The delay through the DEC path */
         /* is given by the offset of the received impulse relative to the */
         /* beginning of frame 2. Right now the receiver can detect delays */
         /* less than two frames long. */
         /* NOTE: There is a two frame delay through the transmitter */
         /* so that, for example, the signal transmitted during frame 2 is */
         /* the one loaded into gsa_TxToneBuf[] during frame 0. */
         if ((gs_RxDECTrainSymbolCount >= DEC_PATH_MIN_SYMBOL_DELAY) && (gs_RxDECTrainSymbolCount <= DEC_PATH_MAX_SYMBOL_DELAY))
         {
            // TODO: Raghu
                if (gft_DbgEcLoopBack)
               Pause(0x1234);
            if ((s_dec_path_sdelay = CalcDECPathDelay()) == -1)
            {
               s_dec_path_sdelay = 0;
            }
            else
            {

#ifdef ADSL_62
               gs_save_computed_decdelay = s_dec_path_sdelay;
               if ( (gs_DECUpsamplingFactor == 2) && (gft_V14 ==1))
               {
                  s_dec_path_sdelay = gs_RxSamplesPerFrame + gs_DEC_FIFO_DELAY - gus_SyncOffset;
                  if (s_dec_path_sdelay > gs_RxSamplesPerFrame) s_dec_path_sdelay -= gs_RxSamplesPerFrame;
                  if(gs_save_computed_decdelay + gus_SyncOffset ==1040) gft_interpdec_phase_align =1;
               }
               gs_dec_path_delay = s_dec_path_sdelay;
#endif

               s_ref_symbolcount = gs_RxDECTrainSymbolCount;
               /* Change substate. */
               gs_RxSubStateCnt = 0;
               gs_RxSubState = R_C_PILOT3_RX_ESTIMATE_PILOT;

               break;
            }
         }
         else if (gs_RxDECTrainSymbolCount > DEC_PATH_MAX_SYMBOL_DELAY)
         {
#ifdef VINAX_ADSL_AFE
            // For now, don't fail.
            s_dec_path_sdelay = 0;
            s_ref_symbolcount = gs_RxDECTrainSymbolCount;
            /* Change substate. */
            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_PILOT3_RX_ESTIMATE_PILOT;
#else

            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;
            gus_ExceptionState = gs_RxState;
            gus_ExceptionCode = E_CODE_RCPilot3_DEC_PATH_DEL_TIMEOUT;
#endif

         }
         break;

      case R_C_PILOT3_RX_ESTIMATE_PILOT:
         /* wait for TX state machine to unmask the RX input */
         if (gs_RxDECTrainSymbolCount == s_ref_symbolcount+4)
         {
            if(s_dec_path_sdelay > 0)
               s_dec_getptr = gs_RxSamplesPerFrame-s_dec_path_sdelay;
            else
               s_dec_getptr = 0;

            /* If C-QUIET5 is being received, skip the pilot accumulation. */
            if (gft_PilotOnDecTraining == FALSE)
            {
               gft_FlagPilotAccDone = TRUE;
               guc_EcTrainingState = TRAINING_DONE;
               gs_RxSubState = R_C_PILOT3_RX_QUIET;
            }
            else
            {
#ifndef ADSL_62
               gft_EnablePLL = TRUE;
#else
               gft_EnablePLL = FALSE;
#endif
            }
         }
         else if (gs_RxDECTrainSymbolCount > s_ref_symbolcount+4)
         {
            /* Accumulate C-PILOT3 frames. */
            Accum16to32(gla_RxAccumBuf, s_dec_getptr, gsa_RxToneBuf, 0, (int16)s_dec_path_sdelay);
            s_dec_getptr += s_dec_path_sdelay;
            if(s_dec_getptr >= gs_RxSamplesPerFrame)
               s_dec_getptr -= gs_RxSamplesPerFrame;

            Accum16to32(gla_RxAccumBuf, s_dec_getptr, gsa_RxToneBuf, s_dec_path_sdelay, (int16)(gs_RxSamplesPerFrame-s_dec_path_sdelay));

            s_dec_getptr += gs_RxSamplesPerFrame-s_dec_path_sdelay;
            if(s_dec_getptr >= gs_RxSamplesPerFrame)
               s_dec_getptr -= gs_RxSamplesPerFrame;

            gs_RxSubStateCnt++;
            if(gs_RxSubStateCnt == NUM_PILOT_EST_SYMBOLS)
            {
               gft_FlagPilotAccDone = TRUE;
               guc_EcTrainingState = TRAINING_IN_PROGRESS;
               AddFunctionToBkgdFifo(BgDECTrainAveragePilot);
               gs_RxSubState = R_C_PILOT3_RX_QUIET;
            }
         }
         break;

      case R_C_PILOT3_RX_QUIET:
         if (guc_EcTrainingState == TRAINING_DONE)
         {
            /* Wait for an even-numbered training symbol to be received */
            /* so that during the next substate an odd-numbered training symbol */
            /* is accumulated first. */
            if (gft_PilotOnDecTraining == FALSE)
            {
               i = gs_RxDECTrainSymbolCount-(s_ref_symbolcount+4);
            }
            else
            {
               i = gs_RxDECTrainSymbolCount-(NUM_PILOT_EST_SYMBOLS+s_ref_symbolcount+4);
            }
            if ((i > 2) && ((i+1) & 1))
            {
               /* reset the dec pointer for the next accumulation */
               if(s_dec_path_sdelay > 0)
                  s_dec_getptr = DEC_TRAINING_PERIOD*gs_RxSamplesPerFrame-s_dec_path_sdelay;
               else
                  s_dec_getptr = 0;

               gs_RxSubState = R_C_PILOT3_RX_WAIT_TX;
               gs_RxSubStateCnt = 0;
            }
         }
         break;

      case R_C_PILOT3_RX_WAIT_TX:
         //wait four extra frames to ensure that TX is set with transmitting DEC training signal
         // we may not need  4 frames, but this is added as safety, to ensure that we do see echo plus pilot in the next frame


            gs_RxSubStateCnt++;
            if (gs_RxSubStateCnt==4)
            {
               gs_RxSubStateCnt = 0;
               gs_RxSubState = R_C_PILOT3_RX_ACCUM;
            }
         break;

      case R_C_PILOT3_RX_ACCUM:
         /* Accumulate Rx frames. These frames will contain the CO's pilot */
         /* tone plus any local echo signal. */
         Accum16to32(gla_RxAccumBuf, s_dec_getptr, gsa_RxToneBuf, 0, (int16)s_dec_path_sdelay);

         s_dec_getptr += s_dec_path_sdelay;
         if(s_dec_getptr >= DEC_TRAINING_PERIOD*gs_RxSamplesPerFrame)
            s_dec_getptr -= DEC_TRAINING_PERIOD*gs_RxSamplesPerFrame;


         Accum16to32(gla_RxAccumBuf, s_dec_getptr, gsa_RxToneBuf, s_dec_path_sdelay, (int16)(gs_RxSamplesPerFrame-s_dec_path_sdelay));

         s_dec_getptr += gs_RxSamplesPerFrame-s_dec_path_sdelay;
         if(s_dec_getptr >= DEC_TRAINING_PERIOD*gs_RxSamplesPerFrame)
            s_dec_getptr -= DEC_TRAINING_PERIOD*gs_RxSamplesPerFrame;

         gs_RxSubStateCnt++;

         /* When enough symbols have been accumulated, go to next substate */
         if (gs_RxSubStateCnt == NUM_DEC_TRAINING_SYMBOLS)
         {
            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_PILOT3_RX_DEC_TRAIN;
         }
         break;

      case R_C_PILOT3_RX_DEC_TRAIN:

         gs_RxSubStateCnt++;

            if(gs_RxSubStateCnt == 1)
         {
#ifdef ADSL_62
                AddFunctionToFifo(gp_RxLoadingFunctionFifo, Enable_FFT);
#endif
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, MoveToFdqDoneInt);
         }
         else if(gs_RxSubStateCnt == 2)
         {
            gft_CopyRxBuffer = FALSE;
#ifdef ADSL_62
                gs_RtvSelect = SFDQ_OUTPUT;
                AddFunctionToFifo(gp_RxLoadingFunctionFifo,ConfigRTVBuf0_train);
#endif
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableFDQDoneNTC_EnableGetRxTones);

            /* Compute DEC filter coefficients (background) */
            gft_ReorderDEC = TRUE;
            guc_EcTrainingState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgDECTrain2PreProc);
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgDECTrain2);
            gl_DecStart = gl_RxSymbolCount;
            gs_RxSubState = R_C_PILOT3_RX_TRAINING_DONE;
         }
         break;

      case R_C_PILOT3_RX_TRAINING_DONE:
         if (guc_EcTrainingState == TRAINING_DONE)
         {
            gft_CopyRxBuffer = TRUE;
            if ((OPTNArray[OPTN_AlgControl] & OPTN_DECDnldDisable) == FALSE)
            {
               AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECDelay);
               gft_EnablePLL = FALSE;
            }
            gl_DecEnd = gl_RxSymbolCount;

            // Load back unity TDQ exponent for SNR calculation.
            // Load computed DEC coefficients along with unity TDQ
            gs_pre_tdq_h_exp = gs_UnityTDQExp;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadTDQExp);

                //Enable FFT and reordering
#if 1
//#ifndef HW_SNR_FDQ
            gft_CopyRxBuffer = 1;
            /* Clear reference for noise accumulation. */
            memset(gsa_CQuietRefTones, (int16)0, sizeof(int16)*(gs_RxNumTones*2));
#endif //HW_SNR_FDQ
            /* Notify the TX side to start transmitting MEDLEY signal for SNR measurement. */
            gs_StartDECTraining = FALSE;

            gs_RxSubState = R_C_PILOT3_RX_DEC_SETTLE;
            gs_RxSubStateCnt = 0;
            guc_PgaState = TRAINING_DONE;
            if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_ECTTrain_DELTA)
            {
               //gs_NMS_AGC1_Gain_Save = (gs_AGC1_Gain_Set << 8);
               //gs_PGA_required_Save = gs_PGA_required;
               //gs_RxSubState = R_C_MEDLEY_RX_COMPUTE_ADC_NOISE;
               gs_PGA_required = gs_NMS_AGC1_Gain_Save;
               guc_PgaState = TRAINING_IN_PROGRESS;
               AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgSetNmsPGA);

            }
         }

         break;

      case R_C_PILOT3_RX_DEC_SETTLE:

         if((gs_RxSubStateCnt++ == DEC_SETTLE_TIME)
            &&( guc_PgaState == TRAINING_DONE)
           )
         {
            //Mask Dec output if dec download is disabled
            if((OPTNArray[OPTN_AlgControl] & OPTN_DECDnldDisable)== TRUE)
               AddFunctionToFifo(gp_RxLoadingFunctionFifo,ClearDEC);

            if (gt_StateMachCntrl.s_RXFollowingState  != R_C_REVERB_FR6_RX)
            {
               if((OPTNArray[OPTN_AlgControl] & OPTN_DECDnldDisable)== FALSE)
               {
                  if (gft_PilotOnDecTraining == TRUE)
                  {
                     gft_EnablePLL = TRUE;
                  }
               }
            }

            /* Initialize noise power accumulators. */
            MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*(2*gs_RxNumTones)));

            /* Go to next substate. */
            gs_RxSubStateCnt = 0;
// XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START)
#ifdef VR9_DEC_TRAIN_DBG
                gs_RtvSelect = FFT_OUTPUT;
                AddFunctionToFifo(gp_RxLoadingFunctionFifo,ConfigRTVBuf0_train);
            //Mask DEC output, i.e don't give the DEC output in Rx Path
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,ClearDEC);
            gs_TrainCnt = gs_dbg_dec_avg; //No of of symbols to be averaged for rx echo noise
            gs_RxSubState = R_C_PILOT3_RX_ECHO_QUIET_ACCUM;
#else
            gs_RxSubState = R_C_PILOT3_RX_NOISE_ACCUM;
#endif //VR9_DEC_TRAIN_DBG
// XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (END)

         }
         break;
// XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START)
#ifdef VR9_DEC_TRAIN_DBG
      case R_C_PILOT3_RX_ECHO_QUIET_ACCUM:
         gs_RxSubStateCnt++;
         if (gs_RxSubStateCnt == 1)
         {
            //ignore first symbol after clearing DEC
            break;
         }
            if (gs_RxSubStateCnt <= (gs_TrainCnt+1))
            {
            //First channel as 0 and Last channel as (gs_RxFftLength/2)-1)
            //NoiseAcc(gla_RxAccumBuf, (int16)(2*gs_RxFirstChannel), gsa_RxToneBuf, 0, (int16)0, (int16)(2*gs_RxNumTones),
            // gsa_CQuietRefTones, gs_RxFirstChannel, gs_RxLastChannel);
            NoiseAcc(gla_RxAccumBuf, (int16)(0), gsa_RxToneBuf, 0, (int16)0, (int16)(2*gs_RxNumTones),
               gsa_CQuietRefTones, 0, (gs_RxFftLength >> 1)-1);
            if ((gs_dbg_dec == 0x3001) && (gs_RxSubStateCnt == gs_dbg_deccnt))
               Pause(0x3011);

                if(gs_RxSubStateCnt == (gs_TrainCnt+1))
                {
               RoundNoiseAccum(gla_RxAccumBuf, gla_RxAccumBuf, 0, (gs_RxFftLength >> 1)-1, gs_dbg_log2_dec_avg_symbols);
               MemCopyWords(gsa_RxDecTrainSilenceBuf, 0, gla_RxAccumBuf, 0, gs_RxFftLength);
               MemSetBuffer((int16 *)(gla_RxAccumBuf), 0, 0, (int16)(sizeof(int32)*(2*gs_RxNumTones)));
               // gs_dbg_dec_output ==> 1 Enable DEC output; 0 ==> Mask out DEC OUTput
               if (gs_dbg_dec_output)
               {
                  //Enable DEC output
                  AddFunctionToFifo(gp_RxLoadingFunctionFifo,UnmaskDECOutput);
               }

                    gs_RxSubStateCnt = 0;
               gs_dbg_DEC_TxSignal = gs_dbg_dec_signal; // 1 ==> Tx Medley & 2 ==> Tx REVERB for DEC accumulation;
                    gs_RxSubState = R_C_PILOT3_RX_ECHO_MEDLEY_ACCUM;
                }
            }
         break;

      case R_C_PILOT3_RX_ECHO_MEDLEY_ACCUM:
         gs_RxSubStateCnt++;
//       if(gs_RxSubStateCnt > (DEC_SETTLE_TIME))
         if(gs_RxSubStateCnt > (8))
            {
            NoiseAcc(gla_RxAccumBuf, (int16)(0), gsa_RxToneBuf, 0, (int16)0, (int16)(2*gs_RxNumTones),
               gsa_CQuietRefTones, 0, (gs_RxFftLength >> 1)-1);

            if ((gs_dbg_dec == 0x3002) && (gs_RxSubStateCnt == gs_dbg_deccnt))
               Pause(0x3012);

            if(gs_RxSubStateCnt == (8 + gs_TrainCnt))
//          if(gs_RxSubStateCnt == (DEC_SETTLE_TIME + gs_TrainCnt))
            {
               RoundNoiseAccum(gla_RxAccumBuf, gla_RxAccumBuf, 0, (gs_RxFftLength >> 1)-1, gs_dbg_log2_dec_avg_symbols);
               MemCopyWords(gsa_RxDecTrainMedleyBuf, 0, gla_RxAccumBuf, 0, gs_RxFftLength);

               /* Initialize noise power accumulators. */
               MemSetBuffer((int16 *)(gla_RxAccumBuf), 0, 0, (int16)(sizeof(int32)*(2*gs_RxNumTones)));
               /* Go to next substate. */
               gs_RxSubStateCnt = 0;
               gs_TxFirstPNbit   = 0; //ReStart sending Medley Sequence
               gs_RxSubState = R_C_PILOT3_RX_NOISE_ACCUM;
               if (gs_dbg_dec == 0x3003)
                  Pause(0x3013);
            }
         }
         break;
#endif
// XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (END)
      case R_C_PILOT3_RX_NOISE_ACCUM:

#if 1
//#ifndef HW_SNR_FDQ
         gs_RxSubStateCnt++;
         NoiseAcc(gla_RxAccumBuf, (int16)(2*gs_RxFirstChannel), gsa_RxToneBuf, 0, (int16)PN512_LEN, (int16)(2*gs_RxNumTones),
               gsa_CQuietRefTones, gs_RxFirstChannel, gs_RxLastChannel);

         if (gs_RxSubStateCnt == NUM_SNR_TRAINING_SYMBOLS_ECT)
         {
            /* Compute SNR value in background. */
            gft_CopyRxBuffer = FALSE;
            guc_SnrCalcState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgReverbSnrCalc);
            gs_RxSubState = R_C_PILOT3_RX_SNR_CALC;
         }
#else
      /* HW Based ACC*/
      if (gs_RxSubStateCnt == 0 )
      {
         // Reset the Noise Accumulator Buffer and trigger the SNR in hardware
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ResetNoisePowerBuffer);
      }
      else if (gs_RxSubStateCnt == NUM_SNR_TRAINING_SYMBOLS_ECT)
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ReadAccumulatedNoise);
         // Reset Accum mode
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, RestoreRtvCaptureModeSetting);
         /* Enable call to GetRxTones() */
         gft_CopyRxBuffer = TRUE;

      }
      else if (gs_RxSubStateCnt == NUM_SNR_TRAINING_SYMBOLS_ECT+1)
      {
            /* Compute SNR value in background. */
            gft_CopyRxBuffer = FALSE;
            guc_SnrCalcState = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgReverbSnrCalc);
            gs_RxSubState = R_C_PILOT3_RX_SNR_CALC;

      }

gs_RxSubStateCnt++;

#endif   //#ifdef HW_SNR_FDQ


         break;

      case R_C_PILOT3_RX_SNR_CALC:
         if (guc_SnrCalcState == TRAINING_DONE)
         {
            gft_CopyRxBuffer = TRUE;

            if (gl_RxSymbolCount > gt_StateMachCntrl.l_RXCurrentStateLen-2)
            {
               gs_RxNextState = FAIL_RX;
               gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

               /* Set exception handler variables */
               gus_ExceptionState   = gs_RxState;
               gus_ExceptionCode = E_CODE_RCPilot3_DEC_TRAINING_TIMEOUT;
            }

//#ifdef DANUBE
#ifdef TARGET_HW
                /* Swap the buffer to XMEM */
                RequestSwap_ReverbSnrBuf_ToXmem ();
#endif
//#endif
            /* change substate */
            gs_RxSubState = R_C_PILOT3_RX_WAIT;
            gs_RxSubStateCnt =0;
         }
         break;

      /* ========================================================================= */
      /* Wait for the end of this state */
      /* ========================================================================= */
      case R_C_PILOT3_RX_WAIT:
            if (gl_RxSymbolCount == gt_StateMachCntrl.l_RXCurrentStateLen-1)
         {
            gft_EnablePLL = FALSE;  //Turn of PLL during transition to RCReverb3 to avoid
                              //training the PLL to the glitch in the pilot reference
         }
            else if (gl_RxSymbolCount == gt_StateMachCntrl.l_RXCurrentStateLen)
         {
            gs_RxNextState = gt_StateMachCntrl.s_RXFollowingState;
            gpF_RxStateFunc = gt_StateMachCntrl.pF_RxFollowingState;

            if (gs_RxNextState  == R_C_REVERB_FR6_RX)
            {
               if ((OPTNArray[OPTN_AlgControl] & OPTN_TDQDnldDisable) == FALSE)
               {
                  AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECTDQ);
               }
            }

               memcpy(gusa_RCPilot3_RxOverflowCnts, gusa_RxOverflowCnts, NUM_RX_OVFLOW_CNTRS*sizeof(uint16));
         }
         break;
   }

   // XDSLRTFW-3500(Start)  : ADSL2 / 2+ mode: Missing excpetion state in case of C-TREF2 timeout
   // Introduce a new timeout exception state/code in R_C_TREF2_RX_BIS (C-TREF2) receiver state in BIS/PLUS mode.
   if (gs_RxState == R_C_TREF2_RX_BIS)
   {
      //R-TREF2 state length in Bis/Plus mode is 576 symbol. 2*576 symbol timeout time is used to accommodate
      //R-TREF2 length (576 symbol)+ 64 symbol maximum transition time from Transmitting R-Reverb3
      //to R-TREF2 receive signal + 512 symbol extra delay
      if(gl_RxSymbolCount >= 2*R_C_TREF2_RX_LEN_BIS)
      {
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* Set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_TREF2_BIS_TIMEOUT;
      }
   }
   // Introduce a new timeout exception state/code in R_C_PILOT3_RX (C-PILOT3) receiver state in DMT mode.
   else if (gs_RxState == R_C_PILOT3_RX)
   {
      //C-PILOT3 length in DMT mode is 512 Symbol 2*512 = 1024 symbol timeout time is used to accommodate
      //C-PILOT3 length + 512 symbol extra delay before entering to exception state.
      if(gl_RxSymbolCount > 2*R_C_PILOT3_RX_LEN)
      {
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* Set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_RCPILOT3_TIMEOUT;
      }

   }
   // XDSLRTFW-3500 (End)
}

#undef R_C_PILOT3_RX_INITIALIZE
#undef R_C_PILOT3_RX_ESTIMATE_PILOT
#undef R_C_PILOT3_RX_DEC_PATH_DELAY
#undef R_C_PILOT3_RX_QUIET
#undef R_C_PILOT3_RX_WAIT_TX
#undef R_C_PILOT3_RX_ACCUM
#undef R_C_PILOT3_RX_DEC_TRAIN
#undef R_C_PILOT3_RX_TRAINING_DONE
#undef R_C_PILOT3_RX_WAIT
#undef R_C_PILOT3_RX_DEC_SETTLE
#undef R_C_PILOT3_RX_NOISE_ACCUM
#undef R_C_PILOT3_RX_SNR_CALC
// XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START - END)
#undef R_C_PILOT3_RX_ECHO_QUIET_ACCUM
#undef  R_C_PILOT3_RX_ECHO_MEDLEY_ACCUM
