/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RCQuiet1RxF_BIS.c
 * DESCRIPTION:      RX State Function for ATU-R in the C-QUIET1
 *                   states of the Channel Discovery
 *                   Phase in G.dmt.bis.
 *
 **********************************************************************/

//*******************************************************************
// RCQuiet1RxF_bis.c
//
// History
//
//
// 20/08/2010  Sriram Shastry: CNXT D57 proposes higher DS PCB in C_MSG_PCB in short loops.
//                     Although ASE sends required R_MSG_PCB based on calculation,
//                     D57 always takes the higher one between these two. Therefore,
//                     we got no-connect in TR100A2 fixed rate tests in short loops
//                     with FB noise. The workaround is to retrain and cut Tx power.
//                     This fix will improve the DS rate performance in short loops
//                     especially with FB noise.
//                     Grep for SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut
//
// 16/04/10 Nihar: VINAX-CO uses tones for the PAR reduction which are a multiple of 16
//                  If the CPE by accident chooses a pilot tone which is used in showtime
//                  for PAR reduction the PLL drifts aways and the CPE looses sync.
//                  To avoid this situation some of the potential pilot tone indexes are
//                  taken out of the supported set
//                  DMT-mode:       tone: 224
//                  BIS-/PLUS-mode: tone: 224, 368
//                  Grep for IOP_DS_ALL_IFTN_VINAX_NO_PILOT_ON_PAR_TONE
//
// 16/04/10 Nihar: Increase DS performance against Vinax in DTAG lab
//                    DTAG-lab shows higher WhiteNoise level => use -130dBm/Hz instead of
//                    -140dBm/Hz for White Noise detection
//                    Grep for IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz
//
// 16/04/2010 Nihar: Workaround for false configuration of VINAX 10.6 based SAG5630 DSLAM
//                    In DTAG lab SAG5630 shows very low DS rate because of CO-requested -16dB nomPSD
//                    Grep for IOP_DS_ALL_VINAX_ClearNomPSDRequirement
//
// 16/04/2010 Nihar: Low US performance on long loops with Vinax 10.6/10.7 based COs
//                    On long white-noise loops the US performance is too low because of echo effects
//                    reduce the echo and increase the US performance by applying 2dB DS-PCB
//                    Grep for IOP_US_ALL_VINAX_DSPCB2IncreaseUSperf
//
// 22/04/2010 Nihar: Low US performance on long loops with Ericsson 312 (BRCM based)
//                    On long white-noise loops the US performance is too low because of echo effects
//                    Increase US performance by blacking out DS tones on long loops
//                    use gs_PGA_required_In_RCComb1 for loop-length estimation (as G.HS estimation not
//                    yet implemented)
//                    Unfortunately this estimation works only if no ISDN noise is present on CPE side
//                    DTAG is currently testing without ISDN noise
//                    loop length:                           1500 1700 1800 1900 2000 2500 3000 3500 4000
//                    gs_PGA_required_In_RCComb1 (ISDN off):   1B   1E   21   21   24   2A   30   39   3C
//                    gs_PGA_required_In_RCComb1 (ISDN on):    1B   1E   21   21   21   21   21   21   21
//             By default, the fix is enabled based on vendor & vendor specific information
//             To disable it, reset bit 9 of OPTN 25 0
//                    Grep for IOP_US_BISPLUS_BRCM_IncreaseUSperfByDSBlackout
//
// 14/05/2010 Nihar: QLN/HLOG calibration for Annex-B DMT, ADSL2/2+
//             Grep for Feature_DS_BisPlus_ALL_VR9QLNCalib
//
// 26/07/2010 Nihar: Logic to add extra DS PCB to boost the DS data rate
//                   for short loops in Plus mode. All hashdefines/constants
//                   used as part of this logic are derived from experimentation results.
//                   By default its disabled. To enable it cw INFO 103 1 0x0040
//                   Grep for PERF_DS_PLUS_ALL_GeneralizedPcb
// 19/08/2011 Anantha Ramu: Brought up Annex M feature
//                   Grep for XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M
//
// 30/08/2011 Sriram Shastry :  QLN/HLOG calibration for Annex-A DMT, ADSL2/2+. Calibration is done with respect to the
// line simulator generated refernce data.
//             Grep for "XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration"
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
// 12/12/2011 Vinjam/Kannan: STAT cmv added to read the Selected Annex M/J mask in the
//             Tx direction. Integrated to VR9 R4.3 ADSL code base.
//             Grep for "XDSLRTFW-356 SMS00845338 Feature_ALL_US_SelectedAnxMJMask".
//
// 07/06/2012 Vinjam: Number of downstream virtual noise break points (extracted from C-MSG-PCB) are copied
//            to "gt_DS_RefVirtNoiseLevel_ADSL2". Also "CMV INFO 114" is initialized to "&(gt_DS_RefVirtNoiseLevel_ADSL2)".
//            Disabled DS SRA & DS L2, when Downstream virtual noise feature is enabled.
//            These conditions are imposed to restrict the downstream virtual noise feature.
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// 11/7/2012 Vinjam: Re-adjusted "CMV INFO 11" to point to a buffer which contains Showtime SNR with out Virtual Noise.
//            also Virtual Noise related buffers/variables are initialized when gus_NumbDsVnBrkPoints > 0.
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise.
//
// 12/7/2012 Vinjam: Removed code which disabled DS SRA & PM L2 when virtual noise feature is enabled
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise.
//
// 14/09/2012 Sriram : Switched off the Tx images for better showtime stability in G.992.5M with CNXT DSLAM.
//                     Grep for :XDSLRTFW-524 IOP_US_AnxMPlus_ALL_iFFTScaleback_SwitchoffTxImagesCNXT
//
// 24/12/2012 Vinjam:  Modified reporting Tx PSD Mask number for Annex-M/J as per VRx Message Specifications (1.9)
//                     Grep for XDSLRTFW-356 SMS00845338 Feature_ALL_US_SelectedAnxMJMask
//
// 26/12/2012 Stefan/Vinjam: Integrated R3.5 fix to R5.2 Mainline.
//            To avoid long training times in ADSL mode and too early false mode switches to VDSL binary,
//             FW sends the intentional retrain information (using a global variable guc_Forced_Retrain) to SW/DSL API.
//             Grep for XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime
//
//07/03/2013 Palaksha: Improving DS PCB calculation on AR10
//             Improving DS PCB calculation on VRx Annex B.
//             At present on VRx platform we see rate degradation due to
//             incorrect DS PCB calculation. With respect to this following changes are done
//             (d) Increase the DS PCB based on loop length around 5000Feet incase gft_StrongNoiseForDsPcbnoise=0
//       Grep for ADSLRTFW-1580 Perf_DS_BisPlus_ALL_ImpDsPcb
//
// 22/03/2013 Prashant Patil: Avoid zero input to function (ConvertToDB), this was affecting the QLN computed
//                            at short loops.
//       Grep for XDSLRTFW-759 BugFix_DS_ALL_ALL_ShortLoopQln
//
// 5/4/2013 Enable images for Cnxt .. send only single image
//          XDSLRTFW-577 IOP_US_AnxMPlus_Cnxt_UsPerf
//
// 14/06/2013 Naveen: Re-adjusted the DS PCB calcualtion for VRx Annex B/J
//                    The CMV CMV_INFX_DFE_IOP_FIX_DS_PCB_ENABLE is enabled
//                    We increase the DS PCB  based on loop length upto 1000m incase gft_StrongNoiseForDsPcbnoise=0
//                    For loop lengths from 1000m to 2000m, DC PCB used is 3dB
//            Grep for XDSLRTFW-754 Perf_DS_Plus_ALL_AdjDsPcb
//

// 28/05/2013 Ram: Moved a code segment from func SelectMode_Bis() (file hndshk.c) as it was modifying ANX-L TSSI with
//                 G.992.5 TSSI. Looks like gl_SelectedMode was not yet updated with GHS-Rx data.
//                 Grep for XDSLRTFW-681: BugFix_DS_DMT_CNXT_No_Connect_in_19Kft_and_above_AnxL_Loops
//
// 24/5/2013 Vinjam: Added mapping of "HERC CMV INFO 85" to "Showtime SNR with out Virtual Noise" and the existing
//                   HERC/SOC CMV INFO 85 (INFO_RX_CLEAR_EOC) is moved to HERC/SOC CMV INFO 130
//                   Grep for XDSLRTFW-965 Task_DS_BisPlus_All_AttachHercCMVINFO85
//
// 09/07/2013 Anantha Ramu: Auto SRA is disabled for ReTx.
//            Grep for "XDSLRTFW-1025 FEATURE_DS_BisPlus_ALL_Disable_SRA_for_ReTx"
//
// 19/7/2013 Vinjam: Removed one image sent to Lucent Stringer DSLAM (CNXT) in G.992.5M mode as it is causing link drops
//           in loop reach automation tests (with Flexit2).
//           Grep for XDSLRTFW-1096 Fix_A_DS_BisPlus_CNXT_RemoveOneImage
//
// 15/04/2014 ChiWen/Hanyu: Fine tuned US performance against CNXT DSLAMs based on ADSLRTFW-1480 and ADSLRTFW-1591 with the following changes
//  (1) Added special flat US TSSI;
//  (2) Set tone 32 to zero(gusa_US_Tssi_Value[32] = 0);
//  (3) Enabled special flat US TSSI in C-REVERB1/R-REVERB1 (might have influence over the final PGA training);
//  (4) Enabled special flat US TSSI in C-REVERB2;
//  (5) Renamed gft_USPerf_Midloop_Gspn to gft_USPerf_Gspn for all CNXT CO's;
//  (6) Above changes are applied to all CNXT CO/DSLAMs regardless of CO FW versions and controlled by CMV bit4 (MASK 0x0010) of info 103 27
//      that is ENABLED (bit4=1) by default. This is especially recommended at CenturyLink/USA. So far no side effect has been observed.
//  Grep for XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement
//
// 09/11/2015 Stefan: Clean-up RCQuiet1RxF_BIS function for oISDN
//          move gs_LowestMinPCB calculation to ComputeDsPcb
//          Grep for XDSLRTFW-2510 : PCB_and_QLN_optimization_oISDN
//
// 09/19/2017 Stefan: No link in DTAG warehouse (Halle) on short loops with BRCM
//    CO- and CPE-training statemachines get out of sync in ADSL2+ training because BRCM CO does
//    transition from QUIET5 to REVERB3 too early
//    It seems that CO detects its own signal - especially the tssi-shaped out of band signal on
//    US tones (tones 32-63)
//    The issue is seen only with VRx518 based boards - not with VR9/VRx318 or BRCM CPEs
//    Current assumption is that the termination of the line is slightly different on VRx518 boards
//    resulting in a different echo attenuation on CO side on very short loops
//    Fix on CPE side:
//    Disable out of band signal on US frequencies by sending out Blackout-tones for tones
//    in the US band
//    fix is limited to 1000m (for longer loops the line impedance is dominating - not the AFE)
// Grep for XDSLRTFW-3487 VRx518 / No connect in Annex J with DPBO 70 profile
//
//************************************************************************************************************************

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "detect.h"
#include "states.h"
#include "RCComb1RxF_BIS.h"
#include "RCComb2RxF_BIS.h"
#include "cmv.h"
#include "hndshk_Data.h"
#include "fifo.h"
#include "tssi_rx.h"
#include "diagparam_bis.h"
#include "memsetbf.h"
#include "noiseacc.h"
#include "string.h"
#include "ec_data.h"
#include "DSLEngin.h"
#include "LinkStart.h"
#include "SetPgaForToneDetection.h"
#include "afe.h"
#include "pga_set.h"
#include "memcopy.h"
#include "pll.h"
#include "accum32.h"
#include "BgDetectMultiTones_Comb.h"
#include "post_hsk.h"
#include "stateini.h"
#include "ifft_cutback.h"
#include "InitTDQfilter.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

// XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (Start)
#ifndef ISDN  //Annex A
#include "vecpwr.h"
#include "dsp_op.h"
#include "rx_ops.h"
#include "xy_iof.h"
#include "gpersistent.h"
#endif
// XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (End)
int16 gs_minimum_QUIET1_RX_LEN = 400;

FlagT checkRateAdaptive(void) ;
#define  EricssonVendorCode0  (0xB5)
#define  EricssonVendorCode6  (0x61)
#define  EricssonVendorCode7  (0x97)

#ifdef ISDN
// IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz (Start)
#define VINAX_FW_VERSION_10_6_BYTE6 (0x90)
#define VINAX_FW_VERSION_10_6_BYTE7 (0x51)
// IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz (End)

// IOP_US_BISPLUS_BRCM_IncreaseUSperfByDSBlackout (Start)
// DTAG Ericsson 612 FW version numbers (for information only)
#define ERICSSON612_VENDORCODE_OCT6          (0x91)
#define ERICSSON612_VENDORCODE_OCT7_W503QUAL (0x0d)          // BRCM FW used for W503V qualification
#define ERICSSON312_VENDORCODE_OCT0          (0xB5)
// DTAG Ericsson 312 FW version numbers
#define ERICSSON312_VENDORCODE_OCT6          (0x61)
#define ERICSSON312_VENDORCODE_OCT7_W303QUAL (0x97)          // BRCM FW used for W303V qualification
#define ERICSSON312_VENDORCODE_OCT7_W305QUAL (0x9F)          // BRCM FW used for W503V qualification
// IOP_US_BISPLUS_BRCM_IncreaseUSperfByDSBlackout (End)
#endif

extern int16 ConvertToDB(int32 l_xin);
extern int32 VectorPower(int16 *s_databuf, int16 s_offset, int16 s_ndata, int16 s_GuardBits);
#ifndef ISDN
/*^^^
 *---------------------------------------------------------------------
 * Function: HamBandNotchPCBAjustment
 *
 * Description: PCB adjustment table based on PGA set value
 *
 *  With current CO Hamband Notch profile, we have the following PGA setting in the
 *  White noise -140dBm straight loop.
Loop  PGA           PGA
Length (Against     (Against
(ft)    Geminax CO)  Alcatel CO)
0     -8              -5
200      -8          -5
400      -5          -5
600      -5          -2
800      -5          -2
1000  -2              -2
1200  -2               1
1400  -2               1
1600  1                1
1800  1                4
2000  1                7
2200  4                7
2400  7                7
2600  7               10
2800  7               10
3000  10              10
3200  10              13
3400  10              13
3600  10              13
3800  10
4000  13

   Note: The above PGA set values are collect form lab. With different noise level,
the PGA value could vary on same loop length.
 *---------------------------------------------------------------------
 *^^^
 */
int16 HamBandNotchPCBAjustment()
{
   int s_PCB_DS_Delta_bis;

   if (gs_PGA_required_In_RCComb1 < -512)  //  PGA < -2dB
      s_PCB_DS_Delta_bis = 4;
   else if (gs_PGA_required_In_RCComb1 < 256)  // -2dB <= PGA < 1dB
      s_PCB_DS_Delta_bis = 5;
   else if (gs_PGA_required_In_RCComb1 < (7<<8)) // 1dB <= PGA < 7dB
      s_PCB_DS_Delta_bis = 4;
   else if (gs_PGA_required_In_RCComb1 < 2560) //7dB <= PGA < 10dB
   {
      s_PCB_DS_Delta_bis = 3;
      if (gft_NotchPresent == 2)  //shallow Notch
         s_PCB_DS_Delta_bis = 1;
   }
   else if (gs_PGA_required_In_RCComb1 < (13<<8)) // 10dB <= PGA < 13dB
   {
      s_PCB_DS_Delta_bis = 1;
      if (gft_NotchPresent == 2)   //shallow Notch
         s_PCB_DS_Delta_bis = 0;
   }
   else
      s_PCB_DS_Delta_bis = 0; //PGA > 13dB

   //when strong noise presents (such as 5T1, 24HDSL or ETSIB noise, we need to fine tune the PCB adjustment)
   if (gft_StrongNoisePresent)
   {
      if (gft_NotchPresent == 2)  //shallow Notch
      {
         //don't add extra power cut back in the short loop
         if (gs_PGA_required_In_RCComb1 < -512) //  PGA < -2dB
            s_PCB_DS_Delta_bis = 0;
         else
         {
            if (gft_24HDSLNoise)  //if 24HDSL noise or ETSIB noise presents
            {
               if (gs_PGA_required_In_RCComb1 < (7<<8))
                  s_PCB_DS_Delta_bis -= 2;
            }
            else
               s_PCB_DS_Delta_bis -= 3;
         }
      }
      else  //for deep notch.
         s_PCB_DS_Delta_bis -= 4;

      if (s_PCB_DS_Delta_bis < 0)
         s_PCB_DS_Delta_bis = 0;

   }
   // Above 4kft don't apply "s_PCB_DS_Delta_bis = 0" //XDSLRTFW-3261
   if(gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_AT_4000F)
   {
      s_PCB_DS_Delta_bis = 0;
   }
   return (s_PCB_DS_Delta_bis);

}
#endif

/*^^^
 *---------------------------------------------------------------------
 * Function: RCQuiet1RxF_BIS
 *
 * Description: Implements the R_C_QUIET1_RX_BIS
 *
 * R_C_QUIET1_RX_BIS_CALCULATE_QLN_PSD   - Computes Quiet Line Noise PSD for
 *                            for loop diagnostic test parameter.
 * R_C_QUIET1_RX_BIS_DETECT_C_COMB       - Waits to Detect C-Comb symbol
 *
 *---------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_QUIET1_RX_BIS_WAIT              (0)
#define R_C_QUIET1_RX_BIS_SET512FFT        (1)
#define R_C_QUIET1_RX_BIS_SET_PGA_BEFORE_CALCULATE_QLN_PSD (15)
#define R_C_QUIET1_RX_BIS_CALCULATE_QLN_PSD (2)
#define R_C_QUIET1_RX_BIS_DETECT_C_COMB_WAIT    (3)
#define R_C_QUIET1_RX_BIS_DETECT_C_COMB         (4)

#if defined(INFINEON) && defined(ISDN) && defined(AMAZON_AFE)
#define R_C_QUIET1_RX_BIS_DETECT_VDSL2_OOB      (5)
#endif

#define R_C_QUIET1_BIS_SI_TIMEOUT_LEN     (20*FRAME_COUNT_FOR_ONE_SEC)


#if defined(INFINEON) && defined(ISDN) && defined(AMAZON_AFE)

#define NUM_MINFRAME_AFESETTLE      (4)
#define NUM_FRAMESNOISEAC_VDSL2OOB  (32)
#define NUM_LOG2FRAMESNOISEAC_VDSL2OOB (5)
#endif

// XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (Start)
#define R_C_QUIET1_PRE_QLN_PSD1  (50)
#define R_C_QUIET1_PRE_QLN_PSD2 (51)
#define R_C_QUIET1_QLN_BisPlusAccum    (32)
#define LOG2_R_C_QUIET1_QLN_BisPlusAccum     (5)
// XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (End)
extern FlagT gft_ANFPNotchPresent;
void RCQuiet1RxF_BIS(void)
{
   int16 i, s_temp, s_max;
   // XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (Start_End)
   int32 l_Acc;
#if defined(INFINEON) && defined(ISDN) && defined(AMAZON_AFE)
   int16 s_SignalPowerVDSL2OOB,s_VDSL_OOB_Th;
#endif
   int16 s_majorVer;

#ifdef ISDN
   int16 s_minorVer;
#endif
#ifndef ISDN
   FlagT ft_CTune_Adapt;
   FlagT ft_AWGN130_140Noise;
   uint16 us_CTune_12kft_above;
   int16  s_hsk_power_12kft_above;
#endif

   FlagT ft_DetectCntThresholdMet;

   if(gl_RxSymbolCount == 0)
   {
      if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
      {
      //XDSLRTFW-1025 FEATURE_DS_BisPlus_ALL_Disable_SRA_for_ReTx (Start)
      // CMV OPTN 15 bit 2
         OPTNArray[OPTN_OLRControl_DS] &= ~OPTN_EnableAutoSRA; //SRA disabled for ReTx
      //XDSLRTFW-1025 FEATURE_DS_BisPlus_ALL_Disable_SRA_for_ReTx (End)
      }
      //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
      //Raise an exception, If CMV DSL0 0x0001 is enabled & received virtual noise break points
      //are greater than "MAX_NUM_VN_DS_PSD_POINTS" (= 16).
      //Reset INFO 114 structure
      memset(&gt_DS_RefVirtNoiseLevel_ADSL2, 0, sizeof(gt_DS_RefVirtNoiseLevel_ADSL2));
      //XDSLRTFW-2443 / XDSLRTFW-2462
      //set the a pointer to "SNR with out virtual noise". This is used in show time.
      //gsa_RxWithOutVnSnrBuf[ ] is kept in Port-1 memory as VR9 ADSL2 doesn't yet support bonding (R5.1).
      gpsa_RxSnrBufWoVN = (int16 *) (&gsa_RxWithOutVnSnrBuf[0]);
      memset(gpsa_RxSnrBufWoVN, 0x00, (RX_NUM_TONES * sizeof(int16)));
      INFOMap[INFO_DS_VIRTUAL_NOISE] = (int16 *)(void *) &gt_DS_RefVirtNoiseLevel_ADSL2; //Attach to CMV

      if(((gs_DSL_FeaturesControl & DSL_Enable_DS_VirtualNoise) == DSL_Enable_DS_VirtualNoise)&&(gus_NumbDsVnBrkPoints > 0))
      {
         if(gus_NumbDsVnBrkPoints <= MAX_NUM_VN_DS_PSD_POINTS)
         {
            gt_DS_RefVirtNoiseLevel_ADSL2.us_NumberOfTones = gus_NumbDsVnBrkPoints;
            //set the a pointer to "SNR with out virtual noise". This is used in show time.
            //gsa_RxWithOutVnSnrBuf[ ] is kept in Port-1 memory as VR9 ADSL2 doesn't yet support bonding (R5.1).
            // initialization moved up.
            //gpsa_RxSnrBufWoVN = (int16 *) (&gsa_RxWithOutVnSnrBuf[0]);
            //memset(gpsa_RxSnrBufWoVN, 0x00, 1024);

            //Disable DS SRA - Taken out
            //OPTNArray[OPTN_OLRControl_DS] &= ~OPTN_EnableAutoSRA;
            //Disable DS L2 - Taken out
            //OPTNArray[OPTN_OLRControl_DS] |= OPTN_DisableL2Mode;
         }
         else
         {
            //Received virtual noise break points are more than "MAX_NUM_VN_DS_PSD_POINTS" (=16).
            //Memory is allocated to store "MAX_NUM_VN_DS_PSD_POINTS".
            //Drop the link with exception code.
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;
            /* Set exception handler variables */
            gus_ExceptionState = gs_RxState;
            gus_ExceptionCode = E_CODE_EXCEEDS_MAX16_DS_VN_BREAKPOINTS;
         }
      }
      //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

      /* Attempting Diag Mode */
      if(STATArray[STAT_MacroState] == STAT_LoopDiagMode)
      {
         gt_StateMachCntrl.l_RXCurrentStateLen = R_C_QUIET1_MIN_RX_LEN_BIS_DIAG - 1;
         gt_DS_MeasurementPeriod.us_QLN_measurement_period   = (uint16)R_C_QUIET1_QLN_LEN_DIAG;
      }
      /* Attempting Data Mode */
      else
      {
         /* Attempting a Short Initialization */
         if (gl_SelectedMode & LINK_SHORTINIT)
         {
            gl_pll_freq_offset = gl_HsPLLFreqOffset;
            SetLinkModeDependentVariables();
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BGInitModem_PostHandshake);

            gt_StateMachCntrl.l_RXCurrentStateLen = 0;
         }
         /* Attempting a Full Initialization */
         else
         {
            // We seem to miss the comb if we wait until the minimum quiet time
            // before looking for Comb. Made a variable.
            gt_StateMachCntrl.l_RXCurrentStateLen = gs_minimum_QUIET1_RX_LEN;

         }
         gt_DS_MeasurementPeriod.us_QLN_measurement_period   = (uint16)R_C_QUIET1_QLN_LEN;
      }

      gs_RxSubState = R_C_QUIET1_RX_BIS_WAIT;

      guc_FdqTrainingState = TRAINING_WAITING;
      guc_TdqTrainingState = TRAINING_WAITING;
      guc_EcTrainingState     = TRAINING_WAITING;
      guc_AecTrainingState = TRAINING_WAITING;
      guc_AvgAecLmsSequences  = TRAINING_WAITING;
      gft_BitloadState     = TRAINING_WAITING;
#ifndef TARGET_HW
      // Set the flag to true to indicate DMA buffer pointers should be reset
      gft_ResetDmaPtr = TRUE;
#endif

      gs_RxSubStateCnt = 0;


      //XDSLRTFW-681: BugFix_DS_DMT_CNXT_No_Connect_in_19Kft_and_above_AnxL_Loops (Start)
      //Moved below code segment from func SelectMode_Bis() (and file hndshk.c) as it was modifying ANX-L TSSI with
      //G.992.5 TSSI. Looks like gl_SelectedMode was not yet updated with GHS-Rx data.

      //XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining (Start)
      // Consider about sending US-TSSI in CLR message ??
      // Sriram : Modify the UsTssi Value for Connexant CO( delete FW Retrain)
#ifndef ISDN
      if((gs_CurrentCoChipset == GSI_CO_CHIPSET) &&
         (gs_CurrentCoVendorID == 0x10 ) &&
         (gt_INFX_CMV.us_OperatorSpBits4 & CMV_TO_ENABLE_CNXT_Midloop_USPerf) &&
         (!(gt_INFX_CMV.us_OperatorSpBits5 & CMV_TO_ENABLE_CNXT_USPerf_E67)) && //XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (START_END)
         ((gl_SelectedMode & (ANNEX_L)) != ANNEX_L))
      {
         for (i = 0; i < gt_GHS_USTssiInfo.s_NumBrkptkept; i++)
         {
            gt_GHS_USTssiInfo.uca_Brkpt[i] = guca_US_TssiIndex_G9925A_GSI_Intracom[i];
            gt_GHS_USTssiInfo.uca_Tssi[i] = guca_US_TssiValue_G9925A_GSI_Intracom[i];
         }
         //XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (START_END)
         gft_USPerf_Gspn = 1; // Trigger  Tssi for Reverb/Segue phase ( wTssi and w/oTssi)
      }
#endif
      // Sriram : Modify the UsTssi Value for Connexant CO( delete FW Retrain)
      //XDSLRTFW-626: Enh_all_all_TelfonicaLongTraining (End)
      //XDSLRTFW-681: BugFix_DS_DMT_CNXT_No_Connect_in_19Kft_and_above_AnxL_Loops (End)

//XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (START)
#ifndef ISDN
        if( (gt_INFX_CMV.us_OperatorSpBits5 & CMV_TO_ENABLE_CNXT_USPerf_E67) &&
            (gs_CurrentCoChipset == GSI_CO_CHIPSET) &&
            ((gl_SelectedMode & ANNEX_A) == ANNEX_A) ) //XDSLRTFW-2403 (Start_End)
      {
         for (i = 0; i < gt_GHS_USTssiInfo.s_NumBrkptkept; i++)
         {
            gt_GHS_USTssiInfo.uca_Brkpt[i] = guca_US_TssiIndex_G9925A_GSI_E67[i];
            gt_GHS_USTssiInfo.uca_Tssi[i] = guca_US_TssiValue_G9925A_GSI_E67[i];
         }
         gft_USPerf_Gspn = 1; // Trigger  Tssi for Reverb/Segue phase ( wTssi and w/oTssi)
      }
#endif
//XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (END)

      // Start background task to compute DS inverse tssi.
      guc_BkgdTaskState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgCalculateTssi);
      //XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): enable single Notch disturber
      //and 512pt QLN for PLUS mode only
      if(gl_SelectedMode & (MODE_G992_5))
      {  // gs_DSL_AlgControl4 |= DSL_EnableFixedRFIdisturberSingleNotch;
         STATArray[STAT_QLN_Performance] |= STAT_512Bin_QLN_ON;
      }

   }

    switch (gs_RxSubState) {

   /* ==================================================================== */
   /* Wait for channel to stabilize and perform initialization */
   /* ==================================================================== */
   case R_C_QUIET1_RX_BIS_WAIT:

      if(gs_TxState == R_QUIET1_TX_BIS)
      {

         // XDSLRTFW-356 SMS00845338 Feature_ALL_US_SelectedAnxMJMask (Start)
         if (gl_SelectedMode & (ANNEX_M | ANNEX_J))
         {
          //XDSLRTFW-356 SMS00845338 Feature_ALL_US_SelectedAnxMJMask (Start_End)
             //Modified reporting Tx PSd Mask number for Annex-M/J as per VRx Message Spec
          STATArray[STAT_SELECTED_ANX_MJ_MASK] = (1 << gs_AnnexBMJPSDMaskIdx); //As per VR9 Message Specification
          //STATArray[STAT_SELECTED_ANX_MJ_MASK] = gs_AnnexBMJPSDMaskIdx; //For PSD automation
         }
         // XDSLRTFW-356 SMS00845338 Feature_ALL_US_SelectedAnxMJMask (End)

         // start transmitting images of data
         if (gl_SelectedMode & (ANNEX_B | ANNEX_J))
            gft_TxImages = 1;
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
         // if US performance fix: on
         // (images are currently disabled)
         if ( (OPTNArray[OPTN_TXPathControl] & 0x1) && (gus_TxPathControl & 0x800)) // Images turned on
            gft_TxImages = 1;
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)

//XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M (Start)

         if ((gl_SelectedMode == (MODE_G992_5 | ANNEX_M)))
         {
         // XDSLRTFW-524 IOP_US_AnxMPlus_ALL_iFFTScaleback_SwitchoffTxImagesCNXT (START)
         // For Connexant Adsl2pM Mode , disable the Tximages as a work around for stable showtime
            if(gs_CurrentCoChipset == GSI_CO_CHIPSET)
            {
               //XDSLRTFW-1096 Fix_A_DS_BisPlus_CNXT_RemoveOneImage (Start_End)
               gft_TxImages = 0;
            }
            else
         // XDSLRTFW-524 IOP_US_AnxMPlus_ALL_iFFTScaleback_SwitchoffTxImagesCNXT (END)
            {
               gft_TxImages = 1;
            }
         }
         if ((gl_SelectedMode == (MODE_G992_3 | ANNEX_M)))
         {
            gft_TxImages = 1;
         }
//XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M (End)

         gs_RxSubStateCnt++;
         if (gs_RxSubStateCnt == 1)
         {
         //For ADSL_62, the reconfiguration below is for 1024 pt fft only.
         //If 512 fft is selected, tx filter reconfiguration is handled in Reconfig_PostGHS
#ifdef ADSL_62
            if ((gl_SelectedMode & MODE_G992_5) && (gft_V14 == 0))
            {
               gs_DEC_ORDER = 240;
            }
            //load unity DEC
            gs_pre_dec_h_exp = 1;
            gs_pre_dec_h_delay  = 0;
            gsa_pre_dec_h[0] = 0x4000;
            for(i=1; i<gs_DEC_ORDER; i++)
               gsa_pre_dec_h[i] = 0;
         }
#endif
         else if (gs_RxSubStateCnt == 2)
         {
            /* Reconfig digital front end filters based on selected mode */
            Reconfig_STR_FW(gl_SelectedMode);
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,Reconfig_DFE_Tx);
            {
               //Later if someone wants to try other than 17a before GHS
                gus_AFE_RxMode = ADSL2_CPE;
                gus_AFE_TxMode = ADSL2_CPE;
            }
            //Used below hybrid setting for handshake. when we change the hyb for HSK, then we have to update this variable gs_HybridGainRef
            //{ 0x0253,     0x063F,          0x0414,       0xF84F},  //  0   -7.6930   123  210     1600   145   1p   133   off   1p Null Loop
            //gs_HybridGainRef = (int16)  0xF84F;//   -7.6930  CHECK_VRX518AFE
            //AFED_ModeConfig();
            gs_Hyb_Hsk_QlnHlog = 2; //QLN
           // Reconfig_AFE();

            /* For socrates only -- we will switch to 512 pt FFT if G9923 */
#ifdef TARGET_HW
            if (gl_SelectedMode & MODE_G992_3)
            {
               if((OPTNArray[OPTN_StateMachineCtrl] & OPTN_FFT1024_Enable) != 0)
               {
                  /* Update f/w variables to correspond to using 512 pt FFT */
                     gs_RxFftLength = 512;
                  gs_numAecLMSIterations = NUM_AEC_LMS_ITERATIONS;/* we run out of MIPS here with 1024 samples/frame with default value of 16 */
                                                      /* Empirically, 12 iterations seems to be fine with 1024 samples/frame on Socrates+ */
                  gs_presync_stepsize = 1;

                  OPTNArray[OPTN_StateMachineCtrl] |= OPTN_FFT512_Enable_PostGHS;
               }
            }
#endif


            if (isNeededXtraIfftCutback())
            {
               gft_XtraIfftCutback = 1;
               AddFunctionToFifo(gp_RxLoadingFunctionFifo, Reconfig_IRI_IFFT_Size);
            }

            gs_RxSubStateCnt = 0;

            if((OPTNArray[OPTN_StateMachineCtrl] & OPTN_FFT512_Enable_PostGHS) != 0)
            {
               gs_RxSubState = R_C_QUIET1_RX_BIS_SET512FFT;
            }
            else
            {
               //For Plus mode, put strymon in reset mode to reload dec length
               AddFunctionToFifo(gp_RxLoadingFunctionFifo,Reconfig_PostGHS);
               gs_RxSubState = R_C_QUIET1_RX_BIS_SET_PGA_BEFORE_CALCULATE_QLN_PSD;
            }

#if 0//def HW_SNR_FDQ
            // setup to do hardware accumulation mode
            gs_RtvSelect = FFT_OUTPUT;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,ConfigRTVBuf0_train_Accum);
            /* Turn off Copy RxToneBuf */
            gft_CopyRxBuffer = FALSE;
#endif
           } //else if (gs_RxSubStateCnt == 2)

      }
      break;

    case R_C_QUIET1_RX_BIS_SET512FFT:

      gs_RxSubStateCnt++;

      if(gs_RxSubStateCnt == 1)
      {
#if 1
         // A code optimization since we are only here if FFT is 512!
         // gs_RxFftLength would have changed.
         gs_RxCPLength = 512 >> 4;
         gs_RxSamplesPerFrame = 512;
         /* Compute log2(gs_RxFftLength)-1 = log2(gs_FftLength/2) */
         gs_RxLog2FftLength1 = 8;
         /* Compute log2rxnumsamples */
         gs_Log2RxSamplesPerFrame = 9;

#ifdef ADSL_62
            gs_TxFftLength_Oversample = gs_RxFftLength;
            gs_TxCPLength_Oversample = gs_RxCPLength;
         /* Compute log2(gs_TxFftLength)-1 = log2(gs_FftLength/2) */
         gs_TxLog2FftLength1_Oversample = 8;
#endif

#else
         gs_RxCPLength = gs_RxFftLength >> 4;
         gs_RxSamplesPerFrame = gs_RxFftLength;
         /* Compute log2(gs_RxFftLength)-1 = log2(gs_FftLength/2) */
         gs_RxLog2FftLength1 = 0;
         s_temp = (gs_RxFftLength >> 1);
         while((s_temp&1) == 0)
         {
            gs_RxLog2FftLength1++;
            s_temp >>= 1;
         }
         /* Compute log2rxnumsamples */
         s_temp = gs_RxSamplesPerFrame;
         gs_Log2RxSamplesPerFrame = 0;
         while((s_temp&1) == 0)
         {
            gs_Log2RxSamplesPerFrame++;
            s_temp >>= 1;
         }
#endif
         /* =============================================================================== */
         /* Update DEC Upsampling factor based on Rx FFT and Tx IFFT Lengths */
         /* =============================================================================== */

            for(gs_DECUpsamplingFactor=1, s_temp=gs_TxFftLength_Oversample; s_temp<gs_RxSamplesPerFrame; s_temp<<=1)
            gs_DECUpsamplingFactor <<= 1;

      }
      else if(gs_RxSubStateCnt == 2)
      {

#ifndef ADSL_62
         /* =============================================================================== */
         /* Update Iridia based on Rx FFT and Tx IFFT Lengths                       */
         /* =============================================================================== */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,Reconfig_IRI);
#else
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,Reconfig_PostGHS);
         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_QUIET1_RX_BIS_SET_PGA_BEFORE_CALCULATE_QLN_PSD;
#endif

      }
#ifndef ADSL_62
      else if(gs_RxSubStateCnt == 3)
      {
         /* =============================================================================== */
         /* Update Strymons SMODE Register based on Rx FFT and Tx IFFT Lengths            */
         /* =============================================================================== */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,Reconfig_STR_SMODE);

      }
      else if(gs_RxSubStateCnt == 4)
      {
         /* =============================================================================== */
         /* Update Strymons Filters based on above reconfigs (SMODE registers/DEC Length)   */
         /* =============================================================================== */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,Reconfig_DFE_Rx);

      }
      else if(gs_RxSubStateCnt == 5)
      {
         /* =============================================================================== */
         /* Update Strymons Filters based on above reconfigs (SMODE registers/DEC Length)   */
         /* =============================================================================== */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,Reconfig_DFE_Tx);

         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_QUIET1_RX_BIS_SET_PGA_BEFORE_CALCULATE_QLN_PSD;
      }
#endif
      break;

   case R_C_QUIET1_RX_BIS_SET_PGA_BEFORE_CALCULATE_QLN_PSD:

      if (gl_SelectedMode & LINK_SHORTINIT)
      {
         gs_RxSubState = R_C_QUIET1_RX_BIS_DETECT_C_COMB_WAIT;
         guc_SnrCalcState = TRAINING_DONE;
      }
      else if (gs_RxSubStateCnt == 0)
      {
         gs_RxSubStateCnt++; /* compute needed PGA */
#ifndef ISDN
         //AnxA: use the G.hs estimated PGA setting while measuring the QLN instead of Max gain
         //to avoid clip due to strong noise.
         //Note: For AnxB QLN Calibration G.hs estimated gain setting may be required.
         gs_PGA_required = gs_PGA_required_In_GHS;
#else
         int16 s_PGA;
         //SetInitialPgaToMax();
         s_PGA = AFED_SetInitialPgaToMax();
#endif //ifndef ISDN

         SetTDQtoUnity();
         // Feature_DS_BisPlus_ALL_VR9QLNCalib (Start)
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_HskQlnHlogSetHybrid);
         // Feature_DS_BisPlus_ALL_VR9QLNCalib (End)
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECTDQ);
         // XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (Start)
         gs_RxSubStateCnt = -1;
         gl_Rx_QLN_Power = 0;
         gs_RxSubState = R_C_QUIET1_PRE_QLN_PSD1;
      }
      break;

   case R_C_QUIET1_PRE_QLN_PSD1:

      gs_RxSubStateCnt++;
      /* The following part should be removed later */
        if (gs_RxSubStateCnt < R_C_QUIET1_QLN_BisPlusAccum)
        {
         l_Acc = VectorPower(gsa_RxToneBuf, 0, (int16) (2 * gs_RxNumTones), (int16) (gs_RxLog2NumTones));

           /* Compute the average power */
           gl_Rx_QLN_Power += (l_Acc >> LOG2_R_C_QUIET1_QLN_BisPlusAccum);
        }
      else if (gs_RxSubStateCnt == R_C_QUIET1_QLN_BisPlusAccum)
      {
#ifdef FD_ACCUM_FOR_PGA
         if (gs_RxFftLength  == 1024)
            gs_td_fd_pwr_offset  = TD_FD_PWR_DIFF_PLUS;     // 3 db
         else if (gs_RxFftLength  == 512)
            gs_td_fd_pwr_offset  = TD_FD_PWR_DIFF_BIS;      // 6 db
#endif

         //XDSLRTFW-759 BugFix_DS_ALL_ALL_ShortLoopQln (START)
         // Work around
         if (gl_Rx_QLN_Power == 0)
         {
            gl_Rx_QLN_Power = 1; //Inorder avoid log(0)
         }
         //XDSLRTFW-759 BugFix_DS_ALL_ALL_ShortLoopQln (END)

         gs_PGA_required = PD_DB - ConvertToDB(gl_Rx_QLN_Power)
                           - (gs_td_fd_pwr_offset + gs_PGA_margin)
                           + gs_PGA_set;
         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_QUIET1_PRE_QLN_PSD2;
      }
      break;
   case R_C_QUIET1_PRE_QLN_PSD2:
      if (gs_RxSubStateCnt == 0)
      {
         gs_RxSubStateCnt++;
         // XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (End)
         AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgPGA);
         guc_PgaTrainingState = TRAINING_IN_PROGRESS;
      } /* "gs_RxSubStateCnt==0" */
      else if (gs_RxSubStateCnt == 1)
      {
         if (guc_PgaTrainingState == TRAINING_DONE)
         {
            gs_RxSubStateCnt++; /* set PGA */
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
         } /* TRAINING_DONE */
      } /* "gs_RxSubStateCnt==1" */
      else if (gs_RxSubStateCnt == 2)
      {
         // Setup for ICN power measurement.
         memset(gla_RxAccumBuf, (int16)0, sizeof(int32)*(gs_RxNumTones*2));
         memset(gsa_CReverbRefTones, (int16)0, sizeof(int16)*(gs_RxNumTones*2));

         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_QUIET1_RX_BIS_CALCULATE_QLN_PSD;
      } /* "gs_RxSubStateCnt==2" */

      break; /* R_C_QUIET1_RX_BIS_SET_PGA_BEFORE_CALCULATE_QLN_PSD */

    case R_C_QUIET1_RX_BIS_CALCULATE_QLN_PSD:

#if 1//ndef HW_SNR_FDQ
   //take the 5-symbol delay from setting afe to rxtone buffer into consideration
      if (gs_RxSubStateCnt >= 3)
         // Compute Qln PSD in background from accumulated frame
         NoiseAcc(gla_RxAccumBuf, (int16)0, gsa_RxToneBuf, (int16)0, (int16)0, (int16)0, gsa_CReverbRefTones, (int16)0, (int16)(gs_RxNumTones-1));

      if (++gs_RxSubStateCnt == gt_DS_MeasurementPeriod.us_QLN_measurement_period + 3)
      {
            gs_RxSubStateCnt = 0;
         guc_SnrCalcState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)QuietLineNoisePSD);
#ifndef DANUBE_TEMP
#if defined(INFINEON) && defined(ISDN) && defined(AMAZON_AFE)
         gs_RxSubState = R_C_QUIET1_RX_BIS_DETECT_VDSL2_OOB;
#else
         gs_RxSubState = R_C_QUIET1_RX_BIS_DETECT_C_COMB_WAIT;
#endif
#else
            gs_RxSubState = R_C_QUIET1_RX_BIS_DETECT_C_COMB_WAIT;
#endif
      }

#else

      /* HW Based ACC*/
      if (gs_RxSubStateCnt == 0 )
      {
         // Reset the Noise Accumulator Buffer and trigger the SNR in hardware
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ResetNoisePowerBuffer);
      }
      else if (gs_RxSubStateCnt ==  gt_DS_MeasurementPeriod.us_QLN_measurement_period  )
      {
         // Queue TC task to read the Accumulated Noise
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ReadAccumulatedNoise);
         gs_RtvSelect = SFDQ_OUTPUT;
         // Reset Accum mode
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, RestoreRtvCaptureModeSetting);
         /* Enable call to GetRxTones() */
         gft_CopyRxBuffer = TRUE;
      }
      else if (gs_RxSubStateCnt ==  gt_DS_MeasurementPeriod.us_QLN_measurement_period + 1)
      {
            gs_RxSubStateCnt = -1;
         guc_SnrCalcState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)QuietLineNoisePSD);

#ifndef DANUBE_TEMP
#if defined(INFINEON) && defined(ISDN) && defined(AMAZON_AFE)
         gs_RxSubState = R_C_QUIET1_RX_BIS_DETECT_VDSL2_OOB;
#else
         gs_RxSubState = R_C_QUIET1_RX_BIS_DETECT_C_COMB_WAIT;
#endif
#else
            gs_RxSubState = R_C_QUIET1_RX_BIS_DETECT_C_COMB_WAIT;
#endif
      }

      gs_RxSubStateCnt++;


#endif // #ifndef HW_SNR_FDQ

      break;

#ifndef DANUBE_TEMP
#if defined(INFINEON) && defined(ISDN) && defined(AMAZON_AFE)
      // 235 frames available after the QLN computation

   case R_C_QUIET1_RX_BIS_DETECT_VDSL2_OOB:
      if ((guc_HandshakeDone == TRUE) &&        // Wait for any backgd tasks to complete.
         (guc_BkgdTaskState == TRAINING_DONE) &&
         (guc_SnrCalcState == TRAINING_DONE))
      {
         gs_RxSubStateCnt++;

         // Strong Noise detected
         if (gs_RxAvNoisePSD <= -135)
            gft_LowAvgNoise = TRUE;
         else
            gft_LowAvgNoise = FALSE;

         if (gft_LowAvgNoise == TRUE)
            s_VDSL_OOB_Th = 0x0600; // 6dB Threshold
         else
            s_VDSL_OOB_Th = 0x0280; // 2.5dB Threshold

         if(gs_RxSubStateCnt == 1)  // set decimator to 4, to measure out of band noise
         {
            // set decimator setting to 4
            SetAmznAFE_RXFILT(4);
            gl_Pa = 0;
         }

         else if((gs_RxSubStateCnt > (NUM_MINFRAME_AFESETTLE + 1))&&(gs_RxSubStateCnt <= (NUM_MINFRAME_AFESETTLE + NUM_FRAMESNOISEAC_VDSL2OOB + 1))) // 32 frames
         {
            //Average noise for 32 frames
            /*  accumulate received power */
            gl_Pa += VectorPower(gsa_RxToneBuf, 0, gs_RxSamplesPerFrame, (int16)(gs_Log2RxSamplesPerFrame+NUM_LOG2FRAMESNOISEAC_VDSL2OOB));

            if (gs_RxSubStateCnt == NUM_MINFRAME_AFESETTLE + NUM_FRAMESNOISEAC_VDSL2OOB + 1) //(5+32-1)
            {
               gs_SignalPowerVDSL2OOB = ConvertToDB(gl_Pa);
            }
         }

         //Repeat the above process for DEC->6
         else if(gs_RxSubStateCnt == (NUM_MINFRAME_AFESETTLE + NUM_FRAMESNOISEAC_VDSL2OOB + 2))
         {
            // set decimator setting to 6
            SetAmznAFE_RXFILT(6);

            gl_Pa = 0;
         }

         else if((gs_RxSubStateCnt > ((NUM_MINFRAME_AFESETTLE <<1 )+ NUM_FRAMESNOISEAC_VDSL2OOB + 2) )&&(gs_RxSubStateCnt <= (((NUM_MINFRAME_AFESETTLE + NUM_FRAMESNOISEAC_VDSL2OOB )<<1) + 2) ) )
         {
            //Average noise for 32 frames
            /*  accumulate received power */
            gl_Pa += VectorPower(gsa_RxToneBuf, 0, gs_RxSamplesPerFrame, (int16)(gs_Log2RxSamplesPerFrame + NUM_LOG2FRAMESNOISEAC_VDSL2OOB));
            if (gs_RxSubStateCnt == (((NUM_MINFRAME_AFESETTLE + NUM_FRAMESNOISEAC_VDSL2OOB )<<1) + 2) )     //(42+32-1)
            {
               //compute the power in the signal
               gs_Dec6SignalPowerVDSL2OOB = ConvertToDB(gl_Pa);


               s_SignalPowerVDSL2OOB = gs_SignalPowerVDSL2OOB - gs_Dec6SignalPowerVDSL2OOB;

               if(s_SignalPowerVDSL2OOB > s_VDSL_OOB_Th)
               {
                  gft_VDSL2OOB_Noise = TRUE;
                  guc_PGAmarginForVDSL2OOB = 2;
               }

               gs_RxSubStateCnt = 0;
               gs_RxSubState = R_C_QUIET1_RX_BIS_DETECT_C_COMB_WAIT;
            }
         }
      }

      break;
#endif
#endif
   /* ==================================================================== */
   /* Wait to Detect C-COMB symbol */
   /* ==================================================================== */
   case R_C_QUIET1_RX_BIS_DETECT_C_COMB_WAIT:

      if ((guc_HandshakeDone == TRUE) &&        // Wait for any backgd tasks to complete.
         (guc_BkgdTaskState == TRAINING_DONE) &&
         (guc_SnrCalcState == TRAINING_DONE) &&
         (gl_RxSymbolCount >= gt_StateMachCntrl.l_RXCurrentStateLen))
      {

         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_RestoreHyb_QlnHlog);

#ifndef ISDN
         //XDSLRTFW-3602  (start)
         ft_CTune_Adapt = FALSE;
         // Since at long loops ANNEXL will be selected, performance is already
         // lower at ANNEXL loops, So don't need CTune changes
         // Currently only for BDCM 5A mode at 12kft 750 BT loop tested
         // Other 5A modes to be verified,VINAX2 Rev2 not switching to AnnexL

         //XDSLRTFW-3618 /XDSLRTFW-3619 (start)
         // With CNXT DSLAMs BT loops US Rates are better and DS rates are less
         // Use CTune value of 14 @BT loops to gain DS data rates.
         ft_AWGN130_140Noise = FALSE;
         // Check the AWGN -140 set or not
         if ((STATArray[STAT_Performance] == STAT_M140WhiteNoise)
              ||(STATArray[STAT_Performance] == (STAT_M140WhiteNoise|STAT_M130M140WhiteNoise))
             )
         {
            ft_AWGN130_140Noise = TRUE;
         }
         // BDCM goes with 5A mode around 12kft 250 BT, other DSLAMs with 3A mode.
         // ToDo: need to revisit filters have changed, LL API changes have come in
         if((gl_SelectedMode & MODE_G992_5)
            &&(gl_SelectedMode & ANNEX_A)
           )
         {
            if((gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_CTune14_5A)
               &&(ft_AWGN130_140Noise == TRUE)
               &&(gs_CurrentCoChipset == BDCM_CO_CHIPSET)
               &&(gus_XtalkLowerThan_m138dBmHz < NO_CTUNE_AWGN_140_THR)
              )
            {
               gus_ctune_poco_bin = 0xE;
               ft_CTune_Adapt = TRUE;
            }
         }
         //use C tune values for 3A mode in RA cases
         if((gl_SelectedMode & ANNEX_A)
            &&(gl_SelectedMode & MODE_G992_3)
           )
         {
            ft_CTune_Adapt = TRUE;
         }
         //For All 3A modes go with Ctune -12,
         us_CTune_12kft_above = 0xC;
         s_hsk_power_12kft_above = MINIMUM_GHS_TONE_PWR_CTune12;

         // For CNXT DSLAM Ctune -14 above 12kft loops
         if((gs_CurrentCoChipset == GSI_CO_CHIPSET)
             &&(gus_XtalkLowerThan_m138dBmHz < NO_CTUNE_AWGN_140_THR)
             &&(ft_AWGN130_140Noise == TRUE)
            )
         {
            us_CTune_12kft_above = 0xE;
            s_hsk_power_12kft_above = MINIMUM_GHS_TONE_PWR_FINETUNE_CTune14;
         }
         //XDSLRTFW-3618 /XDSLRTFW-3619 (end)

         // for all CO chipsets 24HDSL noise cases disable CTune forcing
         if(gft_24HDSLNoise == TRUE)
         {
            ft_CTune_Adapt = FALSE;
         }
         if((gl_SelectedMode & ANNEX_A)&&(ft_CTune_Adapt == TRUE))
         {
            // Ctune 14 for HSK power < 3000 by default for all DSLAMs around 17.5kft for 3A modes
            if (gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_CTune14)
            {
               gus_ctune_poco_bin = 0xE;
               if (gusa_AfeChipId[1] == 2) //A21 chip
               {
                  gusa_InitHybridSettings= &gusa_A21_HybridSetting_ADSL_A_17kft[0][0];
               }
            }
            // Ctune 12 for HSK power < 8600 (for CNXT use Ctune value 14 from 12kft BT loops onwards)
            else if(gs_hsk_tone_power_dB < s_hsk_power_12kft_above)
            {
               gus_ctune_poco_bin = us_CTune_12kft_above;
            }
         }
#if 0
         //For 3L BT loops with CNXT DSLAM Ctune -14,
         if((gs_CurrentCoChipset == GSI_CO_CHIPSET)
             &&(gus_XtalkLowerThan_m138dBmHz < NO_CTUNE_AWGN_140_THR)
             &&(ft_AWGN130_140Noise == TRUE)
             &&(gs_hsk_tone_power_dB < 5000)//4300 for 15kft 1500 BT
             &&(gl_SelectedMode & ANNEX_L)
            )
         {
            gus_ctune_poco_bin = 0xE;
            //gusa_InitHybridSettings= &gusa_A21_HybridSetting_ADSL_A_17kft[0][0];
         }
#endif
         if(gs_ctune_poco_bin_force >=0)
         {
            gus_ctune_poco_bin = (uint16)(gs_ctune_poco_bin_force & 0x000F);
         }
         vrx5afe_c_tune(gus_ctune_poco_bin & 0x000F);
         //XDSLRTFW-3602  (end)
         //XDSLRTFW-3674 Options_For_debug(start)
         //BT loops hybrid table switching
         //XDSLRTFW-3674 CNXT_E67_IOP_Txfilter_changes
         if( ((gl_SelectedMode & (ANNEX_A|ANNEX_L))
              &&(ft_AWGN130_140Noise == TRUE)
              &&(gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_6kft_THR_ADSL2p_LLAPI) // helps to improve DS rate
              &&(gt_INFX_CMV.s_HybTablesSwitch & 0x0001))
            ||(gs_HybTableForce == 3)
         )
         {
            if(gs_HybTrIndexDbg == 0)
            {
               memcpy(&gusa_A21_HybridSetting_ADSL_A_BTLOOPS[0][0],gsa_NMS_Force,4*2);
            }
            gusa_InitHybridSettings= &gusa_A21_HybridSetting_ADSL_A_BTLOOPS[0][0];
            guc_HybTable = 3;
         }
         if(gs_HybTableForce == 2)
         {
            if(gs_HybTrIndexDbg == 0)
            {
               memcpy(&gusa_A21_HybridSetting_ADSL_A_17kft[0][0],gsa_NMS_Force,4*2);
            }

            gusa_InitHybridSettings= &gusa_A21_HybridSetting_ADSL_A_17kft[0][0];
            guc_HybTable = 2;
         }
         if(gs_HybTableForce == 1)
         {
            if(gs_HybTrIndexDbg == 0)
            {
               memcpy(&gusa_A21_HybridSetting_ADSL_A[0][0],gsa_NMS_Force,4*2);
            }

            gusa_InitHybridSettings= &gusa_A21_HybridSetting_ADSL_A[0][0];
            guc_HybTable = 1;
         }
         //XDSLRTFW-3674 Options_For_debug(end)
#endif

#ifdef DANUBE_AFE
            //re-enable tx shaper
         WriteAfe(DANUBEA_SOFT_RESETS, 0x0000);
            // retore hyb hpf with setting from afeini
            WriteAfe(DANUBEA_HYB_SET_A, gs_HybA);
         WriteAfe(DANUBEA_HYB_SET_B, gs_HybB);
         /* Turn HPF on and equalizer off and set HPF corner frequency x. */
         gs_HPFEq_Reg_Setting = gs_HPF_init; //0x0001;
         WriteAfe(DANUBEA_HPF_EQ_SET,gs_HPFEq_Reg_Setting);
#endif


         /* Attempting Diag Mode */
         if(STATArray[STAT_MacroState] == STAT_LoopDiagMode)
         {
            gt_StateMachCntrl.l_RXCurrentStateLen = R_C_QUIET1_MAX_RX_LEN_BIS_DIAG - 1;
         }
         /* Attempting Data Mode */
         else
         {
            /* Attempting a Short Initialization */
            if (gl_SelectedMode & LINK_SHORTINIT)
            {
               gt_StateMachCntrl.l_RXCurrentStateLen = R_C_QUIET1_BIS_SI_TIMEOUT_LEN;
            }
            /* Attempting a Full Initialization */
            else
            {
               gt_StateMachCntrl.l_RXCurrentStateLen = R_C_QUIET1_MAX_RX_LEN_BIS - 1;
            }
         }
         gs_RxSubState = R_C_QUIET1_RX_BIS_DETECT_C_COMB;


      }
      break;

   /* ==================================================================== */
   /* Detect C-COMB symbol */
   /* ==================================================================== */
   case R_C_QUIET1_RX_BIS_DETECT_C_COMB:

      if (gs_RxSubStateCnt == 0)
      {
         gs_avg_first_channel = gsa_Inspected_COMB_Subcarriers[0] - HALF_DETECT_BAND;
         gs_avg_last_channel = gsa_Inspected_COMB_Subcarriers[NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2-1] + HALF_DETECT_BAND;
         gs_avg_num_channels = gs_avg_last_channel - gs_avg_first_channel + 1;

         gs_TrainCnt =0;
         gs_RxDetectCnt = 0;
         // Initialize BgDetectMultiTones state.
         guc_BkgdTaskState = TRAINING_DONE;
         gft_BgDetectMultiTonesResult = 0;

         // Recalibrate PGA. Set PGA to Max
         memset(gla_RxAccumBuf, (int16)0, sizeof(int32)*(gs_RxNumTones*2));
         //SetInitialPgaToMax() ;
         int16 s_PGA;
         s_PGA = AFED_SetInitialPgaToMax();
         SetTDQtoUnity(); // Also resets TDQ to unity scaling.
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECTDQ);
         guc_PgaTrainingState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgPGA);
         gs_SetPgaForTones_State = SETPGATONES_CHECKLEVEL;
         gs_RxSubStateCnt++;
         break;
      }
      else if (gs_RxSubStateCnt == 1)
      {
         if (guc_PgaTrainingState == TRAINING_DONE)
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
            gs_RxSubStateCnt++;
         }
         break;
      }
      // When gs_RxSubStateCnt > 1, run the set PGA state machine.
      else
      {
         SetPgaForToneDetection();
      }

      if ((guc_BkgdTaskState == TRAINING_DONE) && (gs_RxDetectCnt < gs_ChanDiscDetCnt))
      {  // Check if BgDetectMultiTones has completed.
         gs_TrainCnt++;

         if(gs_TrainCnt == 1)
         {
            if (gft_BgDetectMultiTonesResult)
            {
               gs_RxDetectCnt++;     /*  C-COMB symbol present, inc its counter */
            }
            else
            {
               for(i=0; i<NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2; i++)
                  gsa_CombToneDetCnt[i] = 0;

               gs_RxDetectCnt = 0;
            }
         }

         if(gs_TrainCnt <= gs_R_C_COMB1_AC_LEN_BIS)
         {
            Accum16to32((int32 *)gla_RxAccumBuf, (int16) (2*gs_avg_first_channel),
            gsa_RxToneBuf, (int16) (2*gs_avg_first_channel), (int16)(2*gs_avg_num_channels));
         }

         if(gs_TrainCnt == gs_R_C_COMB1_AC_LEN_BIS)
         {
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgDetectMultiTones_Comb);
            guc_BkgdTaskState = TRAINING_IN_PROGRESS;

            gs_TrainCnt = 0;
         }
      }


      if (gs_RxDetectCnt >= gs_ChanDiscDetCnt)
         ft_DetectCntThresholdMet = 1;
      else
         ft_DetectCntThresholdMet = 0;

// XDSLRTFW-2510 : PCB_and_QLN_optimization_oISDN (Start)
#ifdef ISDN
      // If R_C_COMB_QUIET_TRANSITIONS_CNT_BIS consecutive C-COMB symbols are detected, and if the PGA setting is OK,
      // then transition to the next state.

      if(ft_DetectCntThresholdMet && (gs_SetPgaForTones_State == SETPGATONES_LEVEL_OK))
      {
         gs_PGA_required_In_RCComb1 = gs_PGA_required + (6*(14 - gs_pre_tdq_h_exp)<<8);

         // PERF_DS_PLUS_ALL_GeneralizedPcb (Start)
         // LoopLengthEstimation - Fine tuning
         int16 s_CombMaxAmplitude = 0, s_CombTonesConsidered, *psa_Tone, s_index;
         int16 s_value, s_value1, s_ExtraPGABoostRequired;

         if (gft_ANFPNotchPresent == 0) // Test other than cabinet mode
         {
             if ((gl_SelectedMode & (MODE_G992_5)) != 0)
             {
                 s_CombTonesConsidered = NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2PLUS; // use 22 for ADSL2+
             }
             else
             {
                 s_CombTonesConsidered = 12; // use comb tones upto 200th bin.
             }

             // Max value of signal amplitude on all tones is available in
             // "gs_MaxFreqDomainValue".
             // Add logic to check for max amplitude on comb tones only between 32 to 256 in
             // AnnexA mode
             for (i = 0; i < s_CombTonesConsidered; i++)
             {
                 psa_Tone = gpsa_RxToneBuf_sav; // gpsa_RxToneBuf_sav pointer is initialized in
                 // SetPgaForToneDetection()
                 s_index = gsa_Inspected_COMB_Subcarriers[i];
                 psa_Tone += (2 * s_index);
                 // FFT Real amplitude on comb tone
                 s_value = *psa_Tone++;
                 if (s_value < 0)
                     s_value = -s_value;
                 // FFT Imaginary amplitude on com tone
                 s_value1 = *psa_Tone;
                 if (s_value1 < 0)
                     s_value1 = -s_value1;
                 // Take Max(FFT_Real, FFT_Imag)
                 if (s_value < s_value1)
                     s_value = s_value1;
                 if (s_CombMaxAmplitude < s_value)
                     s_CombMaxAmplitude = s_value;
             }

             // loop length estimation logic
             // LoopLengthEstimation
             // Logic for loop length estimation using PGA set value and the head room present on
             // a tone with max amplitude
             // Find the head room with respect to reference constellation point 0x2000
             gl_Pa = (0x2000) * (0x2000);    // 0x2000 is a reference constellation point to which
                                             // PGA is set during R-C-COMB1 for BIS/PLUS
             s_ExtraPGABoostRequired = ConvertToDB(gl_Pa); // returns value in 8.8. format
             //XDSLRTFW-3290
             //"gs_pre_tdq_h_exp" consider digital cutback for short loops
             // 15 => dervied experimentally to match VR9
             gs_PGAforLoopLengthEstimation = (gs_PGA_set >> 8)+(6*(14 - gs_pre_tdq_h_exp))+15;
             gl_Pa = (s_CombMaxAmplitude * s_CombMaxAmplitude);
             s_ExtraPGABoostRequired -= ConvertToDB(gl_Pa);
             s_ExtraPGABoostRequired = (s_ExtraPGABoostRequired >> 8);
             gs_PGAforLoopLengthEstimation += s_ExtraPGABoostRequired;
         }
         // PERF_DS_PLUS_ALL_GeneralizedPcb (End)

         // XDSLRTFW-3487 VRx518 / No connect in Annex J with DPBO 70 profile (Start)
         // CO- and CPE-training statemachines get out of sync in ADSL2+ training because BRCM CO does
         // transition from QUIET5 to REVERB3 too early
         // It seems that CO detects its own signal - especially the tssi-shaped out of band signal on
         // US tones (tones 32-63)
         // The issue is seen only with VRx518 based boards - not with VR9/VRx318 or BRCM CPEs
         // Current assumption is that the termination of the line is slightly different on VRx518 boards
         // resulting in a different echo attenuation on CO side on very short loops
         // Fix on CPE side:
         // Disable out of band signal on US frequencies by sending out Blackout-tones for tones
         // in the US band
         // fix is limited to 1000m (for longer loops the line impedance is dominating - not the AFE)
         // Threshold for looplength is set to <1100m to reduce the number of different thresholds (the same
         // threshold is already used in function BgComputeDsPCB for DS PCB calculation
         if (    ((gl_SelectedMode & (ANNEX_B)) || (gl_SelectedMode & (ANNEX_J)))
               && (gl_SelectedMode & (MODE_G992_5))
               && (gs_CurrentCoChipset == BDCM_CO_CHIPSET)
               && (gs_hsk_tone_power_dB_PCB > gs_hsk_tone_power_threshold))
         {
            //guca_dbg_BlackOutTones
            guca_RMsgPCBTab[4+4] = guca_dbg_BlackOutTones[0]; //blackout tones 32..39
            guca_RMsgPCBTab[4+5] = guca_dbg_BlackOutTones[1]; //blackout tones 40..47
            guca_RMsgPCBTab[4+6] = guca_dbg_BlackOutTones[2]; //blackout tones 48..55
            guca_RMsgPCBTab[4+7] = guca_dbg_BlackOutTones[3]; //blackout tones 56..63
         }
         // XDSLRTFW-3487 VRx518 / No connect in Annex J with DPBO 70 profile (End)

         // XDSLRTFW-1832 (Start)
         // Sync loss with IUVDSL48J3 on 3.8km in 5J mode
         // Synch loss was due to DS SES, -ve margin was observed on initial tones 61-63 which were loaded with some bits
         // causing DS CRCs. Blacked-out those tones for higher loop > 3700 meters.
         if (   (gl_SelectedMode & (ANNEX_J))
             && (gl_SelectedMode & (MODE_G992_5))
             && (gs_CurrentCoChipset == IFTN_CO_CHIPSET))
         {
            int16 s_majorVer = ((gs_CurrentCoVendorID >> 12) & 0xf);
            // Vinax firmware numbers (B.x.xx)
            if ((s_majorVer == 0xB))
            {
               if ( gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_AT_3400M) // only for loops > 3700m
               {
                  guca_RMsgPCBTab[4+7] = 0xff; //blackout tones 56..63
               }
            }
         }
         // XDSLRTFW-1832 (End)

         if(OPTNArray[OPTN_AlgControl3] & CMV_TO_ENABLE_DTAG_US_PERF_DS_PERF)
         {
            // IOP_US_BISPLUS_BRCM_IncreaseUSperfByDSBlackout (Start)
            /* workaround for longer Loop  upstream improvement with a broadcom annexB modem */
            if(   (gl_SelectedMode & ANNEX_B)
               && (gs_CurrentCoChipset == BDCM_CO_CHIPSET)                          //  check the provider field (4 bytes)
               && (guca_fe_G9941_VendorID[0] == ERICSSON312_VENDORCODE_OCT0 )        //  check the country
               && (guca_fe_G9941_VendorID[6] == ERICSSON312_VENDORCODE_OCT6 )        //  check the vendor info
               && ((STATArray[STAT_Performance] & STAT_FBNoiseLowThreshold)==0)      //  don't apply fix if FB noise present
               && ((TESTArray[31] & 1) != 1))                              // disable if TEST 31 = 1.
            {
               FlagT ft_raBis1; // limit changes to rate adaptive settings.
               ft_raBis1 = checkRateAdaptive();   // function is at bottom of file.
               if ( ft_raBis1 )
               {
                  if (guca_fe_G9941_VendorID[7] == ERICSSON312_VENDORCODE_OCT7_W303QUAL )   //  check the vendor info
                  {
                     if ( gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_AT_1700M)  //>1700M    1700M-3549 1800m-33B0
                     {  // n = n*8
                        guca_RMsgPCBTab[4+7] = 0xff; //blackout tones 56..63
                        guca_RMsgPCBTab[4+8] = 0xff; //blackout tones 64..71
                        guca_RMsgPCBTab[4+9] = 0xff; //blackout tones 72..79
                     }
                     else if ( gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_AT_1400M )  //>1400M // if > 25dB
                     {  // n = n*8
                        guca_RMsgPCBTab[4+7] = 0xff; //blackout tones 56..63
                        guca_RMsgPCBTab[4+8] = 0xff; //blackout tones 64..71
                     }
                     else if ( gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_AT_1200M )  //>1200M    // if > 23dB
                     {  // n = n*8
                        guca_RMsgPCBTab[4+7] = 0xff; //blackout tones 56..63
                        guca_RMsgPCBTab[4+8] = 0x0f; //blackout tones 64..67
                     }
                     else if ( gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_AT_1100M )  //>1100M    // if > 20dB
                     {  // n = n*8
                        guca_RMsgPCBTab[4+7] = 0xff; //blackout tones 56..63
                     }
                  }
                  else // use this as default:  if (guca_fe_G9941_VendorID[7] == ERICSSON312_VENDORCODE_OCT7_W503QUAL )  //  check the vendor info
                  {
                     if ( gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_AT_3200M ) //>3400M 3400M-0x1c7b  //DTAG 1A3E
                     {  // n = n*8
                        guca_RMsgPCBTab[4+7] = 0xff; //blackout tones 56..63
                        guca_RMsgPCBTab[4+8] = 0xff; //blackout tones 64..71
                        guca_RMsgPCBTab[4+9] = 0x0f; //blackout tones 72..75
                     }
                     else if ( gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_AT_3000M ) //>3000M 3000M-0x20E3 3100M-1F55 //DTAG 0x20A4
                     {  // n = n*8
                        guca_RMsgPCBTab[4+7] = 0xff; //blackout tones 56..63
                        guca_RMsgPCBTab[4+8] = 0xff; //blackout tones 64..71
                        guca_RMsgPCBTab[4+9] = 0x03; //blackout tones 72..73
                     }
                     else if ( gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_AT_2500M ) //>2500M 2500M-28e0 2600M-273d  dtag 0x2896
                     {  // n = n*8
                        guca_RMsgPCBTab[4+7] = 0xff; //blackout tones 56..63
                        guca_RMsgPCBTab[4+8] = 0xff; //blackout tones 64..71
                     }
                     else if ( gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_AT_2200M ) //>2200M 2200M-0x2d76 2300-2Be8
                     {  // n = n*8
                        guca_RMsgPCBTab[4+7] = 0xff; //blackout tones 56..63
                        guca_RMsgPCBTab[4+8] = 0x3f; //blackout tones 64..69
                     }
                     else if ( gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_AT_2100M ) //>2100 2100M-2EEC 2200-2D76
                     {  // n = n*8
                        guca_RMsgPCBTab[4+7] = 0xff; //blackout tones 56..63
                        guca_RMsgPCBTab[4+8] = 0x0f; //blackout tones 64..67
                     }
                     else if ( gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_AT_1700M )  //>1700M    1700M-3549 1800m-33B0
                     {  // n = n*8
                        guca_RMsgPCBTab[4+7] = 0xff; //blackout tones 56..63
                        guca_RMsgPCBTab[4+8] = 0x03; //blackout tones 64..65
                     }
                  }
               }// if raBis
            }
            // IOP_US_BISPLUS_BRCM_IncreaseUSperfByDSBlackout (End)
         }

         // For all Geminax FWs, in 2+ mode require 3 dB DS power cutback upto 1 km loop to enhance the
         // DS performence (by disabling the PAR tones) and at least 1dB DS Power cutback at all the other loops
         // for Geminax 7.11 & 7.12 FW  to enhance the US performence (by reducing echo).
         // except if it is a cabinet mode application where tones start above 255.
         if ((gs_CurrentCoChipset == IFTN_CO_CHIPSET) && (gs_firstSupportedTone < 255))
         {
            s_majorVer = ((gs_CurrentCoVendorID>>12)&0xf);
            s_minorVer = ((gs_CurrentCoVendorID>>4)&0xff);
            //ADSLRTFW-1580 Perf_DS_BisPlus_ALL_ImpDsPcb (Start_End) // This was using 1900m

            if (    (guca_fe_G9941_VendorID[6] ==  VINAX_FW_VERSION_10_6_BYTE6)
                 && (guca_fe_G9941_VendorID[7] ==  VINAX_FW_VERSION_10_6_BYTE7)
            )
            {
               gft_M140WhiteNoise = gft_M130WhiteNoise;
               if (STATArray[STAT_Performance] & STAT_M130WhiteNoise)
               STATArray[STAT_Performance] |= STAT_M140WhiteNoise;
            }

            // IOP_DS_ALL_IFTN_VINAX_NO_PILOT_ON_PAR_TONE (START_END)
            if ((s_majorVer == 0xB) || (s_majorVer == 0xC))
               gs_MaxAuxPilotToneIdx = 208;

         }
         // XDSLRTFW-2xxx (End)

         s_max = 0;
         for(i=0; i<NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2; i++)
         {
            if(gsa_CombToneDetCnt[i] >= s_max)
            {
               s_max = gsa_CombToneDetCnt[i];
               gs_ChosenPilot_preSNR = gsa_Inspected_COMB_Subcarriers[i];
            }
         }

         /* Compute scaling for gs_ChosenPilot_preSNR */
         PllScalingCalc(gs_ChosenPilot_preSNR, &gs_PllScaling_bis_preSNR);

         /* Update Pilot Tone */
         gs_PilotToneIdx = gs_ChosenPilot_preSNR;

         gs_NumCombSubcarriersInspected = 0;
         for(i=0; i<NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2; i++)
         {
            if(gsa_CombToneDetCnt[i] >= (gs_ChanDiscDetCnt-1))
            gsa_Inspected_COMB_Subcarriers[gs_NumCombSubcarriersInspected++] = gsa_Inspected_COMB_Subcarriers[i];
         }

         if(gs_NumCombSubcarriersInspected == 0)
            gs_NumCombSubcarriersInspected = 1;

         gs_NumCombSubcarriersRequired = (gs_NumCombSubcarriersInspected+1)>>1;

         gs_TrainCnt = 0;
         guc_SnrCalcState = TRAINING_WAITING;              /*  reset SNR calculation status flag */
         gs_RxNextState = R_C_COMB1_RX_BIS;
         gpF_RxStateFunc = (PtrToFunc)RCComb1RxF_BIS;

      }

      // IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz IOP_DS_ALL_VINAX_ClearNomPSDRequirement IOP_US_ALL_VINAX_DSPCB2IncreaseUSperf(Start)
      if ((gs_CurrentCoChipset == IFTN_CO_CHIPSET) && (guca_fe_G9941_VendorID[6] ==  VINAX_FW_VERSION_10_6_BYTE6) && (guca_fe_G9941_VendorID[7] ==  VINAX_FW_VERSION_10_6_BYTE7) )
      {
         // Workaround for false configuration of VINAX 10.6 based SAG5630 DSLAM
         // In DTAG lab SAG5630 shows very low DS rate because of CO-requested -16dB nomPSD
         // Behaviour in DTAG lab:
         //    1st training:  CO uses normal configuration (nomPSD = 0dB)
         //                   CO drops the link in exchange (probably because of bug in actATP calculation
         //                         the calculated DS power seems to be 13dB to 18dB too high
         //    2nd training:  CO starts link with reduced tx-power (nomPSD = -13dB...-18dB)
         // Workaround:
         //    The CPE reboots 'only' with this special case, wherein during the first training the CO
         //    sends DS NOMPSD=0 'AND' the second retrain it sends NOMPSD<0. Its a strange bug seen only
         //    in the field for Vinax and not on the development platform!
         //    Drop link in 2nd training after G.Hs
         //    in this case it seems to be that the nomPSD level is again overwritten to 0dB
         //    according to VINAX team the CO always comes to showtime in the 2nd link - there is addtional check for ATP
         if ((gt_TxPMDControl.s_NOMPSD_DS < 0) && (gs_Persis_PrevDSNomPSD==0))
         {
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* Set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_Vinax_DSNomPSDBug;
            //XDSLRTFW-654 XDSLRTFW-248 Bug_DS_All_All_IntentionalReTrainToReduceTrainTime (Start_End)
            guc_Forced_Retrain = 0x3;
         }
         gs_Persis_PrevDSNomPSD = gt_TxPMDControl.s_NOMPSD_DS;

      }
      // IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz IOP_DS_ALL_VINAX_ClearNomPSDRequirement IOP_US_ALL_VINAX_DSPCB2IncreaseUSperf (End)

      if(gl_RxSymbolCount >= (gt_StateMachCntrl.l_RXCurrentStateLen + BIS_TIME_OUT_LENGTH) && !gft_dbgDisableTimeout)
      {
         gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

         /* Set exception handler variables */
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_RCQuietRx_Bis_TIME_OUT;
      }
      break;
// XDSLRTFW-2510 : PCB_and_QLN_optimization_oISDN (End)
#else    // end of #ifdef ISDN - now the POTS part follows
      // If R_C_COMB_QUIET_TRANSITIONS_CNT_BIS consecutive C-COMB symbols are detected, and if the PGA setting is OK,
      // then transition to the next state.

      if(ft_DetectCntThresholdMet && (gs_SetPgaForTones_State == SETPGATONES_LEVEL_OK)) {
         gs_PGA_required_In_RCComb1 = gs_PGA_required +(6*(14 - gs_pre_tdq_h_exp)<<8);
         gs_PGA_required_In_RCComb1 = gs_PGA_required_In_RCComb1+gs_PGA_required_In_RCComb1_Comp;//XDSLRTFW-3261

            // PERF_DS_PLUS_ALL_GeneralizedPcb (Start)
            // LoopLengthEstimation - Fine tuning
            int16 s_CombMaxAmplitude = 0, s_CombTonesConsidered, *psa_Tone, s_index;
            int16 s_value, s_value1, s_ExtraPGABoostRequired;

            if (gft_ANFPNotchPresent == 0) // Test other than cabinet mode
            {
                if ((gl_SelectedMode & (MODE_G992_5)) != 0)
                {
                    s_CombTonesConsidered =
                    NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2PLUS;
                }
                else
                {
                    s_CombTonesConsidered = 12; // use comb tones upto 200th bin.
                }

                // Max value of signal amplitude on all tones is available in
                // "gs_MaxFreqDomainValue".
                // Add logic to check for max amplitude on comb tones only between 32 to 256 in
                // AnnexA mode
                for (i = 0; i < s_CombTonesConsidered; i++)
                {
                    psa_Tone = gpsa_RxToneBuf_sav; // gpsa_RxToneBuf_sav pointer is initialized in
                    // SetPgaForToneDetection()
                    s_index = gsa_Inspected_COMB_Subcarriers[i];
                    psa_Tone += (2 * s_index);
                    // FFT Real amplitude on comb tone
                    s_value = *psa_Tone++;
                    if (s_value < 0)
                        s_value = -s_value;
                    // FFT Imaginary amplitude on com tone
                    s_value1 = *psa_Tone;
                    if (s_value1 < 0)
                        s_value1 = -s_value1;
                    // Take Max(FFT_Real, FFT_Imag)
                    if (s_value < s_value1)
                        s_value = s_value1;
                    if (s_CombMaxAmplitude < s_value)
                        s_CombMaxAmplitude = s_value;
                }

                // loop length estimation logic
                // LoopLengthEstimation
                // Logic for loop length estimation using PGA set value and the head room present on
                // a tone with max amplitude
                // Find the head room with respect to reference constellation point 0x2000
                gl_Pa = (0x2000) * (0x2000);    // 0x2000 is a reference constellation point to which
                                                // PGA is set during R-C-COMB1 for BIS/PLUS
                s_ExtraPGABoostRequired = ConvertToDB(gl_Pa); // returns value in 8.8. format
                //XDSLRTFW-3290
                //"gs_pre_tdq_h_exp" consider digital cutback for short loops
                // 15 => dervied experimentally to match VR9
                gs_PGAforLoopLengthEstimation = (gs_PGA_set >> 8)+(6*(14 - gs_pre_tdq_h_exp))+15;
                gl_Pa = (s_CombMaxAmplitude * s_CombMaxAmplitude);
                s_ExtraPGABoostRequired -= ConvertToDB(gl_Pa);
                s_ExtraPGABoostRequired = (s_ExtraPGABoostRequired >> 8);
                gs_PGAforLoopLengthEstimation += s_ExtraPGABoostRequired;
            }
            // PERF_DS_PLUS_ALL_GeneralizedPcb (End)

         //If there is a notch existing in the supported set, have a look-up PCB table to adjust the default PCB
         if (gft_NotchPresent)
            gs_PcbDsDeltaForNotch = HamBandNotchPCBAjustment();
         //Add 2dB PGA margin for ANFP short loop (0~6kft, PGA required in RCComb1 < 30dB)
         if (gft_ANFPNotchPresent && (gs_PGA_required_In_RCComb1 < 0x1E00))
            gs_PGA_margin += 0x200;

        // IOP_DS_ALL_IFTN_VINAX_NO_PILOT_ON_PAR_TONE (START)
         if (gs_CurrentCoChipset == IFTN_CO_CHIPSET)
         {
            s_majorVer = ((gs_CurrentCoVendorID >> 12) & 0xf);

            if ((s_majorVer == 0xB) || (s_majorVer == 0xC))
            {
               gs_MaxAuxPilotToneIdx = 208;
            }
         }
         // IOP_DS_ALL_IFTN_VINAX_NO_PILOT_ON_PAR_TONE (END)
         //XDSLRTFW-2033 (start)
         //long loops chose lower bins for pilot idx.
         int16 s_NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2 = NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2;
#ifndef ISDN
         if((gt_INFX_CMV.us_OperatorSpBits7 & CMV_COMB2_preSNR_Fix)
            ||(gft_CNXT_A_LongLoops == TRUE)
            )
         {
            s_NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2 = 4;
         }
#endif
         //XDSLRTFW-2033 (end)
         s_max = 0;
         for(i=0; i<s_NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2; i++)
         {
              if(gsa_CombToneDetCnt[i] >= s_max)
         {
                s_max = gsa_CombToneDetCnt[i];
            gs_ChosenPilot_preSNR = gsa_Inspected_COMB_Subcarriers[i];
         }
         }

         /* Compute scaling for gs_ChosenPilot_preSNR */
         PllScalingCalc(gs_ChosenPilot_preSNR, &gs_PllScaling_bis_preSNR);

         /* Update Pilot Tone */
         gs_PilotToneIdx = gs_ChosenPilot_preSNR;


         gs_NumCombSubcarriersInspected = 0;
         for(i=0; i<NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2; i++)
         {

              if(gsa_CombToneDetCnt[i] >= (gs_ChanDiscDetCnt-1))
              gsa_Inspected_COMB_Subcarriers[gs_NumCombSubcarriersInspected++] = gsa_Inspected_COMB_Subcarriers[i];
         }

         if(gs_NumCombSubcarriersInspected == 0)
         gs_NumCombSubcarriersInspected = 1;

            gs_NumCombSubcarriersRequired = (gs_NumCombSubcarriersInspected+1)>>1;


         gs_TrainCnt = 0;
         guc_SnrCalcState = TRAINING_WAITING;              /*  reset SNR calculation status flag */
         gs_RxNextState = R_C_COMB1_RX_BIS;
         gpF_RxStateFunc = (PtrToFunc)RCComb1RxF_BIS;

         // Temporary, until we update all f/w code to use gl_SelectedMode instead of STATArray[STAT_Mode] cmv
         if (gl_SelectedMode & LINK_SHORTINIT)
         {
            gft_ModemType = G_DMT_BIS;
            if (gl_SelectedMode & (MODE_G992_3 | ANNEX_A))
            {
               STATArray[STAT_Mode] = STAT_ConfigMode_G992_3_A;
            }
            else if (gl_SelectedMode & (MODE_G992_3 | ANNEX_L))
            {
               STATArray[STAT_Mode] = STAT_ConfigMode_G992_3_L;
            }
            else if (gl_SelectedMode & (MODE_G992_3 | ANNEX_B))
            {
               STATArray[STAT_Mode] = STAT_ConfigMode_G992_3_B;
            }
            else if (gl_SelectedMode & (MODE_G992_5 | ANNEX_A))
            {
               STATArray[STAT_Mode] = (int16)STAT_ConfigMode_G992_5_A;
            }
            else if (gl_SelectedMode & (MODE_G992_5 | ANNEX_B))
            {
               STATArray[STAT_Mode] = STAT_ConfigMode_G992_5_B;
            }
         }
      }
      // IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz IOP_DS_ALL_VINAX_ClearNomPSDRequirement IOP_US_ALL_VINAX_DSPCB2IncreaseUSperf(Start)

        //SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut (START)
        //CNXT D57 proposes higher DS PCB in C_MSG_PCB in short loops.
        //Although ASE sends required R_MSG_PCB based on calculation,
        //D57 always takes the higher one between these two. Therefore,
        //we got no-connect in TR100A2 fixed rate tests in short loops
        //with FB noise. The workaround is to retrain and cut Tx power if
        //CO is CNXT D57, loop length is <= ~750m
        //This fix will improve DS rate performance in short loops against
        //D57 especially with FB noise.
        //SMS00822444 IOP_DS_ADSL1_CTLM_ShortLoopTxPowercut (START)
        //Renamed flag/counter/error code as this logic is applied to other CO
        if ((gs_CurrentCoChipset == GSI_CO_CHIPSET) &&
           (gs_CurrentCoVendorID == 0x0b) &&
           (gs_PGAforLoopLengthEstimation != 0) &&
           (gs_PGAforLoopLengthEstimation <= 13) &&
           gus_shortloop_cutpower == 0)
        {
           //6 dB will be cut if the loop length is <= ~550m
           if (gs_PGAforLoopLengthEstimation <= 4)
             gus_shortloop_cutpower = 6;
           else
           //3 dB will be cut if the loop length is ~550m - ~750m
             gus_shortloop_cutpower = 3;

           gs_RxNextState = FAIL_RX;
           gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;

           /* Set exception handler variables */
           gus_ExceptionState = gs_RxState;
           gus_ExceptionCode = E_CODE_SHORTLOOP_CUTPOWER;
        }
        else if (gus_shortloop_cutpower != 0)
        //clear the flag if condition changes
        {
          //if CO changes or looplength jumps to a longer one(~2000m),
          //retrain to prevent connecting to a low US rate
          if ((gs_CurrentCoChipset != GSI_CO_CHIPSET) ||
             (gs_CurrentCoVendorID != 0x0b) ||
             (gs_PGAforLoopLengthEstimation > 26))
          {
            gus_shortloop_cutpower = 0;
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;

            /* Set exception handler variables */
            gus_ExceptionState = gs_RxState;
            // Used different number to distinguish Code flow
            gus_ExceptionCode = E_CODE_SHORTLOOP_CUTPOWER_NonD57;
          }
          //if looplength jumps to >750m and <2000m, clear the flag
          else if (gs_PGAforLoopLengthEstimation > 13)
            gus_shortloop_cutpower = 0;
        }
        //clear the counter
        gft_shortloop_cutpower_counter = 0;
        //SMS00822444 IOP_DS_ADSL1_CTLM_ShortLoopTxPowercut (END)
      //SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut (END)
      if(gl_RxSymbolCount >= (gt_StateMachCntrl.l_RXCurrentStateLen + BIS_TIME_OUT_LENGTH) && !gft_dbgDisableTimeout){

         // If timeout occured while attempting short initialization
         // try a full initialization in next link
         if (gl_SelectedMode & LINK_SHORTINIT)
         {
            gl_SelectedMode = 0;
         }

         gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

         /* Set exception handler variables */
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_RCQuietRx_Bis_TIME_OUT;
      }
      break;
#endif
   }
}

/**************************************************************************/
/*   Calculation for fixed rate.    copied from bitload_bis.c (jun 2007) */
/**************************************************************************/
FlagT checkRateAdaptive(void) {
   int16 tmp_Nbc;
   int16 tmp_maxdatarate;
   int16 tmp_minnetdatarate ;

         int i;
         tmp_Nbc = 0;// Initialize
         for (i=0; i<NUM_DS_BEARER_CHANNELS_SUPPORTED; i++)
         tmp_Nbc += gt_HandshakeBis.sa_DS_BCActive[i];

            tmp_maxdatarate = 0;
         for(i=0; i < tmp_Nbc; i++)
            tmp_maxdatarate += gt_HandshakeBis.sa_DS_MaxNetDataRateBC[i];


         //take max datarate as minimum of maxratelp or max rate from bc
         if(tmp_maxdatarate >= gt_HandshakeBis.sa_DS_MaxDataRateLP[0])
            tmp_maxdatarate = gt_HandshakeBis.sa_DS_MaxDataRateLP[0];

         // choosing the Max(MinNetRate, ReservedRate) of handsahke
         //as the bitloading MinRate
         if (gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0] < gt_HandshakeBis.sa_DS_MinNetDataRateBC[0])
            tmp_minnetdatarate = gt_HandshakeBis.sa_DS_MinNetDataRateBC[0];
         else
            tmp_minnetdatarate = gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0];


         return( (tmp_maxdatarate - 1  > tmp_minnetdatarate) );

} // end rateAdaptive calculation


#undef R_C_QUIET1_BIS_SI_TIMEOUT_LEN

#undef R_C_QUIET1_RX_BIS_SET_PGA_BEFORE_CALCULATE_QLN_PSD
#undef R_C_QUIET1_RX_BIS_CALCULATE_QLN_PSD
#undef R_C_QUIET1_RX_BIS_WAIT
#undef R_C_QUIET1_RX_BIS_SET512FFT
#undef R_C_QUIET1_RX_BIS_DETECT_C_COMB_WAIT
#undef R_C_QUIET1_RX_BIS_DETECT_C_COMB
#if defined(INFINEON) && defined(ISDN) && defined(AMAZON_AFE)
#undef R_C_QUIET1_RX_BIS_DETECT_VDSL2_OOB
#undef NUM_MINFRAME_AFESETTLE
#undef NUM_FRAMESNOISEAC_VDSL2OOB
#undef NUM_LOG2FRAMESNOISEAC_VDSL2OOB

#endif
