/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RCQuiet3RxF_BIS.c
 * DESCRIPTION:      RX State Function for ATU-R in the C-QUIET1, C-QUIET2
 *                   and C-QUIET3 states of the Channel Discovery
 *                   Phase in G.dmt.bis.
 *
 **********************************************************************/

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "vecpwr.h"
#include "detect.h"
#include "states.h"
#include "RCComb3RxF_BIS.h"
#include "afe.h"
#include "fifo.h"
#include "DecideUSPowerCutback_bis.h"
#include "cmv.h"
#include "memsetbf.h"
#include "hndshk_Data.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

/*^^^
 *---------------------------------------------------------------------
 * Function: RCQuiet3RxF_BIS
 *
 * Description: Implements R_C_QUIET3_RX_BIS states.
 *---------------------------------------------------------------------
 *^^^
 */
#define R_C_QUIET3_RX_BIS_RESET_PGA             (0)
#define R_C_QUIET3_RX_BIS_RESET_PGA_WAIT        (1)
#define R_C_QUIET3_RX_BIS_INITIALIZE1           (2)
#define R_C_QUIET3_RX_BIS_PRE_COMPUTE_HARMONICS (3)
#define R_C_QUIET3_RX_BIS_COMPUTE_HARMONICS     (4)
#define R_C_QUIET3_RX_BIS_RESTORE_PGA           (5)
#define R_C_QUIET3_RX_BIS_RESTORE_PGA_WAIT      (6)
#define R_C_QUIET3_RX_BIS_INITIALIZE2           (7)
#define R_C_QUIET3_RX_BIS_DETECT_COMB3          (8)

void RCQuiet3RxF_BIS(void)
{
   int32 l_temp;

      switch(gs_RxSubState)
      {

      case R_C_QUIET3_RX_BIS_RESET_PGA:

         if((OPTNArray[OPTN_StateMachineCtrl] & OPTN_Skip_RLineProbe) !=0)
         {
            gs_RxSubStateCnt = 0;
               gs_RxSubState = R_C_QUIET3_RX_BIS_DETECT_COMB3;
         }
         else  /* R-LineProbe state is not skipped */
         {
         /* save the current pga value */
         gs_PGA_required_saved = gs_PGA_required;

         /* set the PGA value during lineprobe to a fixed value */
         gs_PGA_required = PGA_DURING_LINEPROBE;
         guc_PgaTrainingState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgPGA);

         gs_RxSubState = R_C_QUIET3_RX_BIS_RESET_PGA_WAIT;
         }
         break;

      case R_C_QUIET3_RX_BIS_RESET_PGA_WAIT:

         if (guc_PgaTrainingState == TRAINING_DONE)
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);

            gs_RxSubStateCnt =0;
            gs_RxSubState = R_C_QUIET3_RX_BIS_INITIALIZE1;
         }
         break;

        case R_C_QUIET3_RX_BIS_INITIALIZE1:

      gs_RxSubStateCnt++;

         if((gs_RxSubStateCnt >= PGA_SETTLING_TIME) && (gs_TxState == R_LINEPROBE_TX_BIS))
         {
               /* Save the current TxSineGain */
            gus_TxSineGain_Before_LineProbe = gus_TxSineGain;
               /* boost gus_TxSineGain by a factor of three here */
               gus_TxSineGain *= LINEPROBE_GAIN_FACTOR;
               guc_lineprobe_iter_cnt = 0;

            /* Go to next substate */
               gs_RxSubState = R_C_QUIET3_RX_BIS_PRE_COMPUTE_HARMONICS;
               gs_RxSubStateCnt = 0;
         }
            break;

      case R_C_QUIET3_RX_BIS_PRE_COMPUTE_HARMONICS:

         gl_Pa = 0;
         gl_Rx_Total_Power = 0;
         gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_QUIET3_RX_BIS_COMPUTE_HARMONICS;
         break;

        case R_C_QUIET3_RX_BIS_COMPUTE_HARMONICS:

         gs_RxSubStateCnt++;

            /* Measure the power of the 2nd and 3rd harmonics of the R_LineProbe signal. */
         gl_Pa += VectorPower(gsa_RxToneBuf, (int16) (2*FIRST_R_LINEPROBE_HARMONIC2_TONE),
                        (int16) (2*NUM_LINEPROBE_HARMONIC2_TONES),
                        LOG2_R_C_LINEPROBE_AC_LEN + LOGNUM_LINEPROBE_HARMONIC_TONES_TOTAL);

         gl_Pa += VectorPower(gsa_RxToneBuf, (int16) (2*FIRST_R_LINEPROBE_HARMONIC3_TONE),
                        (int16) (2*NUM_LINEPROBE_HARMONIC3_TONES),
                        LOG2_R_C_LINEPROBE_AC_LEN + LOGNUM_LINEPROBE_HARMONIC_TONES_TOTAL);


         /* After accumulating energy for R_C_LINEPROBE_AC_LEN frames. */
         if (gs_RxSubStateCnt == R_C_LINEPROBE_AC_LEN) {

            /* Save the power of harmonics of line probe signal. */
            /* Note that value is (actual power >> LOGNUM_LINEPROBE_HARMONIC_TONES_TOTAL). */
            gla_HarmonicsPower[guc_lineprobe_iter_cnt] = gl_Pa;

            guc_lineprobe_iter_cnt++;

            if(guc_lineprobe_iter_cnt < NUM_LINEPROBE_CUTBACK_CNT)
            {
               /* gus_TxGainCutBackFactor is assigned 26029 in InitGlobalvariables(). */
                    /* 26029 represents 10^(-0.1) in the 1.15 format. So 1dB reduction in TxSineGain */
               /* is equivalent to 2dB reduction in US Tx Power */
                    l_temp = (int32)gus_TxSineGain*gus_TxGainCutBackFactor;
                  gus_TxSineGain = (int16)(l_temp >>15);
                    AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);

               gs_RxSubState = R_C_QUIET3_RX_BIS_PRE_COMPUTE_HARMONICS;
            }
            else
            {
               /* Decide the best TX power cutback. Note that the */
               /* stepsize for power reduction in this test is 2dB. */
                    /* DecideUSPowerCutback() will be tested later */
               //  gt_RMsgPcb_bis.us_R_MIN_PCB_US = 2*DecideUSPowerCutback(gla_HarmonicsPower);
               gt_RMsgPcb_bis.us_R_MIN_PCB_US = gs_US_PwrCutback_EchoLoop;

               /* Restore the saved TxSineGain */
                    gus_TxSineGain = gus_TxSineGain_Before_LineProbe;
               AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);

                  gs_RxSubState = R_C_QUIET3_RX_BIS_RESTORE_PGA;
                }


         } /* if (gs_RxSubStateCnt == R_C_LINEPROBE_AC_LEN)   */
         break;

      case R_C_QUIET3_RX_BIS_RESTORE_PGA:

      /* get the saved pga value */
        gs_PGA_required = gs_PGA_required_saved;

      guc_PgaTrainingState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgPGA);
      gs_RxSubState = R_C_QUIET3_RX_BIS_RESTORE_PGA_WAIT;
      break;

   case R_C_QUIET3_RX_BIS_RESTORE_PGA_WAIT:

      if (guc_PgaTrainingState == TRAINING_DONE) {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_QUIET3_RX_BIS_INITIALIZE2;
      }
      break;

    case R_C_QUIET3_RX_BIS_INITIALIZE2:

      gs_RxSubStateCnt++;

      if(gs_RxSubStateCnt == PGA_SETTLING_TIME)
      {
            gs_RxSubState = R_C_QUIET3_RX_BIS_DETECT_COMB3;
            gs_RxSubStateCnt = 0;

        }
        break;


      case R_C_QUIET3_RX_BIS_DETECT_COMB3:

           if (gs_TxState == R_QUIET3_TX_BIS && gl_TxSymbolCount > 3)
           {
         if(DetectMultiTones(gsa_RxToneBuf, gsa_COMB_ICOMB_DetectionBins, guc_NUM_OF_BINS_FOR_COMB_DETECTION,  (int16)((guc_NUM_OF_BINS_FOR_COMB_DETECTION+1)>>1), (int16)(gs_ToneDetectScale*256)) )
            gs_RxSubStateCnt++;     /*  C-COMB3 symbol present, inc its counter */
            else
            gs_RxSubStateCnt = 0;
           }

           if(gs_RxSubStateCnt >= R_C_TRANSITION_CNT_BIS)
           {
               MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*2*gs_RxNumTones));
               //XDSLRTFW-2033 (start)

#ifndef ISDN
               if((gt_INFX_CMV.us_OperatorSpBits7 & CMV_COMBDETECT_Bins_Fix)
                   ||(gft_CNXT_A_LongLoops == TRUE)
                   )
               {
                  int16 j = 0;
                  for(j=0; j<(NUM_OF_BINS_FOR_COMB_DETECTION); j++)
                  {
                     gsa_COMB_ICOMB_DetectionBins[j] = gsa_COMB_ICOMB_DetectionBins_BTLL[j];
                  }
                  guc_NUM_OF_BINS_FOR_COMB_DETECTION = guc_NUM_OF_BINS_FOR_COMB_DETECTION_BTLL;
               }
#endif
             //XDSLRTFW-2033 (end)

            gs_RxNextState = R_C_COMB3_RX_BIS;
            gpF_RxStateFunc = (PtrToFunc)RCComb3RxF_BIS;
         }

         if(gl_RxSymbolCount >= R_C_QUIET3_MAX_RX_LEN_BIS -1 + BIS_TIME_OUT_LENGTH)
         {
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* Set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_RCQuietRx_Bis_TIME_OUT;
         }
         break;

      }

}


#undef R_C_QUIET3_RX_BIS_RESET_PGA
#undef R_C_QUIET3_RX_BIS_RESET_PGA_WAIT
#undef R_C_QUIET3_RX_BIS_INITIALIZE1
#undef R_C_QUIET3_RX_BIS_PRE_COMPUTE_HARMONICS
#undef R_C_QUIET3_RX_BIS_COMPUTE_HARMONICS
#undef R_C_QUIET3_RX_BIS_RESTORE_PGA
#undef R_C_QUIET3_RX_BIS_RESTORE_PGA_WAIT
#undef R_C_QUIET3_RX_BIS_INITIALIZE2
#undef R_C_QUIET3_RX_BIS_DETECT_COMB3

