/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RCQuiet4RxF_BIS.c
 * DESCRIPTION:      Implements the RX state function for the C-QUIET4 state
 *                   in G.dmt.bis.
 *
 **********************************************************************/

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "rt_tones.h"
#include "vecpwr.h"
#include "states.h"
#include "RCReverb1RxF_BIS.h"
#include "cmv.h"
#include "pll.h"
#include "detect.h"
#include "ghs.h"
#include "BGChooseRevSegBin.h"
#include "fifo.h"

/**********************************************************************
 * Function: RCQuiet4RxF_BIS
 *
 * Description: Implements the state R_C_QUIET4_RX_BIS.
 **********************************************************************/
//------------------------------------------------------------------------//
//RCQuiet4RxF_bis.c
//
// History
//
// 30/08/2011 Sriram Shastry :  QLN/HLOG calibration for Annex-A DMT, ADSL2/2+. Calibration is done with respect to the
// line simulator generated refernce data.
//             Grep for "XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration"
//
//------------------------------------------------------------------------//

/* ======================================= */
/* substates                               */
/* ======================================= */

#define R_C_QUIET4_RX_BIS_GET_NOISEPOWER            (0)
#define R_C_QUIET4_RX_BIS_CALCULATE_NEW_TXSINEGAIN  (1)
#define R_C_QUIET4_RX_BIS_DETECT_REVERB_SIGNAL      (2)

void RCQuiet4RxF_BIS(void)
{
  int32 l_Acc, l_temp, s_length;
  int16 i, s_pwr_cutback;

   switch (gs_RxSubState) {

   case R_C_QUIET4_RX_BIS_GET_NOISEPOWER:

      gs_RxSubStateCnt++;


      /* The following part should be removed later */
      if (gs_RxSubStateCnt <= R_C_QUIET4_AC_LEN_BIS)
      {
         l_Acc = VectorPower(gsa_RxToneBuf, (int16) (2*RX_FIRST_PWR_CHN_BIS), (int16)(2*(RX_LAST_PWR_CHN_BIS-RX_FIRST_PWR_CHN_BIS+1)), RXPWR_GUARD_BITS);
            /* Compute the average power */
            gl_Rx_Total_Power += (l_Acc >> LOG2_R_C_QUIET4_AC_LEN_BIS);
      }

      /* Save the received power for Quiet state which will be */
      /* needed in R_C_SEGUE_LD_RX_BIS state(diag mode) */

        if(gs_RxSubStateCnt == (R_C_QUIET4_AC_LEN_BIS+1))
      {
           gl_Rx_Total_Power_Quiet = gl_Rx_Total_Power;

         gt_TxPMDControl.us_pwr_cutback_DS = (gt_RCMsgPcb_bis.us_C_MIN_PCB_DS > gt_RMsgPcb_bis.us_R_MIN_PCB_DS) ?
            gt_RCMsgPcb_bis.us_C_MIN_PCB_DS: gt_RMsgPcb_bis.us_R_MIN_PCB_DS;

         gft_CopyRxBuffer = FALSE;
         gs_RxSubStateCnt = 0;
           gs_RxSubState = R_C_QUIET4_RX_BIS_CALCULATE_NEW_TXSINEGAIN;
      }

      break;

   case R_C_QUIET4_RX_BIS_CALCULATE_NEW_TXSINEGAIN:

      gs_RxSubStateCnt++;

      if((gs_RxSubStateCnt == 1) && ((gt_RMsgPcb_bis.us_R_MIN_PCB_US !=0) || (gt_RCMsgPcb_bis.us_C_MIN_PCB_US!=0)) )
      {
         gt_TxPMDControl.us_pwr_cutback_US = (gt_RCMsgPcb_bis.us_C_MIN_PCB_US > gt_RMsgPcb_bis.us_R_MIN_PCB_US) ?
            gt_RCMsgPcb_bis.us_C_MIN_PCB_US: gt_RMsgPcb_bis.us_R_MIN_PCB_US;

         s_pwr_cutback = gt_TxPMDControl.us_pwr_cutback_US;

           while(s_pwr_cutback >= 6)
         {
             gus_TxGain_NoCutBack = gus_TxGain_NoCutBack >> 1;
         s_pwr_cutback = s_pwr_cutback - 6;
         }

         gus_TxSineGain = gus_TxGain_NoCutBack;
         for (i=0; i< s_pwr_cutback; i++)
         {
             l_temp = (int32)gus_TxSineGain*gus_TxGainCutBackFactor_Bis; /* gus_TxGainCutBackFactor_Bis has the value for 10^(-0.05) in 1.15 format */
         gus_TxSineGain = (int16)(l_temp >>15);
         }
      }


      if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
         s_length = MIN_LEN_C_QUIET4-10;
         else
            s_length = 394 + 8 * (gs_RxNumTones + 64) -10;

         /* To avoid the false detection, wait for the min length of C_QUIET4 before try to detect C_REVERB1 signal */
            if(gl_RxSymbolCount > s_length)
         {

         /* If tdq's exponent is modified in handshake, restore it here */
              if(gs_pre_tdq_h_exp > 14)
               AddFunctionToFifo(gp_RxLoadingFunctionFifo,UnityTDQ);

         gft_CopyRxBuffer = TRUE;
         gs_RxSubStateCnt = 0;
             gs_RxSubState = R_C_QUIET4_RX_BIS_DETECT_REVERB_SIGNAL;
         }
   break;

   case R_C_QUIET4_RX_BIS_DETECT_REVERB_SIGNAL:

      if ((gs_TxState == R_REVERB1_TX_BIS) && (gl_TxSymbolCount > 80))
      {
      //XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration(Start)
      // Accounted for this change in RCQuiet1RxF_bis
#if 0
#ifdef FD_ACCUM_FOR_PGA
         if (gs_RxFftLength  == 1024)
            gs_td_fd_pwr_offset  = TD_FD_PWR_DIFF_PLUS;
         else if (gs_RxFftLength  == 512)
            gs_td_fd_pwr_offset  = TD_FD_PWR_DIFF_BIS;
#endif
#endif
      //XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration(End)
         gs_RxNextState = R_C_REVERB1_RX_BIS;
         gpF_RxStateFunc = (PtrToFunc)RCReverb1RxF_BIS;
      }


      /* check for timeout */
         if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
         s_length = MAX_LEN_C_QUIET4 + BIS_TIME_OUT_LENGTH;
         else
            s_length = 394 + 8 * (gs_RxNumTones + 64) + BIS_TIME_OUT_LENGTH;

        if(gl_RxSymbolCount >= s_length)
      {
         gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

         /* Set exception handler variables */
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_RCQuietRx_Bis_TIME_OUT;
      }

        break;
   } // end of switch(gs_RxSubState)

}

#undef R_C_QUIET4_RX_BIS_GET_NOISEPOWER
#undef R_C_QUIET4_RX_BIS_CALCULATE_NEW_TXSINEGAIN
#undef R_C_QUIET4_RX_BIS_DETECT_REVERB_SIGNAL

