/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCTref3LDRxF_bis.C
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "gdata_bis_diag.h"
#include "tx_ops.h"
#include "engine_const.h"
#include "const_bis.h"
#include "states.h"
#include "cmv.h"
#include "RCComb2RxF_bis.h"
#include "detect.h"


 /*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCQuietL3RxF_BIS
 *
 *
 *  Prototype: void RCQuietL3RxF_BIS(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gl_RxSymbolCount           - (I/O) RX symbol count
 *      gs_RxSubStateCnt            - (I/O) R_C_SEGUE2 count
 *      gs_RxState                    - State of the receiver state machine
 *
 *  Substates:
 *
 *  Notes: implements states R_C_QUIET_L3_RX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RCQuietL3RxF_BIS(void)
{

  if(gl_RxSymbolCount == 0)
  {
    gs_TrainCnt = 0;
    gs_RxSubState =0;
    gft_CComb2_Detected = FALSE;
  }

  if((gs_TxState == R_QUIET_L3_TX_BIS) && (STATArray[STAT_MacroState] == STAT_LoopDiagMode))
    STATArray[STAT_MacroState] = STAT_IdleState;


  if(STATArray[STAT_MacroState] == STAT_ShortInit)
  {
   gs_TrainCnt++;

   /* Detect C-COMB2 symbol */
   if(DetectMultiTones(gsa_RxToneBuf, gsa_COMB_ICOMB_DetectionBins, guc_NUM_OF_BINS_FOR_COMB_DETECTION,  (int16)((guc_NUM_OF_BINS_FOR_COMB_DETECTION+1)>>1), (int16)(gs_ToneDetectScale*256)) )
      gs_RxSubStateCnt++;     /*  C-COMB symbol present, inc its counter */
   else
      gs_RxSubStateCnt = 0;

   // If R_C_TRANSITION_CNT_BIS consecutive C-COMB symbols are detected,
   // transition to the next state.
   if(gs_RxSubStateCnt == R_C_TRANSITION_CNT_BIS)
   {
      gft_CComb2_Detected = TRUE;
      gs_RxNextState = R_C_COMB2_RX_BIS;
   gpF_RxStateFunc = (PtrToFunc)RCComb2RxF_BIS;
   }

   if(gs_TrainCnt >= LEN_RT1)
   {
      gs_RxNextState = FAIL_RX;
      gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

      /* Set exception handler variables */
      gus_ExceptionState   = gs_RxState;
      gus_ExceptionCode = E_CODE_RCQuietRx_Bis_TIME_OUT;
   }
  }


}
