/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RCReverb1RxF_BIS.c
 * DESCRIPTION:      Implements the RX state function for the C-REVERB1 state
 *                   in G.dmt.bis.
 *
 **********************************************************************/
// ******************************************************************
// RCReverb1RxF_BIS.c
//
// History
//
// 21/11/2011 Hanyu: Ported MFD code to VRx. Set NLNF IB bit7 to indicate Hybrid training data is ready.
//            Mapped hybrid index into NLNF IB bit9:8 to indicate training hyb range.
//            Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo
//
// 21/11/2011 Vinjam/Bhadra: Added code to populate hybrid indix/metric to INFO 103 6 6
//            for NLNF filter detection and training.
//            Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo
//
// 02/12/2011 Balabath:Added new microstate STATs18D and 19D CMV DSL 16 is used inplace of INFO 121
//       for NLNF measurement.INFO 103 (6:11) are mapped to DSL 18 0 5 (Hybrid information)..
//            Additinally, DSL13 bit2 is used inplace of CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap
//
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// ******************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "dsp_op.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ifft_fix.h"
#include "pll.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "fft_bg.h"
#include "ec_init.h"
#include "xrtstate.h"
#include "states.h"
#include "fifo.h"
#include "compiler.h"
#include "ec_data.h"
#include "accum32.h"
#include "noiseacc.h"
#include <string.h>
#include "cmv.h"
#include "aec_init.h"
#include "const.h"
#include "compiler.h"
#include "T1413.h"
#include "vecpwr.h"
#include "memsetbf.h"
#include "afe.h"
#include "xcvr_rx1_b.h"
#include "detect.h"
#include "RCTref1RxF_BIS.h"
#include "dsp_op2.h"
#include "afe_hyb.h"
#include "HybridTraining.h"
#include "hndshk_Data.h"
#include "STR_ReconfigRx.h"

#include "AFED_Functions.h"


/* =============================================== */
/* static variable declarations */
/* =============================================== */
extern int16 gs_aec_order, gs_log2_aec_order;

/**********************************************************************
 *  Function: RCReverb1RxF_BIS
 *
 *  Description: This state coincides with the C-REVERB1 and C-TREF1 states.
 *  It sets PGA and runs PLL through C-TREF1 state.
 *
 *  Prototype: void RCReverb1RxF_BIS(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_RxSubState             - (I/O) Substate within current RX state
 *      gs_RxNextState            - (O)   Rx state starting next symbol period
 *      gl_RxSymbolCount          - (I)   count of symbols passed in current state
 *      gs_RxSubStateCnt          - (I/O) count of symbols passed in current substate
 *      gl_Pa                     - (I/O) accumulated power
 *      gs_PGA_offset             - (O)   PGA offset
 *      gs_RxToneBuf[]            - (O)   Output of FFT, set in RxPower()
 *
 *  Substates:
 *      R_C_REVERB1_RX_BIS_INITIALIZE - Waits a pre-determined number of symbols (frames)
 *                                      for the channel to stabilize, and clears the power
 *                                      measurement accumulator.  Also updates the PLL.
 *
 *      R_C_REVERB1_RX_BIS_SET_PGA    - Computes an average power to be used in setting
 *                                      the PGA, then adjusts and implements this setting
 *                                      into the PGA.  Also updates the PLL.
 *
 *
 *      R_C_REVERB1_RX_BIS_WAIT       - Waits until the current state (R_C_REVERB1_RX_BIS)
 *                                      completes, then sets the next state pointer to
 *                                      R_C_REVERB2_RX_BIS.  Also updates the PLL.
 *
 *  Notes: implements the state R_C_REVERB1_RX_BIS and R_C_TREF1_RX_BIS
 *
 **********************************************************************/


/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_REVERB1_RX_BIS_PGA_TRAIN                (207)

#define R_C_REVERB1_RX_BIS_INIT_HYBRID_TRAINING    (210)
#define R_C_REVERB1_RX_BIS_AGC1_ACCUM           (211)
#define R_C_REVERB1_RX_BIS_AGC2_ACCUM_INIT          (212)
#define R_C_REVERB1_RX_BIS_AGC2_ACCUM           (213)
#define R_C_REVERB1_RX_BIS_SIG_PSD_ACCUM        (214)
#define R_C_REVERB1_RX_BIS_CTREF1_WAIT          (215)
#define R_C_REVERB1_RX_BIS_NOISE_PSD_ACCUM         (216)
#define R_C_REVERB1_RX_BIS_LOAD_BEST_HYBRID        (217)
#define R_C_REVERB1_RX_BIS_PLL_ON_WAIT          (218)
#define R_C_REVERB1_RX_BIS_TSSI_OFF_WAIT           (219)

#define R_C_REVERB1_RX_BIS_RESET_PGA               (0)
#define R_C_REVERB1_RX_BIS_RESET_PGA_WAIT          (1)
#define R_C_REVERB1_RX_BIS_INITIALIZE              (2)
#define R_C_REVERB1_RX_BIS_SET_PGA                 (3)
#define R_C_REVERB1_RX_BIS_PGA_WAIT                (4)
#define R_C_REVERB1_RX_BIS_RESET_PILOT_REFERENCE      (5)
#define R_C_REVERB1_RX_BIS_ESTIMATE_ECHO_POWER           (117)
#define R_C_REVERB1_RX_BIS_DETECT_CTREF1              (115)

#define R_C_REVERB1_RX_BIS_PRE_WAIT                (116)
#define R_C_REVERB1_RX_BIS_WAIT                    (14)



void RCReverb1RxF_BIS(void)
{
    switch (gs_RxSubState) {


   case R_C_REVERB1_RX_BIS_RESET_PGA:

   if (gl_RxSymbolCount == 0)
   {

         if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
      {
           if((gt_RMsgFmt_bis.us_FMT_R_REVERB1 == 0) && (gt_RCMsgFmt_bis.us_FMT_R_REVERB1 == 0))
         gs_R_C_REVERB1_RX_LEN_BIS = R_REVERB1_TX_LEN1_BIS + (gt_RCMsgFmt_bis.us_FMT_R_QUIET4<<9) - 80;  /* The length of R-QUIET4 is specified by CO */
         else
         gs_R_C_REVERB1_RX_LEN_BIS = R_REVERB1_TX_LEN2_BIS + (gt_RCMsgFmt_bis.us_FMT_R_QUIET4<<9) - 80;
      }
         else {
           gs_R_C_REVERB1_RX_LEN_BIS = R_C_REVERB1_RX_LEN_BIS_DIAG;
      }

         gs_RxSubStateCnt = 0;
         gft_EnableDoublePGATrain = TRUE;
         gs_RxSubState = R_C_REVERB1_RX_BIS_INIT_HYBRID_TRAINING;
#ifndef ISDN
         //XDSLRTFW-3674 New_LLAPI_changes
         if((guc_HybTable == 3) &&(gt_INFX_CMV.s_HybTablesSwitch & 0x0001))
         {
            gft_IsBTorLLoop = TRUE;
         }
#endif
         gl_HybTrSymcnt[0] = gl_RxSymbolCount; //debug
      }

    break;
   case R_C_REVERB1_RX_BIS_RESET_PGA_WAIT:

      if (guc_PgaTrainingState == TRAINING_DONE) {
         gft_EnablePLL = FALSE;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_SetPga);
         gs_RxSubStateCnt = 0;

         gs_RxSubState = R_C_REVERB1_RX_BIS_INITIALIZE;  //Cocomo
      }
      break;

    case R_C_REVERB1_RX_BIS_INIT_HYBRID_TRAINING:
      gs_RxSubStateCnt++;
      if (gs_RxSubStateCnt == 1)
      {
         gl_HybTrSymcnt_start = gl_RxSymbolCount;

         InitHybridVars_VR9();
         /* Disable PLL. */
         gft_EnablePLL = FALSE;
         //Bypass Rx IIR Filter
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,Strmon_RxIIR_Bypass); //Stymon Rx IIR Bypass
      }
      if (gs_RxSubStateCnt == 2)
      {
         //We are doing double PGA training, i.e train PGA1 followed by PGA2 for all the Hybrid's
         gs_PgaHandlerRun = 0; //Train PGA1 first , while training keep HPF in Bypass mode
         gs_LoadHybIndex = 0;  // Load initial hybrid, HPF, and corresponding PGA.
         //clear previous AFE overflow
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_CheckADCOverflow_ADSL);
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_LoadHybridHPFAndPGA_VR9);

      }
      if (gs_RxSubStateCnt == 5) //3 symbol delay after setting PGA to have correct value
      {
#ifdef VR9_HYB_TRAIN_DEBUG
         if(gs_Set_Pause == 0x199)Pause(0x1991);  //Debug
#endif //VR9_HYB_TRAIN_DEBUG

         InitHybridAccum(0);
         /* Initialize the hybrid training pipeline for AGC1 accumulation. */
         gs_HybridAccumCnt = HYB_PGA_ACCUM_CNT;
         gs_Log2HybridAccumCnt = HYB_LOG2_PGA_ACCUM_CNT;
         gs_RxSubState = R_C_REVERB1_RX_BIS_AGC1_ACCUM;
      }
      break;
    case R_C_REVERB1_RX_BIS_AGC1_ACCUM:
      if (HybridTrainingPipeline_VR9(0) != FALSE)
      {
         gs_RxSubStateCnt = 0;
#ifdef VR9_HYB_TRAIN_DEBUG
         if(gs_Set_Pause == 0x200)Pause(0x2001);  //Debug
#endif //VR9_HYB_TRAIN_DEBUG
         /* Initialize the hybrid training pipeline for AGC2 accumulation. */
         gs_PgaHandlerRun = 1; //Train PGA2, while training put HPF inplace
         //gs_LoadHybIndex = 0;  //Start Index //This line may not be required here
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_LoadHybridHPFAndPGA_VR9);
         gs_RxSubState = R_C_REVERB1_RX_BIS_AGC2_ACCUM_INIT;
      }
      break;
    case R_C_REVERB1_RX_BIS_AGC2_ACCUM_INIT:
      gs_RxSubStateCnt++;
      if (gs_RxSubStateCnt == 3)
      {
         /* Initialize the hybrid training pipeline for AGC2 accumulation. */
         InitHybridAccum(1);
         gl_HybTrSymcnt[1] = gl_RxSymbolCount; //debug
         gs_RxSubState = R_C_REVERB1_RX_BIS_AGC2_ACCUM;
      }
      break;
   case R_C_REVERB1_RX_BIS_AGC2_ACCUM:
      if (HybridTrainingPipeline_VR9(1) != FALSE)
      {
#if 0 //def VR9_HYB_TRAIN_DEBUG
         if(gs_Set_Pause == 0x201)Pause(0x2002);  //Debug
         gl_HYbPGATrain_SymCount = gl_RxSymbolCount; //Debug
#endif //VR9_HYB_TRAIN_DEBUG
         //Restore RxIIR filter after PGA computation
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,Strmon_RxIIR_Inplace); //Keep Stymon Rx IIR inplace

         //XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End)
         /* Load Decim2/HPF after PGA training. */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,ReconfigDecim2_HPF);


         //gs_LoadHybIndex = 0;  //Start Index //This line may not be required here
         gs_LoadAllPGAGains = 1; //Load PGA1 & PGA2 gains at a time
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_LoadHybridHPFAndPGA_VR9);

         gl_DetectTone_RevRefPwr = 0;
         gs_RxSubStateCnt = 0;
         gs_TrainCnt = 0;
         gs_RxSubState = R_C_REVERB1_RX_BIS_ESTIMATE_ECHO_POWER;
      }
      break;

     case R_C_REVERB1_RX_BIS_ESTIMATE_ECHO_POWER:
      gs_RxSubStateCnt++;
      /* Measure reference power when Tx is in RReverb and Rx is CReverb */
      /* NOTE: Implies we must be finish this substate before RReverb1 */
      if(gs_RxSubStateCnt >= 4)
      {
         int32 l_tone_power, l_rx_power;
         //Dry run to get the optimal number of shifts
         if(gs_RxSubStateCnt == 4)
         {
            gs_DetectTone_PwrCalcShifts = 2;
            do {
               gs_DetectTone_PwrCalcShifts++;
               l_rx_power = VectorPower(gsa_RxToneBuf, (int16) (2*(gs_CPilotTone-5)), (int16)(2*11), gs_DetectTone_PwrCalcShifts);
            } while(l_rx_power > 0x7FFF);
         }
         // Calculate power in tone being detected.
         l_tone_power = VectorPower(gsa_RxToneBuf, (int16) (2*gs_CPilotTone), 2, gs_DetectTone_PwrCalcShifts);
         // Calculate total power in band of tones from first_tone to last_tone.
         l_rx_power = VectorPower(gsa_RxToneBuf, (int16) (2*(gs_CPilotTone-5)), (int16)(2*11), gs_DetectTone_PwrCalcShifts);
         l_rx_power -= l_tone_power;

         /* Accumulate reference power */
         gs_TrainCnt++;
         gl_DetectTone_RevRefPwr += l_rx_power; /* Assume no overflow */

         if(gs_TrainCnt == 16)
         {
            gl_DetectTone_RevRefPwr >>= 4; //16 symbol Average
            gs_RxSubStateCnt = 0;
            gs_TrainCnt = 0;
            {
#ifdef ISDN
               //US TSSI off causes Spikes in the Rx Signal during Signal & Noise PSD measurement
               //for Hybrid Metric computation. These spikes were mainly observed in G.992.3 AnxL mode(BT loops).
               //US TSSI off may not be required during signal & noise PSD measurement since
               //AGC gain was computed with US TSSI ON.
               guc_HybTssiOff = 0x11;
#endif
               gs_RxSubStateCnt = 0;
               gs_RxSubState = R_C_REVERB1_RX_BIS_TSSI_OFF_WAIT;
               //Pause(1000);
            }
         }

      }
      break;

     case R_C_REVERB1_RX_BIS_TSSI_OFF_WAIT:
      gs_RxSubStateCnt++;
      if (gs_RxSubStateCnt == 8) //4 symbol for Tx & another 4 symbol for Rx propagate
      {
               /* Clear the REVERB reference buffer to convert NoiseAcc() to PSD accumulation. */
               /* Note that this reference buffer is not being used until frame synchronization */
               /* when it gets restored so there is no need to restore it right after the */
               /* hybrid training. */
               memset(gsa_CReverbRefTones, (int16)0, sizeof(int16)*(gs_RxNumTones*2));
               /* Initialize the hybrid training pipeline for signal PSD accumulation. */
               gs_HybridAccumCnt = HYB_SIG_PSD_ACCUM_CNT;
               gs_Log2HybridAccumCnt = HYB_LOG2_SIG_PSD_ACCUM_CNT;
               InitHybridAccum(2);
               gl_HybTrSymcnt[2] = gl_RxSymbolCount; //debug
               gs_RxSubState = R_C_REVERB1_RX_BIS_SIG_PSD_ACCUM;
      }
      break;
   case R_C_REVERB1_RX_BIS_SIG_PSD_ACCUM:
      if (HybridTrainingPipeline_VR9(2) != FALSE)
      {

#if 0 //def VR9_HYB_TRAIN_DEBUG
         gl_HybTrainSigPSD_SymCount = gl_RxSymbolCount; //Debug
         if(gs_Set_Pause == 0x202)Pause(0x2003);  //Debug
#endif //VR9_HYB_TRAIN_DEBUG
         gs_RxSubState = R_C_REVERB1_RX_BIS_CTREF1_WAIT;
         gl_HybTrSymcnt[3] = gl_RxSymbolCount; //debug
      }
      break;
   case R_C_REVERB1_RX_BIS_CTREF1_WAIT:
      if (gl_RxSymbolCount == gs_R_C_REVERB1_RX_LEN_BIS)
      {
#ifdef VR9_HYB_TRAIN_DEBUG
         if(gs_Set_Pause == 0x203)Pause(0x2004);  //Debug
#endif //VR9_HYB_TRAIN_DEBUG
         //gs_LoadHybIndex = 0;  //Start Index //This line may not be required here
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_LoadHybridHPFAndPGA_VR9);
      }
      //if (gl_RxSymbolCount == (gs_R_C_REVERB1_RX_LEN_BIS+3))
      if (gl_RxSymbolCount == (gs_R_C_REVERB1_RX_LEN_BIS+PGA_SETTLING_TIME))
      {

         /* Initialize the hybrid training pipeline for noise PSD accumulation. */
         gs_HybridAccumCnt = HYB_NOISE_PSD_ACCUM_CNT;
         gs_Log2HybridAccumCnt = HYB_LOG2_NOISE_PSD_ACCUM_CNT;
         InitHybridAccum(3);
         gs_RxSubState = R_C_REVERB1_RX_BIS_NOISE_PSD_ACCUM;
      }
      break;

   case R_C_REVERB1_RX_BIS_NOISE_PSD_ACCUM:
      if (HybridTrainingPipeline_VR9(3) != FALSE)
      {
#ifdef ISDN
         /* Notify TX side to switch the TSSI back on. Note that a clean echo from */
         /* the new TX signal will appear in the RX buffer five frames from now. */
         //US TSSI off causes Spikes in the Rx Signal during Signal & Noise PSD measurement
         //for Hybrid Metric computation. These spikes were mainly observed in G.992.3 AnxL mode(BT loops).
         //US TSSI off may not be required during signal & noise PSD measurement since
         //AGC gain was computed with US TSSI ON.
         guc_HybTssiOff = 0x10;
#endif
         gs_RxSubState = R_C_REVERB1_RX_BIS_LOAD_BEST_HYBRID;
      }
      break;
   case R_C_REVERB1_RX_BIS_LOAD_BEST_HYBRID:
      if (guc_BkgdTaskState == BKGDTASK_DONE)
      {
#ifdef VR9_HYB_TRAIN_DEBUG
         if(gs_Set_Pause == 0x204)Pause(0x2005);  //Debug
#endif //VR9_HYB_TRAIN_DEBUG
         /* Assume we are on a short loop if maximum metric is within 0.78% of the */
         /* straight loop hybrid metric. */
         if ((gs_HybZeroMetric + (gs_HybZeroMetric >> 7)) > gs_HybMaxMetric)
         {
            /* Load the default (straight loop) hybrid. */
            gs_LoadHybIndex = STRAIGHTLOOP_HYBIDX;
         }
#ifdef VRX518
            //Force null loop hybrid in null loop based on GHS tones received power up to 300m
            //and PGA required < -10dB*256
           else if (((gs_hsk_tone_power_dB - gs_hsk_power_dB_VendorComp) > HSK_TONE_PWR_TO_FORCE_0_HYB) &&
                                    (gs_PGA_required_In_GHS < (int16)0xF600))
            {
            /* Load the Null (straight loop) hybrid. */
               gs_LoadHybIndex = STRAIGHTLOOP_HYBIDX;
            }
#endif
         else
         {
            /* Load the hybrid that gives the best metric. */
            gs_LoadHybIndex = gs_HybMaxIndex;
            if(gs_HybMaxIndex == (VRX518_MAX_NUM_ADAP_HYB_SETTINGS-1)) //XDSLRTFW-3753 last index used for Qln/Hlog Hyb setting (special hybrid)
            {
               gs_LoadHybIndex = gs_HybSecondBestIndex;
            }
         }

         // Force a specific hybrid index for debug purposes
         if (gs_HybTrIndexDbg != -1)
         {
            gs_LoadHybIndex = gs_HybTrIndexDbg;
         }
         gl_HybTrSymcnt[4] = gl_RxSymbolCount; //debug
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,AFED_LoadHybridHPFAndPGA_VR9);
         //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start)
         //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (Start)
         gt_HybridInfo.s_HybMaxIndex = gs_HybMaxIndex;
         gt_HybridInfo.s_HybMaxMetric = gs_HybMaxMetric;
         gt_HybridInfo.s_HybSecondBestIndex = gs_HybSecondBestIndex;
         gt_HybridInfo.s_HybSecondBestMetric = gs_HybSecondBestMetric;
         gt_HybridInfo.s_HybZeroMetric = gs_HybZeroMetric;
         gt_HybridInfo.s_LoadHybIndex = gs_LoadHybIndex;
         //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (End)
        //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (End)


           // XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
           // Bit7=1 indicates Hyb training data ready for NLNF decision.
            gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x080;
            // Set Training Hybrid IB of INFO 121 0 or us_NlnfIbs LSB[9:8]
               // Set Training Hybrid IB of INFO 121 0 or us_NlnfIbs LSB[9:8]
               if ((gs_LoadHybIndex >= 2) && (gs_LoadHybIndex <= 18))
                  gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x0100; // 0b01 Short BT <=800ft
               else if ((gs_LoadHybIndex >= 19) && (gs_LoadHybIndex <= 22))
                  gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x0200; // 0b10 ~1kft BT 800ft< BT <=1250
               else if (gs_LoadHybIndex >= 23)
                  gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x0300; // 0b10 Long BT >1250FT
#endif //#ifndef ISDN
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
           // XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (END)

         /* Reverb reference power threshold was captured with default hybrid, */
         /* adjust it here based on the ratio of signal powers for default and */
         /* selected hybrid. */
#if 1 //Madhu VRX518
         AdjustRevRefPwr();
#endif
         /* Change pilot tone index to the one used after channel discovery. */
         gs_PilotToneIdx = gs_CPilotTone;
         /* Go to the next state. */
         gs_RxSubStateCnt = 0;
         gs_RxSubState = R_C_REVERB1_RX_BIS_PLL_ON_WAIT;
      }
      break;
   case R_C_REVERB1_RX_BIS_PLL_ON_WAIT:
      gs_RxSubStateCnt++;
      /* Wait for the newly set up TX signal to fully propagate through the TX and */
      /* RX pipelines. */
      if (gs_RxSubStateCnt == 5)
      {
#ifdef VR9_HYB_TRAIN_DEBUG
         if(gs_Set_Pause == 0x205)Pause(0x2006);  //Debug
#endif //VR9_HYB_TRAIN_DEBUG
         gl_HybTrSymcnt_end = gl_RxSymbolCount;

         /* Get the reference phase of pilot signal and do the appropriate scaling of */
         /* loop coefficients for the new pilot tone. */
         ResetPllRefTone(gsa_RxPilotTone[0], gsa_RxPilotTone[1]);
         ResetPLL((int16)gs_Kp_Slow, (int16)gs_Ki_Slow, (int16)PLL_QUARTER_PI_RADIANS);
         ScalePLL(gs_PllScaling);
         /* Enable PLL. */
         gft_EnablePLL = TRUE;

         gs_RxSubState = R_C_REVERB1_RX_BIS_DETECT_CTREF1;
         gpF_RxStateFunc = (PtrToFunc)RCTref1RxF_BIS;
//XDSLRTFW-2033 (start)
#ifndef ISDN
         // In auto mode Annex L BT loops are not stable, AT&T report showtime not reached within 120s
         // giving options to force ADSL1/ADSL2 modes based on CMV control
         if (((( (gl_SelectedMode & (MODE_G992_3))) && (gl_SelectedMode & (ANNEX_L))) != 0)
             &&(gs_LoadHybIndex > 2 )
             &&(gs_CurrentCoChipset == GSI_CO_CHIPSET)
            && ((gs_hsk_tone_power_dB < 1100) &&(gs_hsk_tone_power_dB >100))
             )
         {

            if((gt_INFX_CMV.us_OperatorSpBits7 & CMV_ForceRetrain_at_Reverb1)
               &&( gft_pAnnexLBTLoops_CNXT == FALSE)
               )
            {
               gft_pAnnexLBTLoops_CNXT = TRUE;
               /* Set exception handler variables */
               gus_ExceptionState = gs_RxState;
               gus_ExceptionCode = E_CODE_ForceRetrain_at_Reverb1_ANNEXL;
               gs_RxNextState = FAIL_RX;
               gpF_RxStateFunc = (PtrToFunc) ExceptionHandler;

            }
         }
#endif
//XDSLRTFW-2033 (end)
      }
      break;

    } /* switch(gs_RxSubState) */
}



#undef R_C_REVERB1_RX_BIS_RESET_PGA
#undef R_C_REVERB1_RX_BIS_RESET_PGA_WAIT
#undef R_C_REVERB1_RX_BIS_INITIALIZE
#undef R_C_REVERB1_RX_BIS_SET_PGA
#undef R_C_REVERB1_RX_BIS_PGA_WAIT
#undef R_C_REVERB1_RX_BIS_RESET_PILOT_REFERENCE
#undef R_C_REVERB1_RX_BIS_ESTIMATE_ECHO_POWER
#undef R_C_REVERB1_RX_BIS_DETECT_CTREF1
#undef R_C_REVERB1_RX_BIS_MEASURE_PGA_PRE_AEC_TRAIN

#undef R_C_REVERB1_RX_BIS_PRE_WAIT
#undef R_C_REVERB1_RX_BIS_WAIT


