/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RCReverb2RxF_BIS.c
 * DESCRIPTION:      RX State Function for ATU-R in the C-REVERB2 and C-ECT
 *                   states of the Transceiver Training Phase in G.dmt.bis.
 *
 **********************************************************************/

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "fifo.h"
#include "states.h"
#include "RCReverb3RxF_BIS.h"
#include "RQuiet5TxF_bis.h"
#include "pll.h"
#include "string.h"

/*^^^
 *---------------------------------------------------------------------
 * Function: RCReverb2RxF_BIS
 *
 * Description: Implements the R_C_REVERB2_RX_BIS and R_C_ECT_RX_BIS states.
 *---------------------------------------------------------------------
 *^^^
 */

void RCReverb2RxF_BIS(void)
{
   /* At the end of RCReverb1RxF_BIS(), the first few frames of C-REVERB2 should have been */
   /* detected. Here we just need to count to the end of C-ECT. No need to do FFT.         */

   if (gl_RxSymbolCount == 1) {
      gft_EnablePLL = TRUE;
       ResetPllRefTone(gsa_RxPilotTone[0], gsa_RxPilotTone[1]);
   }

    if (gl_RxSymbolCount == R_C_REVERB2_RX_LEN_BIS - R_C_TRANSITION_CNT_BIS - 3)
   {  /* Turn off PLL during C-ECT state */
      gft_EnablePLL = FALSE;
       AddFunctionToFifo(gp_RxLoadingFunctionFifo, MoveToFrameStartInt);
   }

    if (gl_RxSymbolCount == R_C_REVERB2_RX_LEN_BIS - R_C_TRANSITION_CNT_BIS - 2)
       AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableFDQDoneNTC_DisableGetRxTones);

   //if (gl_RxSymbolCount == R_C_REVERB2_RX_LEN_BIS + R_C_ECT_RX_LEN_BIS - R_C_TRANSITION_CNT_BIS - 1) {
   if (gl_RxSymbolCount == R_C_REVERB2_RX_LEN_BIS + R_C_ECT_RX_LEN_BIS - 1) {
      gs_RxNextState = R_C_REVERB3_RX_BIS;      // Go to R-REVERB3
      gpF_RxStateFunc = (PtrToFunc)RCReverb3RxF_BIS;

      // Save the Rx overflow counters for the current state
      memcpy(gusa_RCReverb2_RxOverflowCnts, gusa_RxOverflowCnts, NUM_RX_OVFLOW_CNTRS*sizeof(uint16));

      // For Socrates specific codeswap requirement only
      gpF_TxStateFunc = (PtrToFunc)RQuiet5TxF_XCVR2_BIS;
   }
}
