/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCReverb3RxF_bis.c
 *
 *   Transceiver Training Phase 1 RX State Functions for ATU-R.
 *   Covering the RX states: R_C_REVERB3_RX_BIS
 *
 *   Notes:
 *
 *   R_C_REVERB3_RX_BIS implemented here
 *
 *------------------------------------------------------------------------
 */
//*******************************************************************
// RCReverb3RxF_bis.c
//
// History
//
// 14/05/2010 Nihar: QLN/HLOG calibration for Annex-B DMT, ADSL2/2+
//             Grep for Feature_DS_BisPlus_ALL_VR9QLNCalib
//
// 11/08/2010 Kannan/Bhadra: Start Channel Identification & TDQ training
//                   from Rx channel '1' against TI & CNXT based COs for better
//                   DS performance. Since this change doesn't degrade the performance make it general.
//                   Grep for PERF_DS_ALL_TI&CNXT_ChIDfrmTone1
//
//*****************************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "dsp_op.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ifft_fix.h"
#include "pll.h"
#include "gdata.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "fft_bg.h"
#include "ec_init.h"
#include "xrtstate.h"
#include "states.h"
#include "fifo.h"
#include "compiler.h"
#include "ec_data.h"
#include "accum32.h"
#include "noiseacc.h"
#include <string.h>
#include "cmv.h"
#include "aec_init.h"
#include "const.h"
#include "compiler.h"
#include "T1413.h"
#include "vecpwr.h"
#include "memsetbf.h"
#include "afe.h"
#include "frm_sync_b.h"
#include "frm_sync_proc_b.h"
#include "ReverbSnr_b.h"
#include "gdata_bis.h"
#include "detect.h"
#include "const_bis.h"
#include "Decim_Phase_Data.h"
#include "RCPilot3Tref2RxF.h"
#include "ovflw.h"
#include "diagparam_bis.h"
#if defined(TARGET_HW)
#include "dataswap.h"
#endif

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"
#include "DebugBuffer.h"
#include "bufmisc.h"
#define LOG_ECHO_DBG


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCReverb3RxF_bis
 *
 *  Description: The frame alignment, TDQ and FDQ at the ATU-R is trained
 * in this state. The PLL is also run through this state until the PLL is
 *  called in GetRxTones()
 *
 *  Prototype: void RCReverb3RxF_bis(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gs_RxSubState              - (I/O) current RX substate
 *    gs_RxSubStateCnt              - (I/O) count of symbols passed in current substate
 *    gl_RxSymbolCount              - (I) count of symbols passed in current state
 *    gsa_RxNextState               - (O) RX next state
 *    gus_ExceptionState            - (O) Exception state
 *    gus_ExceptionCode             - (O) Exception code
 *      gla_RxAccumBuf[]            - (I/O) accumulated frames
 *    gsa_RxToneBuf[]               - (O) FFT output buffer
 *    gus_SyncOffset             - (I/O) frame synch offset
 *    guc_TdqTrainingState       - (I/O) TDQ init. flag
 *    gt_TDQInput                - (I/O) structure for TDQ input
 *    guc_FdqTrainingState       - (I/O) FDQ init. flag
 *    gsa_pre_FDQ_coef[]             - (O) mantissas of FDQ coefficients
 *    gsa_pre_FDQ_exp[]             - (O) exponents of FDQ coefficients
 *    guc_CommandedPllState         - (I/O) PLL tone state variable
 *    gsa_NoisePower[]              - (I/O) accumulated noise power buffer
 *    gsa_CReverbRefTones[]          - (I) C_Reverb reference tone buffer
 *    gsa_ReverbSnrBuf[]            - (O) SNR buffer
 *
 *  Substates:
 *      R_C_REVERB3_RX_BIS_INITIALIZE      - Waits a pre-determined number of symbols
 *                                       (frames) for the channel to stabilize,
 *                                       and clears the Echo Canceller filter
 *                                       coefficients. Also updates the PLL.
 *      R_C_REVERB3_RX_BIS_AVERAGE_FRAME   - Computes a representative symbol (frame)
 *                                       by averaging over a pre-determined number
 *                                       of received symbols (frames) in the time
 *                                       domain. Also updates the PLL.
 *      R_C_REVERB3_RX_BIS_FRAME_ALIGN     - Performs symbol (frame) alignment by
 *                                       computing an estimate of the sample
 *                                       offset required to achieve synchronization.
 *                                       Also updates the PLL.
 *      R_C_REVERB3_RX_BIS_FDQ_SETUP - Prepare for FDQ training.
 *      R_C_REVERB3_RX_BIS_AVERAGE_FRAME3  - Computes a representative symbol (frame)
 *                                       by averaging over a pre-determined number
 *                                       of received symbols (frames) in the frequency
 *                                       domain. Also updates the PLL.
 *      R_C_REVERB3_RX_BIS_BEGIN_FDQ_TRAIN - Computes the frequency-domain equalizer (FDQ)
 *                                       coefficients. Also updates the PLL.
 *      R_C_REVERB3_RX_BIS_END_FDQ_TRAIN   - Implements the new FDQ coefficients, and
 *                                       resets the PLL reference tone.
 *      R_C_REVERB3_RX_BIS_CALCULATE_SNR   - Computes an SNR estimate in each of the sub-
 *                                       channels of interest in the downstream band.
 *                                       Also updates the PLL.
 *      R_C_REVERB3_RX_BIS_COMPUTE_HCHAN   - Computes Hchannel(f) testparameter in linear
 *                               and log domain for loop diagnostics mode.
 *      R_C_REVERB3_RX_BIS_WAIT            - Waits until the end of this state
 *                                       (R_C_REVERB2_RX). Also updates the PLL.
 *
 *  Notes: implements state R_C_REVERB3_RX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_REVERB3_RX_BIS_COMPUTE_HCHAN  (15)
#define R_C_REVERB3_RX_BIS_WAIT           (17)
#define R_C_REVERB3_RX_BIS_DETECT_PILOT      (18)

void RCReverb3RxF_BIS(void) {

   int16 s_length;

   if(gl_RxSymbolCount == 0)
   {
      /* Set averaging time for representative frame used for channel estimate according to mode */
      if(STATArray[STAT_MacroState] == STAT_LoopDiagMode)
      {
         gt_DS_MeasurementPeriod.us_Hlogf_measurement_period = (uint16) R_C_REVERB3_LD_ACCUM_LEN_HLIN;
         gs_DS_MeasurementPeriod_ChanEst = R_C_REVERB3_LD_ACCUM_LEN_CHANEST;
         gs_RxLog2AccumLenHLin = LOG2_R_C_REVERB3_LD_ACCUM_LEN_HLIN;
         gs_RxLog2AccumLenChanEst = LOG2_R_C_REVERB3_LD_ACCUM_LEN_CHANEST;
      }
      else
      {
         gt_DS_MeasurementPeriod.us_Hlogf_measurement_period = (uint16) R_C_REVERB3_BIS_ACCUM_LEN_HLIN;
         gs_DS_MeasurementPeriod_ChanEst = R_C_REVERB3_BIS_ACCUM_LEN_CHANEST;
         gs_RxLog2AccumLenHLin = LOG2_R_C_REVERB3_BIS_ACCUM_LEN_HLIN;
         gs_RxLog2AccumLenChanEst = LOG2_R_C_REVERB3_BIS_ACCUM_LEN_CHANEST;
      }
      // AR8_TF: PERF_DS_ALL_TI&CNXT_ChIDfrmTone1 (Start)
#ifndef  ISDN  // Only for Annex - A
      // Do the Frame Sync and Chnl Identification from Rx Chnl 1 for Better TDQ Training
      // TI CO's send RCREVERB from chnl 24 onwards.
      // It has beem enabled for all the DSLAMs, because this change should not degrades the DS
      // performance
      // Enable this change for TI and Connexant DSLAM's which will send expanded Reverb Signal.
      // This may be enabled for other DSLAMs if this change helps to improve the DS Performance.
      // if ((gs_CurrentCoChipset == GSI_CO_CHIPSET)||(gs_CurrentCoChipset == TI_CO_CHIPSET))
      // {
      gs_RxFirstChannelSave = gs_RxFirstChannel;
      gs_RxFirstChannel = RX_FIRST_CHNL_TDQ_TRAIN;
      // }
#endif // ifndef ISDN
      // AR8_TF: PERF_DS_ALL_TI&CNXT_ChIDfrmTone1 (End)
   }

    switch (gs_RxSubState) {

   /* ======================================================================================== */
   /* Compute Hchannel(f) test paramter for loop diagnostics */
   /* ======================================================================================== */
   case R_C_REVERB3_RX_BIS_COMPUTE_HCHAN:
      if ((guc_SnrCalcState == TRAINING_DONE) && (gl_RxSymbolCount >= PGA_SETTLING_TIME))
      {
         if(STATArray[STAT_MacroState] == STAT_LoopDiagMode)
            gs_RCReverb3Len_Min = R_C_REVERB3_RX_LEN_BIS_DIAG - 11;

         // Compute Hlin function in background from accumulated frame
         guc_BkgdTaskState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)ComputeHlin);

         gs_RxSubState = R_C_REVERB3_RX_BIS_WAIT;
         if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_SNR_Save)
         {
            // REVERB QUIET signal.
            memcpy(gpsa_RCReverb_Quiet_Snr,gsa_ReverbSnrBuf,1024);
         }

//#ifdef DANUBE
#ifdef TARGET_HW
                /* Swap the buffer to XMEM */
             RequestSwap_ReverbSnrBuf_ToXmem ();
#endif
//#endif
      }
      break;

   /* ======================================================================================== */
   /* Wait to the end of C_REVERB3 signal */
   /* ======================================================================================== */
    case R_C_REVERB3_RX_BIS_WAIT:

      if (gft_goto_RReverb3_Flag == FALSE)
      {
         if ((guc_BkgdTaskState == TRAINING_DONE) && (gl_RxSymbolCount >= gs_RCReverb3Len_Min))
         {
            guc_LoopAtten_LSB = (uint8)( gt_NearEndParam.us_LoopAttenuation& 0xFF);
            guc_LoopAtten_MSB = (uint8)(( gt_NearEndParam.us_LoopAttenuation>> 8) & 0x3);

            gft_CopyRxBuffer = TRUE;
            /* Notify TX to transition to R-REVERB3 state (happens on a multiple of 512 frames). */
            gft_goto_RReverb3_Flag = TRUE;
         }
      }
      else
      {
         /* Wait for the TX side transition if not in Loop Diagnostics mode. */
         if ((gs_TxState == R_REVERB3_TX_BIS) || (STATArray[STAT_MacroState] == STAT_LoopDiagMode))
         {
            /* Once TX side transitions to R-REVERB3, turn off PLL to avoid phase errors */
            /* due to state transitions. */
            gft_EnablePLL = FALSE;

            /* Set unity TDQ exponent back to 1 for detection and DEC training. */
            /* Note that unity TDQ exponent > 1 can be used on echo limited loops */
            /* only when there is no echo (i.e., TX is quiet) or when DEC is loaded. */
            gs_pre_tdq_h_exp = 14;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadTDQExp);

            /* The threshold for tone detection was captured without FDQs so disable */
            /* them (except on the pilot tone). */
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQ);

            gs_RxSubStateCnt = 0;
            gs_RxSubState = R_C_REVERB3_RX_BIS_DETECT_PILOT;
#ifdef LOG_ECHO_DBG
            MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*(2*gs_RxNumTones)));
#endif
         }
      }
        break;

   case R_C_REVERB3_RX_BIS_DETECT_PILOT:

      if (gs_RxSubStateCnt < R_C_REVERB1_DET_CNT)
      {
         /* RT asks the CO to transmit C-TREF/C-QUIET during R-ECT. In both cases, */
         /* detect the transition by detecting the absence of reverb (incorporated */
         /* into DetectTone() routine). */
         if (DetectTone(gsa_RxToneBuf, gs_PilotToneIdx, (int16)(gs_PilotToneIdx-5),(int16)(gs_PilotToneIdx+5), (DETECT_SCALE*256)) )
         {
            gs_RxSubStateCnt++;
#ifdef LOG_ECHO_DBG
            if(gs_RxSubStateCnt <=(R_C_REVERB1_DET_CNT-2))
               Accum16to32(gla_RxAccumBuf, 0, gsa_RxToneBuf, 0, (int16)(2*gs_RxNumTones));
#endif
         }
         else
         {
            gs_RxSubStateCnt = 0;
#ifdef LOG_ECHO_DBG
            MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*(2*gs_RxNumTones)));
#endif
         }
      }
      else if (gs_RxSubStateCnt == R_C_REVERB1_DET_CNT)
      {
#ifdef LOG_ECHO_DBG

           if (gt_INFX_CMV.s_CTUNE_NMSForce_mask & 0x0004)
         {
            RightShiftAndRound32to16((int16 *)(void *)gpsa_EchoLog, 0, gla_RxAccumBuf, 0,gs_RxSamplesPerFrame, 2);
         }


#endif
         /* Eable FDQs now that C-TREF2/C-QUIET5 detection is done. */
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQ);

#ifdef ADSL_62
            gs_RtvSelect = FFT_OUTPUT;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,ConfigRTVBuf0_train);
#else
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFrameStartInt);

#endif
         gs_RxSubStateCnt++;
      }
      else if (gs_RxSubStateCnt > R_C_REVERB1_DET_CNT)
      {
            gs_RxNextState = R_C_TREF2_RX_BIS;
         gpF_RxStateFunc = (PtrToFunc)RCPilot3Tref2RxF;

#ifdef ADSL_62
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, Disable_FFT);
#else
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQDoneNTC_DisableGetRxTones);
#endif
           // AR8_TF: PERF_DS_ALL_TI&CNXT_ChIDfrmTone1 (Start)
#ifndef  ISDN  // Only for Annex - A
           // Do the Frame Sync and Chnl Identification from Rx Chnl 1 for Better TDQ Training
           // TI CO's send RCREVERB from chnl 24 onwards.
           // Enable this change for TI and Connexant DSLAM's which will send expanded Reverb
           // Signal.
           // This may be enabled for other DSLAMs if this change helps to improve the DS
           // Performance.
           // if ((gs_CurrentCoChipset == GSI_CO_CHIPSET)||(gs_CurrentCoChipset == TI_CO_CHIPSET))
           // {
           gs_RxFirstChannel = gs_RxFirstChannelSave;
           // }
#endif // ifndef ISDN
           // AR8_TF: PERF_DS_ALL_TI&CNXT_ChIDfrmTone1 (End)
        }

      /*  check for timeout */
        if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
      s_length = R_C_REVERB3_MAX_RX_LEN_BIS +10;
      else
          s_length = R_C_REVERB3_RX_LEN_BIS_DIAG +10;

      if(gl_RxSymbolCount >= s_length)
      {  /* run out of time */
         gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

         /* Set exception handler variables */
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_RCReverb3Rx_bis_SignalEnd_Failure;
      }
      break;

   default:
      /* Common utility function between DMT and BIS modes for Reverb w/o echo state */
      RCReverbFrameSyncFdq();
      break;
    }
}

#undef R_C_REVERB3_RX_BIS_COMPUTE_HCHAN
#undef R_C_REVERB3_RX_BIS_WAIT
#undef R_C_REVERB3_RX_BIS_DETECT_PILOT
