/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCReverb4RxF_bis.c
 *
 *   Transceiver Training Phase RX State Functions for ATU-R.
 *   Covering the RX states: R_C_REVERB4
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RCReverb4RxF_bis.c
//
// History
// 23/08/2011 Kannan: TDQ scale factor was very high.
//    In order to scale the TDQ exponent we need one frame of Time domain
//      data. In order to capture the Time domain data VR9 requires another
//      2 symbol delay as compared to Danube. This is applicable
//      even while switching from Time Domain to Frequecny domain data.
//      Note: If the buffer does not contain proper time domain data,
//      we observed that TDQ training algo always choose the unity TDQ in
//      in long loops.
//      Grep for
//      XDSLRTFW-251 Bugfix_DS_ALL_ALL_TimeDomain_FreqDomain_switchingDelay
//
// 25/03/2014 Sriram Shastry: Changes done for "SMS01261908:Link drop issue during on-hook/off-hook in G.dmt with Catena/Ciena CNX-5 DSLAMs"
//                   Changed the name of the global variable gsa_RxPilotToneInCReverb4 to gsa_RxPilotToneInCReverb34.
//        Grep for XDSLRTFW-1633 SMS01261908 SMS001231692 PERF_DS_ADSL1_AB_Ciena_PLL_TRACKING_REVERB3
//
// ******************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "dsp_op.h"
#include "snr.h"
#include "rx_ops.h"
#include "pll.h"
#include "gdata.h"
#include "fifo.h"
#include "accum32.h"
#include "noiseacc.h"
#include "cmv.h"
#include "detect.h"
#include <string.h>
#include "memsetbf.h"
#include "const_bis.h"
#include "gdata_bis.h"
#include "ReverbSnr_b.h"
#include "states.h"
#include "RCMsg1RxF_BIS.h"
#include "RCReverb5RxF_bis.h"
#include "cmv.h"
#include "ovflw.h"
#include "bitload_const.h"

/* =============================================== */
/* variable declarations */
/* =============================================== */
/* the following is used by function RCReverb4RxF_BIS() only */
#ifdef CALC_REVERB_ECHO_SNR
int16 gs_RCReverb4SnrCnt_BIS;                      /* count used by SNR calculation */
#endif /*  CALC_REVERB_ECHO_SNR */

/*^^^
*-------------------------------------------------------------------
########               ########
######## RX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCReverb4RxF_BIS
 *
 *  Description: Computes SNR in this state for monitoring purposes only.
 *  Transition to R_C_MSGS1_RX after the detection of C_SEGUE1 signal
 *
 *  Prototype: void RCReverb4RxF_BIS(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gl_RxSymbolCount           - (I/O) RX symbol count
 *      gs_RxSubStateCnt             - (I/O) R_C_SEGUE1 count
 *      gs_RxState                   - State of the receiver state machine
 *    gsa_RxToneBuf[]               - (O) FFT output buffer
 *    gsa_NoisePower[]           - (I/O) accumulated noise power buffer
 *    gsa_CReverbRefTones[]        - (I) C_Reverb reference tone buffer
 *    gsa_ReverbEchoSnrBuf[]        - (O) SNR buffer
 *
 *  Substates:
 *      R_C_REVERB4_RX_BIS_INITIALIZE    - Waits for the channel to stabilize,
 *                                     then initializes the parameters used
 *                                     in the SNR calculation.
 *      R_C_REVERB4_RX_BIS_CALCULATE_SNR - Computes an SNR estimate for each
 *                                     downstream channel.
 *      R_C_REVERB4_RX_BIS_DETECT_SEGUE  - After the SNR calculation is completed,
 *                                     this substate monitors the received
 *                                     signal and searches for the C_SEGUE1
 *                                     symbol (frame). Once C_SEGUE1 is
 *                                     detected, the state machine is set to
 *                                     transition to the next state
 *                                     (R_C_MSGS1_RX).
 *
 *  Notes: implements state R_C_REVERB4_RX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* =============================================== */
/* substates */
/* =============================================== */
#define R_C_REVERB4_RX_BIS_INITIALIZE    (0)
#define R_C_REVERB4_RX_BIS_PREDETECT     (1)
#define R_C_REVERB4_RX_BIS_DETECT_SEGUE  (2)

void RCReverb4RxF_BIS(void) {

   int16 s_ToneType;
    int i; //XDSLRTFW-1633 SMS01261908 SMS001231692 PERF_DS_ADSL1_AB_Ciena_PLL_TRACKING_REVERB3 (START_END)

   /* ============================================== */
   /* Wait for channel to stablelized */
   /* ============================================== */
   switch(gs_RxSubState) {

      case R_C_REVERB4_RX_BIS_INITIALIZE:

         if (gl_RxSymbolCount == 0)
         {
         //XDSLRTFW-1633 SMS01261908 SMS001231692 PERF_DS_ADSL1_AB_Ciena_PLL_TRACKING_REVERB3 (START)
            gft_EnablePLL = TRUE;   //Turn on PLL now that transition to RCReverb3 is completed

            // Train PLL with reference pilot tone.
            gft_DDPilot = DD_PILOT_OFF;
            if (OPTNArray[OPTN_StateMachineCtrl] & OPTN_EnableDataOnPilot_Bis)
            {
               i = gs_PilotToneIdx;
               gsa_RxPilotToneInCReverb34[0] = (gsa_CReverbRefTones[i*2] >= 0)?(0x7fff):(0x8001);
               gsa_RxPilotToneInCReverb34[1] = (gsa_CReverbRefTones[i*2+1] >= 0)?(0x7fff):(0x8001);
            }
            else
            {
               gsa_RxPilotToneInCReverb34[0] = 0x7fff;
               gsa_RxPilotToneInCReverb34[1] = 0x7fff;
            }
            ConvertDataToPllRef(gsa_RxPilotToneInCReverb34);
         }
         else if (gl_RxSymbolCount == PLL_ACQUISITION_LEN0)
         {
            gft_DDPilot = DD_PILOT_ON;
            //XDSLRTFW-1633 SMS01261908 SMS001231692 PERF_DS_ADSL1_AB_Ciena_PLL_TRACKING_REVERB3 (END)
            /* Go to next substate */
            gs_RxSubStateCnt = 0;

            gs_RxSubState = R_C_REVERB4_RX_BIS_PREDETECT;

         }
         break;

   /* =================================================================== */
   /* Get one Reverb frame in time domain for TDQ scaling */
   /* =================================================================== */
      case R_C_REVERB4_RX_BIS_PREDETECT:
         if (gs_RxSubStateCnt == 0)
         {
            /* Set unity TDQ exponent to 1 for TDQ scaling capture. */
            gs_pre_tdq_h_exp = 14;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadTDQExp);
            /* Disable PLL to avoid glitches due to TDQ scaling loads. */
            gft_EnablePLL = FALSE;
#ifdef ADSL_62
            gs_RtvSelect = FFT_OUTPUT;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,ConfigRTVBuf0_train);
#endif
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFrameStartInt);
         }
         if (gs_RxSubStateCnt == 1)
         {
#ifdef ADSL_62
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, Disable_FFT);
#endif
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,DisableFDQDoneNTC_DisableGetRxTones);
         }
#ifdef ADSL_62
         //XDSLRTFW-251 Bugfix_DS_ALL_ALL_TimeDomain_FreqDomain_switchingDelay (START-END)
         //VR9 platform requires another 2 symbol delay to get proper
         //time domain signal. Earlier the delay was 3 symbols(code taken from
         //Danube platform), Now the delay would be 5 symbols.
         if (gs_RxSubStateCnt == 3+2)
#else
         if (gs_RxSubStateCnt == 3)
#endif
         {
            memcpy(&(gsa_RxRepFrameAlignBuf[gs_RxSamplesPerFrame]), gsa_RxToneBuf, sizeof(int16)*gs_RxSamplesPerFrame);

            /* Load back unity TDQ exponent. */
            gs_pre_tdq_h_exp = gs_UnityTDQExp;
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadTDQExp);

#ifdef ADSL_62
                AddFunctionToFifo(gp_RxLoadingFunctionFifo, Enable_FFT);
#endif
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFdqDoneInt);
         }
#ifdef ADSL_62
         //XDSLRTFW-251 Bugfix_DS_ALL_ALL_TimeDomain_FreqDomain_switchingDelay (START-END)
         if (gs_RxSubStateCnt == 4 + 2)
#else
         if (gs_RxSubStateCnt == 4)
#endif
         {
#ifdef ADSL_62
                gs_RtvSelect = SFDQ_OUTPUT;
                AddFunctionToFifo(gp_RxLoadingFunctionFifo,ConfigRTVBuf0_train);
#endif
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,EnableFDQDoneNTC_EnableGetRxTones);
         }
#ifdef ADSL_62
         //XDSLRTFW-251 Bugfix_DS_ALL_ALL_TimeDomain_FreqDomain_switchingDelay (START-END)
         if (gs_RxSubStateCnt == 6 + 2)
#else
         if (gs_RxSubStateCnt == 6)
#endif
         {
            /* Re-enable PLL. */
            gft_EnablePLL = TRUE;

            // Goto next substate when search complete
            gs_RxSubStateCnt = -1;
            gs_RxSubState = R_C_REVERB4_RX_BIS_DETECT_SEGUE;
         }
         gs_RxSubStateCnt++;
         break;

   /* =============================================== */
   /* Detect C_SEGUE1 */
   /* =============================================== */
      case R_C_REVERB4_RX_BIS_DETECT_SEGUE:

      /*  wait to detect C_SEGUE1 */
         s_ToneType = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

      /*  if incoming symbol is C_Segue, then incr. counter */
      /*  else reset counter */
         if (s_ToneType == C_SEGUE)
            gs_RxSubStateCnt++;
         else
            gs_RxSubStateCnt = 0;

            if(gl_RxSymbolCount == (gs_RCReverb4_rx_len_bis - 10))
               gft_EnablePLL = FALSE;

         if (gs_RxSubStateCnt == gl_CyclicPrefixInsertCnt) {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,InsertRxCP);
         }
      /*  C_SEGUE1 detected, go to next state */
         if (gs_RxSubStateCnt >= R_C_SEGUE1_LEN)
         {
                gft_EnablePLL = TRUE;

            if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
            {
            gs_RxNextState = R_C_MSG1_RX_BIS;
            gpF_RxStateFunc = (PtrToFunc)RCMsg1RxF_BIS;

               // Save the Rx overflow counters for the current state
            memcpy(gusa_RCReverb3_RxOverflowCnts, gusa_RxOverflowCnts, NUM_RX_OVFLOW_CNTRS*sizeof(uint16));
             }
            else
            {
            gs_RxNextState = R_C_REVERB5_RX_BIS;
            gpF_RxStateFunc = (PtrToFunc)RCReverb5RxF_BIS;
            }
         }

      /* Check for timeout  */
      /* (allow extra 30 symbols for some time flexibility) */
         else if (gl_RxSymbolCount > (gs_RCReverb4_rx_len_bis + 30)) {

            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

         /* Set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_RCReverb4Rx_Bis_C_SEGUE1_Failure;
         }
         break;
   } /* switch */

}

#undef R_C_REVERB4_RX_BIS_INITIALIZE
#undef R_C_REVERB4_RX_BIS_PREDETECT
#undef R_C_REVERB4_RX_BIS_DETECT_SEGUE
