/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCReverb5RxF_bis.C
 *
 *   Exchange phase states functions for both TX and RX.
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "fifo.h"
#include "tx_ops.h"
#include "detect.h"
#include "memsetbf.h"
#include "engine_const.h"
#include "const_bis.h"
#include "states.h"
#include "RCMedleyRxF_BIS.h"
#include "cmv.h"

 /*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCReverb5RxF_BIS
 *
 *
 *  Prototype: void RCReverb5RxF_BIS(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gl_RxSymbolCount           - (I/O) RX symbol count
 *      gs_RxSubStateCnt            - (I/O) R_C_SEGUE2 count
 *      gs_RxState                    - State of the receiver state machine
 *
 *  Substates:
 *
 *  Notes: implements states R_C_REVERB5_RX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RCReverb5RxF_BIS(void) {

   int16 s_ToneType;

if(gl_RxSymbolCount == 0)
   {
      gs_RxSubStateCnt =0;

      gt_StateMachCntrl.s_RXFollowingState = R_C_MEDLEY_RX_BIS;
      gt_StateMachCntrl.pF_RxFollowingState = (PtrToFunc)RCMedleyRxF_BIS;

      if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
      gt_StateMachCntrl.s_RxTimeOutLen = R_C_REVERB5_MAX_RX_LEN_BIS;
        else
      gt_StateMachCntrl.s_RxTimeOutLen = R_C_REVERB5_RX_LEN_BIS_DIAG;
}

   /*  wait to detect C_SEGUE2 */
   s_ToneType = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

   /*  if incoming symbol is C_Segue, then incr. counter */
   /*  else reset counter */
   if (s_ToneType == C_SEGUE)
      gs_RxSubStateCnt++;
   else
      gs_RxSubStateCnt = 0;

   if (gs_RxSubStateCnt >= R_C_SEGUE2_LEN) {
      /*  C_SEGUE2 detected, go to next state */
      gs_RxNextState = gt_StateMachCntrl.s_RXFollowingState;
      gpF_RxStateFunc = gt_StateMachCntrl.pF_RxFollowingState;
   }

   /*  if C_SEGUE not detected yet, then the ATU-C has timed out */
   /*  goto FAIL_RX state */
   if (gl_RxSymbolCount > gt_StateMachCntrl.s_RxTimeOutLen + R_C_SEGUE2_LEN) {
      gs_RxNextState = FAIL_RX;
      gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

      /* Set exception handler variables */
      gus_ExceptionState   = gs_RxState;
      gus_ExceptionCode = E_CODE_RCReverb5Rx_Bis_C_SEGUE_Failure;
   }
}

