/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCReverb6RxF_bis.c
 *
 *   Transceiver Training Phase RX State Functions for ATU-R.
 *   Covering the RX states: R_C_REVERB6
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "dsp_op.h"
#include "snr.h"
#include "rx_ops.h"
#include "gdata.h"
#include "fifo.h"
#include "detect.h"
#include <string.h>
#include "const_bis.h"
#include "gdata_bis.h"
#include "states.h"
#include "RCParamsRxF_BIS.h"
#include "cmv.h"

/*^^^
*-------------------------------------------------------------------
########               ########
######## RX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCReverb6RxF_BIS
 *
 *  Description: Transition to R_C_PARAMS_RX after the detection of C_SEGUE3
 *               signal
 *
 *  Prototype: void RCReverb5RxF_BIS(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gl_RxSymbolCount           - (I/O) RX symbol count
 *      gs_RxSubStateCnt             - (I/O) R_C_SEGUE1 count
 *      gs_RxState                   - State of the receiver state machine
 *
 *  Notes: implements state R_C_REVERB6_RX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RCReverb6RxF_BIS(void) {

   int16 s_ToneType, s_R_C_REVERB6_RX_MIN_LEN_BIS, s_R_C_REVERB6_RX_MAX_LEN_BIS;

   if (( gl_SelectedMode & (MODE_G992_5)  ))
   {
      s_R_C_REVERB6_RX_MIN_LEN_BIS = gs_RxNumTones - gs_TxNumTones - 10;
      s_R_C_REVERB6_RX_MAX_LEN_BIS = gs_RxNumTones - gs_TxNumTones + 1990 + 100; /* +100 is only a arbitrary number >0 */
   }
   else
   {
      s_R_C_REVERB6_RX_MIN_LEN_BIS = 246-gs_TxNumTones;
      s_R_C_REVERB6_RX_MAX_LEN_BIS = 2246-gs_TxNumTones+10;

   }

   if(gl_RxSymbolCount >= (s_R_C_REVERB6_RX_MIN_LEN_BIS - 10))
   {
      /*  wait to detect C_SEGUE3 */
         s_ToneType = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

      /*  if incoming symbol is C_Segue, then incr. counter */
      /*  else reset counter */
         if (s_ToneType == C_SEGUE)
            gs_RxSubStateCnt++;
         else
            gs_RxSubStateCnt = 0;
   }

      /*  C_SEGUE3 detected, go to next state */
   if (gs_RxSubStateCnt >= R_C_SEGUE1_LEN)  {
      gs_RxNextState = R_C_PARAMS_RX_BIS;
      gpF_RxStateFunc = (PtrToFunc)RCParamsRxF_BIS;

   }

      /* Check for timeout  */
         if (gl_RxSymbolCount >= (s_R_C_REVERB6_RX_MAX_LEN_BIS+10))
         {
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* Set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_RCReverb6Rx_Bis_C_SEGUE3_Failure;
         }

}


