/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCReverb7RxF_bis.C
 *
 *   Exchange phase states functions for both TX and RX.
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RCReverb7RxF_bis.c
//
// History
//
//
// 03/09/2008 Sriram Shastry: Clear gft_disableAnnexL  before entering SHOWTIME
//                     Grep for SMS00790593 IOP_DS_BRCM_BisPlus_DisableAnxL
//
// 20/08/2010  Sriram Shastry: Clear gus_CNXT_shortloop_cutpower before entering SHOWTIME
//                       Grep for SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut
//
// 14/04/2014 Hanyu: Ported ADSLRTFW-1391: Added a fix for CNX5 CO VID CTNW to avoid false
//                  "Showtime link drop" when CO retrains to select the best mode.
//                   Grep for XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY
//
// 14/04/2014 Hanyu: Ported ADSLRTFW-1391: Additional fix to control Tx R-Segue4 by a flag gft_CTNW_Tx_RSegue4
//                   since CNX5 has variable behavor on different cards/ports.
//                   Set the flag to allow R-Segue4 Tx if C-Segue4 is detected or timeout.
//                   Grep for XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY
//
// 14/04/2014 Hanyu: Ported ADSLRTFW-1391: Added more delay (total of 356 symbols) for ADSL2
//                   C-Segue4 detection since CNX5 has variable behavor
//                   on different cards/ports or loops in ADSL2 mode.
//                   Grep for XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY
//
// ******************************************************************
#include "common.h"
#include "rt_state_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "fifo.h"
#include "detect.h"
#include "const_bis.h"
#include "states.h"
#include "rinfo_bis.h"
#include "cmv.h"
#include "mul.h"
#include "string.h"
#ifdef IFX_XTC
   #include "xtc_setup.h"
   #include "ConfigXtcIfRxPath.h"
#endif
#ifdef CUSTOMER_TASKS
   #include "customertasks.h"
#endif


 /*^^^
 *------------------------------------------------------------------------
 *
 *  Name: GetLowestLatencyPath
 *
 *
 *  Prototype: uint8 GetLowestLatencyPath(Config_t* pt_config)
 *
 *  Input Arguments: Config_t* pt_config
 *
 *  Output Arguments:
 *
 *  Return: uc_lowest_latency_lp
 *
 *
 *  Note: This utility function is used to find out the lowest latency path
 *    from the PMS parameter. According to the latency definition,
 *      where
 *           latency = [Sp*Dp]/4, ([] denotes rounding to the higher integer).
 *      Also, Sp = (8* CWSize / Lp) = (8* ( (Sum{Bpn}+1) * Mp) + Rp) ) / Lp).
 *
 *    Therefore, as a simple example, finding out min{latency_lp0, latency_lp1},
 *      is equivelant to finding out min{Sp_lp0*Dp_lp0, Sp_lp1*Dp_lp1}, or
 *    min{(CWSize_lp0*Dp_lp0)/Lp_lp0, (CWSize_lp1*Dp_lp1)/Lp_lp1}.

 *    To avoid division, we use the trick that we can compare (<, > , ==) two
 *    rational numbers a/b and c/d by comparing a*d with  b*c.
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE uint8 GetLowestLatencyPath(Config_t* pt_config)
{
   uint8 uc_lowest_latency_lp;
   uint16 us_K[NUM_DATA_PATHS], us_CWSize_times_Dp[NUM_DATA_PATHS];
   uint16 us_tempA, us_tempB;
   uint32 ul_temp1, ul_temp2;
   int lp, bc;

   // calculate CWSize*Dp
   for (lp = 0; lp < pt_config->s_Nlp; lp++ )
   {
      us_K[lp] = 0;
      for (bc = 0; bc < pt_config->s_Nbc; bc++)
      {
         if (lp == guca_txBCnToLPp[bc])
            us_K[lp] += pt_config->sa_Bpn[lp][bc];
      }

      us_K[lp]++;
        MULS16(us_tempA, us_K[lp], pt_config->s_Mp[lp]);
        us_tempA += pt_config->s_Rp[lp];
        MULS16(us_CWSize_times_Dp[lp], us_tempA, pt_config->s_Dp[lp]);
   }

   // find the lowest latency path
   us_tempA = us_CWSize_times_Dp[0];
   us_tempB = pt_config->s_Lp[0];
   uc_lowest_latency_lp = 0;

   for (lp = 1; lp < pt_config->s_Nlp; lp++)
   {
      // save the product into long word variable to avoid overflow
      ul_temp1 = (uint32)us_tempA*(uint32)pt_config->s_Lp[lp];
      ul_temp2 = (uint32)us_tempB*(uint32)us_CWSize_times_Dp[lp];
      if (ul_temp1 > ul_temp2)
      {
         us_tempA = us_CWSize_times_Dp[lp];
         us_tempB = pt_config->s_Lp[lp];
         uc_lowest_latency_lp = lp;
      }
   }

   return (uc_lowest_latency_lp);
}


 /*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCReverb7RxF_BIS
 *
 *
 *  Prototype: void RCReverb7RxF_BIS(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gl_RxSymbolCount           - (I/O) RX symbol count
 *      gs_RxSubStateCnt            - (I/O) R_C_SEGUE2 count
 *      gs_RxState                    - State of the receiver state machine
 *
 *  Substates:
 *
 *  Notes: implements states R_C_REVERB7_RX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */
#define R_C_REVERB7_WAIT_FOR_CRC_CHECK             (0)
#define R_C_REVERB7_DECODE_CPARAMS                 (1)
#define R_C_REVERB7_WAIT_FOR_TRANSITION_TO_SHOWTIME  (2)
// XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY (START)
// A flag to allow R-Segue4 Tx for CTNW CO/DSLAM.
FlagT gft_CTNW_Tx_RSegue4;
// XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY (END)

C_SCOPE void RCReverb7RxF_BIS(void) {

   int16 s_ToneType, s_numRevMatches, s_numSegueMatches;
  //XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY (START_END)
  int16 s_delay_symbol;

   if (gl_RxSymbolCount == 0)
   {
      gs_RxSubStateCnt =0;
      gs_TrainCnt=0;
     // XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY (START)
     // For Ciena CNX5 DSLAM, set gft_CTNW_Tx_RSegue4 = 1 if and only if
     // C-Segue4 is detected or timeout.
     // To avoid IOP issue with other DSLAMs,
     // only limit the change to Ciena CTNW at this time.
     // Other CO/FW ID can be added into the "if-condition" later if needed.
     gft_CTNW_Tx_RSegue4 = 1; // To allow Tx R-Segue4 by default
     // Initialize the flag=0 to control Tx R-Segue4 for CTNW CO.
     if (gs_CurrentCoChipset == CTNW_CO_CHIPSET)
       gft_CTNW_Tx_RSegue4 = 0;
     // XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY (END)
   }

   switch(gs_RxSubState)
   {
   case R_C_REVERB7_WAIT_FOR_CRC_CHECK:
         if (guc_CrcCalcState == TRAINING_DONE)
            gs_RxSubState = R_C_REVERB7_DECODE_CPARAMS;
         break;

   case R_C_REVERB7_DECODE_CPARAMS:
         if (gus_RC_CRC_received == gus_RC_CRC_computed)
         {
            gs_RxSubState = R_C_REVERB7_WAIT_FOR_TRANSITION_TO_SHOWTIME;
            DecodeCParams();
            guc_US_lowest_latency_LP = GetLowestLatencyPath(&gt_tx_config);
            gft_DecodeCParamsOK = TRUE; // Its default value is FALSE.
         }
         else
         {
            /* ============================================================ */
            /*  CRC's don't match:  go to FAIL state */
            /* ============================================================ */
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* Set exception handler variables */
            gus_ExceptionState   = gs_RxState;
            gus_ExceptionCode = E_CODE_RCCRC1Rx_Bis_C_PARAMS_DECOD_ERR;
         }
         break;

   case R_C_REVERB7_WAIT_FOR_TRANSITION_TO_SHOWTIME:
#ifdef IFX_XTC
      if (gft_AlphaeusSel == FALSE)
      {
         SetupRxXtcInput();
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ConfigXtcIfRxPath);
      }
#endif


         // workaround to prevent CPE Crashing against old Geminax FW (07.0F.03)
         // (1). Geminax cannot handle the case if CPE failed bitloading,
         // (a). Its state machine goes into showtime  without configuring showtime variables.
         // (b)  Its state machine tries to configure Iridia with junk values on C_SEGUE4 and it still enables
         // Iridia before showtime.
         // We saw CPE detected the garbage signal as segue, transited to showtime before showtime page is swapped in
         // and crashed. We make CPE not enter showtime but set exception code (bitloading_exception + segue_detect_exception)
         // if bitloading exception flag is on and the number of (falsely) detected segue symbols is greater than 5.

         //  Make sure we don't enter showtime if bitload Exception code is set.
          if (gus_BitloadExceptionCode != 0 && gs_CurrentCoChipset ==  IFTN_CO_CHIPSET && gs_RxSubStateCnt > 5)
      {
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* Set exception handler variables */
            gus_ExceptionState = gs_RxState;
            gus_ExceptionCode = E_CODE_RCReverb7Rx_Bis_C_SEGUE_Quiet_Failure;
      }

      break;

   } // switch(gs_RxSubState)


   if ((gs_TxState == R_REVERB7_TX_BIS)||(gs_TrainCnt > 0))
      gs_TrainCnt++;

   // Here we settle with 7 successful segue detections (instead of 10) for two reasons:
   // 1. Excess margin reduction
   // Detect 7 segue frames instead of 10, to load FDQ with 6dB gain
   // 2. Since at 8 Segues we start the non-reversible procedure of transitioning into Showtime,
   // we commit to the state transition at this point
   if (gs_RxSubStateCnt < R_C_SEGUE2_LEN - 3)
   {
      /*  wait to detect C_SEGUE2 */
      DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, &s_numRevMatches, &s_numSegueMatches);
      if(s_numSegueMatches >= ((3*gs_RSDetect_NumBins+1)>>2))  /* Segue matches over 3/4 of all tones tested */
         s_ToneType = C_SEGUE;
      else
         s_ToneType = C_REVERB;

      /*  if incoming symbol is C_Segue, then incr. counter */
      /*  else reset counter */
      if (s_ToneType == C_SEGUE)
      {
         gs_RxSubStateCnt++;
      }
      else
         gs_RxSubStateCnt = 0;

      // Check for loss of pilot.  This can happen if CO intentionally retrains instead of continuing to showtime.
      // If pilot is bad don't detect a Segue to reduce chance of mistakenly entering showtime.
// XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY (START)
// When Ciena CNX5 intentionally retrains to compare different modes on mid-long loops,
// it sends C-Segue4 too early, i.e. CNX5 only sends 84 symbols of C-Reverb7
// in ADSL2 that violates ITU spec of minimum 128 symbols followed by C-Segue4. In ADSL2+, CNX5 sends
// 302 symbols of C-Reverb7 in intentional retrains.
// However, in normal training without CO intentional retrains, CNX5 does send
// 645 and 829 symbols of C-Reverb7 in ADSL2/L and 2+ modes, respectively.
// A fix is added for CNX5 CO VID CTNW to avoid
// false "Showtime link drop" which could cause confusing at AT&T lab tests
// and field deployment.
       // As per G.992.3/5, the minimum delay should be 128 symbols.
       // Detecting C-Segue4 too early could result in false showtime link drop
       // To avoid IOP issue with other DSLAMs, only limit the change to Ciena CTNW at this time.
       s_delay_symbol = 0; // No delay for other COs/DSLAMs.
#ifndef ISDN  // Annex A only
       if (gs_CurrentCoChipset == CTNW_CO_CHIPSET)
       {
        if (gl_SelectedMode & (MODE_G992_5))
          // For CNX5 in ADSL2+ mode, delay 428+10 symbols of
          // (LENGTH_AFTER_BOTH_ATU_IN_REVERB7 + R_C_SEGUE2_LEN)
          // to start C-Segue4 detection to avoid "Showtime link drop"
          // based on experiments at AT&T lab.
          s_delay_symbol = 438;
        else
          // For CNX5 in ADSL2 mode, delay 356 symbols
          // to start C-Segue4 detection to avoid "Showtime link drop"
          // based on experiments at AT&T lab.
          s_delay_symbol = 356;
       }
#endif
       if ((gft_PilotPowerOK == 0) ||
           (gs_TrainCnt < s_delay_symbol))
// XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY (END)
      {
         gs_RxSubStateCnt = 0;

#if 0
         // Following was seen to trigger falsely on 24DSL 16kft loops.  Since this isn't a critical workaround (it only prevents false showtime entry), it is safer to disable for now.
         //-----------------------------------------------------------------------------------
         // Issue found where Geminax CO intentionally retrains, it sends 1 symbol of Seque,
         // then Quiet, followed by Seque until the CO completes reset.  The CPE would detect this
         // as Seque and enter Showtime while the CO Resets.
         if (gs_CurrentCoChipset ==  IFTN_CO_CHIPSET)
         {
            gs_RxNextState = FAIL_RX;
            gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

            /* Set exception handler variables */
            gus_ExceptionState = gs_RxState;
            gus_ExceptionCode = E_CODE_RCReverb7Rx_Bis_C_SEGUE_Quiet_Failure;
         }
#endif

      }
   }
   else
   {
      // increment the counter after 7 frames
      gs_RxSubStateCnt++;

      if (gs_RxSubStateCnt == R_C_SEGUE2_LEN - 2)
      {
         if(!(OPTNArray[OPTN_PwrManControl] & OPTN_ExMarginRedDisable))
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadFDQ);
         }
      }
   }

   /* Train to showtime transition */
   DoRxFFTBufferScenarioTransition(gs_RxSubStateCnt, R_C_SEGUE2_LEN);


#ifdef ADSL_62
   if (gs_RxSubStateCnt == R_C_SEGUE2_LEN - 2)
   {
      memcpy(gsa_RxBuffer8X_1, gsa_pre_FDQ_coef, sizeof(int16)*gs_RxSamplesPerFrame);

      //move FDQ coefficients array to YMEM (L2 functionality requires FDQ reside in XYmem).
      gsa_FDQ_coef_out = gsa_pre_FDQ_coef = (int16 *) gsa_RxBuffer8X_1;
        //move RxToneBuf to YExtended
      gsa_RxToneBuf = (int16 *) gsa_YBlock_Extended;
   }
#endif

   if (gs_RxSubStateCnt == R_C_SEGUE2_LEN - 1)
   {
      /* Change or rather initialize the captured tone index (in an Iridia register) */
      AddFunctionToFifo(gp_RxLoadingFunctionFifo,ChangeCapturedToneIdx);
#ifndef ISDN
        //IOP_DS_BRCM_BisPlus_DisableAnxL (Start-End)
        //clear the flag before entering showtime
      gft_disableAnnexL = 0;
        //SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut (START_END)
        //clear the flag of Tx cut power for CNXT D57 CO before entering SHOWTIME
        //SMS00822444 IOP_DS_ADSL1_CTLM_ShortLoopTxPowercut (START_END)
        //Renamed flag as this is applied to other CO
        gus_shortloop_cutpower = 0;
        gft_pAnnexLBTLoops_CNXT = FALSE;//XDSLRTFW-2033
#endif
        // XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY (START)
        // When Ciena CNX5 intentionally retrains, we have to control Tx R-Segue4
        // by this flag since CNX5 has variable behavor on different cards/ports.
        // Set the flag to allow R-Segue4 Tx if C-Segue4 is detected.
        gft_CTNW_Tx_RSegue4 = 1;
        // XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY (END)
#ifdef IFX_XTC
      if (gft_AlphaeusSel == FALSE)
      {
         // Enable Rx xTC I/F
         AddFunctionToFifo(gp_RxLoadingFunctionFifo,EnableRxXtcIF);
      }
#endif

   }
    // XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY (START)
    // Set the flag to allow R-Segue4 Tx if C-Segue4 detection is timeout.
    // The timeout threshold = (2048+10) - (10+2*128), derived from G.992.3/5.
    // If timeout occurs, most likely CO is waiting for our R-Segue4.
    if (gs_TrainCnt == (R_C_REVERB7_RX_MAX_LEN_BIS - 266))
       gft_CTNW_Tx_RSegue4 = 1;
    // XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY (END)

/*  if C_SEGUE not detected within the (max possible length+10), */
/*  goto FAIL_RX state */
   if (gs_TrainCnt >= (R_C_REVERB7_RX_MAX_LEN_BIS+10))
   {
      gs_RxNextState = FAIL_RX;
      gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

      /* Set exception handler variables */
      gus_ExceptionState   = gs_RxState;
      gus_ExceptionCode = E_CODE_RCReverb7Rx_Bis_C_SEGUE_Failure;
   }

}

#undef R_C_REVERB7_WAIT_FOR_CRC_CHECK
#undef R_C_REVERB7_DECODE_CPARAMS
#undef R_C_REVERB7_WAIT_FOR_TRANSITION_TO_SHOWTIME
