/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCSegueLDRxF_bis.C
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "gdata_bis_diag.h"
#include "const_bis.h"
#include "states.h"
#include "RCMsgLDRxF_bis.h"
#include "RCQuietL3RxF_bis.h"
#include "vecpwr.h"
#include "detect.h"

 /*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCSegueLDRxF_BIS
 *
 *
 *  Prototype: void RCSegueLDRxF_BIS(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gl_RxSymbolCount           - (I/O) RX symbol count
 *      gs_RxSubStateCnt            - (I/O) R_C_SEGUE2 count
 *      gs_RxState                    - State of the receiver state machine
 *
 *  Substates:
 *
 *  Notes: implements states R_C_SEGUE_LD_RX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RCSegueLDRxF_BIS(void)
{
   int16 s_numRevMatches, s_numSegueMatches;

   if(gl_RxSymbolCount == 0)
   {
      gs_RxSubStateCnt=0;
   }
   else if (gl_RxSymbolCount == R_C_SEGUE_LD_RX_LEN_BIS -1)
   {
      gs_RxNextState =  R_C_MSG_LD_RX_BIS;
      gpF_RxStateFunc = (PtrToFunc)RCMsgLDRxF_BIS;
   }

   /* If all DS LD messages have been recieved check for C-QUIET */
   if(guc_msg_ld_idx_ds == 6)
   {
      DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, &s_numRevMatches, &s_numSegueMatches);
      if (s_numSegueMatches >= ((3*gs_RSDetect_NumBins+1)>>2) ||
         s_numRevMatches  >= ((3*gs_RSDetect_NumBins+1)>>2))   /* Reverb or Segue matches over 3/4 of all tones tested */
      {
         gs_RxSubStateCnt = 0;
      }
      else
      {
         gs_RxSubStateCnt++;
      }

      /* If R_C_TRANSITION_CNT_BIS frames are considered as Quiet, */
      /* it means that CO has received the last R-ACK message */
      /* successfully and switch to C-QUIET(L3) */
      if(gs_RxSubStateCnt == R_C_TRANSITION_CNT_BIS)
      {
         gs_RxNextState = R_C_QUIET_L3_RX_BIS;
         gpF_RxStateFunc = (PtrToFunc)RCQuietL3RxF_BIS;
      }
   }
}
