/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCTref1LDRxF_bis.C
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "gdata_bis_diag.h"
#include "detect.h"
#include "engine_const.h"
#include "const_bis.h"
#include "states.h"
#include "RCTref2LDRxF_bis.h"
#include "pll.h"

 /*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCTref1LDRxF_BIS
 *
 *
 *  Prototype: void RCTref1LDRxF_BIS(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gl_RxSymbolCount           - (I/O) RX symbol count
 *      gs_RxSubStateCnt            - (I/O) R_C_SEGUE2 count
 *      gs_RxState                    - State of the receiver state machine
 *
 *  Substates:
 *
 *  Notes: implements states R_C_TREF1_LD_RX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RCTref1LDRxF_BIS(void) {

   int16 s_ToneType, s_temp1, s_temp2;
   uint16 us_infobit;

   s_temp1 = (int16)(gl_RxSymbolCount % 64);
   s_temp2 = (int16)(gl_RxSymbolCount % 8);

   if(s_temp1 == 0)
   {
   guc_R_C_Ack = 0;
   gs_RxSubStateCnt = -1;
   }

   if(s_temp2 == 0)
   {
   gs_RxSubStateCnt++;
   guc_Reverb_Counter = 0; /* Reset this counter */
   }

   /* More robust detection by enabling it only when Tx is in R-QUIET1-LD */
   if(gs_TxState == R_QUIET1_LD_TX_BIS)
   {
      /*  If it's not tref signal, further determine if it's Reverb or Segue frame. */
      if(!DetectTone(gsa_RxToneBuf, gs_PilotToneIdx, (int16)(gs_PilotToneIdx-5),(int16)(gs_PilotToneIdx+5), (DETECT_SCALE*256)) )
      {
      s_ToneType = DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL);

      /*  if incoming symbol is C_REVERB, then incr. counter */
      if (s_ToneType == C_REVERB)
         guc_Reverb_Counter++;

      if(s_temp2 == 7) /* Determine the received bit every 8 frames */
      {
         if(guc_Reverb_Counter > 3) /* If four or more frames are decoded as Reverb, 0 is considered as the transmitted bit */
            us_infobit = 0;
         else
            us_infobit = 1;

         guc_R_C_Ack |= us_infobit << (gs_RxSubStateCnt & 0x07);
      }

      if((s_temp1 == 63) && (guc_R_C_Ack == C_ACK_MESSAGE_LD))/* Determine if C-ACK message is received correctly every 64 frames */
      {
         /*  If C_ACK is received successfully, go to R_C_TREF2_LD_RX_BIS state */
         gs_RxNextState =  R_C_TREF2_LD_RX_BIS;
         gpF_RxStateFunc = (PtrToFunc)RCTref2LDRxF_BIS;
      }
      } /* End of if(!DetectTone(gsa_RxToneBuf, gs_PilotToneIdx, (int16)(gs_PilotToneIdx_bis-5),(int16)(gs_PilotToneIdx_bis+5), (DETECT_SCALE*256)) ) */
   }
}
