/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RCTref1RxF_BIS.c
 * DESCRIPTION:      Implements the RX state function for the C-TREF1 state
 *                   in G.dmt.bis.
 *
 **********************************************************************/

// **********************************************************************/
// History :  RCTref1RxF_BIS.c
// 14/09/2012 Sriram : Switched off the Tx images for better showtime stability in G.992.5M with CNXT DSLAM.
//                     Grep for :XDSLRTFW-524 IOP_US_AnxMPlus_ALL_iFFTScaleback_SwitchoffTxImagesCNXT
//
// 10/01/2013 Vinjam: Relocated "SOC OPTN 25" CMVs to "SOC OPTN 33" &
//            Added a new CMV "OPTN 33 0 0x0400" to Fix an issue with C-TREF1 detection in long loops
//            Reason: As per VRx message spec, "OPTN 25" is reserved for "Polling" far-end counters
//            Grep for XDSLRTFW-656 Fix_AB_DS_All_All_RelocateOptn25ToOptn33
//
// 5/4/2013 Enable images for Cnxt .. send only single image
//          XDSLRTFW-577 IOP_US_AnxMPlus_Cnxt_UsPerf
//
// 19/7/2013 Vinjam: Removed one image sent to Lucent Stringer DSLAM (CNXT) in G.992.5M mode as it is causing link drops
//           in loop reach automation tests (with Flexit2).
//           Grep for XDSLRTFW-1096 Fix_A_DS_BisPlus_CNXT_RemoveOneImage
// ********************************************************************************************************************/


#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "dsp_op.h"
#include "snr.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "ifft_fix.h"
#include "pll.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "frm_sync.h"
#include "tdq_init.h"
#include "fdq_init.h"
#include "fft_bg.h"
#include "ec_init.h"
#include "xrtstate.h"
#include "states.h"
#include "fifo.h"
#include "compiler.h"
#include "ec_data.h"
#include "accum32.h"
#include "noiseacc.h"
#include <string.h>
#include "cmv.h"
#include "aec_init.h"
#include "const.h"
#include "compiler.h"
#include "T1413.h"
#include "vecpwr.h"
#include "memsetbf.h"
#include "afe.h"
#include "xcvr_rx1_b.h"
#include "detect.h"
#include "RCReverb2RxF_BIS.h"
#include "dsp_op2.h"
#include "afe_hyb.h"
#include "HybridTraining.h"

#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif


/* =============================================== */
/* static variable declarations */
/* =============================================== */
extern int16 gs_aec_order, gs_log2_aec_order;

/**********************************************************************
 *  Function: RCTref1RxF_BIS
 *
 *  Description: This state coincides with C-TREF1 state.
 *  It sets PGA and runs PLL through C-TREF1 state.
 *
 *  Prototype: void RCTref1RxF_BIS(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_RxSubState             - (I/O) Substate within current RX state
 *      gs_RxNextState            - (O)   Rx state starting next symbol period
 *      gl_RxSymbolCount          - (I)   count of symbols passed in current state
 *      gs_RxSubStateCnt          - (I/O) count of symbols passed in current substate
 *      gl_Pa                     - (I/O) accumulated power
 *      gs_PGA_offset             - (O)   PGA offset
 *      gs_RxToneBuf[]            - (O)   Output of FFT, set in RxPower()
 *
 *  Substates:
 *      R_C_REVERB1_RX_BIS_INITIALIZE - Waits a pre-determined number of symbols (frames)
 *                                      for the channel to stabilize, and clears the power
 *                                      measurement accumulator.  Also updates the PLL.
 *
 *      R_C_REVERB1_RX_BIS_SET_PGA    - Computes an average power to be used in setting
 *                                      the PGA, then adjusts and implements this setting
 *                                      into the PGA.  Also updates the PLL.
 *
 *
 *      R_C_REVERB1_RX_BIS_WAIT       - Waits until the current state (R_C_REVERB1_RX_BIS)
 *                                      completes, then sets the next state pointer to
 *                                      R_C_REVERB2_RX_BIS.  Also updates the PLL.
 *
 *  Notes: implements the state R_C_REVERB1_RX_BIS and R_C_TREF1_RX_BIS
 *
 **********************************************************************/
#if 0
extern void Pause(int16 s_Marker);
#endif

/* =============================================== */
/* substates */
/* =============================================== */
#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */

#define R_C_REVERB1_RX_BIS_PRE_WAIT             (120)
#define R_C_REVERB1_RX_BIS_WAIT                 (130)

#else // Non-AMAZON_AFE
#define R_C_REVERB1_RX_BIS_DETECT_CTREF1           (115)
#define R_C_REVERB1_RX_BIS_PRE_WAIT             (116)
#define R_C_REVERB1_RX_BIS_WAIT                 (14)


#endif   /* End of #ifdef/#else AMAZON_AFE */
void RCTref1RxF_BIS(void)
{
#ifdef ISDN
   FlagT ft_TxImages_BackUp = 0;
#endif

#ifdef BIS_CODESWAP
   /* Start XCVR2 page to be swapped */
   if ((gs_CodeSwapStatus == CODESWAP_IDLE) && (gs_CodeSwapSection == CSPAGE_BIS_XCVR2)
      && (gs_TxState == R_REVERB2_TX_BIS)) {
      gs_CodeSwapStatus = CODESWAP_START;
   }
#endif

    switch (gs_RxSubState) {

     case R_C_REVERB1_RX_BIS_DETECT_CTREF1:

#ifdef ISDN
      //XDSLRTFW-656 Fix_AB_DS_All_All_RelocateOptn25ToOptn33 (Start)
      if (OPTNArray[OPTN_AlgControl3] & CMV_TO_DETECT_CTREF_LONG_LOOPS)
      {
         // Dis-able image creation for short time to help in C-Tref detection.
         // This is a workaround is to pass the traing in long loops.
         if(gs_PilotToneIdx <= 128)
         {
            ft_TxImages_BackUp = gft_TxImages;
            gft_TxImages = 0;
         }
      }
      //XDSLRTFW-656 Fix_AB_DS_All_All_RelocateOptn25ToOptn33 (End)
#else
      // XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (START)
      if ((gl_SelectedMode & (ANNEX_M)) && (gs_AnnexBMJPSDMaskIdx > 3))
      {
         // Dis-able image creation for short time
         // to help in C-Tref detection.
         // This is a workaround is to pass the traing in long loops >= 4Km.
         // Proper fix is to remove the echo of the TX images by storing the
         // echo. This is possible becuase TX/echo is periodic.
         gft_TxImages = 0;
      }
#endif

      // XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (END)
      if(gl_RxSymbolCount >= (gs_R_C_REVERB1_RX_LEN_BIS - 80))
      {
         /* Detect C-TREF1 by detecting PILOT TONE. */
         if (DetectTone(gsa_RxToneBuf, gs_CPilotTone, (int16)(gs_CPilotTone-5),(int16)(gs_CPilotTone+5), (int16)(gs_ToneDetectScale*256)))


         gs_TrainCnt++;
         else
         gs_TrainCnt = 0;



         if(gs_TrainCnt == R_C_TRANSITION_CNT_BIS)
         {
               gs_RxSubStateCnt =0;
               gs_TrainCnt =0;
            gs_RxSubState = R_C_REVERB1_RX_BIS_PRE_WAIT;

#ifdef ISDN
            //XDSLRTFW-656 Fix_AB_DS_All_All_RelocateOptn25ToOptn33 (Start)
            if (OPTNArray[OPTN_AlgControl3] & CMV_TO_DETECT_CTREF_LONG_LOOPS)
            {
               // enable back the image creation, was disabled for short time to help in C-Tref detection.
               // This is a workaround to pass the traing in long loops.
               if(gs_PilotToneIdx <= 128)
               {
                  gft_TxImages = ft_TxImages_BackUp; //Restore back
               }
            }
            //XDSLRTFW-656 Fix_AB_DS_All_All_RelocateOptn25ToOptn33 (End)
#else
            // XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (START)
            if ((gl_SelectedMode & (ANNEX_M)) && (gs_AnnexBMJPSDMaskIdx > 3))
            {
               // enable the image creation
               // XDSLRTFW-524 IOP_US_AnxMPlus_ALL_iFFTScaleback_SwitchoffTxImagesCNXT (START)
               // For Connexant Adsl2pM Mode , disable the Tximages as a work around for stable showtime
               if (((gl_SelectedMode == (MODE_G992_5 | ANNEX_M))) && (gs_CurrentCoChipset == GSI_CO_CHIPSET))
               {
                  //XDSLRTFW-1096 Fix_A_DS_BisPlus_CNXT_RemoveOneImage (Start_End)
                  gft_TxImages = 0;
               }
               else
               // XDSLRTFW-524 IOP_US_AnxMPlus_ALL_iFFTScaleback_SwitchoffTxImagesCNXT (END)
               {
                  gft_TxImages = 1;
               }
            }
            // XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (END)
#endif

         }
#if 0
            if(gl_RxSymbolCount >= (gs_R_C_REVERB1_RX_LEN_BIS + gs_R_C_TREF1_RX_LEN_BIS - 80))
            {
            Pause(1000);
            }
#endif
      }

      break;

   case R_C_REVERB1_RX_BIS_PRE_WAIT:

      if(gl_RxSymbolCount >= (gs_R_C_REVERB1_RX_LEN_BIS + gs_R_C_TREF1_RX_LEN_BIS - 80))
      {
         gs_RxSubState = R_C_REVERB1_RX_BIS_WAIT;
         gs_RxSubStateCnt = 0;
            gs_TrainCnt =0;
      }

   break;

   case R_C_REVERB1_RX_BIS_WAIT:
      gs_RxSubStateCnt++;

      if(gs_RxSubStateCnt == 1)
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, MoveToFdqDoneInt);    // Enable FFT for detecting C-REVERB2

      if(gs_RxSubStateCnt == 2)
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableFDQDoneNTC_EnableGetRxTones);     // Enable FFT for detecting C-REVERB2
         gft_EnablePLL = FALSE;
      }

      if(gs_RxSubStateCnt >= 5)
      {
         /* Detect C-REVERB2 by detecting PILOT TONE going off. */

         if (!DetectTone(gsa_RxToneBuf, gs_PilotToneIdx, (int16)(gs_PilotToneIdx-5),(int16)(gs_PilotToneIdx+5), (int16)(gs_ToneDetectScale*256)))
         gs_TrainCnt++;
         else
         gs_TrainCnt = 0;

         if(gs_TrainCnt == R_C_TRANSITION_CNT_BIS)
         {

            gs_RxNextState = R_C_REVERB2_RX_BIS;
            gpF_RxStateFunc = (PtrToFunc)RCReverb2RxF_BIS;


                if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
            gft_BIS_TX_transition = TRUE;    /* TX may enter R-QUIET5 for non-diagnostics mode */
         }
      }
#if 0
      if(gl_RxSymbolCount >= (gs_R_C_REVERB1_RX_LEN_BIS + gs_R_C_TREF1_RX_LEN_BIS - 80+63))
      {
         Pause(1000);
      }
#endif
      break;

    } /* switch(gs_RxSubState) */
}




#undef R_C_REVERB1_RX_BIS_CTREF1_WAIT
#undef R_C_REVERB1_RX_BIS_PRE_WAIT
#undef R_C_REVERB1_RX_BIS_WAIT

