/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RCTref12LDRxF_bis.C
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "rx_ops.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "gdata_bis_diag.h"
#include "const_bis.h"
#include "states.h"
#include "RCSegueLDRxF_bis.h"
#include "RCTref1LDRxF_bis.h"
 /*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RCTref2LDRxF_BIS
 *
 *
 *  Prototype: void RCTref2LDRxF_BIS(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gl_RxSymbolCount           - (I/O) RX symbol count
 *      gs_RxSubStateCnt            - (I/O) R_C_SEGUE2 count
 *      gs_RxState                    - State of the receiver state machine
 *
 *  Substates:
 *
 *  Notes: implements states R_C_TREF2_LD_RX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RCTref2LDRxF_BIS(void) {

   /* If state machine enters this state, it means  */
   /* C-ACK message for the current iteration is received successfully. */
   if (gl_RxSymbolCount == 0)
      gft_RCAckLDRcvFlag = RECEIVE_OK1;

   if (gl_RxSymbolCount == R_C_TREF2_LD_RX_LEN_BIS -1)
   {
      /* If the last R-MSGx-LD transaction completed successfully, */
      /* switch to R_C_SEGUE_LD state. */
      if (gs_TxState == R_QUIET2_LD_TX_BIS)
      {
         gs_RxNextState =  R_C_SEGUE_LD_RX_BIS;
         gpF_RxStateFunc = (PtrToFunc)RCSegueLDRxF_BIS;
      }
      else /* There are more R-MSGx-LD messages to be transmitted */
      {
         gs_RxNextState =  R_C_TREF1_LD_RX_BIS;
         gpF_RxStateFunc = (PtrToFunc)RCTref1LDRxF_BIS;
      }
   }
}
