/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RComb1TxF_BIS.c
 * DESCRIPTION:      Implements the TX state function for the R-COMB1 state
 *                   in G.dmt.bis.
 *
 **********************************************************************/

#include "common.h"
#include "rt_state.h"
#include "fifo.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "gdata_bis_diag.h"
#include "GenerateComb.h"
#include "states.h"
#include "RQuietTxF_bis.h"
#include "RMsgFmtTxF_bis.h"
#include "RLineProbeTxF_bis.h"
#include "cmv.h"
#include "RQuiet2SITxF_bis.h"

/**********************************************************************
 * Function: RComb1TxF_BIS
 *
 * Description: Implements the states R_COMB1_TX_BIS
 **********************************************************************/

void RComb1TxF_BIS(void)
{
   int16 s_Gain;

   if(gl_TxSymbolCount == 0)
   {
      s_Gain = ENCGAIN2;      // Send R-COMB unless modified below

      // Prepare for transition to the next state

      if((STATArray[STAT_MacroState] == STAT_ShortInit) && (gft_CComb2_Detected == FALSE))
      {
         gt_StateMachCntrl.s_TXFollowingState = R_QUIET2_SI_TX_BIS;        /* Quiet2 state for short initialization */
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RQuiet2SITxF_BIS;
      }
      else
      {
         gt_StateMachCntrl.s_TXFollowingState = R_QUIET2_TX_BIS;
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RQuiet2TxF_BIS;
      }

      gt_StateMachCntrl.l_TXCurrentStateLen = R_COMB1_TX_LEN_BIS - 1;


      GenerateComb(gs_TxFirstChannel, gs_TxLastChannel, s_Gain);
      gft_IFFT_On = TRUE;        // Need to do IFFT for R-COMB/R-ICOMB symbol
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, Enable_IFFT_Reordering);
   }

   if(gl_TxSymbolCount == gt_StateMachCntrl.l_TXCurrentStateLen) {
      gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
        gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
   }
}
