/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   REctTxF.c
 *
 *   State Function for states R-ECT (DMT), R-ECT (Bis/Plus), and
 *   R-ECT-FR (Lite).
 *
 *   Notes:
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// REctTxF.c
//
// History
//
// 24/06/2011 Kannan: Added debug feature to measure the residual Echo on BT loops.
//                    It is disabled by default. It can be enabled using
//                    "VR9_DEC_TRAIN_DBG" defined ec_data.h
//                    Grep for XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA
//
// ******************************************************************
#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "ec_init.h"
#include "xrtstate.h"
#include "fifo.h"
#include "ec_data.h"
#include <string.h>
#include "memcopy.h"
#include "memsetbf.h"
#include "engine_const.h"
#include "RReverb2TxF.h"
#include "RReverbTxF_bis.h"
#include "RReverbFrTx3F.h"
#include "states.h"
#include "cmv.h"
#include "pll.h"
#include "medley.h"
#include "pn_tab.h"
#include "rmedley_Data.h"
#include "GenMedly.h"
#include "data_alloc.h"
#include "DSLEngin.h"
#include "hndshk_Data.h"

//#define ADSL_62_DEC_DEBUG
/* =============================================== */
/* global variable declarations */
/* =============================================== */

/* =============================================== */
/* static variable declarations */
/* =============================================== */

/*^^^
*-------------------------------------------------------------------
########               ########
######## TX ROUTINES   ########
########               ########
*-------------------------------------------------------------------
*^^^
*/

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: REctTxF
 *
 *  Description: Generating the probing training signal for training the ATU-R
 * Echo Canceller.  The probing training signal is vendor defined. The ATU-C transmits
 *  C_PILOT3/C_QUITE5 signal during this phase.
 *
 * The training signal used here is the PN sequence with the period of 2^14.
 *
 * The PN sequence, pn[k], contains binary numbers (0/1), and these binary
 * digits are modulated according to the following equation:
 *
 *    s[k] =  INIT_ECT_SIGNAL_LEVEL for pn[k] = 0
 *    s[k] = -INIT_ECT_SIGNAL_LEVEL for pn[k] = 1
 *
 *  where INIT_ECT_SIGNAL_LEVEL is the signal level at the D/A.
 *
 *  Prototype: void REctTxF(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *    gt_StateMachCntrl - (I/O) structure of state machine control variables
 *      gl_TxSymbolCount   - (I) # symbol periods in current TX state
 *      gs_TxNextState     - (O) TX state that will begin next symbol period
 *    gs_TxState        - (I) current TX state
 *
 *  Notes: implements states R_ECT_TX, R_ECT_TX_BIS, and R_ECT_FR_TX
 *
 *------------------------------------------------------------------------
 *^^^
 */
#define R_ECT_TX_INIT         (0)
#define R_ECT_TX_IMPULSE_QUIET   (1)
#define R_ECT_TX_TRAIN        (2)
#define R_ECT_TX_MEDLEY       (3)
//XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START)
#ifdef VR9_DEC_TRAIN_DBG
#define R_ECT_TX_SILENCE        (4)
#endif //VR9_DEC_TRAIN_DBG

#ifdef VR9_DEC_TRAIN_DBG
extern int16 gs_dbg_DEC_TxSignal;
#endif //VR9_DEC_TRAIN_DBG
//XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (END)
#ifdef ADSL_62
extern int16 gsa_TxTimeBuf[1024];

FlagT gft_DisableIfft;
int16 gs_TxFftLength_Sav;
int16 gs_TxLog2FftLength1_Sav;
#endif

extern int8 gft_DbgEcLoopBack;
int8 gft_DbgMTPR = 0;
void REctTxF(void)
{
   int16 i, s_TxLastChannel;

   switch (gs_TxSubState)
   {
      /* Get transmitter ready for DEC training. */
      case R_ECT_TX_INIT:
         if (gl_TxSymbolCount == 0)
         {
            /* Init. State Machine Control when this state is entered the first time. */
            switch (gs_TxState)
            {
               case R_ECT_TX:
                  gt_StateMachCntrl.l_TXCurrentStateLen = R_ECT_TX_LEN-1;
                  gt_StateMachCntrl.s_TXFollowingState  = R_REVERB2_TX;
                  gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RReverb2TxF;
                  break;

               case R_ECT_TX_BIS:
                  gt_StateMachCntrl.l_TXCurrentStateLen = R_ECT_TX_LEN_BIS-1;
                  gt_StateMachCntrl.s_TXFollowingState  = R_REVERB4_TX_BIS;
                  gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RReverb34TxF_BIS;
                  break;

               case R_ECT_FR_TX:
                  gt_StateMachCntrl.l_TXCurrentStateLen = R_ECT_FR_TX_LEN-1;
                  gt_StateMachCntrl.s_TXFollowingState  = R_REVERB_FR5_TX;
                  gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RReverbFrTx3F;
                  break;
            }
            /* Transmit zeros initially */
            memset(gsa_TxToneBuf,0,sizeof(int16)*gs_TxFftLength);
// TODO: Raghu
if (!gft_DbgEcLoopBack)
{
#ifdef ADSL_62
                //Disable IFFT and digit ordering at QT interface
            AddFunctionToFifo(gp_TxLoadingFunctionFifo,Disable_IFFT);
#else
                AddFunctionToFifo(gp_TxLoadingFunctionFifo,Disable_IFFT_Reordering);
#endif
}
            gft_IFFT_On    = FALSE;

         }
         else if (gl_TxSymbolCount == 2)
         {
            //enable DEC output since unity dec has been loaded in channel discovery.
            AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadUnityDEC);
         }
         /* Wait until the receiver is ready for DEC training. */
         else if ((gl_TxSymbolCount > 2) && (gs_StartDECTraining == FALSE) &&(guc_PgaState == TRAINING_DONE))
         {
#ifdef ADSL_62
                gs_TxFftLength_Sav = gs_TxFftLength;
                gs_TxLog2FftLength1_Sav = gs_TxLog2FftLength1;
                gs_TxFftLength = gs_TxFftLength_Oversample;
                gs_TxLog2FftLength1 = gs_TxLog2FftLength1_Oversample;
                gft_DisableIfft = 1;
#endif
                /* Initialize Tx Training counter */
            gs_TxDECTrainSymbolCount = -1;

            /* Mask Rx input to zero. */
            AddFunctionToFifo(gp_TxLoadingFunctionFifo,MaskRxInput);

#ifdef ADSL_62
// TODO: RAGHU
            if (!gft_DbgEcLoopBack)
                  AddFunctionToFifo(gp_TxLoadingFunctionFifo,SetTxSineGainUnity);
            else
               AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);
#endif

#ifdef ADSL_62_DEC_DEBUG
#ifdef ADSL_62
                AddFunctionToFifo(gp_TxLoadingFunctionFifo,Disable_FFT);
#else
                AddFunctionToFifo(gp_RxLoadingFunctionFifo,MoveToFrameStartInt);
#endif
#endif
            /* Go to next substate. */
            gs_TxSubState = R_ECT_TX_IMPULSE_QUIET;
         }
         break;

      /* Transmit training sequence. */
      case R_ECT_TX_IMPULSE_QUIET:

// TODO: Raghu
if (!gft_DbgEcLoopBack)
{
         /* Update DEC training symbol counter. Initialized by Rx state machine. */
         gs_TxDECTrainSymbolCount++;

         /* Transmit a ramp during the first frame. This is used by the */
         /* receiver to determine the delay through the DEC path. */
         /* NOTE: There is a two frame delay through the transmitter */
         /* so that, for example, the signal transmitted during frame 2 is */
         /* the one loaded into gsa_TxToneBuf[] during frame 0. */

         if (gs_TxDECTrainSymbolCount == 0)
         {
                for (i = 0; i < gs_TxFftLength; i++)
            {
#ifdef ADSL_62
               gsa_TxTimeBuf[i] = i+1;
#else
               gsa_TxToneBuf[i] = i+1;
#endif
            }
            /* Tell receiver that training has started */
            gs_StartDECTraining = TRUE;
         }
         /* Keep quiet for the next three frames. */
         else if (gs_TxDECTrainSymbolCount == 1)
         {
#ifdef ADSL_62
                memset(gsa_TxTimeBuf, 0, sizeof(int16)*gs_TxFftLength);
#else
                memset(gsa_TxToneBuf, 0, sizeof(int16)*gs_TxFftLength);
#endif
         }
}
else       // TODO: Raghu:  Test IFFT and TXVAR gains configurations
{        gft_DisableIfft = 0;
         gs_StartDECTraining = TRUE;

         TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);

         if (gft_DbgMTPR)
         {
            gsa_TxToneBuf[2*gft_DbgMTPR] = 0;
            gsa_TxToneBuf[2*gft_DbgMTPR+1] = 0;
         }

}

         /* Unmask Rx input so that the receiver can measure the pilot. */
         /* Transmitter keeps quiet during this time. */
         if (gs_TxDECTrainSymbolCount == 4 - UNMASK_RXINPUT_NFRAMES_BEFORE_CLEARDEC)
         {
            /* Restore Rx input. */
            AddFunctionToFifo(gp_TxLoadingFunctionFifo,UnmaskRxInput);
         }
         if (gs_TxDECTrainSymbolCount == 4)
         {
            /* Zero DEC output. */
            AddFunctionToFifo(gp_TxLoadingFunctionFifo,ClearDEC);

#ifndef ADSL_62
            /* Reconfig dec training sequence based on the mode, submode, IFFT size */
            if (((OPTNArray[OPTN_AlgControl] & OPTN_IFFT128_Enable) == 0) || (STATArray[STAT_Misc] & STAT_IFFT64_EMULATE_REVERB))
            {
               dec_training_seq_reconfig(FALSE, (int16)STATArray[STAT_Mode]);
            }
            else
#endif
            {
               dec_training_seq_reconfig(TRUE, (int16)STATArray[STAT_Mode]);
            }

            /* Reset index to the DEC training signal buffer. */
            gs_EcTrainBufIndex = 0;

            /* If C-QUIET5 is being received there is no pilot accumulation */
            /* so proceed to the next substate. */
            if (gft_PilotOnDecTraining == FALSE)
            {
               gs_TxSubState = R_ECT_TX_TRAIN;
               //Use actual gain instead of unity. If the actual gain is too far from the unity
               //it may cause the clipping and hence the DEC taps may not converge. This issue is
               //seen on one of the 518 LIF module for the Annex J mask 1
               //AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);
            }
         }

         /* Go to next substate. */
         else if (gs_TxDECTrainSymbolCount == NUM_PILOT_EST_SYMBOLS+4)
         {
            //Use actual gain instead of unity. If the actual gain is too far from the unity
            //it may cause the clipping and hence the DEC taps may not converge. This issue is
            //seen on one of the 518 LIF module for the Annex J mask 1
            //AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);
            /* Rx has collected enough pilot data, transmit echo canceller training signal */
            gs_TxSubState = R_ECT_TX_TRAIN;
         }
         break;

      /* Transmit the DEC training sequence until RX side completes DEC training. */
      case R_ECT_TX_TRAIN:
         if (gs_StartDECTraining != FALSE)
         {
            gs_TxDECTrainSymbolCount++;

            /* Copy DEC training sequence to the TX buffer. */
#ifdef ADSL_62
            /* wait to get flag from Rx that required frames for pilot are accumulated before setting the TX to transmit
            DEC training signal */
            if (gft_FlagPilotAccDone == TRUE)
            {
               MemCopyWords(gsa_TxTimeBuf, 0, gpsa_DECTrainBuf, gs_EcTrainBufIndex, gs_TxFftLength);
            }
#else
                MemCopyWords(gsa_TxToneBuf, 0, gpsa_DECTrainBuf, gs_EcTrainBufIndex, gs_TxFftLength);
#endif

            gs_EcTrainBufIndex += gs_TxFftLength;
            if (gs_EcTrainBufIndex >= DEC_TRAINING_PERIOD*gs_TxFftLength){
               gs_EcTrainBufIndex = 0;
            }
         }
         else
         {
#ifdef ADSL_62
                /* Shut off the transmitter. */
                memset(gsa_TxTimeBuf,0,sizeof(int16)*gs_TxFftLength);
                /* Enable frequency domain transmission. */
                AddFunctionToFifo(gp_TxLoadingFunctionFifo,Enable_IFFT);


                gft_DisableIfft = FALSE ;
                gs_TxFftLength = gs_TxFftLength_Sav;
                gs_TxLog2FftLength1 = gs_TxLog2FftLength1_Sav;
#else
                /* Shut off the transmitter. */
                memset(gsa_TxToneBuf,0,sizeof(int16)*gs_TxFftLength);
                /* Enable frequency domain transmission. */
            AddFunctionToFifo(gp_TxLoadingFunctionFifo,Enable_IFFT_Reordering);
#endif
            gft_IFFT_On = TRUE;

#ifdef ADSL_62
            AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);
#endif
//XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START)
#ifdef VR9_DEC_TRAIN_DBG
                memset(gsa_TxToneBuf,0,sizeof(int16)*gs_TxFftLength);
            gs_TxSubState = R_ECT_TX_SILENCE;
#else
            /* Prepare to send MEDLEY signal. */
            UnpackPN(gsa_unpk_PN_US, (int16)(gs_PN_US_LEN + gs_PN_US_Step), gusa_PN_US_Tab, ENCGAIN2);
            gs_TxFirstPNbit = 0;
            gs_TxSubState = R_ECT_TX_MEDLEY;
#endif //VR9_DEC_TRAIN_DBG
//XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (END)
         }
         break;
//XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START)
#ifdef VR9_DEC_TRAIN_DBG
      case R_ECT_TX_SILENCE:
         if (gs_dbg_DEC_TxSignal == 1)
         {
            // gs_dbg_TxSignal == 1 ==> Tx Medley
            /* Prepare to send MEDLEY signal. */
            UnpackPN(gsa_unpk_PN_US, (int16)(gs_PN_US_LEN + gs_PN_US_Step), gusa_PN_US_Tab, ENCGAIN2);
            gs_TxFirstPNbit = 0;
            gs_TxSubState = R_ECT_TX_MEDLEY;
         }else if (gs_dbg_DEC_TxSignal == 2)
         {
            // gs_dbg_TxSignal == 2 ==> Tx Reverb
            /* Prepare to send REVERB signal. */
            //TxReverbSegueSetUp_Xcvr_Training_BIS(R_REVERB); //continously send TSSI shaped signal
            /* Set up REVERB signal without TSSI. */
            TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);
         }
         break;
#endif //VR9_DEC_TRAIN_DBG
//XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (END)
      /* If DEC training is done transmit MEDLEY signal for SNR measurement. */
      case R_ECT_TX_MEDLEY:

         /* Generate MEDLEY signal. */
         s_TxLastChannel = gs_TxLastChannel ;
#ifndef ISDN
         if(STATArray[STAT_Mode] & STAT_ConfigMode_G992_3_L)
         {
            if (gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A] == REACHEXT_G992_3L_USPSDMASK1)
               s_TxLastChannel = 24 ;
            else if (gs_Preferred_PSDMask_G9923x[G992_3_ANNEX_A] == REACHEXT_G992_3L_USPSDMASK2)
               s_TxLastChannel = 14 ;
         }
#endif

         if (gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_Tx_ReverbEcho_Meas)
         {
            TxReverbSegueSetUp(gs_TxFirstChannel, s_TxLastChannel, R_REVERB);
         }
         else
         {
         GenerateMedley(gsa_unpk_PN_US, gsa_TxToneBuf, gs_TxFirstPNbit, gs_PN_US_LEN, (int16)(2*gs_TxNumTones));
         /* Clear unused frequencies. */
         MemSetBuffer(gsa_TxToneBuf, 0, 0, (int16)(sizeof(int16)*(2*gs_TxFirstChannel)));
         if (s_TxLastChannel < gs_TxNumTones)
            MemSetBuffer(gsa_TxToneBuf, (int16)(2*(s_TxLastChannel+1)), 0, (int16)(sizeof(int16)*2*(gs_TxNumTones - s_TxLastChannel - 1)));

         /* Update offset to first unpacked bit. */
         gs_TxFirstPNbit += gs_PN_US_Step;
         if (gs_TxFirstPNbit >= gs_PN_US_LEN)
            gs_TxFirstPNbit -= gs_PN_US_LEN;
         }
         break;
   }

   /* Wait for end of R-ECT state. */
   if (gl_TxSymbolCount == (gt_StateMachCntrl.l_TXCurrentStateLen))
   {
      gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
      gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
         /* Save the Tx overflow counters for the current state in DMT mode only. */
         memcpy(gusa_REct_TxOverflowCnts, gusa_TxOverflowCnts, NUM_TX_OVFLOW_CNTRS*sizeof(uint16));
   }
}
#undef R_ECT_TX_INIT
#undef R_ECT_TX_IMPULSE_QUIET
#undef R_ECT_TX_TRAIN
#undef R_ECT_TX_MEDLEY
