/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RExchMarkerTxF_bis.c
 *
 *   Channel Analysis state RExchMarker
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "tx_ops.h"
#include "fifo.h"
#include "RMsg2TxF_bis.h"
#include "states.h"
#include "cmv.h"
#include "RSegueLDTxF_bis.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RExchMarkerTxF_BIS
 *
 *  Description: Sends the R_Reverb signal to the ATU-C.  R_Reverb is
 *  sent on tones gs_TxFirstChannel to gs_TxLastChannel.
 *
 *  Prototype: void RExchMarkerTxF_BIS(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_TxToneBuf[]     - (O) frequency domains samples (set in TxReverbSegue() )
 *    gs_TxState        - (I) current TX state
 *      gl_TxSymbolCount   - (I) # symbol periods in current TX state
 *      gs_TxNextState     - (O) TX state that will begin next symbol period
 *
 *------------------------------------------------------------------------
 *^^^
*/
void RExchMarkerTxF_BIS(void) {

   if (gl_TxSymbolCount == 0)
   {
      /*  set up freq domain REVERB signal in gsa_TxToneBuf input buffer  */
      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);

      AddFunctionToFifo(gp_TxLoadingFunctionFifo,Enable_IFFT_Reordering);
      gft_IFFT_On = TRUE;
   }


   if(gl_TxSymbolCount == R_EXCHMARKER_TX_LEN_BIS-1)
   {
   if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
   {
        gs_TxNextState = R_MSG2_TX_BIS;
      gpF_TxStateFunc = (PtrToFunc)RMsg2TxF_BIS;
   }
   else
   {
        gs_TxNextState = R_SEGUE_LD_TX_BIS;
      gpF_TxStateFunc = (PtrToFunc)RSegueLDTxF_BIS;
   }
   }

}
