/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RLineProbeTxF_BIS.c
 * DESCRIPTION:      Implements the TX state function for the R-LINEPROBE state
 *                   in G.dmt.bis.
 *
 **********************************************************************/

/**********************************************************************
 * Function: RLineProbeTxF_BIS
 *
 * Description: Implements the state R_LINEPROBE_TX_BIS.
 **********************************************************************/
#include "common.h"
#include "rt_tones.h"
#include "gdata.h"
#include "const_bis.h"
#include "TxMTnSt.h"
#include "states.h"
#include "RQuietTxF_bis.h"

void RLineProbeTxF_BIS(void)
{

   /* Use tones 17, 18 and 19 for this state. This set of tones are originally used for fast retrain of Lite mode  */
   /* used to be " const int16 sa_CarSet[NUM_LINEPROBE_TONES] = {R_LINEPROBE_TONE1, R_LINEPROBE_TONE2, R_LINEPROBE_TONE3}; " */
   int16 i, j, s_TxScale;

   /* insert R_LineProbe tones */
   /* used to be " // if(gl_TxSymbolCount ==0) " */
   /* used to be " // TxMultiToneSetUp((CONSTANT int16*)sa_CarSet, 3, R_LINEPROBE_POWER); " */
   if(gl_TxSymbolCount ==0)
   {
         /* Here R_LINEPROBE_POWER = 0x304D */
         /* Multiply scale with sqrt(2) */
         s_TxScale = (int16) ((23170 * (int32)R_LINEPROBE_POWER) >> 14);
         /* Clear tone buffer */
         for (i=0; i < gs_TxFftLength; i++)
         {
            gsa_TxToneBuf[i] = 0;
         }
         /* Insert tones with phase 90 or 270, depending on the sign of s_TxScale */
         for (i=0; i < NUM_LINEPROBE_TONES; i++)
         {
            j = i + gs_CarSet_FirstTone_For_LineProbe;
            gsa_TxToneBuf[ (2 * j) ]       = 0;
            gsa_TxToneBuf[ (2 * j) + 1 ]   = s_TxScale;
         }
         /* Reverse phase for the last carrier. This reduces the high frequency sidelobes, and
         therefore echo, considerably. Additionally, it also improves peak-to-average ratio so that
         the receiver on the other side is less likely to clip even at high PGA setting
         (on short loops). */
         /* no need in LineProbe for " gsa_TxToneBuf[ (2 * sa_CarSet[NUM_LINEPROBE_TONES-1]) + 1 ] = -s_TxScale; " */
   } /* insert R_LineProbe tones */

    if(gl_TxSymbolCount == (R_LINEPROBE_TX_LEN_BIS -1))
   {
   gs_TxNextState = R_QUIET3_TX_BIS;
   gpF_TxStateFunc = (PtrToFunc)RQuiet3TxF_BIS;
   }
}


