/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RMedleyTxF_RxInit_bis.c
 *
 *   State function wrapper for states R_MEDLEY
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "gdata.h"
#include "tx_ops.h"
#include "medley.h"
#include "rmedley_Data.h"
#include "fifo.h"
#include "pn_tab.h"
#include <string.h>
#include "TxTneSt.h"
#include "tx_ops_bis.h"
#include "memsetbf.h"
#include "gdata_bis.h"
#include "states.h"
//#include "RReverbTxF_bis.h"
#include "RExchMarkerTxF_Bis.h"
#include "cmv.h"
#include "RMedleyTxF_BIS.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RMedleyTxF_RxInit_BIS
 *
 *  Description: Transmits R_Medley, a wide band, pseudo random signal,
 *  which is used by the ATU-C to estimate upstream SNR.  The R_Medley
 *  signal is derived from the UPRD sequence, using a 64-bit cyclic subset
 *
 *      d[1 + (n % N)] ... d[1 + ((n+63) % N)]; n = 0 ... L
 *
 *  where N is the length of the PRD, n is the index to the R_Medley symbol
 *  period, and L is the duration of R_MEDLEY, in symbol periods.  This data
 *  sequence is then modulated in the same manner as that of R_Reverb.
 *
 *  The implementation consists of unpacking the PRD data sequence into an
 *  array, computing the index to the beginning of the data subset,
 *  retrieving the data subset, removing the untransmitted tones
 *  and generating the time domain sequence.
 *
 *  Prototype: void RMedleyTxF_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gusa_PN_US_Tab[]      - (I) packed PRD sequence
 *      gsa_TxToneBuf[]     - (O) frequency domains samples (set in TxReverbSegueSetUp())
 *      gl_TxSymbolCount    - (I) # symbol periods in current TX state
 *      gs_TxNextState      - (O) TX state that will begin next symbol period
 *    gs_TxState        - (I) current TX state
 *
 *  Notes: implements states R_MEDLEY_TX (and R_MEDLEY_FR_TX for G992_2)
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RMedleyTxF_RxInit_BIS(void) {

   //invoke the actual RMedleyTxF_BIS function
   RMedleyTxF_BIS();
}
