/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RMedleyTxF_bis.c
 *
 *   State function for states R_MEDLEY
 *
 *------------------------------------------------------------------------
 */
//*******************************************************************
// RMedleyTxF_bis.c
//
// History
//
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
//*****************************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "gdata.h"
#include "tx_ops.h"
#include "medley.h"
#include "rmedley_Data.h"
#include "fifo.h"
#include "pn_tab.h"
#include <string.h>
#include "TxTneSt.h"
#include "tx_ops_bis.h"
#include "memsetbf.h"
#include "gdata_bis.h"
#include "states.h"
#include "RExchMarkerTxF_Bis.h"
#include "cmv.h"
#include "Gen_MedleyBisTones.h"
#include "bitload_const.h"
#include "applyblackoutbits.h"

//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
#include "LL_IOf.h"     //ReadCoreReg(), WriteCoreReg() defined here
#include "STR_ini.h"
#include "STR_IOf.h"
#include "STR_InitFilter.h"
#include "STR_Filt.h"
#include "ec_data.h"

#include "memrymap.h"
#include "datapumpsetup_tx.h"
#include "IRI_Iof.h"
#include "IRI_IOf_tables.h"
#include "IRI_Iof.h"
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RMedleyTxF_BIS
 *
 *  Description: Transmits R_Medley, a wide band, pseudo random signal,
 *  which is used by the ATU-C to estimate upstream SNR.  The R_Medley
 *  signal is derived from the UPRD sequence, using a 64-bit cyclic subset
 *
 *      d[1 + (n % N)] ... d[1 + ((n+63) % N)]; n = 0 ... L
 *
 *  where N is the length of the PRD, n is the index to the R_Medley symbol
 *  period, and L is the duration of R_MEDLEY, in symbol periods.  This data
 *  sequence is then modulated in the same manner as that of R_Reverb.
 *
 *  The implementation consists of unpacking the PRD data sequence into an
 *  array, computing the index to the beginning of the data subset,
 *  retrieving the data subset, removing the untransmitted tones
 *  and generating the time domain sequence.
 *
 *  Prototype: void RMedleyTxF_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gusa_PN_US_Tab[]      - (I) packed PRD sequence
 *      gsa_TxToneBuf[]     - (O) frequency domains samples (set in TxReverbSegueSetUp())
 *      gl_TxSymbolCount    - (I) # symbol periods in current TX state
 *      gs_TxNextState      - (O) TX state that will begin next symbol period
 *    gs_TxState        - (I) current TX state
 *
 *  Notes: implements states R_MEDLEY_TX (and R_MEDLEY_FR_TX for G992_2)
 *
 *------------------------------------------------------------------------
 *^^^
 */
#ifdef ANX_J_DEBUG
extern int16 gs_Set_Pause;
#endif
C_SCOPE void RMedleyTxF_BIS(void)
{
    int16   s_gain = ENCGAIN2, s_NUM_R_MEDLEY_BYTES;

   s_NUM_R_MEDLEY_BYTES = 2*gs_TxNumTones/8;

    // (gl_TxSymbolCount = 0) /* unpack PRD from table */
    if (gl_TxSymbolCount == 0) {

//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
// MEM_ISSUE      if ((OPTNArray[OPTN_TXPathControl]) && ((gl_SelectedMode == (MODE_G992_5 | ANNEX_A))) )
// MEM_ISSUE      {
// MEM_ISSUE         //   0x01:     SWITCH_BEFORE_RREVERB3
// MEM_ISSUE         //   0x02:     SWITCH_BEFORE_RREVERB4
// MEM_ISSUE         //   0x04:     SWITCH_BEFORE_RREVERB5
// MEM_ISSUE         //   0x08:     SWITCH_BEFORE_MEDLEY (not supported)
// MEM_ISSUE         // 0x80xx:     compensate DECDelay
// MEM_ISSUE         if (gus_TxPathControl & 0x8)  // SWITCH_BEFORE_MEDLEY (not supported))
// MEM_ISSUE         {
// MEM_ISSUE            if (gus_TxPathControl & 0x1000)  // change tx-filter delay
// MEM_ISSUE            {
// MEM_ISSUE               gula_Strymon_TxIir_Pots_Plus[26] = 26771;
// MEM_ISSUE               gula_Strymon_TxIir_Pots_Plus[28] =     0;
// MEM_ISSUE               gs_TxIIRFilterSelect = TXIIR_POTS_PLUS;
// MEM_ISSUE               LoadTxIir();
// MEM_ISSUE            }
// MEM_ISSUE            if (gus_TxPathControl & 0x2000)  // 1 image
// MEM_ISSUE            {
// MEM_ISSUE               ReadCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, &ul_data);
// MEM_ISSUE               ul_data &= ~(3<<11);
// MEM_ISSUE               ul_data |=(1<<11);
// MEM_ISSUE               WriteCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, ul_data);
// MEM_ISSUE            }
// MEM_ISSUE            if (gus_TxPathControl & 0x4000)  // all images
// MEM_ISSUE            {
// MEM_ISSUE               ReadCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, &ul_data);
// MEM_ISSUE               ul_data &= ~(3<<11);
// MEM_ISSUE               ul_data |=(2<<11);
// MEM_ISSUE               WriteCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, ul_data);
// MEM_ISSUE            }
// MEM_ISSUE            if (gus_TxPathControl & 0x8000)  // SHIFT_DEC)
// MEM_ISSUE            {
// MEM_ISSUE               gs_DEC_SHIFT = gs_DEC_SHIFT_INIT;
// MEM_ISSUE               AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECTDQ);
// MEM_ISSUE            }
// MEM_ISSUE         }
// MEM_ISSUE      }
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)

      gft_IFFT_On = TRUE;

      if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
      {
      if(gt_RCMsgs1_bis.uc_CA_MEDLEYus >= gt_RMsgs1_bis.uc_CA_MEDLEYds)
         gt_StateMachCntrl.l_TXCurrentStateLen = (gt_RCMsgs1_bis.uc_CA_MEDLEYus<<9) - 1;
          else
         gt_StateMachCntrl.l_TXCurrentStateLen = (gt_RMsgs1_bis.uc_CA_MEDLEYds<<9) -1;
      }
        else
      gt_StateMachCntrl.l_TXCurrentStateLen = MEDLEY_LEN_BIS_DIAG -1;


      // If h/w generates the medley sequence
      if((TESTArray[TEST_HWSequenceGeneration] & TEST_HwBISMedleySequenceGeneration) != 0)
      {
         guc_sequenceToGenerate = (uint8)GENERATE_BIS_MEDLEY;
         AddFunctionToFifo(gp_TxLoadingFunctionFifo,TxHwSequenceGenerationSetup);
      }
      // else s/w generates medley sequence
      {
         /* ul_MedleyState holds previous 32 bits of Medley sequence. First symbol has to be
         treated separately because we need to initialize first 23 bits of PN sequence to 1 */
         gul_MedleyState = 0x007FFFFF;

         guca_MedleyBuffer[0] = 0xFF; // copy to byte buffer
         guca_MedleyBuffer[1] = 0xFF;
         guca_MedleyBuffer[2] = 0x7F;
         guca_MedleyBuffer[3] = 0x00;

         // Generate PN sequence (different for first frame: 4 extra bytes (in the US) to be generated because first 4 bytes are defined as above)
         Gen_PNMedley(&guca_MedleyBuffer[4], (int16)(s_NUM_R_MEDLEY_BYTES-4), &gul_MedleyState);
      }

    }

   // if s/w generates medley sequence
   if((TESTArray[TEST_HWSequenceGeneration] & TEST_HwBISMedleySequenceGeneration) == 0)
   {
      if (gl_TxSymbolCount > 0)
         Gen_PNMedley(guca_MedleyBuffer, (int16)s_NUM_R_MEDLEY_BYTES, &gul_MedleyState);

      /*  if gft_MedleyFlag is not TRUE, then transmit silence during Medley. */
      /*  This feature allows the echo effect to be measured.              */

      if (gft_MedleyFlag == TRUE)   {
         // Modulate into tone buffer
         Gen_MedleyBisTones(gsa_TxToneBuf, guca_MedleyBuffer, (int16)s_NUM_R_MEDLEY_BYTES, gs_TxNumTones, gs_TxFirstChannel, (int16)ENCGAIN2);

         /*  Zero out tones not in US Medley set */
         ClearTonesNotInUsMedleySet(gsa_TxToneBuf);
      }
      else {
         TxToneSetUp(0,0,0);
      }
   }
#ifdef ANX_J_DEBUG
   if(gs_Set_Pause == 0xE4) Pause(0xABE4);  //Debug
#endif
    /* go to next state */
   if (gl_TxSymbolCount == gt_StateMachCntrl.l_TXCurrentStateLen) {
        gs_TxNextState = R_EXCHMARKER_TX_BIS;
      gpF_TxStateFunc = (PtrToFunc)RExchMarkerTxF_BIS;
      // Save the Tx overflow counters for the current state
      memcpy(gusa_RMedley_TxOverflowCnts, gusa_TxOverflowCnts, NUM_TX_OVFLOW_CNTRS*sizeof(uint16));
    }
}
