/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RMsg1TxF_Bis.c
 *
 *   Functions implementing states R_MSG1_TX_BIS
 *
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RMsg1TxF_bis.c
//
// History
//14/03/2012 Kannan: 08/04/2009 Bhadra: Added code for uinversal ReTx R-Msg1 related changes
//                     Grep for SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod to see changes.
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx(R-MSG1 in Particular) and Rx-
//                   training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
// **********************************************************************************
#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "crc16.h"
#include "tx_ops_bis.h"
#include "tx_ops.h"
#include "rinfo_bis.h"
#include "states.h"
#include "RMedleyTxF_bis.h"
#include "DebugBuffer.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RMsg1TxF_BIS
 *
 *  Description: Sends the R_MSG1 message to
 *  the ATU-C.  One bit of information is transmitted in each symbol.
 *  A one bit is encoded as one symbol of R_Reverb and a zero
 *  bit is encoded as one symbol of R_Segue.  A CRC16 checksum is computed
 *  on the R_MSG1 and is also sent in this state
 *
 *  Prototype: void RMsg1TxF_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      guca_RMsgs1Tab[]    - (O) R_Msgs1 message data to be transmitted
 *    gus_R_CRC           - (I/O) CRC16 computed over gus_RMsgs1Tab[]
 *      gl_TxSymbolCount    - (I) # symbol periods in current TX state
 *      gs_TxNextState      - (O) TX state that will begin next symbol period
 *    gs_TxState        - (I) Current TX state
 *      gt_StateMachCntrl   - (O) Maintains state machine control variables
 *
 *  Notes: implements states R_MSG1_TX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */
#define R_MSG1_PREFIX_TX_BIS_TRANSMIT  (0)
#define R_MSG1_TX_BIS_TRANSMIT         (1)
#define R_MSG1_TX_BIS_CRC_TRANSMIT     (2)

void RMsg1TxF_BIS(void) {

    uint16  us_infobit;
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   //SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod Start
   int16 s_RMsg1_numBits_bis;


   s_RMsg1_numBits_bis = R_MSG1_NUM_BITS_BIS;

#ifdef UNV_RETX_MSGS
   if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
      s_RMsg1_numBits_bis = R_MSG1_RETX_NUM_BITS_BIS;
   }
#endif
   //SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod End
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
   gft_IFFT_On = TRUE;
    switch (gs_TxSubState) {

      /* ==================================================================== */
      /*  Send R_MSG1_TX */
      /* ==================================================================== */
      case R_MSG1_PREFIX_TX_BIS_TRANSMIT:
         if (gl_TxSymbolCount == 0) {

            /* Pack R_MSG1 for transmission */
            FormRMsg1_BIS();
            gs_TxSubStateCnt = 0;
         }

         TxInfoBit(guca_PreAmbleField_bis, gs_TxSubStateCnt);

         gs_TxSubStateCnt++;
         if (gs_TxSubStateCnt == R_MSG1_PRFX_LEN_BIS) {
            gs_TxSubState = R_MSG1_TX_BIS_TRANSMIT;
            gus_R_CRC = 0x0000;
            gs_TxSubStateCnt = 0;
         }
         break;

      /* ==================================================================== */
      /*  Send R_MSG1_TX & Compute CRC  */
      /* ==================================================================== */
      case R_MSG1_TX_BIS_TRANSMIT:

         us_infobit = TxInfoBit(guca_RMsgs1Tab_bis, gs_TxSubStateCnt);

         CalcCRC16(&gus_R_CRC, us_infobit);

         gs_TxSubStateCnt++;
         //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START_END)
         //SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod (Start End)
         if (gs_TxSubStateCnt == s_RMsg1_numBits_bis)
         {
#ifdef DEBUG_TRACES // XDSLRTFW-597
            LogMessages(4,NOT_END_OF_MSG,(uint16)R_MSG1_MSG, 4, (uint8 *)guca_PreAmbleField_bis, DEBUG_BUFFER_DELIMITER_ADSL);
            LogMessageSegments(NOT_END_OF_MSG,(uint16)(s_RMsg1_numBits_bis>>3),(uint8 *)guca_RMsgs1Tab_bis, DEBUG_BUFFER_DELIMITER_ADSL);
            LogMessageSegments(END_OF_THE_MSG,(uint16)2,(uint8 *)(void *)(&gus_R_CRC), DEBUG_BUFFER_DELIMITER_ADSL);
#endif
#ifdef DEBUG_STREAMING
            DSH_SendStream(DSH_R_MSG1_ADSL,(uint16)(s_RMsg1_numBits_bis>>3),&guca_RMsgs1Tab_bis[0]);
#endif
            gs_TxSubState = R_MSG1_TX_BIS_CRC_TRANSMIT;
            gs_TxSubStateCnt = 0;
         }
         break;

      /* ==================================================================== */
      /*  Send CRC  */
      /* ==================================================================== */
      case R_MSG1_TX_BIS_CRC_TRANSMIT:



         /* extract bit */
         us_infobit = (gus_R_CRC >> gs_TxSubStateCnt);
         us_infobit &= 0x1;

         TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, us_infobit);

         gs_TxSubStateCnt++;
         if (gs_TxSubStateCnt == R_CRC_TX_BIS_LEN) {
            gs_TxNextState = R_MEDLEY_TX_BIS;
            gpF_TxStateFunc = (PtrToFunc)RMedleyTxF_MTDQ_BIS;
         }
         break;
   } /* switch (gs_TxSubState) */

}

#undef R_MSG1_PREFIX_TX_BIS_TRANSMIT
#undef R_MSG1_TX_BIS_TRANSMIT
#undef R_MSG1_TX_BIS_CRC_TRANSMIT
