/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RMsg12TxF_Bis.c
 *
 *   Functions implementing states R_MSG2_TX_BIS
 *
 *
 *------------------------------------------------------------------------
 */


 // ****************************************************************************************************
// RMsg12TxF_Bis.c
// History :
//  27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx(R-MSG2 in particular) and Rx-
//                   training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
//****************************************************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "crc16.h"
#include "tx_ops_bis.h"
#include "tx_ops.h"
#include "rinfo_bis.h"
#include "states.h"
#include "RReverb6TxF_bis.h"
#include "cmv.h"
#include "DebugBuffer.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RMsg2TxF_BIS
 *
 *  Description: Sends the R_MSG2 message to
 *  the ATU-C.  One bit of information is transmitted in each symbol.
 *  A one bit is encoded as one symbol of R_Reverb and a zero
 *  bit is encoded as one symbol of R_Segue.  A CRC16 checksum is computed
 *  on the R_MSG2 and is also sent in this state
 *
 *  Prototype: void RMsg2TxF_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      guca_RMsgs2Tab_bis[] - (O) R_Msgs2 message data to be transmitted
 *    gus_R_CRC            - (I/O) CRC16 computed over gus_RMsgs2Tab[]
 *      gl_TxSymbolCount     - (I) # symbol periods in current TX state
 *      gs_TxNextState       - (O) TX state that will begin next symbol period
 *    gs_TxState        - (I) Current TX state
 *      gt_StateMachCntrl    - (O) Maintains state machine control variables
 *
 *  Notes: implements states R_MSG2_TX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */

#define R_MSG2_TX_BIS_TRANSMIT         (0)
#define R_MSG2_TX_BIS_CRC_TRANSMIT     (1)

void RMsg2TxF_BIS(void) {

    uint16  us_infobit;
   int16 s_R_MSG2_NUM_BITS_BIS;

   if (( gl_SelectedMode & (MODE_G992_5)  ))
      s_R_MSG2_NUM_BITS_BIS = R_MSG2_NUM_BYTES_PLUS*8;
   else
      s_R_MSG2_NUM_BITS_BIS = R_MSG2_NUM_BYTES_BIS*8;

   gft_IFFT_On = TRUE;

    switch (gs_TxSubState) {
      /* ==================================================================== */
      /*  Send R_MSG2_TX & Compute CRC  */
      /* ==================================================================== */
      case R_MSG2_TX_BIS_TRANSMIT:

         if (gl_TxSymbolCount == 0) {
            /* Pack R_MSG2 to guca_RMsg2Tab_bis[]  */
            FormRMsg2_BIS();

            gus_R_CRC = 0x0000;
            gs_TxSubStateCnt = 0;
            //DebugBuffer2_ADSL(END_OF_THE_MSG,(uint16)2,(uint8 *)(&gus_R_CRC), DEBUG_BUFFER_DELIMITER_ADSL);
         }

         /* Extract one bit each frame, and set the Transmit signal */
         /* corresponding ( 0= Reverb, 1=Segue */
         us_infobit = TxInfoBit(guca_RMsgs2Tab_bis, gs_TxSubStateCnt);

         /* Compute the CRC */
         CalcCRC16(&gus_R_CRC, us_infobit);

         gs_TxSubStateCnt++;

         if (gs_TxSubStateCnt == s_R_MSG2_NUM_BITS_BIS) {
#ifdef DEBUG_TRACES // XDSLRTFW-597
            LogMessages(4,NOT_END_OF_MSG,(uint16)R_MSG2_MSG, (uint16)R_MSG2_NUM_BYTES_PLUS, (uint8 *)guca_RMsgs2Tab_bis, DEBUG_BUFFER_DELIMITER_ADSL);
            LogMessageSegments(END_OF_THE_MSG,(uint16)2,(uint8 *)(void *)&gus_R_CRC, DEBUG_BUFFER_DELIMITER_ADSL);
#endif
#ifdef DEBUG_STREAMING
            DSH_SendStream(DSH_R_MSG2_ADSL,(uint16)(R_MSG2_NUM_BYTES_PLUS),&guca_RMsgs2Tab_bis[0]);
#endif
            gs_TxSubState = R_MSG2_TX_BIS_CRC_TRANSMIT;
            gs_TxSubStateCnt = 0;


         }



         break;

      /* ==================================================================== */
      /*  Send CRC  */
      /* ==================================================================== */
      case R_MSG2_TX_BIS_CRC_TRANSMIT:

         /* extract bit */
         us_infobit = (gus_R_CRC >> gs_TxSubStateCnt);
         us_infobit &= 0x0001;

         TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, us_infobit);

         gs_TxSubStateCnt++;
         if (gs_TxSubStateCnt == R_CRC_TX_BIS_LEN) {

            gs_TxNextState = R_REVERB6_TX_BIS;
            gpF_TxStateFunc = (PtrToFunc)RReverb6TxF_BIS;
         }
         break;
   } /* switch (gs_TxSubState) */

}

#undef R_MSG2_TX_BIS_TRANSMIT
#undef R_MSG2_TX_BIS_CRC_TRANSMIT
