/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RMsgFmtTxF_BIS.c
 * DESCRIPTION:      Implements the TX state function for the R-MSG-FMT state
 *                   and the R-MSG-PCB state in G.dmt.bis.
 *
 **********************************************************************/

 // ****************************************************************************************************
// FormRMsgFmt_bis.c
// History :
//  27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx(R-MSG-PCB in particular) and Rx-
//                   training messages (G.Hs + training)
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
//****************************************************************************************************

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "GenerateComb.h"
#include "const_bis.h"
#include "crc16.h"
#include "rinfo_bis.h"
#include "fifo.h"
#include "RReverbTxF_bis.h"
#include "states.h"
#include "cmv.h"
#include "DebugBuffer.h"

/**********************************************************************
 * Function: RMsgFmtTxF_BIS
 *
 * Description: Implements the states R_MSG_FMT_TX_BIS and R_MSG_PCB_TX_BIS.
 **********************************************************************/

#define R_MSG_FMT_TX_BIS_MESSAGE    0
#define R_MSG_FMT_TX_BIS_CRC        1

void RMsgFmtTxF_BIS(void)
{
   // Positive amplitude for a ZERO bit (R-COMB)
   // Negative amplitude for a ONE bit (R-ICOMB)
   const int16 s_Signal[2] = {ENCGAIN2, -ENCGAIN2};

   int16 s_bytelocation, s_temp, s_temp2;
   uint16 us_infobit;

   if(gl_TxSymbolCount == 0)
   {
      /* Set up state length and next state */
      if(gs_TxState == R_MSG_FMT_TX_BIS)
      {
         FormRMsgFmt_BIS();
         gt_StateMachCntrl.puca_TX_message = guca_RMsgFMTTab;
         gt_StateMachCntrl.s_TXFollowingState = R_MSG_PCB_TX_BIS;
         gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RMsgFmtTxF_BIS;

         if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
         gt_StateMachCntrl.l_TXCurrentStateLen = R_MSG_FMT_TX_LEN_BIS - 1;
         else
              gt_StateMachCntrl.l_TXCurrentStateLen = R_MSG_FMT_TX_LEN_BIS_DIAG - 1;
      }
      else  // if(gs_TxState == R_MSG_PCB_TX_BIS)
      {
         FormRMsgPcb_BIS();
         gt_StateMachCntrl.puca_TX_message = guca_RMsgPCBTab;
         gt_StateMachCntrl.s_TXFollowingState = R_REVERB1_TX_BIS;
            gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RReverb1TxF_BIS;

         if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
         {
         if((gt_RMsgFmt_bis.us_FMT_R_MSG_PCB == 0)
            || (STATArray[STAT_MacroState] == STAT_ShortInit)) /* Blackout bits should not be included */
            gt_StateMachCntrl.l_TXCurrentStateLen = R_MSG_PCB_NO_BLACKOUT_BITS_TX_LEN_BIS - 1;
            else
         {
            //RMSG_PCB includes (4bytes + #blackout tones +2CRC bytes)
                gt_StateMachCntrl.l_TXCurrentStateLen = ((gs_RxNumTones>>3)+6)*3*8 - 1;/*R_MSG_PCB_WITH_BLACKOUT_BITS_TX_LEN_BIS - 1;*/
         }
         }
         else
         {
            /* In Loop Diagnostics Mode R-MSG-PCB includes (32 + #BlackoutTones + 16 + 16 CRC) bits */
            /* which are transmitted using 8 symbols per bit modulation. */
            gt_StateMachCntrl.l_TXCurrentStateLen = 8 * (gs_RxNumTones + 64) - 1;
         }

#ifdef DEBUG_TRACES // XDSLRTFW-597
      LogMessages(4,NOT_END_OF_MSG,(uint16)R_MSG_PCB_MSG, (uint16)((((gt_StateMachCntrl.l_TXCurrentStateLen+1)>>3)/3)-2), (uint8 *)guca_RMsgPCBTab, DEBUG_BUFFER_DELIMITER_ADSL);
#endif
#ifdef DEBUG_STREAMING
      DSH_SendStream(DSH_R_MSG_PCB, (uint16)((((gt_StateMachCntrl.l_TXCurrentStateLen+1)>>3)/3)-2),&guca_RMsgPCBTab[0]);
#endif
      }


      gus_R_CRC = 0x0000;

      gft_IFFT_On = TRUE;        // Need to do IFFT for R-COMB/R-ICOMB symbol
   }

    if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
      s_temp = (int16)(gl_TxSymbolCount % 3);
    else
      s_temp = (int16)(gl_TxSymbolCount % 8);

   switch(gs_TxSubState)
   {
      // gs_TxSubStateCnt counts the number of bits we have sent

      case R_MSG_FMT_TX_BIS_MESSAGE:
         if(s_temp == 0)
         {
            s_bytelocation = gs_TxSubStateCnt >> 3;
            us_infobit = (gt_StateMachCntrl.puca_TX_message[s_bytelocation] >> (gs_TxSubStateCnt & 0x07)) & 0x01;
            CalcCRC16(&gus_R_CRC, us_infobit);


            GenerateComb(gs_TxFirstChannel, gs_TxLastChannel, s_Signal[us_infobit]);

            gs_TxSubStateCnt++;
         }

         if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
         s_temp2 = (int16)(gt_StateMachCntrl.l_TXCurrentStateLen - C_MSGFMT_CRC_NUM_OF_SYMBOLS);
         else
              s_temp2 = (int16)(gt_StateMachCntrl.l_TXCurrentStateLen - C_MSGFMT_CRC_NUM_OF_SYMBOLS_DIAG);

         if(gl_TxSymbolCount == s_temp2)  // Check if it is time to send CRC
         {
            gs_TxSubState = R_MSG_FMT_TX_BIS_CRC;
            gs_TxSubStateCnt = 0;
#ifdef DEBUG_TRACES
            // XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
            LogMessageSegments(END_OF_THE_MSG,(uint16)2,(uint8 *)(void *)&gus_R_CRC, DEBUG_BUFFER_DELIMITER_ADSL);
#endif // #ifdef DEBUG_TRACES
         }
         break;

      case R_MSG_FMT_TX_BIS_CRC:
         if(s_temp == 0)
         {
            us_infobit = (gus_R_CRC >> gs_TxSubStateCnt) & 0x01;


            GenerateComb(gs_TxFirstChannel, gs_TxLastChannel, s_Signal[us_infobit]);

            gs_TxSubStateCnt++;
         }
         break;
   }

   if(gl_TxSymbolCount == gt_StateMachCntrl.l_TXCurrentStateLen)
   {
      /* The new value of gus_TxSineGain is calculated in R_C_QUIET4 if necessary */
      if((gs_TxState == R_MSG_PCB_TX_BIS) && ((gt_RMsgPcb_bis.us_R_MIN_PCB_US !=0) || (gt_RCMsgPcb_bis.us_C_MIN_PCB_US!=0)) )
           AddFunctionToFifo(gp_TxLoadingFunctionFifo,LoadTxSineGain);

      gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
      gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
   }
}

#undef R_MSG_FMT_TX_BIS_MESSAGE
#undef R_MSG_FMT_TX_BIS_CRC
