/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RMsgLDTxF_BIS.c
 * DESCRIPTION:      Implements the TX state function for the R-MSGx-LD state
 *                   in diagnostics mode.
 *
 **********************************************************************/

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "gdata_bis_diag.h"
#include "const_bis.h"
#include "crc16.h"
#include "RQuiet1LDTxF_bis.h"
#include "states.h"
#include "tx_ops.h"
#include "diagparam_bis.h"


/**********************************************************************
 * Function: RMsgLDTxF_BIS
 *
 * Description: Implements the states R_MSG_LD_TX_BIS.
 **********************************************************************/

#define R_MSG_LD_TX_BIS_MESSAGE     0
#define R_MSG_LD_TX_BIS_CRC         1
#define R_MSG_LD_TX_BIS_DONE     2

void RMsgLDTxF_BIS(void)
{
   int16 s_BitCnt;
   int16 s_ByteCnt;
   static uint16 us_TxByte;
   uint16 us_infobit = 0;

   /* Initialize. */
   if(gl_TxSymbolCount == 0)
   {
        gt_StateMachCntrl.s_TXFollowingState = R_QUIET1_LD_TX_BIS;
      gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RQuiet1LDTxF_BIS;
      gt_StateMachCntrl.puca_TX_message = gpuca_RMSGx_LD;
        gt_StateMachCntrl.l_TXCurrentStateLen = R_MSGx_LD_TX_LEN_BIS - 1;
      if (guc_msg_ld_idx_us == 1)
      {
            gt_StateMachCntrl.l_TXCurrentStateLen = R_MSG1_LD_TX_LEN_BIS - 1;
      }
        gus_R_CRC = 0x0000;
        gft_IFFT_On = TRUE;         // Need to do IFFT for R-MSGx-LD symbol
        gs_TxSubStateCnt = 0;
   }

   /* Transmit a bit every eight symbols. */
    if ((int16)(gl_TxSymbolCount & 0x00000007) == 0)
   {
      switch(gs_TxSubState)
      {
      /* Send out message */
      case R_MSG_LD_TX_BIS_MESSAGE:
         /* Get bit count within the current byte. Note that gs_TxSubStateCnt counts the total bits transmitted. */
         s_BitCnt = gs_TxSubStateCnt & 0x0007;

         /* If the transmission of the previous byte completed, get the next message byte. */
         if (s_BitCnt == 0)
         {
            s_ByteCnt = gs_TxSubStateCnt >> 3;
            us_TxByte = (uint16)(gt_StateMachCntrl.puca_TX_message[s_ByteCnt]);
         }

         /* Get the message bit to be transmitted. */
         us_infobit = (us_TxByte >> s_BitCnt) & 0x01;
         /* Calculate CRC. */
         CalcCRC16(&gus_R_CRC, us_infobit);

         /* Check if the last bit in a message is being transmitted. */
         if (gs_TxSubStateCnt == (int16)((gt_StateMachCntrl.l_TXCurrentStateLen - R_CRC_LEN_LD) >> 3))
         {
            gs_TxSubState = R_MSG_LD_TX_BIS_CRC;
            gs_TxSubStateCnt = -1;
         }
         break;

      case R_MSG_LD_TX_BIS_CRC:
         /* Get the CRC bit to be transmitted. */
         us_infobit = (gus_R_CRC >> gs_TxSubStateCnt) & 0x01;

         /* Check if the last CRC bit is being transmitted. */
         if (gs_TxSubStateCnt == (int16)(gt_StateMachCntrl.l_TXCurrentStateLen >> 3))
         {
            gs_TxSubState = R_MSG_LD_TX_BIS_DONE;
         }
         break;
      }

      /* Transmit the bit and increment the total bit count. */
      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, us_infobit); /* R_REVERB = 0; R_SEGUE = 1 */
      gs_TxSubStateCnt++;
   }

   /* Transition to the next state if the whole message is transmitted. */
   if (gl_TxSymbolCount == gt_StateMachCntrl.l_TXCurrentStateLen)
   {
      gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
      gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
   }
}

#undef R_MSG_LD_TX_BIS_MESSAGE
#undef R_MSG_LD_TX_BIS_CRC
