/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RParamsTxF_Bis.c
 *
 *   Functions implementing states R_PARAMS_TX_BIS
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "tx_ops_bis.h"
#include "states.h"
#include "RReverb7TxF_bis.h"
#include "memsetbf.h"
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RParamsTxF_BIS
 *
 *  Description: Sends the R_PARAMS message to the ATU-C.
 *
 *  Prototype: void RParamsTxF_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      guca_RParamsTab_bis[] - (O) R_Params message data to be transmitted
 *      gl_TxSymbolCount     - (I) # symbol periods in current TX state
 *      gs_TxNextState       - (O) TX state that will begin next symbol period
 *    gs_TxState        - (I) Current TX state
 *      gt_StateMachCntrl    - (O) Maintains state machine control variables
 *
 *  Notes: implements states R_PARAMS_TX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RParamsTxF_BIS(void)
{
   int16 i, k, s_constellation_gain;
   uint8 uc_tone_idx, uc_byte, uc_val;

   if(gl_TxSymbolCount ==0)
   {
      /* Clear TX tone buffer */
      MemSetBuffer(gsa_TxToneBuf, 0, 0, (int16)(sizeof(int16)*(2*gs_TxNumTones)));

      gs_BytePosition = 0;
      gus_BitPosition =0;
   }

   uc_tone_idx =0;
   s_constellation_gain = (int16)ENCGAIN2;

   /* Every iteration, we extract two bits to fill one tone */
   for (i=0; i<gs_NSC_RParams; i++)
   {
      uc_byte = guca_R_PARAMS_bis[gs_BytePosition];
      uc_val = (uc_byte >>gus_BitPosition) & 0x03;  /* Get the two bits */

      gus_BitPosition +=2;

      if(gus_BitPosition == 8)
      {
          gus_BitPosition =0;
      gs_BytePosition++;
      }

      k=(guca_Tones_RParams[uc_tone_idx] <<1);
       uc_tone_idx++;


      if(uc_val ==0)
      {
         gsa_TxToneBuf[k]   = s_constellation_gain;
      gsa_TxToneBuf[k+1] = s_constellation_gain;
      }
      else if(uc_val ==1)
      {
         gsa_TxToneBuf[k]   = -s_constellation_gain;
      gsa_TxToneBuf[k+1] = s_constellation_gain;
      }
      else if(uc_val ==2)
      {
         gsa_TxToneBuf[k]   = s_constellation_gain;
      gsa_TxToneBuf[k+1] = -s_constellation_gain;
      }
      else
      {
         gsa_TxToneBuf[k]   = -s_constellation_gain;
      gsa_TxToneBuf[k+1] = -s_constellation_gain;
      }

   }

   /* gs_R_Params_Frame_Len is calculated in BgFormRParams() */
   if(gl_TxSymbolCount == (gs_R_Params_Frame_Len-1))
   {
         gs_TxNextState = R_REVERB7_TX_BIS;
         gpF_TxStateFunc = (PtrToFunc)RReverb7TxF_BIS;
   }

}

